#include <amxmodx>
#tryinclude <reapi>

/* =================== */
#define VOICE_CONTROL_BY_STATS 0
	// 0 - CSX
	// 1 - CSSTATS MYSQL by SKAJIbnEJIb
	// 2 - CSSTATSX SQL by serfreeman1337
	// 3 - AES 0.5 Vega by serfreeman1337

// #define SUPPORT_NO_ROUND_SERVER
	// Поддержка серверов с бесконечным раундом (GunGame, CSDM, etc...)
	
#define BLOCK_TEXT_CHAT
	// Блокировать текстовый чат и голосовой
	// Если закомментировано - блокировуется только голос

const MIN_FRAGS = 10;
	// Минимальное количество фрагов для доступа к микро
	// Для VOICE_CONTROL_BY_STATS 3 настройка принимает значение ранга юзера(начиная с 0)
/* =================== */

#if VOICE_CONTROL_BY_STATS == 0
	#include <csstats>
#endif
#if VOICE_CONTROL_BY_STATS == 1
	#include <csstats_mysql>
#endif
#if VOICE_CONTROL_BY_STATS == 2
	#include <csstatsx_sql>
#endif
#if VOICE_CONTROL_BY_STATS == 3
	#include <aes_main>
#endif
#if !defined _reapi_included
	#include <VtcApi>
	#if defined SUPPORT_NO_ROUND_SERVER
		#include <hamsandwich>
	#endif
#endif
#if defined BLOCK_TEXT_CHAT
	new bool:g_bBlockTextChat[33];
#endif

public plugin_init()
{
	register_plugin("Voice Control by STATS", "1.3", "neugomon");
#if defined _reapi_included	
	if(!has_vtc())
		set_fail_state("Needed meta plugin VTC [https://neugomon.ru/threads/734/]");
	else
	{
	#if defined SUPPORT_NO_ROUND_SERVER
		RegisterHookChain(RG_CBasePlayer_Spawn, "CBasePlayer_Spawn_Post", true);
	#else
		RegisterHookChain(RG_RoundEnd, "RoundEnd_Post", true);
	#endif
	}
#else
	#if defined SUPPORT_NO_ROUND_SERVER
	RegisterHam(Ham_Spawn, "player", "CBasePlayer_Spawn_Post", true);
	#else
	register_logevent("RoundEnd_Post", 2, "1=Round_End");
	#endif
#endif
#if defined BLOCK_TEXT_CHAT
	register_clcmd("say", "clcmd_Say");
	register_clcmd("say_team", "clcmd_Say");
#endif
}

public client_putinserver(id)
{
	if(!get_voice_access(id))
	{
		VTC_MuteClient(id);
	#if defined BLOCK_TEXT_CHAT
		g_bBlockTextChat[id] = true;
	#endif
	}
}
#if defined SUPPORT_NO_ROUND_SERVER
public CBasePlayer_Spawn_Post(const id)
{
	if(is_user_connected(id) && get_voice_access(id))
		VTC_UnmuteClient(id);
}
#else
public RoundEnd_Post()
{
	new players[32], pnum;
	get_players(players, pnum, "ch");
	
	for(new i; i < pnum; ++i)
	{
		if(get_voice_access(players[i]))
		{
			VTC_UnmuteClient(players[i]);
		#if defined BLOCK_TEXT_CHAT
			g_bBlockTextChat[players[i]] = false;
		#endif
		}
		else
		{
			VTC_MuteClient(players[i]);
		#if defined BLOCK_TEXT_CHAT
			g_bBlockTextChat[players[i]] = true;
		#endif
		}
	}
}
#endif
#if defined BLOCK_TEXT_CHAT
public clcmd_Say(id)
	return g_bBlockTextChat[id] ? PLUGIN_HANDLED : PLUGIN_CONTINUE;
#endif
bool:get_voice_access(id)
{
#if VOICE_CONTROL_BY_STATS == 0
	new st[8], bh[HIT_RIGHTLEG + 1];
	if(!get_user_stats(id, st, bh))
		return false;
#endif
#if VOICE_CONTROL_BY_STATS == 1
	new st[22];
	if(csstats_get_user_stats(id, st) <= 0)
		return false;
#endif
#if VOICE_CONTROL_BY_STATS == 2
	new st[8], bh[HIT_RIGHTLEG + 1];
	if(!get_user_stats_sql(id, st, bh))
		return false;
#endif
#if VOICE_CONTROL_BY_STATS == 3
	new st[1], data[4];
	if(!aes_get_player_stats(id, data))
		return false;
	else st[0] = data[1];
#endif
	return (st[0] < MIN_FRAGS) ? false : true;
}