<?php
if($page->privacy == 1 && !is_auth()) {
	show_error_page('not_auth');
}

$accusedProfileId      = 0;
$server    = 0;
$start     = 0;
$limit     = 0;
$paginator = '';
$servers   = '';

if(isset($_GET['accusedProfileId'])) {
	$accusedProfileId = clean($_GET['accusedProfileId'], "int");
}

if(empty($accusedProfileId)) {
	if(isset($_GET['page'])) {
		$number = clean($_GET['page'], "int");
	}

	$STH = $pdo->query("SELECT complaints_lim FROM config__secondary LIMIT 1");
	$STH->setFetchMode(PDO::FETCH_OBJ);
	$row   = $STH->fetch();
	$limit = $row->complaints_lim;

	if(isset($number)) {
		$start = ($number - 1) * $limit;
	} else {
		$number = 0;
		$start  = 0;
	}

	if(isset($_GET['server'])) {
		$server    = clean($_GET['server'], "int");
		$STH       = $pdo->query(
			"SELECT COUNT(*) as count FROM complaints WHERE accused_admin_server_id = '$server'"
		);
		$page_name = "../complaints/index?server=" . $server . "&";
	} else {
		$STH       = $pdo->query("SELECT COUNT(*) as count FROM complaints");
		$page_name = "../complaints/index?";
	}

	$STH->setFetchMode(PDO::FETCH_ASSOC);
	$row    = $STH->fetch();
	$count  = $row['count'];
	$stages = 3;

	if(($number * $limit - $count) > $limit) {
		header('Location: ../complaints/index');
		exit();
	}

	$paginator = $tpl->get_paginator(
		$number,
		$count,
		$limit,
		$stages,
		$page_name
	);

	if(empty($server)) {
		$servers = '<li class="active"><a href="../complaints/index">' . $messages['All'] . '</a></li>';
	} else {
		$servers = '<li><a href="../complaints/index">' . $messages['All'] . '</a></li>';
	}
	$i   = 0;
	$STH = $pdo->query("SELECT id,name FROM servers ORDER BY trim");
	$STH->setFetchMode(PDO::FETCH_OBJ);
	while($row = $STH->fetch()) {
		if($row->id == $server) {
			$servers .= '<li class="active"><a href="../complaints/index?server=' . $row->id . '">' . $row->name . '</a></li>';
		} else {
			$servers .= '<li><a href="../complaints/index?server=' . $row->id . '">' . $row->name . '</a></li>';
		}
		$i++;
	}
}

$tpl->load_template('elements/title.tpl');
$tpl->set("{title}", $page->title);
$tpl->set("{name}", $conf->name);
$tpl->compile('title');
$tpl->clear();

$tpl->load_template('head.tpl');
$tpl->set("{title}", $tpl->result['title']);
$tpl->set("{site_name}", $conf->name);
$tpl->set("{image}", $page->image);
$tpl->set("{robots}", $page->robots);
$tpl->set("{type}", $page->kind);
$tpl->set("{description}", $page->description);
$tpl->set("{keywords}", $page->keywords);
$tpl->set("{url}", $page->full_url);
$tpl->set("{other}", '');
$tpl->set("{token}", $token);
$tpl->set("{cache}", $conf->cache);
$tpl->set("{template}", $conf->template);
$tpl->set("{site_host}", $site_host);
$tpl->compile('content');
$tpl->clear();

$menu = $tpl->get_menu($pdo);

$nav = [
	$PI->to_nav('main', 0, 0),
	$PI->to_nav('complaints', 1, 0)
];
$nav = $tpl->get_nav($nav, 'elements/nav_li.tpl');

if(isset($_SESSION['id'])) {
	include_once "inc/authorized.php";
} else {
	include_once "inc/not_authorized.php";
}

$tpl->load_template('/complaints/index.tpl');
$tpl->set("{site_host}", $site_host);
$tpl->set("{template}", $conf->template);
$tpl->set("{server}", $server);
$tpl->set("{accusedProfileId}", $accusedProfileId);
$tpl->set("{start}", $start);
$tpl->set("{limit}", $limit);
$tpl->set("{servers}", $servers);
$tpl->set("{pagination}", $paginator);
$tpl->compile('content');
$tpl->clear();
?>