<?php
if(!is_admin()){
	show_error_page('not_adm');
}

$tpl->load_template('elements/title.tpl');
$tpl->set("{title}", $page->title);
$tpl->set("{name}", $conf->name);
$tpl->compile( 'title' );
$tpl->clear();

$tpl->load_template('head.tpl');
$tpl->set("{title}", $tpl->result['title']);
$tpl->set("{image}", $page->image);
$tpl->set("{other}", '<script src="{site_host}modules/editors/tinymce/tinymce.min.js"></script>');
$tpl->set("{token}", $token);
$tpl->set("{cache}", $conf->cache);
$tpl->set("{template}", $conf->template);
$tpl->set("{site_host}", $site_host);
$tpl->compile( 'content' );
$tpl->clear();

$tpl->load_template('top.tpl');
$tpl->set("{site_host}", $site_host);
$tpl->set("{site_name}", $conf->name);
$tpl->compile( 'content' );
$tpl->clear();

$tpl->load_template('menu.tpl');
$tpl->set("{site_host}", $site_host);
$tpl->compile( 'content' );
$tpl->clear();

$nav = array(
	$PI->to_nav('admin', 0, 0),
	$PI->to_nav('admin_tasks', 1, 0)
);
$nav = $tpl->get_nav($nav, 'elements/nav_li.tpl', 1);

$tpl->load_template('page_top.tpl');
$tpl->set("{nav}", $nav);
$tpl->compile( 'content' );
$tpl->clear();

$STH = $pdo->query("SELECT * FROM `tasks`");
$STH->setFetchMode(PDO::FETCH_ASSOC);

$awards = array(
	'1' => 'Деньги',
	'2' => 'Скидка'
);

foreach( $STH->fetchAll() as $task )
{
	$tpl->load_template('tasks_row.tpl');
	$tpl->set("{id}", $task['id']);
	$tpl->set("{name}", $task['name']);
	$tpl->set("{description}", $task['description']);
	$tpl->set("{fa}", $task['fa']);
	$tpl->set("{file}", $task['file']);
	$tpl->set("{strfield}", $task['strfield']);
	$tpl->set("{intfield}", $task['intfield']);
	$tpl->set("{award_count}", $task['award_count']);
	if( $task['active'] == 1 )
	{
		$tpl->set("{option}", '<option selected value="1">Включен</option><option value="2">Выключен</option>');
	} else {
		$tpl->set("{option}", '<option value="1">Включен</option><option selected value="2">Выключен</option>');
	}
	
	$list = '';

	foreach( $awards as $k => $award )
	{
		$list .= '<option '.( ( $task['award'] == $k ) ? 'selected': '' ).' value="'.$k.'">'.$award.'</option>';
	}
	
	$tpl->set("{award}", $list);
	$tpl->compile('rows');
	$tpl->clear();
}

$list = '';
foreach( $awards as $k => $award )
{
	$list .= '<option value="'.$k.'">'.$award.'</option>';
}

$tpl->load_template('tasks.tpl');
$tpl->set("{site_host}", $site_host);
$tpl->set("{award}", $list);
$tpl->set("{rows}", $tpl->result['rows']);
$tpl->compile( 'content' );
$tpl->clear();

$tpl->load_template('bottom.tpl');
$tpl->set("{site_host}", $site_host);
$tpl->compile( 'content' );
$tpl->clear();
?>