<?php
//Нельзя трогать
$module = array(
	'name' => 'demoview', 
	'to_head' => "<script src=\"$site_host/modules_extra/demoview/ajax/ajax.js?v={cache}\"></script>", 
	'tpl_dir' => "../../../modules_extra/demoview/templates/$conf->template/", 
);

class DemoView {
	private $pdo;
	private $tpl;
	private $module;

	function __construct($module, $pdo = null, $tpl = null) {
		$this->module = $module;
		if(isset($pdo)) {
			$this->pdo = $pdo;
		}
		if(isset($tpl)) {
			$this->tpl = $tpl;
		}
	}
	
	public function get_demo($start, $server, $limit = 10) {
		global $messages;

		$start = checkStart($start);
		$server = check($server, "int");
		$limit = check($limit, "int");

		if(empty($start)) {
			$start = 0;
		}
		if(empty($limit)) {
			$limit = 10;
		}

		if(empty($server)) {
			$STH = $this->pdo->query("SELECT demoview.*,users.login,users.avatar,servers.name FROM demoview LEFT JOIN users ON demoview.author = users.id LEFT JOIN servers ON demoview.server = servers.id ORDER BY date DESC LIMIT $start, $limit");
			$STH->setFetchMode(PDO::FETCH_OBJ);
		} else {
			$STH = $this->pdo->query("SELECT demoview.*,users.login,users.avatar,servers.name FROM demoview LEFT JOIN users ON demoview.author = users.id LEFT JOIN servers ON demoview.server = servers.id WHERE demoview.server = $server ORDER BY date DESC LIMIT $start, $limit");
			$STH->setFetchMode(PDO::FETCH_OBJ);
		}
		$this->tpl->result['local_content'] = '';
		while($row = $STH->fetch()) {
			if($row->status == 0) {
				$status = "Не рассмотрена";
				$color = "warning";
			}
			if($row->status == 1) {
				$status = "Читов не обнаружено";
				$color = "success";
			}
			if($row->status == 2) {
				$status = "Обнаружены читы";
				$color = "danger";
			}
			$this->tpl->load_template($this->module['tpl_dir'].'get_demo.tpl');
			$this->tpl->set("{color}", $color);
			$this->tpl->set("{id}", $row->id);
			$this->tpl->set("{nick}", $row->nick);
			$this->tpl->set("{author}", $row->author);
			$this->tpl->set("{login}", $row->login);
			$this->tpl->set("{avatar}", $row->avatar);
			$this->tpl->set("{status}", $status);
			$this->tpl->set("{name}", $row->name);
			$this->tpl->set("{date}", expand_date($row->date, 7));
			$this->tpl->compile('local_content');
			$this->tpl->clear();
		}
		if($this->tpl->result['local_content'] == '') {
			$this->tpl->result['local_content'] = '<p style="padding-top:10px;text-align: center;">Демо записей нет</p>';
		}

		return $this->tpl->result['local_content'];
	}
}
?>