/*
	Плагин: Crux Ansata
	Автор: DUKKHAZ0R 
	
	Описание:
	Плагин добавляет на сервер талисман жизни, у человека имеющего его будет восстанавливаться 5 хп каждые 2 секунды.
	В начале рануда рандомному игроку выпадает талисман жизни, если человек умирает, то любой другой сможет подобрать талисман.
	Минимальное количество игроков для работы плагина, количество восстанавливаемого здоровья и интервал восстанавления можно настроить в исходнике.
	
*/

#include <amxmodx>
#include <engine>

#define MIN_PLAYERS 4
#define ROUND_ACCESS 2
#define GIVE_HEALTH 5
#define INTERVAL_REGENERATION 2.0

new const g_szModel[] = "models/crux_ansata.mdl";

new g_iPlayerId, g_iRoundCounter, szName[32];

public plugin_init()
{
	register_plugin("Crux Ansata", "1.0", "DUKKHAZ0R");
	
	register_touch("crux_ansata", "player", "fw_TouchEntity");
	
	register_logevent("eRoundStart", 2, "1=Round_Start");
	register_event("DeathMsg", "eDeathMsg", "a", "1>0");
	register_event("TextMsg", "eRoundRestart", "a", "2&#Game_C", "2&#Game_w");
	
	set_task(INTERVAL_REGENERATION, "RegenerationHealth", .flags="b");
}

public plugin_precache()
{
	precache_model(g_szModel);
}

public client_disconnect(id)
	if(g_iPlayerId == id) g_iPlayerId = 0;
	
public eRoundRestart()
	g_iRoundCounter = 0;

public eRoundStart()
{
	if(++g_iRoundCounter < ROUND_ACCESS || get_playersnum() < MIN_PLAYERS)
		return;
		
	static iEnt;
	
	while((iEnt = find_ent_by_class(iEnt, "crux_ansata")))
		remove_entity(iEnt);
		
	static apPlayers[32], iPlayers;
	get_players(apPlayers, iPlayers, "ach");
	
	g_iPlayerId = apPlayers[random(iPlayers-1)];
	get_user_name(g_iPlayerId, szName, charsmax(szName));
	
	ChatColor(0, "^4[CA] ^3%s ^1выпал талисман жизни.", szName);
}

public eDeathMsg()
{
	static pVictim, Float:flOrigin[3]; pVictim = read_data(2);
	
	if(pVictim == g_iPlayerId)
	{
		new iEnt = create_entity("info_target");
		
		if(!is_valid_ent(iEnt))
			return;
		
		entity_get_vector(pVictim, EV_VEC_origin, flOrigin);
		entity_set_vector(iEnt, EV_VEC_origin, flOrigin);
		entity_set_string(iEnt, EV_SZ_classname, "crux_ansata");
		entity_set_int(iEnt, EV_INT_solid, SOLID_TRIGGER);
		entity_set_int(iEnt, EV_INT_movetype, MOVETYPE_NONE);
		entity_set_int(iEnt, EV_INT_effects, 8);
		entity_set_model(iEnt, g_szModel);
		entity_set_size(iEnt, Float:{-16.0,-16.0,-16.0}, Float:{16.0,16.0,16.0});
		ChatColor(g_iPlayerId = 0, "^4[CA] ^3%s ^1потерял талисман жизни.", szName);
	}
}

public fw_TouchEntity(iEnt, id)
{
	if(!is_valid_ent(iEnt))
		return;
		
	get_user_name(g_iPlayerId = id, szName, charsmax(szName));
	ChatColor(0,"^4[CA] ^3%s ^1поднял талисман жизни.",szName);
	
	entity_set_int(iEnt, EV_INT_flags, FL_KILLME);
}

public RegenerationHealth()
{
	if(!g_iPlayerId || get_playersnum() < MIN_PLAYERS)
		return;
	
	static Float:fHealth, MsgId_Health; fHealth = entity_get_float(g_iPlayerId, EV_FL_health);
	
	if(!MsgId_Health) MsgId_Health = get_user_msgid("Health");
	
	if(fHealth < 100 && is_user_alive(g_iPlayerId))
	{
		static Float:giveHealth; giveHealth = (fHealth + GIVE_HEALTH) < 100 ? float(GIVE_HEALTH) : (100 - fHealth);
		
		entity_set_float(g_iPlayerId, EV_FL_health, fHealth + giveHealth);
		
		message_begin(MSG_ONE_UNRELIABLE, MsgId_Health, _, g_iPlayerId);
		write_byte(floatround(fHealth + giveHealth));
		message_end();
		
		message_begin(MSG_ONE_UNRELIABLE, 98, _, g_iPlayerId);
		write_short(1<<10);
		write_short(1<<10);
		write_short(0x0000);
		write_byte(0);
		write_byte(255);
		write_byte(0);
		write_byte(40);
		message_end();
	}
}

stock ChatColor(const id, const szMessage[], any:...)
{
	static szBuffer[191], apPlayers[32], iPlayers; iPlayers = 1;
	vformat(szBuffer, charsmax(szBuffer), szMessage, 3);
	if(id)
	{
		if(!is_user_connected(id)) return;
		apPlayers[0] = id;
		iPlayers = 1;
	}
	else get_players(apPlayers, iPlayers, "ch");
	for(new i;i < iPlayers; i++)
	{
		message_begin(MSG_ONE_UNRELIABLE, 76, .player = apPlayers[i]);
		write_byte(apPlayers[i]);
		write_string(szBuffer);
		message_end();
	}
}