<?php
if($page->privacy == 1 || !is_auth()) {
	show_error_page('not_auth');
}

$tpl->load_template('elements/title.tpl');
$tpl->set("{title}", $page->title);
$tpl->set("{name}", $conf->name);
$tpl->compile( 'title' );
$tpl->clear();

$tpl->load_template('head.tpl');
$tpl->set("{title}", $tpl->result['title']);
$tpl->set("{site_name}", $conf->name);
$tpl->set("{image}", $page->image);
$tpl->set("{robots}", $page->robots);
$tpl->set("{type}", $page->kind);
$tpl->set("{description}", $page->description);
$tpl->set("{keywords}", $page->keywords);
$tpl->set("{url}", $page->full_url);
$tpl->set("{other}", '');
$tpl->set("{token}", $token);
$tpl->set("{cache}", $conf->cache);
$tpl->set("{template}", $conf->template);
$tpl->set("{site_host}", $site_host);
$tpl->compile( 'content' );
$tpl->clear();

$menu = $tpl->get_menu($pdo);

$nav = array(
	$PI->to_nav('main', 0, 0),
	$PI->to_nav('tasks', 1, 0)
);
$nav = $tpl->get_nav($nav, 'elements/nav_li.tpl');

if(isset($_SESSION['id'])) {
	include_once "inc/authorized.php";
} else {
	include_once "inc/not_authorized.php";
}

$STH = $pdo->query("SELECT * FROM `users__tasks` WHERE `userid` = {$_SESSION[id]}");
$STH->setFetchMode(PDO::FETCH_ASSOC);
$complet = $STH->fetchAll();

$STH = $pdo->query("SELECT * FROM `tasks` WHERE `active`=1");
$STH->setFetchMode(PDO::FETCH_ASSOC);

foreach( $STH->fetchAll() as $task )
{
	$tpl->load_template('tasks/row.tpl');
	$tpl->set("{id}", $task['id']);
	$tpl->set("{fa}", $task['fa']);
	$tpl->set("{name}", $task['name']);
	$tpl->set("{description}", $task['description']);
	
	if( array_search($task['id'], array_column($complet, 'taskid')) !== false )
	{
		$tpl->set("{status}", '<div class="btn btn-outline-success">Выполнено</div>');
	} else {
		$tpl->set("{status}", '<div class="btn btn-outline-primary" data-target="#tasksmodal" data-toggle="modal" onclick="task_check_file('.$task['id'].');">Проверить</div>');
	}
	
	$tpl->compile('rows');
	$tpl->clear();
}

$tpl->load_template('tasks/tasks.tpl');
$tpl->set("{site_host}", $site_host);
$tpl->set("{rows}", $tpl->result['rows']);
$tpl->set("{template}", $conf->template);
$tpl->compile( 'content' );
$tpl->clear();
?>