#include <amxmodx>
#include <fakemeta>
#include <hamsandwich>

#define PLUGIN	"Back Weapons"
#define AUTHOR	"hoboman313/cheap_suit/EFFEX"
#define VERSION	"1.87"

#if AMXX_VERSION_NUM < 183
#define client_disconnected		client_disconnect
#endif

#define MAX_PLAYERS 		32
#define OFFSET_WEAPONTYPE 	43
#define EXTRAOFFSET_WEAPONS 	4
#define MAX_BACKWEAPONS		2

#define PRIMARY_WEAPONS (1<<CSW_SCOUT | 1<<CSW_MAC10 | 1<<CSW_AUG | 1<<CSW_UMP45 | 1<<CSW_SG550 | 1<<CSW_GALIL | 1<<CSW_FAMAS | 1<<CSW_AWP | 1<<CSW_MP5NAVY | 1<<CSW_M249 | 1<<CSW_M4A1 | 1<<CSW_TMP | 1<<CSW_G3SG1 | 1<<CSW_SG552 | 1<<CSW_AK47 | 1<<CSW_P90)
#define INVALID_WEAPONS (1<<CSW_HEGRENADE | 1<<CSW_FLASHBANG | 1<<CSW_SMOKEGRENADE | 1<<CSW_C4 | 1<<CSW_KNIFE | 1 << CSW_USP | 1 << CSW_GLOCK18 | 1 << CSW_ELITE | 1 << CSW_DEAGLE | 1 << CSW_FIVESEVEN | 1 << CSW_P228)

#define isInvalidWeapon(%1)        (INVALID_WEAPONS & (1<<%1))
#define is_weapon_primary(%1)      (PRIMARY_WEAPONS & (1<<%1))
#define cs_get_weapon_type(%1)     get_pdata_int(%1, OFFSET_WEAPONTYPE, EXTRAOFFSET_WEAPONS)

enum
{
	MODEL_NULL    = 0,
	MODEL_AUG     = 1,
	MODEL_AK47    = 2,
	MODEL_AWP     = 3,
	MODEL_MP5NAVY = 4,
	MODEL_P90     = 5,
	MODEL_GALIL   = 6,
	MODEL_M4A1    = 7,
	MODEL_SG550   = 8,
	MODEL_SG552   = 9,
	MODEL_SCOUT   = 10,
	MODEL_XM1014  = 11,
	MODEL_M3      = 12,
	MODEL_G3SG1   = 13,
	MODEL_M249    = 14,
	MODEL_FAMAS   = 15,
	MODEL_UMP45   = 16
}

new g_weapons[][] =
{	
	"weapon_p228",
	"weapon_scout",
	"weapon_hegrenade",
	"weapon_xm1014",
	"weapon_c4",
	"weapon_mac10",
	"weapon_aug",
	"weapon_smokegrenade",
	"weapon_elite",
	"weapon_fiveseven",
	"weapon_ump45",
	"weapon_sg550",
	"weapon_galil",
	"weapon_famas",
	"weapon_usp",
	"weapon_glock18",
	"weapon_awp",
	"weapon_mp5navy",
	"weapon_m249",
	"weapon_m3",
	"weapon_m4a1",
	"weapon_tmp",
	"weapon_g3sg1",
	"weapon_flashbang",
	"weapon_deagle",
	"weapon_sg552",
	"weapon_ak47",
	"weapon_knife",
	"weapon_p90"
}

new g_weaponclass[] = "backweapon"
new g_weaponmodel[] = "models/pubg/resources/pubg_backweapons.mdl"

new g_weaponent[MAX_PLAYERS+1][MAX_BACKWEAPONS]

public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	register_cvar(PLUGIN, VERSION, FCVAR_SPONLY|FCVAR_SERVER)
	
	RegisterHam(Ham_Killed,           "player", "bacon_killed")
	RegisterHam(Ham_Spawn,            "player", "bacon_spawn_post", 1)
	RegisterHam(Ham_AddPlayerItem,    "player", "bacon_addplayeritem")
	RegisterHam(Ham_RemovePlayerItem, "player", "bacon_removeplayeritem")
	
	for(new i; i < sizeof g_weapons; i++)
	{
		RegisterHam(Ham_Item_Deploy,         g_weapons[i], "bacon_item_deploy_post",         1)
	}
}

public plugin_precache()
	precache_model(g_weaponmodel)

public client_putinserver(id)
{
	static infotarget 
	if(!infotarget) infotarget = engfunc(EngFunc_AllocString, "info_target")
	
	for(new i, iEntID;i < MAX_BACKWEAPONS;i++)
	{
		iEntID = g_weaponent[id][i] = engfunc(EngFunc_CreateNamedEntity, infotarget)
		if(pev_valid(iEntID))
		{
			engfunc(EngFunc_SetModel, iEntID, g_weaponmodel)
			set_pev(iEntID, pev_classname, g_weaponclass)
			set_pev(iEntID, pev_movetype, MOVETYPE_FOLLOW)
			set_pev(iEntID, pev_effects, EF_NODRAW)
			set_pev(iEntID, pev_aiment, id)
		}
	}
}

public client_disconnected(id)
{
	if(isAllEntitiesValid(id))
		engfunc(EngFunc_RemoveEntity, g_weaponent[id])
	
	g_weaponent[id][0] = g_weaponent[id][1] = 0
}

public bacon_killed(id, idattacker, shouldgib)
{
	turnBothEntitiesInvisible(id)
}

public bacon_addplayeritem(id, ent)
{
	static weaponid; weaponid = cs_get_weapon_type(ent)
	if(isAllEntitiesValid(id) && !isInvalidWeapon(weaponid))
	{
		set_pev(g_weaponent[id][is_weapon_primary((weaponid = cs_get_weapon_type(ent))) ? 0 : 1], pev_body, get_weapon_model(weaponid))
		turnBothEntitiesInvisible(id)
	}
	return HAM_IGNORED
}

public bacon_spawn_post(id) 
{
	if(is_user_alive(id))
	{
		turnBothEntitiesInvisible(id)
	}
}

public bacon_removeplayeritem(id, ent)
{
	static weapon;weapon = cs_get_weapon_type(ent)
	if(isAllEntitiesValid(id) && !isInvalidWeapon(weapon))
	{
		fm_set_entity_visibility(g_weaponent[id][is_weapon_primary(weapon) ? 0 : 1], 0)
	}
}

public bacon_item_deploy_post(ent)
{
	static id; id = pev(ent, pev_owner)
	if(is_user_alive(id)) 
	{
		static iWeaponType, weapon
		iWeaponType = is_weapon_primary((weapon = cs_get_weapon_type(ent))) ? 0 : 1
		
		if(isInvalidWeapon(weapon))
		{
			checkVisibility(id)
			return
		}
		
		new iOppositeWeaponEntity = g_weaponent[id][iWeaponType ? 0 : 1]
		if(user_has_weapon(id, getWeaponIdFromModel(iOppositeWeaponEntity)))
		{
			fm_set_entity_visibility(iOppositeWeaponEntity, 1)
		}
		fm_set_entity_visibility(g_weaponent[id][iWeaponType], 0)
	}
}

checkVisibility(id)
{
	new iRifleModel = g_weaponent[id][0], iShotgunModel = g_weaponent[id][1]	
	fm_set_entity_visibility(iRifleModel, user_has_weapon(id, getWeaponIdFromModel(iRifleModel)) ? 1 : 0)
	fm_set_entity_visibility(iShotgunModel, user_has_weapon(id, getWeaponIdFromModel(iShotgunModel)) ? 1 : 0)
}

getWeaponIdFromModel(iEnt)
{
	switch(pev(iEnt, pev_body))
	{
		case MODEL_SCOUT:   return CSW_SCOUT
		case MODEL_XM1014:  return CSW_XM1014
		case MODEL_AUG:     return CSW_AUG
		case MODEL_UMP45:   return CSW_UMP45
		case MODEL_SG550:   return CSW_SG550
		case MODEL_GALIL:   return CSW_GALIL
		case MODEL_FAMAS:   return CSW_FAMAS
		case MODEL_AWP:     return CSW_AWP
		case MODEL_MP5NAVY: return CSW_MP5NAVY
		case MODEL_M249:    return CSW_M249
		case MODEL_M3:      return CSW_M3
		case MODEL_M4A1:    return CSW_M4A1
		case MODEL_G3SG1:   return CSW_G3SG1
		case MODEL_SG552:   return CSW_SG552
		case MODEL_AK47:    return CSW_AK47
		case MODEL_P90:     return CSW_P90
	}
	return 0
}

get_weapon_model(weapon)
{
	switch(weapon)
	{
		case CSW_SCOUT:   return MODEL_SCOUT
		case CSW_XM1014:  return MODEL_XM1014
		case CSW_AUG:	  return MODEL_AUG
		case CSW_UMP45:   return MODEL_UMP45
		case CSW_SG550:   return MODEL_SG550
		case CSW_GALIL:   return MODEL_GALIL
		case CSW_FAMAS:   return MODEL_FAMAS
		case CSW_AWP:     return MODEL_AWP
		case CSW_MP5NAVY: return MODEL_MP5NAVY
		case CSW_M249:    return MODEL_M249
		case CSW_M3:      return MODEL_M3
		case CSW_M4A1:    return MODEL_M4A1
		case CSW_G3SG1:   return MODEL_G3SG1
		case CSW_SG552:   return MODEL_SG552
		case CSW_AK47:    return MODEL_AK47
		case CSW_P90:     return MODEL_P90
	}
	return 0
}

bool:isAllEntitiesValid(id)
{
	new bool:bReturn = false
	for(new i;i < MAX_BACKWEAPONS;i++)
	{
		if((g_weaponent[id][i] > 0) && pev_valid(g_weaponent[id][i]))
		{
			bReturn = true
			break
		}
	}
	return bReturn
}

turnBothEntitiesInvisible(id)
{
	fm_set_entity_visibility(g_weaponent[id][0], 0)
	fm_set_entity_visibility(g_weaponent[id][1], 0)
}

fm_set_entity_visibility(index, visible) 
{
	set_pev(index, pev_effects, visible == 1 ? pev(index, pev_effects) & ~EF_NODRAW : pev(index, pev_effects) | EF_NODRAW)
}
