#include <amxmodx>
#include <amxmisc>
#include <pubnite_mod>
#include <cromchat>

#define PLUGIN 				"PUBNITE: Commands Management"
#define VERSION 			"1.0"
#define AUTHOR 				"EFFEX"

#define resetPlayerTeam(%1)		pubnite_set_user_team(%1, 0, false)
#define isTeam(%1)			(1 <= get_user_team(%1) <= 2)

#define DUO_NUM				2
#define TRIO_NUM			3
#define SQUAD_NUM			4

const CONST_GRENADES =			(1 << CSW_HEGRENADE)|(1 << CSW_FLASHBANG)|(1 << CSW_SMOKEGRENADE)

public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	register_dictionary("effxs_battleroyale.txt")
	
	register_concmd("pubnite_set_vbucks", "cmdVBucks", ADMIN_BAN, "<name@all> <vbucks (use 0 for reset the win value)> <0|1 (take/give)> - give/take/reset vbucks for/from/of the player")
	register_concmd("pubnite_set_wins", "cmdSetWins", ADMIN_KICK, "<name|@all> <value (use 0 for reset the win value)> <0 (duo)|1 (trio)|2 (squad)> <0|1 (take|give)> - give/take/reset victories for/from/of the player")
	register_concmd("pubnite_get_weapons_list", "cmdGetWeaponsList", ADMIN_KICK)
	register_concmd("pubnite_customitem_life", "cmdChangeItemLife", ADMIN_BAN, "<customitem id> <new life>")
	register_concmd("pubnite_spawn_weapon", "cmdSpawnWeapon", ADMIN_KICK, "<weapon id/name (type pubnite_get_weapons_list)> <weapon rarity>")
	register_concmd("pubnite_reset_teams", "cmdResetTeams", ADMIN_KICK, "<name|@all|@duos|@trios|@squads> - reset player's team or determined type of teams")
	register_concmd("pubnite_set_user_team", "cmdSetUserTeam", ADMIN_BAN, "<name> <teamid or player name to follow> - type pubnite_get_teams to get team id")
	register_concmd("pubnite_make_teams", "cmdMakeTeams", ADMIN_KICK, "<duos|trios|squads> - make random teams")
	register_concmd("pubnite_get_teams", "cmdGetsTeams", ADMIN_KICK)
}

public cmdGetWeaponsList(id, iLevel, iCid)
{
	if(!cmd_access(id, iLevel, iCid, 1))
		return PLUGIN_HANDLED

	for(new i = 1, szWeaponName[MAX_PLAYERS];i <= CSW_P90;i++)
	{
		if(pubnite_is_weapon_registered(i))
		{
			get_weaponname(i, szWeaponName, charsmax(szWeaponName))
			replace(szWeaponName, charsmax(szWeaponName), "weapon_", "")
			
			console_print(id, "Weapon: %s, ID: %d", szWeaponName, i)
		}
	}
	return PLUGIN_HANDLED
}

public cmdSetWins(id, iLevel, iCid)
{
	if(!cmd_access(id, iLevel, iCid, 3))
		return PLUGIN_HANDLED

	new szTarget[MAX_PLAYERS], szWinType[2], szParam[2], szValue[10]
	read_argv(1, szTarget, charsmax(szTarget))
	read_argv(2, szValue, charsmax(szValue))
	read_argv(3, szWinType, charsmax(szWinType))
	read_argv(4, szParam, charsmax(szParam))

	new iValue = str_to_num(szValue)

	new iWinType = clamp(str_to_num(szWinType), 0, 2)
	new iParam = str_to_num(szParam)

	new iTarget, bool:bIsForEveryone = bool:(szTarget[0] == '@')
	if(bIsForEveryone)
	{
		new iPlayers[MAX_PLAYERS], iNum
		get_players(iPlayers, iNum, "ch")
		for(new i;i < iNum;i++)
		{
			setWins(iPlayers[i], bool:iParam, iWinType, iValue)
		}
	}
	else
	{
		iTarget = cmd_target(id, szTarget, CMDTARGET_NO_BOTS)
		if(!iTarget)
			return PLUGIN_HANDLED

		setWins(iTarget, bool:iParam, iWinType, iValue)
	}
	
	new szTargetName[MAX_PLAYERS]
	get_user_name(iTarget, szTargetName, charsmax(szTargetName))
	if(iValue > 0)
	{
		CC_SendMatched(0, CC_COLOR_RED, "Admin: %s^x04 %d^x01 victories %s^x04 %s.", iParam ? "gave" : "took", iValue, iParam ? "for" : "from", bIsForEveryone ? "everyone" : szTargetName)
	}
	else
	{
		CC_SendMatched(0, CC_COLOR_RED, "Admin: reseted&x04 %s&x01's victory value!", szTargetName)
	}
	return PLUGIN_HANDLED
}

setWins(iPlayer, bool:bSet, iWinType, iValue)
{
	if(!iValue)
	{
		pubnite_set_user_wins(iPlayer, 0, -1)
		return
	}

	if(bSet)
	{
		pubnite_set_user_wins(iPlayer, (pubnite_get_user_wins(iPlayer, iWinType) + iValue), iWinType)
	}
	else pubnite_set_user_wins(iPlayer, (pubnite_get_user_wins(iPlayer, iWinType) - iValue), iWinType)
}

public cmdVBucks(id, iLevel, iCid)
{
	if(!cmd_access(id, iLevel, iCid, 3))
		return PLUGIN_HANDLED

	new szTarget[MAX_PLAYERS], szParam[2], szVBucks[15]
	read_argv(1, szTarget, charsmax(szTarget))
	read_argv(2, szVBucks, charsmax(szVBucks))
	read_argv(3, szParam, charsmax(szParam))
	
	new bool:iParam = bool:str_to_num(szParam), iTarget, iVBucks = str_to_num(szVBucks)	
	new bool:bForEveryone = bool:(szTarget[0] == '@')
	if(bForEveryone)
	{
		new iPlayers[MAX_PLAYERS], iNum
		get_players(iPlayers, iNum, "ch")
		for(new i;i < iNum;i++)
		{
			setVBucks(iPlayers[i], iVBucks, iParam)
		}
	}
	else
	{
		iTarget = cmd_target(id, szTarget, CMDTARGET_NO_BOTS)
		if(!iTarget)
			return PLUGIN_HANDLED
		
		setVBucks(iTarget, iVBucks, iParam)
	}
	
	new szTargetName[MAX_PLAYERS]
	get_user_name(iTarget, szTargetName, charsmax(szTargetName))
	if(iVBucks > 0)
	{
		CC_SendMatched(0, CC_COLOR_RED, "Admin: %s^x04 %d^x01 vbucks %s^x04 %s.", iParam ? "gave" : "took", iVBucks, iParam ? "for" : "from", bForEveryone ? "everyone" : szTargetName)
	}
	else
	{
		CC_SendMatched(0, CC_COLOR_RED, "Admin: reseted&x04 %s&x01's vbucks value!", szTargetName)
	}
	return PLUGIN_HANDLED
}

setVBucks(id, iVBucks, bool:bSet)
{
	if(!iVBucks)
	{
		pubnite_set_user_vbucks(id, 0)
		return
	}

	if(bSet)
	{
		pubnite_set_user_vbucks(id, pubnite_get_user_vbucks(id) + iVBucks)
	}
	else pubnite_set_user_vbucks(id, pubnite_get_user_vbucks(id) - iVBucks)
}

public cmdChangeItemLife(id, iLevel, iCid)
{
	if(!cmd_access(id, iLevel, iCid, 3))
		return PLUGIN_HANDLED

	new szCustomItemID[5], szLife[2]
	read_argv(1, szCustomItemID, charsmax(szCustomItemID))
	read_argv(2, szLife, charsmax(szLife))

	new iLife = str_to_num(szLife)
	if(iLife <= 0)
	{
		console_print(id, "[AMXX]: Invalid life value!")
		return PLUGIN_HANDLED
	}

	pubnite_change_item_life(str_to_num(szCustomItemID), iLife)
	return PLUGIN_HANDLED
}

public cmdSpawnWeapon(id, iLevel, iCid)
{
	if(!cmd_access(id, iLevel, iCid, 2))
		return PLUGIN_HANDLED
		
	new szWeaponID[17], szWeaponRarity[2]
	read_argv(1, szWeaponID, charsmax(szWeaponID))
	read_argv(2, szWeaponRarity, charsmax(szWeaponRarity))

	new iWeaponID = str_to_num(szWeaponID), iRarity = str_to_num(szWeaponRarity)
	if(!iWeaponID)
	{
		format(szWeaponID, charsmax(szWeaponID), "weapon_%s", szWeaponID)
		if(!(iWeaponID = get_weaponid(szWeaponID)))
		{
			console_print(id, "[AMXX]: Invalid weapon ID/NAME.")
			return PLUGIN_HANDLED
		}
	}
	else if(!((1 << iWeaponID) & CONST_GRENADES) && !iRarity)
	{
		console_print(id, "Usage: pubnite_spawn_weapon <weapon id (type pubnite_get_weapons_list)> <weapon rarity>")
		return PLUGIN_HANDLED
	}

	pubnite_create_weapon(iWeaponID, iRarity, id)
	return PLUGIN_HANDLED
}

public cmdSetUserTeam(id, iLevel, iCid)
{
	if(!cmd_access(id, iLevel, iCid, 3))
		return PLUGIN_HANDLED
		
	new szTarget[MAX_PLAYERS], szTeamID[MAX_PLAYERS]
	read_argv(1, szTarget, charsmax(szTarget))
	read_argv(2, szTeamID, charsmax(szTeamID))
	
	new iTarget = cmd_target(id, szTarget, CMDTARGET_NO_BOTS)
	if(!iTarget)
		return PLUGIN_HANDLED
		
	new iTeamID = str_to_num(szTeamID), szTargetName[MAX_PLAYERS]
	if(pubnite_players_remaining(iTeamID, false) > 0)
	{
		if(isTeamCompleted(.iTeamID = iTeamID))
		{
			console_print(id, "[AMXX]: Team not avaliable to receive new players!")
			return PLUGIN_HANDLED
		}
		pubnite_set_user_team(iTarget, iTeamID, false)
		
		get_user_name(iTarget, szTargetName, charsmax(szTargetName))
		CC_SendMatched(0, CC_COLOR_RED, "Admin: changed the team of the player^x04 %s.", szTargetName)
	}
	else
	{
		if(isNotContainingLetters(szTeamID))
		{
			console_print(id, "[AMXX]: Team does not exists!")
			return PLUGIN_HANDLED
		}
			
		if(!(iTarget = find_player("a", szTeamID)))
			return PLUGIN_HANDLED
			
		if(!(iTeamID = pubnite_get_user_team(iTarget)))
		{
			console_print(id, "[AMXX]: This player does not have a team!")
			return PLUGIN_HANDLED
		}
		else if(isTeamCompleted(iTarget))
		{
			console_print(id, "[AMXX]: Team not avaliable to receive new players!")
			return PLUGIN_HANDLED
		}

		pubnite_set_user_team(iTarget, iTeamID, false)
		
		get_user_name(iTarget, szTargetName, charsmax(szTargetName))
		CC_SendMatched(0, CC_COLOR_RED, "Admin: changed the team of the player^x04 %s.", szTargetName)
	}
	return PLUGIN_HANDLED
}

public cmdResetTeams(id, iLevel, iCid)
{
	if(!cmd_access(id, iLevel, iCid, 2))
		return PLUGIN_HANDLED

	if(!pubnite_teamsLeft(1, false))
	{
		console_print(id, "[AMXX]: There are no teams to reset!")
		return PLUGIN_HANDLED
	}

	new szTeamsType[MAX_PLAYERS]
	read_argv(1, szTeamsType, charsmax(szTeamsType))
	if(szTeamsType[0] == '@')
	{
		new iTeammatesNum
		getNum(szTeamsType, iTeammatesNum)

		new iPlayers[MAX_PLAYERS], iNum
		get_players(iPlayers, iNum, "ch")
		for(new i, iPlayer;i < iNum;i++)
		{
			iPlayer = iPlayers[i]
			if(szTeamsType[1] == 'a')
			{
				pubnite_reset_team_array()
				resetPlayerTeam(iPlayer)
			}
			else 
			{
				if(pubnite_players_remaining(pubnite_get_user_team(iPlayer), false) == iTeammatesNum)
				{
					resetPlayerTeam(iPlayer)
				}
			}
		}
		CC_SendMatched(0, CC_COLOR_RED, "Admin: reseted everyone's team.")
	}
	else
	{
		new iTarget = cmd_target(id, szTeamsType, CMDTARGET_NO_BOTS)
		if(!iTarget)
			return PLUGIN_HANDLED

		if(!pubnite_get_user_team(iTarget))
		{
			console_print(id, "[AMXX]: This player is solo.")
			return PLUGIN_HANDLED
		}

		new szTargetName[MAX_PLAYERS]
		get_user_name(iTarget, szTargetName, charsmax(szTargetName))
		CC_SendMatched(0, CC_COLOR_RED, "Admin: reseted^x04 %s's^x01 team.", szTargetName)

		resetPlayerTeam(iTarget)
	}
	return PLUGIN_HANDLED
}

public cmdMakeTeams(id, iLevel, iCid)
{
	if(!cmd_access(id, iLevel, iCid, 2))
		return PLUGIN_HANDLED
		
	if(!pubnite_is_in_countdown())
	{
		console_print(id, "%L", id, "SERVER_TEAM_IN_COUNTDOWN")
		return PLUGIN_HANDLED
	}
	
	new szTeamsType[10], iTeammatesNum
	read_argv(1, szTeamsType, charsmax(szTeamsType))
	getNum(szTeamsType, iTeammatesNum)
	
	if(cantMakeTeam(id, iTeammatesNum))
		return PLUGIN_HANDLED	

	new iPlayers[MAX_PLAYERS], iNum
	get_players(iPlayers, iNum, "ach")

	if(iTeammatesNum == DUO_NUM)
	{
		if((iNum & 1) != 0) // is the number of players odd?
		{
			console_print(id, "[AMXX]: Number of players is odd, you cannot make everyone team up as duo.")
			return PLUGIN_HANDLED
		}
	}
	else
	{
		new Float:fCalc = (float(iNum) / float(iTeammatesNum))
		if((fCalc - float(floatround(fCalc)) != 0.0))
		{					 
			console_print(id, "[AMXX]: Number of players is insufficient, you cannot make everyone team up as duo.")
			return PLUGIN_HANDLED
		}
	}
	
	new Array:g_arPlayersID = ArrayCreate(1, MAX_PLAYERS)
	for(new i, iPlayer;i < iNum;i++)
	{
		iPlayer = iPlayers[i]
	
		if(isTeam(iPlayer))
		{
			resetPlayerTeam(iPlayer)
			pubnite_reset_team_array()

			ArrayPushCell(g_arPlayersID, iPlayer)
		}
	}

	new iArraySize = ArraySize(g_arPlayersID), iTeamsFormed = 1
	for(new i, iPlayersPicked;i < iArraySize;i++)
	{
		iPlayersPicked++
		pubnite_set_user_team(ArrayGetCell(g_arPlayersID, i), iTeamsFormed, false)
		
		if((iPlayersPicked == iTeammatesNum) && (i < (iArraySize - 1)))
		{
			iTeamsFormed++
			iPlayersPicked = 0
		}
	}

	console_print(id, "------------------ Teams ------------------")
	console_print(id, "You've successfully made %d teams.", iTeamsFormed)
	console_print(id, "------------------ Teams ------------------")
	
	CC_SendMatched(0, CC_COLOR_RED, "Admin: made players team up as^x04 %s^x01", szTeamsType)
	return PLUGIN_HANDLED
}

public cmdGetsTeams(id, iLevel, iCid)
{
	if(!cmd_access(id, iLevel, iCid, 1))
		return PLUGIN_HANDLED
		
	console_print(id, "------------------ TEAMS ------------------")
	
	new szMessage[MAX_PLAYERS_PER_TEAM][192], iTeamNum
	for(new i;i < MAX_PLAYERS_PER_TEAM;i++)
	{
		if(pubnite_players_remaining(i, false) > 0)
		{
			iTeamNum++
			
			getAllMembersFromTeam(id, i, szMessage[i], charsmax(szMessage[]))
			console_print(id, "Team ID %d - %s", iTeamNum, szMessage[i])
		}
	}

	if(!iTeamNum)
	{
		console_print(id, "[AMXX]: No teams found!")
	}
	
	console_print(id, "------------------ TEAMS ------------------")
	return PLUGIN_HANDLED
}

getAllMembersFromTeam(id, iTeamID, szMessage[], iLen)
{
	new szPreposition[5]
	formatex(szPreposition, charsmax(szPreposition), " %L ", id, "SERVER_PREPOSITION")
	
	new iPlayers[MAX_PLAYERS], iNum, iNamesGot, iMembersNum = pubnite_players_remaining(iTeamID, false)
	get_players(iPlayers, iNum, "ch")
	for(new i, iPlayer, szName[MAX_PLAYERS];i < iNum;i++)
	{
		iPlayer = iPlayers[i]
		
		if(pubnite_get_user_team(iPlayer) == iTeamID)
		{
			iNamesGot++
			
			get_user_name(iPlayer, szName, charsmax(szName))
			formatex(szMessage, iLen, "%s%s%s", szMessage, szName, (iNamesGot == (iMembersNum - 1)) ? szPreposition : (iNamesGot < (iMembersNum - 1)) ? ", " : "")
		}
	}
}

cantMakeTeam(id, iTeamType)
{
	new iCvarValue[3]
	getCvarValue(iCvarValue)
	
	new iPlayers[MAX_PLAYERS], playerCount
	get_players(iPlayers, playerCount, "ach")
	if((iTeamType == DUO_NUM) && playerCount < iCvarValue[0])
	{
		console_print(id, "%L", id, "SERVER_TEAM_MIN_PLAYERS_DUO", iCvarValue[0])
		return true
	}
	
	if((iTeamType == TRIO_NUM) && playerCount < iCvarValue[1])
	{
		console_print(id, "%L", id, "SERVER_TEAM_MIN_PLAYERS_THREESOME", iCvarValue[1])
		return true
	}
	
	if((iTeamType == SQUAD_NUM) && playerCount < iCvarValue[2])
	{
		console_print(id, "%L", id, "SERVER_TEAM_MIN_PLAYERS_SQUAD", iCvarValue[2])
		return true
	}
	return false
}

getCvarValue(iValue[3])
{
	iValue[0] = get_cvar_num("pubnite_min_players_to_duo")
	iValue[1] = get_cvar_num("pubnite_min_players_to_threesome")
	iValue[2] = get_cvar_num("pubnite_min_players_to_squad")
}

getNum(szTeamsType[], &iTeammatesNum)
{
	switch(szTeamsType[0])
	{
		case 't', 'T':
		{
			iTeammatesNum = TRIO_NUM
		}
		case 's', 'S':
		{
			iTeammatesNum = SQUAD_NUM
		}
		default:
		{
			iTeammatesNum = DUO_NUM
		}
	}
}

isTeamCompleted(iTarget = 0, iTeamID = 0)
{
	new iCvarValue[3]
	getCvarValue(iCvarValue)
	
	new iPlayers[MAX_PLAYERS], playerCount, iPlayersInMyTeam = pubnite_players_remaining(iTeamID ? iTeamID : pubnite_get_user_team(iTarget), false)
	get_players(iPlayers, playerCount, "ach")
	if(!iPlayersInMyTeam && (playerCount < iCvarValue[0]))
	{
		return true
	}
	else if((iPlayersInMyTeam == 2) && (playerCount < iCvarValue[1]))
	{
		return true
	}
	else if((iPlayersInMyTeam == 3) && (playerCount < iCvarValue[2]))
	{
		return true
	}
		
	if(iPlayersInMyTeam >= min(get_cvar_num("pubnite_max_players_in_team"), MAX_PLAYERS_PER_TEAM))
	{
		return true
	}
	return false
}

isNotContainingLetters(const szString[])
{
	new iLen = strlen(szString), iCount
	for(new i;i < iLen;i++)
	{
		if(isalpha(szString[i]))
			iCount++
	}
	return bool:(iCount < iLen)
}
