#include <amxmodx>
#include <fakemeta>

#define PLUGIN 				"PUBNite: Compass"
#define VERSION 			"1.0"
#define AUTHOR 				"EFFEX"

#if !defined MAX_PLAYERS
#define MAX_PLAYERS			32
#endif

new g_hHudCompass

public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	g_hHudCompass = CreateHudSyncObj()
	set_task(0.1, "showCompassHud", .flags = "b")
}

public showCompassHud()
{
	new iPlayers[MAX_PLAYERS], iNum
	get_players(iPlayers, iNum, "ach")
	if(!iNum)
		return

	new Float:fAngles[MAX_PLAYERS + 1][3], szHud[100]
	for(new i, iPlayer;i < iNum;i++)
	{
		iPlayer = iPlayers[i]

		pev(iPlayer, pev_angles, fAngles[iPlayer])
		getCompassString(fAngles[iPlayer][1], szHud, charsmax(szHud))

		set_hudmessage(200, 200, 200, -1.0, 0.0, 0, 6.0, 0.1)
		ShowSyncHudMsg(iPlayer, g_hHudCompass, "v^n%s", szHud)
	}
}

getCompassString(Float:fAngle, szString[], iLen)
{
	static szCompassStrings[24][4] = 
	{
		"N", "15", "30", 
		"NE", "60", "75", 
		"E", "105", "120", 
		"SE", "150", "165", 
		"S", "195", "210", 
		"SW", "240", "255", 
		"W", "285", "300", 
		"NW", "330", "345"
	}
	const iDirectionsNumber = 9
	
	new iStart = (floatround(fAngle / 15.0) % sizeof szCompassStrings) - iDirectionsNumber / 2
	for(new i = iStart, curlen; i < (iStart + iDirectionsNumber); i++ )
	{
		curlen += formatex
		(
			szString[curlen], 
			iLen - curlen, 
			"    %s", 
			szCompassStrings[(i < 0 ? i + sizeof szCompassStrings : i) % sizeof szCompassStrings]
		)
	}
}
