#include <amxmodx>
#include <fakemeta>

#define PLUGIN 				"PUBNite: Custom Item Base"
#define VERSION 			"1.0"
#define AUTHOR 				"EFFx"

#if !defined MAX_PLAYERS
#define MAX_PLAYERS			32
#endif

#define isInvalidItem(%1)		(%1 < 0) || (%1 > ArraySize(g_arrayCustomItems) - 1)

#define MAX_MODEL_LENGTH		64
#define MAX_CUSTOM_ITEMS		10
#define START_CUSTOM_ITEMS_ID		150

enum _:cCustomItensData
{
	szCustomItemName[MAX_MODEL_LENGTH],
	szCustomItemModel[MAX_MODEL_LENGTH],
	iCustomItemRarity,
	iCustomItemID,
	iCustomItemLife,
	iCustomItemFunc,
	iCustomItemPluginID
}

new Array:g_arrayCustomItems

public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
}

public plugin_natives()
{
	g_arrayCustomItems = ArrayCreate(cCustomItensData)
	
	register_native("pubnite_register_customitem", "_RegisterCustomItem")
	register_native("pubnite_get_customitem_data", "_GetCustomItemData")
	register_native("pubnite_is_customitem", "_IsCustomItem")
	register_native("pubnite_get_customitem_num", "_GetCustomItemsNum")
	register_native("pubnite_get_customitem", "_GetCustomItem")
	register_native("pubnite_get_customitem_id", "_GetCustomItemID")
	register_native("pubnite_has_customitem", "_HasCustomItem")
	register_native("pubnite_customitemid_by_name", "_GetCustomItemIdByName")
	register_native("pubnite_customitem_rarity", "_GetCustomItemRarityById")
	register_native("pubnite_get_customitem_life", "_GetCustomItemLifeById")
	register_native("pubnite_find_customitem_which", "_FindCustomItemWhich")
	register_native("pubnite_change_item_life", "_ChangeCustomItemLife")
	register_native("pubnite_change_item_rarity", "_ChangeCustomItemRarity")
	register_native("pubnite_customitemname_by_id", "_CustomItemNameByID")
}

public _RegisterCustomItem(iPlugin, iParam)
{
	if(ArraySize(g_arrayCustomItems) >= MAX_CUSTOM_ITEMS)
	{
		log_amx("Couldn't create more custom items, the max value has been reached!")
		return 0
	}
	
	new szNativeParams[3][MAX_MODEL_LENGTH]
	get_string(2, szNativeParams[0], charsmax(szNativeParams[]))
	
	if(!precacheModel(szNativeParams[0]))
	{
		log_amx("Model ^"%s^" does not exists!", szNativeParams[0])
		return 0
	}
	
	get_string(1, szNativeParams[1], charsmax(szNativeParams[]))
	get_string(5, szNativeParams[2], charsmax(szNativeParams[]))
	
	new arrayData[cCustomItensData], iNewCustomizedItemID = (START_CUSTOM_ITEMS_ID + ArraySize(g_arrayCustomItems))
	copy(arrayData[szCustomItemName], charsmax(arrayData), szNativeParams[1])
	copy(arrayData[szCustomItemModel], charsmax(arrayData), szNativeParams[0])
	
	arrayData[iCustomItemRarity] = get_param(3)
	arrayData[iCustomItemLife] = get_param(4)
	arrayData[iCustomItemID] = iNewCustomizedItemID
	arrayData[iCustomItemFunc] = get_func_id(szNativeParams[2], iPlugin)
	arrayData[iCustomItemPluginID] = iPlugin
	
	ArrayPushArray(g_arrayCustomItems, arrayData)
	return iNewCustomizedItemID
}

public _IsCustomItem()
{
	new iParamCustomItemID = get_param(1)
	if(!ArraySize(g_arrayCustomItems) && (iParamCustomItemID > START_CUSTOM_ITEMS_ID))
	{
		log_amx("No itens have been registered.")
		return false
	}
	
	new iItem = (iParamCustomItemID - START_CUSTOM_ITEMS_ID)
	if(isInvalidItem(iItem))
	{
		return false
	}

	new arrayData[cCustomItensData]
	ArrayGetArray(g_arrayCustomItems, iItem, arrayData)
	return bool:(iParamCustomItemID == arrayData[iCustomItemID])
}

public _GetCustomItemData()
{
	new iValue = ArraySize(g_arrayCustomItems)
	if(!iValue)
	{
		log_amx("No itens have been registered.")
		return 0
	}
	
	new arrayData[cCustomItensData]
	ArrayGetArray(g_arrayCustomItems, get_param(1), arrayData)

	set_param_byref(2, arrayData[iCustomItemID])
	set_param_byref(3, arrayData[iCustomItemRarity])
	set_string(4, arrayData[szCustomItemModel], charsmax(arrayData))
	return 1
}

public _GetCustomItemID()
{
	if(!ArraySize(g_arrayCustomItems))
	{
		log_amx("No itens have been registered.")
		return
	}
	
	new arrayData[cCustomItensData]
	ArrayGetArray(g_arrayCustomItems, get_param(1), arrayData)
	set_param_byref(2, arrayData[iCustomItemID])
}

public _GetCustomItemsNum()
{
	return ArraySize(g_arrayCustomItems)
}

public _GetCustomItem()
{
	if(!ArraySize(g_arrayCustomItems))
	{
		log_amx("No itens have been registered.")
		return
	}
	
	new arrayData[cCustomItensData]
	ArrayGetArray(g_arrayCustomItems, get_param(1), arrayData)
	
	set_param_byref(2, arrayData[iCustomItemID])
	set_string(3, arrayData[szCustomItemName], charsmax(arrayData))
}

public _HasCustomItem()
{
	if(!ArraySize(g_arrayCustomItems))
	{
		log_amx("No itens have been registered.")
		return 0
	}
	
	new iItem = (get_param(2) - START_CUSTOM_ITEMS_ID)
	if(isInvalidItem(iItem))
	{
		log_amx("(_HasCustomItem)     invalid custom item passed, position does not exists.")
		return 0
	}

	new id = get_param(1), arrayData[cCustomItensData], iReturn
	ArrayGetArray(g_arrayCustomItems, iItem, arrayData)
		
	callfunc_begin_i(arrayData[iCustomItemFunc], arrayData[iCustomItemPluginID]) 
	callfunc_push_int(id)
	callfunc_push_intrf(iReturn) 
	callfunc_end()
	return iReturn
}

public _GetCustomItemIdByName()
{
	new iArraySize = ArraySize(g_arrayCustomItems)
	if(!iArraySize)
	{
		log_amx("No itens have been registered.")
		return 0
	}
	
	new arrayData[cCustomItensData], szParamName[MAX_PLAYERS], iReturnValue
	get_string(1, szParamName, charsmax(szParamName))
	for(new i;i < iArraySize;i++)
	{
		ArrayGetArray(g_arrayCustomItems, i, arrayData)
		if(equal(szParamName, arrayData[szCustomItemName]))
		{
			iReturnValue = arrayData[iCustomItemID]
			break
		}
	}
	return iReturnValue
}

public _GetCustomItemRarityById()
{
	if(!ArraySize(g_arrayCustomItems))
	{
		log_amx("No itens have been registered.")
		return 0
	}
	
	new iItem = (get_param(1) - START_CUSTOM_ITEMS_ID)
	if(isInvalidItem(iItem))
	{
		log_amx("(_GetCustomItemRarityById)     invalid custom item passed, position does not exists.")
		return 0
	}
	
	new arrayData[cCustomItensData]
	ArrayGetArray(g_arrayCustomItems, iItem, arrayData)
	return arrayData[iCustomItemRarity]
}

public _GetCustomItemLifeById()
{
	if(!ArraySize(g_arrayCustomItems))
	{
		log_amx("No itens have been registered.")
		return 0
	}
	
	new iItem = (get_param(1) - START_CUSTOM_ITEMS_ID)
	if(isInvalidItem(iItem))
	{
		log_amx("(_GetCustomItemLifeById)     invalid custom item passed, position does not exists.")
		return 0
	}
	
	new arrayData[cCustomItensData]
	ArrayGetArray(g_arrayCustomItems, iItem, arrayData)
	return arrayData[iCustomItemLife]
}

public _FindCustomItemWhich()
{
	if(!ArraySize(g_arrayCustomItems))
	{
		log_amx("No itens have been registered.")
		return 0
	}
	
	return (get_param(1) - START_CUSTOM_ITEMS_ID)
}

public _ChangeCustomItemLife()
{
	if(!ArraySize(g_arrayCustomItems))
	{
		log_amx("No itens have been registered.")
		return 0
	}
	
	new iItem = (get_param(1) - START_CUSTOM_ITEMS_ID)
	if(isInvalidItem(iItem))
	{
		log_amx("(_ChangeCustomItemLife)     invalid custom item passed, position does not exists.")
		return 0
	}

	new arrayData[cCustomItensData]
	ArrayGetArray(g_arrayCustomItems, iItem, arrayData)
	arrayData[iCustomItemLife] = get_param(2)
	ArraySetArray(g_arrayCustomItems, iItem, arrayData)
	return 1
}

public _ChangeCustomItemRarity()
{
	if(!ArraySize(g_arrayCustomItems))
	{
		log_amx("No itens have been registered.")
		return 0
	}
	
	new iItem = (get_param(1) - START_CUSTOM_ITEMS_ID)
	if(isInvalidItem(iItem))
	{
		log_amx("(_ChangeCustomItemRarity)     invalid custom item passed, position does not exists.")
		return 0
	}

	new arrayData[cCustomItensData]
	ArrayGetArray(g_arrayCustomItems, iItem, arrayData)
	arrayData[iCustomItemRarity] = get_param(2)
	ArraySetArray(g_arrayCustomItems, iItem, arrayData)
	return 1
}

public _CustomItemNameByID()
{
	new iValue = ArraySize(g_arrayCustomItems)
	if(!iValue)
	{
		log_amx("No itens have been registered.")
		return 0
	}
	
	new iItem = (get_param(1) - START_CUSTOM_ITEMS_ID)
	if(isInvalidItem(iItem))
	{
		log_amx("(_CustomItemNameByID)     invalid custom item passed, position does not exists.")
		return 0
	}

	new arrayData[cCustomItensData]
	ArrayGetArray(g_arrayCustomItems, iItem, arrayData)

	set_string(2, arrayData[szCustomItemName], charsmax(arrayData))
	return 1
}

precacheModel(szModel[])
{
	if(file_exists(szModel))
	{
		engfunc(EngFunc_PrecacheModel, szModel)

		// Quick&Dirty Fix
		new temp[80]
		copy(temp, (strlen(szModel) - 4), szModel)
		formatex(temp, charsmax(temp), "%st.mdl", temp)
		if(file_exists(temp))
		{
			engfunc(EngFunc_PrecacheModel, temp)
			return true
		}
		copy(temp, (strlen(szModel) - 4), szModel)
		formatex(temp, charsmax(temp), "%sT.mdl", temp)
		if(file_exists(temp))
		{
			engfunc(EngFunc_PrecacheModel, temp)
			return true
		}
		return true
	}
	return false
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1046\\ f0\\ fs16 \n\\ par }
*/
