#include <amxmodx>
#include <fakemeta>
#include <cstrike>

#define PLUGIN 			"Roundend Blocker"
#define VERSION 		"1.4"
#define AUTHOR 			"Jim"

#define MAX_BOTS		2

new g_szBotName[MAX_BOTS][32], g_iBotID[MAX_BOTS]

new pCvarBotNameT, pCvarBotNameCT

public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	if(is_plugin_loaded("BattleRoyale Mod") == -1)
	{
		set_fail_state("MOD DISABLED")
	}

	pCvarBotNameT = register_cvar("pubnite_bot_name_t", "[PUBNite - BOT TR]")
	pCvarBotNameCT = register_cvar("pubnite_bot_name_ct", "[PUBNite - BOT CT]")

	register_logevent("round_start", 2,"1=Round_Start")
	
	get_pcvar_string(pCvarBotNameT, g_szBotName[0], charsmax(g_szBotName[]))
	get_pcvar_string(pCvarBotNameCT, g_szBotName[1], charsmax(g_szBotName[]))
	
	set_task(2.0, "createBots")
}

public round_start() 
{
	for(new i, iBot;i < MAX_BOTS;i++)
	{
		if((iBot = g_iBotID[i]) > 0)
		{
			hideBot(iBot)
		}
	}
}

public createBots() 
{	
	for(new i, iBot, ptr[128];i < MAX_BOTS;i++)
	{
		iBot = engfunc(EngFunc_CreateFakeClient, g_szBotName[i])
		if(!iBot) 
			return
		
		engfunc(EngFunc_FreeEntPrivateData, iBot)
		dllfunc(DLLFunc_ClientConnect, iBot, g_szBotName[i], "127.0.0.1", ptr)
		if(!is_user_connected(iBot)) 
		{
			return
		}
		
		g_iBotID[i] = iBot
		dllfunc(DLLFunc_ClientPutInServer, iBot)
		
		hideBot(iBot)
		cs_set_user_team(iBot, _:(i + 1))
	}
}

hideBot(bot)
{	
	new iFirstBot = g_iBotID[0], iSecondBot = g_iBotID[1]
	if(get_user_team(iFirstBot) == get_user_team(iSecondBot))
	{
		cs_set_user_team(iFirstBot, CS_TEAM_T)
		cs_set_user_team(iSecondBot, CS_TEAM_CT)
	}
	
	set_pev(bot, pev_spawnflags, pev(bot, pev_spawnflags) | FL_FAKECLIENT)
	set_pev(bot, pev_flags, pev(bot, pev_flags) | FL_FAKECLIENT)
	set_pev(bot, pev_model, "")
	set_pev(bot, pev_takedamage, DAMAGE_NO)
	set_pev(bot, pev_solid, SOLID_NOT)
	set_pev(bot, pev_effects, pev(bot, pev_effects) | EF_NODRAW)
	
	engfunc(EngFunc_SetOrigin, bot, Float:{9999.0, 9999.0, 9999.0})
}

public kick_bot() 
{
	for(new i;i < MAX_BOTS;i++)
	{
		server_cmd("kick #%d", get_user_userid(g_iBotID[i]))
	}
}

public plugin_end() 
{
	kick_bot()
}
