#include <amxmodx>
#include <hamsandwich>
#include <fakemeta>
#include <cromchat>
#include <pubnite_mod>

#define PLUGIN 				"PUBNite: Glider"
#define VERSION 			"1.0"
#define AUTHOR 				"EFFEX"

#define SAFE_DISTANCE			200.0
#define SAFE_VELOCITY			350.0

const m_flFallVelocity =		251
new const g_szPickupSound[] = 		"items/gunpickup2.wav"

new bool:g_bHasGlider[MAX_PLAYERS + 1], bool:g_bParachuteOpened[MAX_PLAYERS + 1]
new g_iTimesUsed[MAX_PLAYERS + 1], Float:g_fUserGameTime[MAX_PLAYERS + 1]
new g_iGliderID

new pCvarParachuteLife

public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	pCvarParachuteLife = register_cvar("pubnite_glider_life", "5")
	
	g_iGliderID = pubnite_register_customitem("Glider", "models/pubg/itens/w_glider.mdl", RARITY_BLUE, get_pcvar_num(pCvarParachuteLife), "hasGlider")
	if(!g_iGliderID)
	{
		set_fail_state("Couldn't create the Glider item.")
	}
	register_dictionary("effxs_customitens.txt")

	register_forward(FM_CmdStart, "forward_cmdStart")
	RegisterHam(Ham_Spawn, "player", "ham_PlayerSpawn_Post", 1)
}

public plugin_precache()
{
	precache_sound(g_szPickupSound)
}

public hasGlider(id, &ret)
{
	ret = g_bHasGlider[id]
}

public ham_PlayerSpawn_Post(id)
{
	g_bHasGlider[id] = g_bParachuteOpened[id] = false
}

public pubnite_customitem_dropped(iPlayer, iCustomItemID)
{
	if((iCustomItemID == g_iGliderID) && g_bHasGlider[iPlayer])
	{
		pubnite_create_customitem(g_iGliderID, g_iTimesUsed[iPlayer], iPlayer)
		g_bHasGlider[iPlayer] = false
	}
}

public pubnite_customitem_pickedup(iPlayer, iEntityID, iCustomItemID, iCustomItemLife)
{
	if((iCustomItemID == g_iGliderID) && !g_bHasGlider[iPlayer] && !pubnite_is_knockedout(iPlayer))
	{
		g_bHasGlider[iPlayer] = true
		g_iTimesUsed[iPlayer] = iCustomItemLife

		set_hudmessage(255, 255, 255, -1.0, 0.37, 0, 1.0, 5.0)
		show_hudmessage(iPlayer, "%L", iPlayer, "GLIDER_EQUIPED", get_pcvar_num(pCvarParachuteLife))
		
		emit_sound(iPlayer, CHAN_ITEM, g_szPickupSound, VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
		engfunc(EngFunc_RemoveEntity, iEntityID)
	}
}

public forward_cmdStart(id, uc_handle)
{
	if(!is_user_alive(id) 
	|| is_user_bot(id) 
	|| !g_bHasGlider[id] 
	|| pubnite_is_knockedout(id)
	|| pubnite_has_round_ended())
		return FMRES_IGNORED
	
	if(~pev(id, pev_flags) & FL_ONGROUND)
	{
		if((get_uc(uc_handle, UC_Buttons) & IN_USE) && get_pdata_float(id, m_flFallVelocity) >= SAFE_VELOCITY)
		{
			if(!g_iTimesUsed[id])
			{
				static Float:fGameTime;fGameTime = get_gametime()
				if((fGameTime - g_fUserGameTime[id]) >= 1.0)
				{
					g_fUserGameTime[id] = fGameTime
					
					CC_SendMatched(id, CC_COLOR_RED, "&x03%L", id, "SERVER_NO_GLIDERS_LEFT")
					client_cmd(id, "spk buttons/button11")
				}
				return FMRES_IGNORED
			}
			parachuteFreeMode(id, g_bParachuteOpened[id])
		}
	}
	else 
	{
		if(g_bParachuteOpened[id])
		{
			g_bParachuteOpened[id] = false
		}
	}
	return FMRES_IGNORED
}

parachuteFreeMode(id, bool:bOpen)
{
	static Float:fGameTime;fGameTime = get_gametime()
	if(!bOpen)
	{
		if((fGameTime - g_fUserGameTime[id]) > 2.0)
		{
			g_fUserGameTime[id] = fGameTime
			g_bParachuteOpened[id] = true
			
			if(!pubnite_set_user_parachute(id, true, g_bParachuteOpened[id]))
			{
				g_iTimesUsed[id]--
				client_print(id, print_center, "%L", id, "SERVER_GLIDER_LIFE", g_iTimesUsed[id])
			}
		}
	}
	else
	{
		if(get_cvar_num("pubnite_parachute_type") > 0)
		{
			if((fGameTime - g_fUserGameTime[id]) >= 0.2)
			{
				g_fUserGameTime[id] = fGameTime
				g_bParachuteOpened[id] = false
				
				pubnite_set_user_parachute(id, true, g_bParachuteOpened[id])
			}
		}
	}
}
