#include <amxmodx>
#include <cstrike>
#include <fakemeta>
#include <engine>
#include <hamsandwich>
#include <fun>
#include <xs>
#include <pubnite_mod>

#define PLUGIN 					"PUBNite: Grappler"
#define VERSION 				"1.0"
#define AUTHOR 					"EFFx"

#if AMXX_VERSION_NUM < 183
#define client_disconnected			client_disconnect
#endif

#if !defined DMG_GRENADE
#define	DMG_GRENADE				(1 << 24)
#endif

#define message_begin_f(%1,%2) 			engfunc(EngFunc_MessageBegin, %1, SVC_TEMPENTITY, %2, 0)
#define write_coord_f(%1) 			engfunc(EngFunc_WriteCoord, %1)
#define getWeaponBoxID(%1,%2) 			get_pdata_cbase(%1, (m_rpgPlayerItems + %2), m_rpgPlayerItemsDiff)

#define TASK_PULL 				8562
#define TASK_GRAPPLER_THINK			8903
#define TASK_REMOVE_GRAPPLER			9001
#define TASK_RETRACT_GRAPPLER			1731

#define m_rpgPlayerItems  			367
#define m_flNextPrimaryAttack			46	
#define m_pPlayer				41
#define m_WeaponBox_rgpPlayerItems  		34
#define m_rpgPlayerItemsDiff  			5
#define XTRA_OFS_WEAPON				4
#define GRAPPLER_SLOT				2

#define GRAPPLER_RARITY				RARITY_PURPLE

#define GRAPPLER_WEAPON_NAME			"weapon_fiveseven"
#define GRAPPLER_WORLD_MODEL 			"models/pubg/itens/w_grappler.mdl"

#define CSW_GRAPPLER_WEAPON			CSW_FIVESEVEN

const Float:g_fGrapplerDelay =			3.0
const Float:g_fGrapplerSpeed = 			700.0
const Float:g_fThrowSpeed = 			2000.0

new const g_szGrapplerClassName[] = 		"pubnite_grappler"

new const g_szGrapplerModel[] =			"models/rpgrocket.mdl"
new const g_szGrapplerWeaponViewModel[] =	"models/pubg/itens/v_grappler.mdl"

new const g_szGrapplerShotSound[] =		"pubg/effects/grappler_shot.wav"
new const g_szGrapplerPullSound[] =		"pubg/effects/grappler_pull.wav"
new const g_szGrapplerRetractSound[] =		"pubg/effects/grappler_retract.wav"
new const g_szGrapplerImpactSound[] =		"pubg/effects/grappler_impact.wav"

new g_iGrapplerItemID, g_iSprBeam

new bool:g_bHasGrappler[MAX_PLAYERS + 1], bool:g_bIsGrappled[MAX_PLAYERS + 1]
new g_iGrapplerID[MAX_PLAYERS + 1], pCvarGrapplerBullets, pCvarGrapplerMaxDistance

public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR)

	pCvarGrapplerBullets = register_cvar("pubnite_grappler_bullets", "20")
	pCvarGrapplerMaxDistance = register_cvar("pubnite_grappler_distance", "1250.0")

	g_iGrapplerItemID = pubnite_register_customitem("Grappler", GRAPPLER_WORLD_MODEL, GRAPPLER_RARITY, get_pcvar_num(pCvarGrapplerBullets), "hasGrappler")
	if(!g_iGrapplerItemID)
	{
		set_fail_state("Couldn't create the Grappler item.")
	}

	register_dictionary("effxs_customitens.txt")
	register_clcmd("drop", "cmdDrop")
	
	register_forward(FM_Touch, "fwTouch")
	register_forward(FM_CmdStart, "forward_cmdStart")
	register_forward(FM_UpdateClientData, "fw_UpdateClientData_Post", 1)
	register_forward(FM_SetModel, "forward_SetModel")
	register_forward(FM_PlaybackEvent, "fw_PlaybackEvent")
	
	register_event("CurWeapon", "event_CurWeapon", "be", "1=1")
	register_event("HLTV", "event_roundStart", "a", "1=0", "2=0")
	
	RegisterHam(Ham_Weapon_PrimaryAttack, GRAPPLER_WEAPON_NAME, "ham_WeaponPrimaryAttack_Pre", 0)
	RegisterHam(Ham_Item_Deploy, GRAPPLER_WEAPON_NAME, "ham_GrapplerWeaponDeploy_Post", 1)
	RegisterHam(Ham_TakeDamage, "player", "ham_PlayerTakeDamage_Pre", 0)
	RegisterHam(Ham_Spawn, "player", "ham_PlayerSpawn_Post", 1)
}

public plugin_precache()
{
	precache_model(g_szGrapplerModel)
	precache_model(g_szGrapplerWeaponViewModel)
	
	precache_sound(g_szGrapplerShotSound)
	precache_sound(g_szGrapplerPullSound)
	precache_sound(g_szGrapplerRetractSound)
	precache_sound(g_szGrapplerImpactSound)
	
	g_iSprBeam = engfunc(EngFunc_PrecacheModel, "sprites/zbeam4.spr")
}

public client_disconnected(id)
{
	remove_task(id + TASK_REMOVE_GRAPPLER)
	remove_task(id + TASK_PULL)
	remove_task(id + TASK_GRAPPLER_THINK)
}

public hasGrappler(id, &ret)
{
	ret = g_bHasGrappler[id]
}

public pubnite_customitem_dropped(iPlayer, iCustomItemID)
{
	if((iCustomItemID == g_iGrapplerItemID) && g_bHasGrappler[iPlayer])
	{
		dropGrappler(iPlayer)
	}
}

public pubnite_noregistered_weapon(iPlayer, iWeaponID)
{
	if((iWeaponID == CSW_GRAPPLER_WEAPON) && g_bHasGrappler[iPlayer])
	{
		dropGrappler(iPlayer)
	}
}

public pubnite_customitem_pickedup(iPlayer, iEntityID, iCustomItemID, iCustomItemLife, bUseButtonPressed)
{
	if((iCustomItemID == g_iGrapplerItemID) && !g_bHasGrappler[iPlayer] && !pubnite_is_knockedout(iPlayer))
	{
		new iWeapon = getWeaponBoxID(iPlayer, GRAPPLER_SLOT)
		if((iWeapon > 0) && bUseButtonPressed)
		{
			dropWeapon(iWeapon, iPlayer)
		}

		set_hudmessage(255, 255, 255, -1.0, 0.3, 0, 1.0, 5.0)
		show_hudmessage(iPlayer, "%L", iPlayer, "GRAPPLER_EQUIPED")
		
		g_bHasGrappler[iPlayer] = true
		give_item(iPlayer, GRAPPLER_WEAPON_NAME)
		
		new iWeaponEntity = find_ent_by_owner(-1, GRAPPLER_WEAPON_NAME, iPlayer)
		if(iWeaponEntity > 0)
		{
			cs_set_weapon_ammo(iWeaponEntity, clamp(iCustomItemLife, 0, get_pcvar_num(pCvarGrapplerBullets)))
		}
		engfunc(EngFunc_RemoveEntity, iEntityID)
	}
}

public forward_SetModel(iEnt, const szModel[])
{
	if(!pev_valid(iEnt))
		return FMRES_IGNORED

	if(equal(szModel, "models/w_fiveseven.mdl"))
	{
		dllfunc(DLLFunc_Think, iEnt)
		return FMRES_SUPERCEDE
	}
	return FMRES_IGNORED
}

public cmdDrop(id)
{
	if(!is_user_alive(id))
		return PLUGIN_HANDLED
		
	if((get_user_weapon(id) == CSW_GRAPPLER_WEAPON) && g_bHasGrappler[id])
	{
		dropGrappler(id)
		return PLUGIN_HANDLED
	}
	return PLUGIN_CONTINUE
}

dropGrappler(iPlayer)
{
	new iClip
	get_user_weapon(iPlayer, iClip)
	pubnite_create_customitem(g_iGrapplerItemID, iClip, iPlayer)
	
	if(is_user_alive(iPlayer))
	{
		stripUserWeapon(iPlayer, GRAPPLER_WEAPON_NAME)
	}

	g_bHasGrappler[iPlayer] = false
}

public event_roundStart()
{
	new iEnt = -1
	while((iEnt = find_ent_by_class(iEnt, g_szGrapplerClassName)))
	{
		engfunc(EngFunc_RemoveEntity, iEnt)
	}
}

public event_CurWeapon(id)
{
	if(read_data(2) != CSW_GRAPPLER_WEAPON)
	{
		removeGrappler(id)
	}
	else cs_set_user_bpammo(id, CSW_GRAPPLER_WEAPON, 0)
}

public ham_PlayerSpawn_Post(id)
{
	removeGrappler(id)
	g_bHasGrappler[id] = false
}

public ham_PlayerTakeDamage_Pre(iVictim, iInflictor, iAttacker, Float:fDamage, iDamageBits)
{	
	if(!is_user_connected(iVictim) || !is_user_connected(iAttacker) || (iDamageBits & DMG_GRENADE))
		return HAM_IGNORED
		
	if(get_user_weapon(iAttacker) == CSW_GRAPPLER_WEAPON)
	{
		SetHamReturnInteger(0)
		return HAM_SUPERCEDE
	}
	return HAM_IGNORED
}

public ham_GrapplerWeaponDeploy_Post(const iWeapon)
{
	static id; id = get_pdata_cbase(iWeapon, m_pPlayer, XTRA_OFS_WEAPON)
	if(is_user_connected(id))
	{
		SendWeaponAnim(id, 3)
		set_pev(id, pev_viewmodel2, g_szGrapplerWeaponViewModel)
	}
}

public fw_UpdateClientData_Post(id, sendweapons, cd_handle)
{
	if(!is_user_alive(id) || (get_user_weapon(id) != CSW_GRAPPLER_WEAPON))
		return FMRES_IGNORED	
		
	set_cd(cd_handle, CD_flNextAttack, get_gametime() + 0.001)
	return FMRES_HANDLED
}

public fw_PlaybackEvent(flags, id, eventid, Float:delay, Float:origin[3], Float:angles[3], Float:fparam1, Float:fparam2, iParam1, iParam2, bParam1, bParam2)
{
	if(!is_user_connected(id) 
	|| (get_user_weapon(id) != CSW_GRAPPLER_WEAPON)
	|| !g_bHasGrappler[id])
		return FMRES_IGNORED
		
	engfunc(EngFunc_PlaybackEvent, flags | FEV_HOSTONLY, id, eventid, delay, origin, angles, fparam1, fparam2, iParam1, iParam2, bParam1, bParam2)

	new iClip
	get_user_weapon(id, iClip)
	if((iClip < 1) || (get_user_button(id) & IN_ATTACK2))
		return FMRES_IGNORED

	if((g_bIsGrappled[id] || pubnite_get_user_parachute(id)) || task_exists(id + TASK_PULL))
		return FMRES_IGNORED
		
	emit_sound(id, CHAN_WEAPON, g_szGrapplerShotSound, 1.0, ATTN_NORM, 0, PITCH_NORM)
	
	removeGrappler(id)
	throwGrappler(id)
	
	SendWeaponAnim(id, 1)
	return FMRES_SUPERCEDE
}

SendWeaponAnim(id, iAnim)
{
	set_pev(id, pev_weaponanim, iAnim)

	message_begin(MSG_ONE_UNRELIABLE, SVC_WEAPONANIM, _, id)
	write_byte(iAnim)
	write_byte(pev(id, pev_body))
	message_end()
}

public ham_WeaponPrimaryAttack_Pre(const iWeapon)
{
	static id; id = get_pdata_cbase(iWeapon, m_pPlayer, XTRA_OFS_WEAPON)
	if(!is_user_alive(id) || !g_bHasGrappler[id] || cs_get_weapon_ammo(iWeapon) < 1)
		return HAM_IGNORED
		
	if(get_user_button(id) & IN_ATTACK2)
		return HAM_SUPERCEDE
		
	if((g_bIsGrappled[id] 
	|| pubnite_get_user_parachute(id)) 
	|| task_exists(id + TASK_PULL)
	|| pev_valid(g_iGrapplerID[id]))
		return HAM_SUPERCEDE
		
	if(isInvalidSpot(id))
	{
		static Float:fUserGameTime[MAX_PLAYERS + 1], Float:fGameTime;fGameTime = get_gametime()
		if((fGameTime - fUserGameTime[id]) >= 1.0)
		{
			fUserGameTime[id] = fGameTime
			set_task(1.5, "retractGrappler", id + TASK_RETRACT_GRAPPLER)
		}
	}
	return HAM_IGNORED
}

public retractGrappler(id)
{
	id -= TASK_RETRACT_GRAPPLER
			
	client_cmd(id, "spk ^"%s^"", g_szGrapplerRetractSound)
	removeGrappler(id)
}

isInvalidSpot(id)
{
	new iTarget, iBody, Float:fOrigin[3]
	get_user_aiming(id, iTarget, iBody)
	return (!get_user_hitpoint(id, fOrigin) || is_user_alive(iTarget))
}

public forward_cmdStart(id, uc_handle)
{
	if(!is_user_alive(id) || !g_bHasGrappler[id] || !g_bIsGrappled[id])
		return FMRES_IGNORED
		
	if(get_uc(uc_handle, UC_Buttons) & IN_ATTACK2)
	{
		if(pev_valid(g_iGrapplerID[id]) && !isInvalidSpot(id))
		{	
			if(!task_exists(id + TASK_PULL))
			{ 
				emit_sound(id, CHAN_WEAPON, g_szGrapplerPullSound, 1.0, ATTN_NORM, 0, PITCH_NORM)
				set_task(0.55, "taskRemoveGrappler", id + TASK_REMOVE_GRAPPLER)
				
				static iTaskData[2]
				iTaskData[0] = id
				iTaskData[1] = g_iGrapplerID[id]
			
				goToGrappler(iTaskData)
				set_task(0.1, "goToGrappler", id + TASK_PULL, iTaskData, sizeof iTaskData, "b")
			}
		}
		return FMRES_IGNORED
	}
	return FMRES_IGNORED
}

public fwTouch(ptr, ptd)
{
	if(!pev_valid(ptr))
		return FMRES_IGNORED
	
	if(is_user_connected(ptd))
		return FMRES_IGNORED
		
	static szPtrClass[32]	
	pev(ptr, pev_classname, szPtrClass, charsmax(szPtrClass))
	
	if(equali(szPtrClass, g_szGrapplerClassName))
	{		
		static id;id = pev(ptr, pev_owner)
		if(ptd == id)
			return FMRES_IGNORED
			
		static Float:fOrigin[3]
		pev(ptr, pev_origin, fOrigin)
		
		g_bIsGrappled[id] = true
		
		set_task(g_fGrapplerDelay, "taskRemoveGrappler", id + TASK_REMOVE_GRAPPLER)
		emit_sound(ptr, CHAN_STATIC, g_szGrapplerImpactSound, 1.0, ATTN_NORM, 0, PITCH_NORM)
		
		message_begin_f(MSG_BROADCAST, SVC_TEMPENTITY, fOrigin, 0)
		write_byte(TE_SPARKS)
		write_coord_f(fOrigin[0]) 
		write_coord_f(fOrigin[1])
		write_coord_f(fOrigin[2])
		message_end()		
		
		set_pev(ptr, pev_velocity, Float:{0.0, 0.0, 0.0})
		set_pev(ptr, pev_movetype, MOVETYPE_NONE)
	}
	return FMRES_HANDLED
}

public goToGrappler(param[])
{
	new id = param[0]
	new iGrapplerEnt = param[1]

	if(!is_user_alive(id) || !pev_valid(iGrapplerEnt) || !pev_valid(id))
	{
		remove_task(id + TASK_PULL)
		return PLUGIN_HANDLED
	}
	
	static Float:fVelocity[3]
	if(g_bIsGrappled[id])
	{
		static Float:fGrapplerOrigin[3], Float:fUsrOrigin[3], Float:fDist
		pev(iGrapplerEnt, pev_origin, fGrapplerOrigin)
		pev(id, pev_origin, fUsrOrigin)
		
		fDist = vector_distance(fGrapplerOrigin, fUsrOrigin)
		if(fDist >= 30.0)
		{
			new Float:fSpeed = g_fGrapplerSpeed
			fSpeed *= 0.52
			
			fVelocity[0] = (fGrapplerOrigin[0] - fUsrOrigin[0]) * (2.0 * fSpeed) / fDist
			fVelocity[1] = (fGrapplerOrigin[1] - fUsrOrigin[1]) * (2.0 * fSpeed) / fDist
			fVelocity[2] = (fGrapplerOrigin[2] - fUsrOrigin[2]) * (2.0 * fSpeed) / fDist
		}
	}
	fVelocity[2] += 300.0
	
	set_pev(id, pev_velocity, fVelocity)
	return PLUGIN_HANDLED
}

public taskRemoveGrappler(id)
{
	id -= TASK_REMOVE_GRAPPLER
	
	if(!is_user_connected(id))
		return
		
	if(!task_exists(id + TASK_PULL))
	{
		client_cmd(id, "spk ^"%s^"", g_szGrapplerRetractSound)
	}
	removeGrappler(id)
	remove_task(id + TASK_PULL)
}

public GrapplerThink(param[])
{
	new id = param[0]
	new GrapplerEnt = param[1]
	
	if(!is_user_alive(id) || !pev_valid(GrapplerEnt) || !pev_valid(id))
	{
		if(!is_user_alive(id))
		{
			removeGrappler(id)
		}
		remove_task(id + TASK_GRAPPLER_THINK)
		return
	}
	
	static Float:entOrigin[3]
	pev(GrapplerEnt, pev_origin, entOrigin)

	static Float:usrOrigin[3]
	pev(id, pev_origin, usrOrigin)

	if(get_distance_f(entOrigin, usrOrigin) >= get_pcvar_num(pCvarGrapplerMaxDistance))
	{
		taskRemoveGrappler(id + TASK_REMOVE_GRAPPLER)
		return
	}
		
	static tr
	engfunc(EngFunc_TraceLine, usrOrigin, entOrigin, 1, -1, tr)
		
	static Float:fFraction
	get_tr2(tr, TR_flFraction, fFraction)
		
	if(fFraction != 1.0)
		removeGrappler(id)
}

removeGrappler(id)
{
	if(task_exists(id + TASK_REMOVE_GRAPPLER))
	{
		remove_task(id + TASK_REMOVE_GRAPPLER)
	}
	
	new iGrapplerID = g_iGrapplerID[id]
	if(iGrapplerID && pev_valid(iGrapplerID))
	{
		killBeam(iGrapplerID)
		engfunc(EngFunc_RemoveEntity, iGrapplerID)
	}
	
	g_iGrapplerID[id] = 0
	g_bIsGrappled[id] = false
	
	if(is_user_connected(id))
	{
		killBeam(id)
	}
}

killBeam(id)
{
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY, .player = id)
	write_byte(TE_KILLBEAM)
	write_short(id)
	message_end()
}

throwGrappler(id)
{
	if(g_iGrapplerID[id] && pev_valid(g_iGrapplerID[id]))
	{
		removeGrappler(id)
	}

	static Float:fAngle[3], Float:fvAngle[3], Float:fStart[3]
	pev(id, pev_origin, fStart)
	pev(id, pev_angles, fAngle)
	pev(id, pev_v_angle, fvAngle)
	
	new iEnt = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "info_target"))
	if(pev_valid(iEnt))
	{	
		g_iGrapplerID[id] = iEnt
		
		engfunc(EngFunc_SetModel, iEnt, g_szGrapplerModel)
		
		fStart[2] += (pev(id, pev_flags) & FL_DUCKING) ? 10.0 : 15.0
		engfunc(EngFunc_SetOrigin, iEnt, fStart)		
		
		set_pev(iEnt, pev_angles, fAngle)
		set_pev(iEnt, pev_solid, SOLID_TRIGGER)
		set_pev(iEnt, pev_movetype, MOVETYPE_FLY)
		set_pev(iEnt, pev_classname, g_szGrapplerClassName)
		set_pev(iEnt, pev_owner, id)
		
		static Float:fForward[3], Float:Velocity[3]
		
		engfunc(EngFunc_MakeVectors, fvAngle)
		global_get(glb_v_forward, fForward)
		
		Velocity[0] = fForward[0] * g_fThrowSpeed
		Velocity[1] = fForward[1] * g_fThrowSpeed
		Velocity[2] = fForward[2] * g_fThrowSpeed
		set_pev(iEnt, pev_velocity, Velocity)
		
		message_begin(MSG_BROADCAST,SVC_TEMPENTITY);
		write_byte(TE_BEAMENTS);
		write_short(id)
		write_short(iEnt)
		write_short(g_iSprBeam)
		write_byte(2) 
		write_byte(1)
		write_byte(600)
		write_byte(25)
		write_byte(2)
		write_byte(255) 
		write_byte(255)
		write_byte(255) 
		write_byte(192) 
		write_byte(0) 
		message_end()
	
		set_rendering(iEnt, kRenderFxNone, 0, 0, 0, kRenderTransAlpha, 0)
		
		static TaskData[2]
		TaskData[0] = id
		TaskData[1] = iEnt
		
		set_task(0.1, "GrapplerThink", id + TASK_GRAPPLER_THINK, TaskData, 2, "b")
	}
}

get_user_hitpoint(id, Float:fOrigin[3])
{
	if(!is_user_alive(id))
		return false

	new Float:fStart[3], Float:fViewOfs[3]
	pev(id, pev_origin, fStart)
	pev(id, pev_view_ofs, fViewOfs)
	xs_vec_add(fStart, fViewOfs, fStart)

	new Float:fDest[3]
	pev(id, pev_v_angle, fDest)
	engfunc(EngFunc_MakeVectors, fDest)
	global_get(glb_v_forward, fDest)
	xs_vec_mul_scalar(fDest, get_pcvar_float(pCvarGrapplerMaxDistance), fDest)
	xs_vec_add(fStart, fDest, fDest)

	engfunc(EngFunc_TraceLine, fStart, fDest, 0, id, 0)
	get_tr2(0, TR_vecEndPos, fOrigin)
	
	if(engfunc(EngFunc_PointContents, fOrigin) == CONTENTS_SKY)
	{
		return false
	}
	return true
}

stripUserWeapon(id, szWeapon[])
{
	if(!equal(szWeapon, "weapon_", 7)) 
		return

	new iWeaponId = get_weaponid(szWeapon)
	if(!iWeaponId) 
		return

	new iEnt = -1
	while((iEnt = engfunc(EngFunc_FindEntityByString, iEnt, "classname", szWeapon)) && pev(iEnt, pev_owner) != id) {}
		
	if(!iEnt) 
		return
	
	if(get_user_weapon(id) == iWeaponId) 
	{
		ExecuteHamB(Ham_Weapon_RetireWeapon, iEnt)
	}
	
	if(!ExecuteHamB(Ham_RemovePlayerItem, id, iEnt)) 
		return
		
	ExecuteHamB(Ham_Item_Kill, iEnt)
	set_pev(id, pev_weapons, pev(id, pev_weapons) & ~(1 << iWeaponId))
}

dropWeapon(iWeapon, player)
{	
	static szClassName[MAX_PLAYERS]
	pev(iWeapon, pev_classname, szClassName, charsmax(szClassName))
	engclient_cmd(player, "drop", szClassName)
}
