#include <amxmodx>
#include <cstrike>
#include <fakemeta>
#include <hamsandwich>
#include <pubnite_mod>
#include <cromchat>
#include <fun>
#include <xs>

#define PLUGIN 				"PUBNite: Health Turret"
#define VERSION 			"1.0"
#define AUTHOR 				"EFFEX"

#define message_begin_fl(%1,%2,%3,%4)	engfunc(EngFunc_MessageBegin, %1, %2, %3, %4)
#define write_coord_fl(%1)		engfunc(EngFunc_WriteCoord, %1)

#define TASK_REMOVE_TURRET		218281111
#define TASK_GIVE_HEALTH		773212212

#define MAX_HEALTH			100

#define TURRET_SPAWN_MODEL 		"models/pubg/itens/health_turret.mdl"
#define TURRET_WORLD_MODEL 		"models/pubg/itens/w_health_turret.mdl"

new const g_szTurretSpawnSound[] =	"pubg/effects/model_buy_sound.wav"
new const g_szTurretDeathSound[] =	"pubg/effects/turretdeath.wav"
new const g_szTurretHealSound[] =	"pubg/effects/turretheal.wav"

new const g_szPickupSound[] = 		"items/gunpickup2.wav"
new const g_szTurretClassName[] =	"health_turret"

new g_iExplosionSprite, g_iTurretItemID, g_mMessageScreenFade
new pCvarTurretRadius, pCvarTurretHeal, pCvarTurretLife

new bool:g_bHasTurret[MAX_PLAYERS + 1]

public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
		
	register_dictionary("effxs_battleroyale.txt")
	register_dictionary("effxs_customitens.txt")
	
	g_mMessageScreenFade = get_user_msgid("ScreenFade")

	pCvarTurretRadius = register_cvar("pubnite_health_turret_radius", "225.0")
	pCvarTurretHeal = register_cvar("pubnite_health_turret_health", "3")
	pCvarTurretLife = register_cvar("pubnite_health_turret_life", "15")
	
	register_event("HLTV", "event_NewRound", "a", "1=0", "2=0")
	RegisterHam(Ham_Spawn, "player", "ham_PlayerSpawn_Post", 1)
	register_clcmd("nightvision", "cmdNightVision")
	
	g_iTurretItemID = pubnite_register_customitem("Health Turret", TURRET_WORLD_MODEL, RARITY_GOLD, 0, "hasTurret")
	if(!g_iTurretItemID)
	{
		set_fail_state("Couldn't create the Health Turret item.")
	}
}

public plugin_precache()
{
	precache_model(TURRET_SPAWN_MODEL)

	precache_sound(g_szTurretSpawnSound)
	precache_sound(g_szPickupSound)
	precache_sound(g_szTurretDeathSound)
	precache_sound(g_szTurretHealSound)
	
	g_iExplosionSprite = 	precache_model("sprites/shockwave.spr")
}

public hasTurret(id, &ret)
{
	ret = g_bHasTurret[id]
}

public ham_PlayerSpawn_Post(id)
{
	g_bHasTurret[id] = false
}

public event_NewRound()
{
	new iEnt = -1
	while((iEnt = engfunc(EngFunc_FindEntityByString, iEnt, "classname", g_szTurretClassName)) > 0)
	{
		engfunc(EngFunc_RemoveEntity, iEnt)
	}	
}

public pubnite_customitem_dropped(iPlayer, iCustomItemID)
{
	if((iCustomItemID == g_iTurretItemID) && g_bHasTurret[iPlayer])
	{
		pubnite_create_customitem(g_iTurretItemID, 0, iPlayer)
		g_bHasTurret[iPlayer] = false
	}
}

public pubnite_customitem_pickedup(iPlayer, iEntityID, iCustomItemID)
{
	if((iCustomItemID == g_iTurretItemID) 
	&& !g_bHasTurret[iPlayer] 
	&& !pubnite_is_knockedout(iPlayer))
	{
		g_bHasTurret[iPlayer] = true
		
		set_hudmessage(255, 255, 255, -1.0, 0.37, 0, 1.0, 5.0)
		show_hudmessage(iPlayer, "%L", iPlayer, "SERVER_HEALTH_TURRET_EQUIPED")
		
		emit_sound(iPlayer, CHAN_ITEM, g_szPickupSound, VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
		engfunc(EngFunc_RemoveEntity, iEntityID)
	}
}

public pubnite_customitem_used(iPlayer, iCustomItemID)
{
	if((iCustomItemID == g_iTurretItemID) 
	&& g_bHasTurret[iPlayer] 
	&& (get_user_weapon(iPlayer) == CSW_KNIFE)
	&& !pubnite_is_knockedout(iPlayer))
	{
		createTurret(iPlayer)
	}
}

public cmdNightVision(id)
{
	if(!g_bHasTurret[id] || (get_user_weapon(id) != CSW_KNIFE))
		return
		
	createTurret(id)
}

createTurret(id)
{
	new Float:fOrigin[3]
	originUnitsAhead(id, fOrigin, 110)
	
	if(isInvalidPlace(fOrigin, id))
	{
		CC_SendMatched(id, CC_COLOR_RED, "%L", id, "SERVER_INVALID_PLACE_TO_USE")
		client_cmd(id, "spk buttons/button11")
		return
	}
		
	new iEnt = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "info_target"))
	if(pev_valid(iEnt))
	{
		g_bHasTurret[id] = false
		
		set_pev(iEnt, pev_origin, fOrigin)
		engfunc(EngFunc_SetModel, iEnt, TURRET_SPAWN_MODEL)
		
		set_pev(iEnt, pev_movetype, MOVETYPE_NONE)
		set_pev(iEnt, pev_solid, SOLID_BBOX)
		set_pev(iEnt, pev_classname, g_szTurretClassName)
		engfunc(EngFunc_DropToFloor, iEnt)
		
		engfunc(EngFunc_SetSize, iEnt, Float:{-20.0, -20.0, -0.1}, Float:{15.0, 15.0, 50.0})
		emit_sound(iEnt, CHAN_BODY, g_szTurretSpawnSound, VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
		setRendering(iEnt, kRenderFxGlowShell, Float:{0.0, 200.0, 0.0}, 20.0)

		if(~pev(iEnt, pev_flags) & FL_ONGROUND)
		{
			fOrigin[2] -= distanceToGround(iEnt)
			engfunc(EngFunc_SetOrigin, iEnt, fOrigin)
			engfunc(EngFunc_DropToFloor, iEnt)
		}
		
		set_task(1.0, "giveHealth", iEnt + TASK_GIVE_HEALTH, .flags = "b")
	}
}

Float:distanceToGround(id) 
{ 
	new Float:fStart[3], Float:fEnd[3]
	pev(id, pev_origin, fStart)
	if(pev(id, pev_flags) & FL_DUCKING) 
	{ 
		fStart[2] += 18.0
	} 

	fEnd[0] = fStart[0] 
	fEnd[1] = fStart[1]
	fEnd[2] = fStart[2] - 9999.0

	new iPtr = create_tr2(), Float:fFraction
	engfunc(EngFunc_TraceHull, fStart, fEnd, IGNORE_MONSTERS, HULL_HUMAN, id, iPtr)
	get_tr2(iPtr, TR_flFraction, fFraction)
	free_tr2(iPtr)

	return (fFraction * 9999.0)
} 

setRendering(iEnt, iRenderFx = kRenderFxNone, Float:fRenderColor[3] = {0.0, 0.0, 0.0}, Float:fRenderAmmt = 0.0)
{
	set_pev(iEnt, pev_renderfx, iRenderFx)
	set_pev(iEnt, pev_rendercolor, fRenderColor)
	set_pev(iEnt, pev_rendermode, kRenderNormal)
	set_pev(iEnt, pev_renderamt, fRenderAmmt)
}

public giveHealth(iEnt)
{
	iEnt -= TASK_GIVE_HEALTH
	
	if(!pev_valid(iEnt))
	{
		remove_task(iEnt + TASK_GIVE_HEALTH)
		return
	}

	new iTimes = pev(iEnt, pev_iuser1)
	set_pev(iEnt, pev_iuser1, (iTimes + 1))
	
	if(iTimes  >= get_pcvar_num(pCvarTurretLife))
	{
		remove_task(iEnt + TASK_GIVE_HEALTH)
		
		emit_sound(iEnt, CHAN_BODY, g_szTurretDeathSound, VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
		set_task(4.7, "removeTurret", iEnt + TASK_REMOVE_TURRET)
		return
	}
	
	new Float:fOrigin[3]
	pev(iEnt, pev_origin, fOrigin)
	
	new id = FM_NULLENT
	while((id = engfunc(EngFunc_FindEntityInSphere, id, fOrigin, get_pcvar_float(pCvarTurretRadius))) != 0) 
	{
		if(is_user_alive(id) && !pubnite_is_knockedout(id))
		{
			message_begin(MSG_ONE, g_mMessageScreenFade, .player = id)
			write_short(2096)
			write_short(1024)
			write_short(0)
			write_byte(0)
			write_byte(200) 
			write_byte(0) 
			write_byte(75) 
			message_end()
	
			set_user_health(id, clamp((get_user_health(id) + get_pcvar_num(pCvarTurretHeal)), 0, MAX_HEALTH))
		}
	}
	
	emit_sound(iEnt, CHAN_BODY, g_szTurretHealSound, VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
	createBlast(iEnt, {0, 200, 0})
}

public removeTurret(iEnt)
{
	iEnt -= TASK_REMOVE_TURRET
	
	if(!pev_valid(iEnt))
		return
		
	createBlast(iEnt, {255, 255, 255})
	engfunc(EngFunc_RemoveEntity, iEnt)
}

createBlast(iEnt, iRGB[3])
{
	new Float:fStartOrigin[3]
	pev(iEnt, pev_origin, fStartOrigin)
	
	message_begin_fl(MSG_PVS, SVC_TEMPENTITY, fStartOrigin, 0)
	write_byte(TE_BEAMCYLINDER)
	write_coord_fl(fStartOrigin[0])
	write_coord_fl(fStartOrigin[1])
	write_coord_fl(fStartOrigin[2])
	write_coord_fl(fStartOrigin[0])
	write_coord_fl(fStartOrigin[1])
	write_coord_fl(fStartOrigin[2] + get_pcvar_float(pCvarTurretRadius))
	write_short(g_iExplosionSprite)
	write_byte(0)
	write_byte(3)
	write_byte(10)
	write_byte(80)
	write_byte(0)
	write_byte(iRGB[0])
	write_byte(iRGB[1])
	write_byte(iRGB[2])
	write_byte(75)
	write_byte(0)
	message_end()
}
