#include <amxmodx>
#include <fakemeta>
#include <engine>
#include <hamsandwich>
#include <pubnite_mod>
#include <cromchat>

#define PLUGIN 				"PUBNite: Jetpack"
#define VERSION 			"1.0"
#define AUTHOR 				"EFFEX"

#if AMXX_VERSION_NUM < 183
#define client_disconnected		client_disconnect
#endif

#define JETPACK_MODEL			"models/pubg/itens/jetpack.mdl"

const Float:DELAYED_MESSAGE =		1.0

new g_iJetPackID, g_iPlayerTrailSprite

new Float:g_fGameTime[MAX_PLAYERS + 1], Float:g_fLastUse[MAX_PLAYERS + 1]
new g_iPlayerJetPack[MAX_PLAYERS + 1], g_iJumps[MAX_PLAYERS + 1], bool:g_bJumped[MAX_PLAYERS + 1]
new bool:g_bHasJetPack[MAX_PLAYERS + 1], g_iUserJetPackJumps[MAX_PLAYERS + 1]

new pCvarMaxJumps, pCvarMinJumps, pCvarJetPackImpulse

new const g_szJetPackSound[] =		"pubg/effects/jetpack.wav"
new const g_szPickupSound[] = 		"items/gunpickup2.wav"

public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	pCvarMinJumps = register_cvar("pubnite_jetpack_minjumps", "2")
	pCvarMaxJumps = register_cvar("pubnite_jetpack_maxjumps", "15")
	pCvarJetPackImpulse = register_cvar("pubnite_jetpack_impulse", "400.0")
	
	g_iJetPackID = pubnite_register_customitem("Jetpack", JETPACK_MODEL, RARITY_GOLD, get_pcvar_num(pCvarMaxJumps), "hasJetPack")
	if(!g_iJetPackID)
	{
		set_fail_state("Couldn't create the Jetpack item.")
	}

	register_dictionary("effxs_customitens.txt")
	
	register_event("DeathMsg", "event_DeathMsg", "a")
	register_forward(FM_CmdStart, "forward_cmdStart")
	RegisterHam(Ham_Spawn, "player", "ham_PlayerSpawn_Post", 1)
	RegisterHam(Ham_Player_Jump, "player", "ham_Player_Jump_Pre", 0)
}

public plugin_precache()
{
	precache_sound(g_szJetPackSound)
	precache_sound(g_szPickupSound)
	
	g_iPlayerTrailSprite = 	precache_model("sprites/smoke.spr")
}

public hasJetPack(id, &ret)
{
	ret = g_bHasJetPack[id]
}

public client_disconnected(id)
{
	removeJetPack(id)
}

public ham_PlayerSpawn_Post(id)
{
	g_iJumps[id] = g_iUserJetPackJumps[id] = 0
	removeJetPack(id)
}

public event_DeathMsg()
{
	new iVictim = read_data(2)
	if(is_user_connected(iVictim))
	{
		removeJetPack(iVictim)
	}
}

public pubnite_customitem_dropped(iPlayer, iCustomItemID)
{
	if((iCustomItemID == g_iJetPackID) && g_bHasJetPack[iPlayer])
	{
		pubnite_create_customitem(g_iJetPackID, clamp(g_iUserJetPackJumps[iPlayer], 0, get_pcvar_num(pCvarMaxJumps)), iPlayer)
		removeJetPack(iPlayer)
	}
}

public pubnite_customitem_pickedup(iPlayer, iEntityID, iCustomItemID, iCustomItemLife)
{
	if((iCustomItemID == g_iJetPackID) && !g_bHasJetPack[iPlayer] && !pubnite_is_knockedout(iPlayer))
	{
		if(pubnite_has_customitem(iPlayer, pubnite_customitemid_by_name("RPG")))
		{
			static Float:fGameTime;fGameTime = get_gametime()
			if((fGameTime - g_fGameTime[iPlayer]) > DELAYED_MESSAGE)
			{
				g_fGameTime[iPlayer] = fGameTime
				
				CC_SendMatched(iPlayer, CC_COLOR_RED, "&x03%L", iPlayer, "SERVER_CANT_USE_BOTH_RPG_JETPACK")
				client_cmd(iPlayer, "spk buttons/button11")
			}
			return
		}
		
		new iEnt = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "info_target"))
		if(pev_valid(iEnt))
		{		
			g_iPlayerJetPack[iPlayer] = iEnt
			
			set_pev(iEnt, pev_movetype, MOVETYPE_FOLLOW)
			set_pev(iEnt, pev_aiment, iPlayer)
			set_pev(iEnt, pev_solid, SOLID_NOT)
			engfunc(EngFunc_SetModel, iEnt, JETPACK_MODEL)
		}
				
		set_hudmessage(255, 255, 255, -1.0, 0.37, 0, 1.0, 5.0)
		show_hudmessage(iPlayer, "%L", iPlayer, "JETPACK_EQUIPED")
		
		emit_sound(iPlayer, CHAN_ITEM, g_szPickupSound, VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
	
		g_bHasJetPack[iPlayer] = true
		g_iUserJetPackJumps[iPlayer] = iCustomItemLife
		
		engfunc(EngFunc_RemoveEntity, iEntityID)
	}
}

public ham_Player_Jump_Pre(id)
{
	if(!is_user_alive(id) 
	|| is_user_bot(id) 
	|| !g_bHasJetPack[id] 
	|| pubnite_is_knockedout(id)
	|| pubnite_get_user_parachute(id))
		return HAM_IGNORED
		
	if(!(pev(id, pev_oldbuttons) & IN_JUMP))
	{
		if(++g_iJumps[id] == get_pcvar_num(pCvarMinJumps))
		{
			static Float:fGameTime;fGameTime = get_gametime()
			if((fGameTime - g_fLastUse[id]) > 0.8) // spam check
			{
				if(!g_iUserJetPackJumps[id])
				{
					CC_SendMatched(id, CC_COLOR_RED, "&x03%L", id, "SERVER_JETPACK_OUT_GAS")
					client_cmd(id, "spk buttons/button11")
					return FMRES_IGNORED
				}
					
				new Float:fVelocity[3]
				pev(id, pev_velocity, fVelocity)
				fVelocity[2] = get_pcvar_float(pCvarJetPackImpulse)
				set_pev(id, pev_velocity, fVelocity)
						
				g_iUserJetPackJumps[id]--	
				g_fLastUse[id] = fGameTime
				g_bJumped[id] = true
						
				client_print(id, print_center, "%L", id, "SERVER_JETPACK_LIFE", g_iUserJetPackJumps[id])
								
				setBeamFollow(g_iPlayerJetPack[id])
				emit_sound(id, CHAN_ITEM, g_szJetPackSound, VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
			}
			g_iJumps[id] = 0
		}
	}
	return HAM_IGNORED
}
		
public forward_cmdStart(id, uc_handle)
{
	if(!is_user_alive(id) 
	|| is_user_bot(id) 
	|| !g_bHasJetPack[id] 
	|| pubnite_is_knockedout(id)
	|| pubnite_get_user_parachute(id))
		return FMRES_IGNORED
	
	if(pev(id, pev_flags) & FL_ONGROUND)
	{
		if(g_bJumped[id])
		{
			g_bJumped[id] = false
			killTrailBeam(g_iPlayerJetPack[id])
		}
		g_iJumps[id] = 0
	}
	return FMRES_IGNORED
}

setBeamFollow(iEnt)
{
	if(!pev_valid(iEnt))
		return

	killTrailBeam(iEnt)
	
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(TE_BEAMFOLLOW)
	write_short(iEnt)
	write_short(g_iPlayerTrailSprite)
	write_byte(5)
	write_byte(6)
	write_byte(220)
	write_byte(80)
	write_byte(0)
	write_byte(255)
	message_end()
}

killTrailBeam(iEnt)
{
	if(pev_valid(iEnt))
	{
		message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
		write_byte(TE_KILLBEAM)
		write_short(iEnt)
		message_end()
	}
}

removeJetPack(id)
{
	new iEnt = g_iPlayerJetPack[id]
	if(iEnt && pev_valid(iEnt))
	{
		engfunc(EngFunc_RemoveEntity, iEnt)
	}
	
	g_iJumps[id] = g_iUserJetPackJumps[id] = g_iPlayerJetPack[id] = 0
	g_bHasJetPack[id] = false
}
