#include <amxmodx>
#include <fakemeta>
#include <engine>
#include <hamsandwich>
#include <cromchat>
#include <pubnite_mod>
#include <xs>

#define PLUGIN				"PUBNite: Launchpad"
#define VERSION 			"1.0"
#define AUTHOR 				"EFFEX"

#define message_begin_fl(%1,%2) 	engfunc(EngFunc_MessageBegin, %1, SVC_TEMPENTITY, %2, 0)
#define write_coord_fl(%1) 		engfunc(EngFunc_WriteCoord, %1)

#define TASK_SET_PARACHUTE		212636131
#define FLASHLIGHT_IMPULSE		100
#define LAUNCHPAD_MODEL			"models/pubg/itens/w_launchpad.mdl"

new const g_szLaunchPadSpawnSound[] =	"pubg/effects/launchpad_spawn.wav"
new const g_szLaunchPadUseSound[] =	"pubg/effects/launchpad_use.wav"

new const g_szPickupSound[] = 		"items/gunpickup2.wav"
new const g_szLaunchpadClassName[] =	"launchpad_item"

new bool:g_bHasLaunchPad[MAX_PLAYERS + 1]
new g_iLaunchPadID, g_iExplosionSprite

new pCvarJumpSpeed, pCvarMaxJumps

public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	pCvarJumpSpeed = register_cvar("pubnite_launchpad_jumpspeed", "1200.0")
	pCvarMaxJumps = register_cvar("pubnite_launchpad_maxjumps", "5")
	
	g_iLaunchPadID = pubnite_register_customitem("Launch Pad", LAUNCHPAD_MODEL, RARITY_PURPLE, get_pcvar_num(pCvarMaxJumps), "hasLaunchPad")
	if(!g_iLaunchPadID)
	{
		set_fail_state("Couldn't create the Launch Pad item.")
	}
	
	register_dictionary("effxs_battleroyale.txt")
	register_dictionary("effxs_customitens.txt")

	register_event("HLTV", "event_NewRound", "a", "1=0", "2=0")
	
	RegisterHam(Ham_Player_ImpulseCommands, "player", "ham_PlayerImpulse")
	RegisterHam(Ham_Spawn, "player", "ham_PlayerSpawn_Post", 1)
}

public plugin_precache()
{
	g_iExplosionSprite = 	precache_model("sprites/shockwave.spr")
	precache_model(LAUNCHPAD_MODEL)
	
	precache_sound(g_szPickupSound)
	precache_sound(g_szLaunchPadUseSound)
	precache_sound(g_szLaunchPadSpawnSound)
}

public hasLaunchPad(id, &ret)
{
	ret = g_bHasLaunchPad[id]
}

public ham_PlayerSpawn_Post(id)
{
	g_bHasLaunchPad[id] = false
}

public event_NewRound()
{
	new iEnt = -1
	while((iEnt = find_ent_by_class(iEnt, g_szLaunchpadClassName)))
	{
		engfunc(EngFunc_RemoveEntity, iEnt)
	}
}

public pubnite_customitem_used(iPlayer, iCustomItemID)
{
	if((iCustomItemID == g_iLaunchPadID) 
	&& g_bHasLaunchPad[iPlayer]
	&& !pubnite_is_knockedout(iPlayer))
	{
		spawnLaunch(iPlayer)
	}
}

public pubnite_customitem_dropped(iPlayer, iCustomItemID)
{
	if((iCustomItemID == g_iLaunchPadID) && g_bHasLaunchPad[iPlayer])
	{
		pubnite_create_customitem(g_iLaunchPadID, get_pcvar_num(pCvarMaxJumps), iPlayer)
		g_bHasLaunchPad[iPlayer] = false
	}
}

public pubnite_customitem_pickedup(iPlayer, iEntityID, iCustomItemID, iCustomItemLife)
{
	if((iCustomItemID == g_iLaunchPadID) 
	&& !g_bHasLaunchPad[iPlayer] 
	&& !pubnite_is_knockedout(iPlayer))
	{
		g_bHasLaunchPad[iPlayer] = true
		
		set_hudmessage(255, 255, 255, -1.0, 0.37, 0, 1.0, 5.0)
		show_hudmessage(iPlayer, "%L", iPlayer, "LAUNCHPAD_EQUIPED")
		
		emit_sound(iPlayer, CHAN_ITEM, g_szPickupSound, VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
		engfunc(EngFunc_RemoveEntity, iEntityID)
	}
} 

public client_PreThink(id)
{
	if(!is_user_alive(id) || is_user_bot(id))
		return
		
	new iGroundEntity = pev(id, pev_groundentity)
	if(!pev_valid(iGroundEntity))
		return
		
	static szClassName[MAX_PLAYERS]
	pev(iGroundEntity, pev_classname, szClassName, charsmax(szClassName))
	if(equal(szClassName, g_szLaunchpadClassName))
	{
		new iPevLife = pev(iGroundEntity, pev_iuser3)
		set_pev(iGroundEntity, pev_iuser3, iPevLife + 1) 
		
		static Float:fVelocity[3]
		pev(id, pev_velocity, fVelocity)
		fVelocity[2] = get_pcvar_float(pCvarJumpSpeed)
		set_pev(id, pev_velocity, fVelocity)
		
		playAnimation(iGroundEntity, 1)
		
		set_task(0.8, "setParachuteAbility", id + TASK_SET_PARACHUTE)
		set_pev(id, pev_groundentity, 0)
		
		new iMaxLife = get_pcvar_num(pCvarMaxJumps)
		if(iPevLife >= iMaxLife)
		{
			createBlast(iGroundEntity)
			emit_sound(iGroundEntity, CHAN_BODY, g_szLaunchPadSpawnSound, VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
			engfunc(EngFunc_RemoveEntity, iGroundEntity)
		}
		else 
		{
			emit_sound(iGroundEntity, CHAN_BODY, g_szLaunchPadUseSound, VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
			client_print(id, print_center, "%L", id, "SERVER_LAUNCHPAD_LIFE", (iMaxLife - iPevLife))
		}
	}
}

createBlast(iEntity)
{
	new Float:fStartOrigin[3]
	pev(iEntity, pev_origin, fStartOrigin)
	const Float:BLAST_RADIUS = 250.0
	
	message_begin_fl(MSG_PVS, fStartOrigin)
	write_byte(TE_BEAMCYLINDER)
	write_coord_fl(fStartOrigin[0])
	write_coord_fl(fStartOrigin[1])
	write_coord_fl(fStartOrigin[2])
	write_coord_fl(fStartOrigin[0])
	write_coord_fl(fStartOrigin[1])
	write_coord_fl(fStartOrigin[2] + BLAST_RADIUS)
	write_short(g_iExplosionSprite)
	write_byte(0)
	write_byte(3)
	write_byte(10)
	write_byte(80)
	write_byte(0)
	write_byte(255)
	write_byte(255)
	write_byte(255)
	write_byte(255)
	write_byte(0)
	message_end()
}

public setParachuteAbility(id)
{
	pubnite_set_user_parachute((id - TASK_SET_PARACHUTE), true)
}

public ham_PlayerImpulse(id)
{
	if(!is_user_alive(id) || is_user_bot(id) || !g_bHasLaunchPad[id] || pubnite_is_knockedout(id))
		return HAM_IGNORED
		
	if(pev(id, pev_impulse) == FLASHLIGHT_IMPULSE)
	{
		spawnLaunch(id)
		set_pev(id, pev_impulse, 0)
		return HAM_SUPERCEDE
	}
	return HAM_IGNORED
}

spawnLaunch(id)
{
	new Float:fOrigin[3]
	originUnitsAhead(id, fOrigin, 100)

	if(isInvalidPlace(fOrigin, id))
	{
		CC_SendMatched(id, CC_COLOR_RED, "%L", id, "SERVER_INVALID_PLACE_TO_USE")
		client_cmd(id, "spk buttons/button11")
		return PLUGIN_HANDLED
	}
			
	new iEnt = create_entity("info_target")
	if(pev_valid(iEnt))
	{	
		g_bHasLaunchPad[id] = false
		
		set_pev(iEnt, pev_origin, fOrigin)
		engfunc(EngFunc_SetModel, iEnt, LAUNCHPAD_MODEL)
		set_pev(iEnt, pev_gravity, 1.0)
		set_pev(iEnt, pev_movetype, MOVETYPE_TOSS)
		set_pev(iEnt, pev_solid, SOLID_BBOX)
		set_pev(iEnt, pev_classname, g_szLaunchpadClassName)
		set_pev(iEnt, pev_body, 1)
		emit_sound(iEnt, CHAN_BODY, g_szLaunchPadSpawnSound, VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
		engfunc(EngFunc_DropToFloor, iEnt)
		
		engfunc(EngFunc_SetSize, iEnt, Float:{-15.0, -15.0, 0.0}, Float:{15.0, 15.0, 20.0})
	}
	return PLUGIN_HANDLED
}

playAnimation(const iEnt, const iSequence)
{
	entity_set_float(iEnt, EV_FL_animtime, get_gametime())
	entity_set_float(iEnt, EV_FL_framerate, 1.5)
	entity_set_int(iEnt, EV_INT_sequence, iSequence)
}
