#include <amxmodx>
#include <amxmisc>
#include <cstrike>
#include <engine>
#include <fakemeta>
#include <hamsandwich>
#include <cromchat>
#include <fvault>
#include <fun>
#include <xs>
#include <pubnite_mod>

#if AMXX_VERSION_NUM < 183
#include <dhudmessage>
#define client_disconnected		client_disconnect
#endif

#define PLUGIN 				"BattleRoyale Mod"
#define VERSION 			"2.9"
#define AUTHOR 				"EFFx"

#define SOUND_EFFECTS_FILE		"pubnite_sound_effects"
#define COMMANDS_FILE			"pubnite_commands"
#define ITENS_FILE			"pubnite_itens"
#define RESOURCES_FILE			"pubnite_resources"
#define WIN_SOUNDS			"pubnite_winsounds"
#define WEAPONS_MODELS			"pubnite_weaponsmodels"

#define LOG_FILE			"effxs_battleroyale.log"
#define FILE_FOLDER			"pubnite_mod"

#define m_pPlayer			41
#define m_LastHitGroup			75
#define m_iTeam				114
#define m_rpgPlayerItems  		367
#define m_rpgPlayerItemsDiff  		5
#define m_WeaponBox_rgpPlayerItems  	34
#define XTRA_OFS_WEAPON			4

#define isTeam(%1)			(1 <= get_user_team(%1) <= 2)
#define isHeadShot(%1)			(get_pdata_int(%1, m_LastHitGroup) == HIT_HEAD)
#define fm_get_user_team(%1)		get_pdata_int(%1, m_iTeam)
#define fm_set_user_team(%1,%2)		set_pdata_int(%1, m_iTeam, %2)
#define resetUserSpeed(%1)		ExecuteHamB(Ham_Player_ResetMaxSpeed, %1)
#define getWeaponBoxID(%1,%2) 		get_pdata_cbase(%1, (m_rpgPlayerItems + %2), m_rpgPlayerItemsDiff)

#define lockedSound(%1)			clientPlaySound(%1, g_szSoundsData[sLockedSounds])
#define message_begin_fl(%1,%2,%3,%4)	engfunc(EngFunc_MessageBegin, %1, %2, %3, %4)
#define write_coord_fl(%1)		engfunc(EngFunc_WriteCoord, %1)

#define isTeamKnockAvaliable(%1)	(getKnockedMates(%1) < (getPlayersNumInATeam(g_dUserData[(%1)][iTeamID], true) - 1))
#define isTeammate(%1,%2)		(g_dUserData[%1][iTeamID] && g_dUserData[%2][iTeamID] && g_dUserData[%1][iTeamID] == g_dUserData[%2][iTeamID])
#define isSpectating(%1,%2)		((pev((%1), pev_iuser2) == (%2)) && (pev((%1), pev_iuser1) != 3))

#define playSound(%1,%2)		client_cmd(%1, "%s ^"%s^"", (equal(%2[strlen(%2) - 4], ".mp3")) ? "mp3 play" : "spk", %2)
#define setInvisibility(%1,%2) 		set_user_rendering(%1, kRenderFxNone, 0, 0, 0, %2, 0)
#define isAvaliableClassName(%1)	equal(%1, g_szClassNamesData[cWeapons])
#define cantReadTheLine(%1)		((%1[0] == EOS) || (%1[0] == ';') || ((%1[0] == '/') && (%1[1] == '/')))
#define getMaxChestNum()		clamp(((getPlayersNum() / 4) + 1), 1, g_iVecsNum[vecChests])
#define getPercent(%1,%2) 		((%1) >= 0 ? clamp(floatround(floatmul(float((%1)) / float((%2)), 100.0)), 0, 100) : 0)
#define isGrenade(%1)			((1 << %1) & CONST_INVALID_WEAPONS)
#define isSupportWeapons(%1)		((1 << %1) & CONST_SHOTGUNS)
#define isPrimaryWeapon(%1)		((1 << %1) & CONST_RIFLES) || ((1 << %1) & CONST_SHOTGUNS)
#define getArmorLife(%1)		(25 + (25 * %1))
#define canCreateNewItem(%1)		(%1 < get_pcvar_num(g_pCvars[cMaxItemsOnChest]))
#define canOpenSafeParachute(%1,%2,%3) 	((%1 / xs_vec_len(%2)) < %3)
#define canUseMedKit(%1)		(g_dUserData[%1][iMedKits] && (get_user_weapon(%1) == CSW_KNIFE) && (pev(%1, pev_flags) & FL_ONGROUND) && !isUserMoving(%1) && !g_dUserData[%1][bKnockedOut])
#define canUseChugJug(%1) 		((get_user_weapon(%1) == CSW_KNIFE) && g_dUserData[%1][bHasChugJug] && !g_dUserData[%1][bKnockedOut] && !isUserMoving(%1))
#define isAbleToBeKnockedout(%1) 	(!g_dUserData[%1][bKnockedOut] && g_dUserData[%1][iTeamID] && (getPlayersNumInATeam(g_dUserData[%1][iTeamID]) > 1) && isTeamKnockAvaliable(%1))
#define didMinimumDamage(%1,%2) 	((%1 * %2 / 100) > iPercentage)

#define bitarray_max(%1) 		(%1 >> 5)
#define bitarray_set(%1,%2) 		(%1[%2>>5] |= (1<<(%2 & 31)))
#define bitarray_clear(%1,%2) 		(%1[%2>>5] &= ~(1<<(%2 & 31)))
#define bitarray_reset(%1) 		arrayset(%1, 0, sizeof(%1))
#define bitarray_check(%1,%2) 		(%1[%2>>5] & (1<<(%2 & 31)))

#define is_user_valid(%1) 		(1 <= (%1) <= g_iMaxPlayers)
#define __is_user_alive(%1) 		(g_dUserData[%1][bIsUserAlive])
#define __is_user_bot(%1) 		(g_dUserData[%1][bIsUserBot])

// random_mod(max): A small function to give a random number from 0 to max-1. Useful for get random values from arrays
#define random_mod(%1) 			(random_num(0, (100 * (%1)) - 1) % (%1))

#define MESSAGE_DELAY			1.5
#define BLEEDS_NUM			3
#define KNOCK_SPEED			80.0
#define DISTANCE_CHECK			115
#define MAX_HEALTH			100
#define MAX_SPAWNS			350
#define WEAPONS_CHANCE			5
#define MIN_SPAWNS_PER_ROUND		55
#define MAX_AIRDROP_ITEMS		8
#define MAX_VECS			200
#define MAX_CHESTS			20
#define ALL_MATES			5012
#define PRESS_E_HUD_DELAY		5
#define PICKUP_DELAY			0.2
#define CSW_VEHICLE			3675501
#define SUPPLY_DISTANCE_SOUND		900.0
#define M249_CHANCE			1
#define MAX_SUPLLY_TRIES 		5

#define TASK_SPAWN_AIRDROP		2313412
#define TASK_COUNTDOWN			3313181
#define TASK_WEAPONS			1236613
#define TASK_REMOVEHEALTH		3818301
#define TASK_KNOCK			8831831
#define TASK_PLAYERSCOUNT		1123131
#define TASK_PLANE 			3741719
#define TASK_MEDKIT			2311313
#define TASK_SET_DAMAGEBLE		3913113
#define TASK_ADD_WEAPONS		3813139
#define TASK_UP_PLAYER			7516361
#define TASK_CHUG_JUG_HEAL		3641641
#define TASK_SPIT_ITEMS			5717731
#define TASK_AD_SPIT_ITEMS		7571723
#define TASK_RE_EMITSOUND		8191391
#define TASK_WALL_REMOVE		7711272

const Float:g_fMaxDistance = 		115.0
const Float:MIN_DISTANCE =		0.089301
const Float:MAX_DISTANCE =		0.239025
const Float:g_fGuspeSafeTime =		0.40
const Float:g_fDefaultSafeTime = 	0.90

const iPercentage = 			70
const HUD_HIDE =		 	(1<<1)|(1<<5)
const DMG_HE =				(1 << 24)
const CONST_SHOTGUNS =			(1 << CSW_M3)|(1 << CSW_XM1014)
const CONST_PISTOLS =			(1 << CSW_USP)|(1 << CSW_DEAGLE)
const CONST_INVALID_WEAPONS = 		(1 << CSW_HEGRENADE)|(1 << CSW_FLASHBANG)|(1 << CSW_SMOKEGRENADE)

const CONST_RIFLES = 			(1 << CSW_AUG)|(1 << CSW_UMP45)|
					(1 << CSW_FAMAS)|(1 << CSW_MP5NAVY)|
					(1 << CSW_M4A1)|(1 << CSW_SG552)|
					(1 << CSW_AK47)|(1 << CSW_SCOUT)|
					(1 << CSW_M249)|(1 << CSW_AWP)

new const Float:g_fSize[][3] = 
{
	{0.0, 0.0, 1.0}, {0.0, 0.0, -1.0}, {0.0, 1.0, 0.0}, {0.0, -1.0, 0.0}, {1.0, 0.0, 0.0}, {-1.0, 0.0, 0.0}, {-1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {1.0, -1.0, 1.0}, {1.0, 1.0, -1.0}, {-1.0, -1.0, 1.0}, {1.0, -1.0, -1.0}, {-1.0, 1.0, -1.0}, {-1.0, -1.0, -1.0},
	{0.0, 0.0, 2.0}, {0.0, 0.0, -2.0}, {0.0, 2.0, 0.0}, {0.0, -2.0, 0.0}, {2.0, 0.0, 0.0}, {-2.0, 0.0, 0.0}, {-2.0, 2.0, 2.0}, {2.0, 2.0, 2.0}, {2.0, -2.0, 2.0}, {2.0, 2.0, -2.0}, {-2.0, -2.0, 2.0}, {2.0, -2.0, -2.0}, {-2.0, 2.0, -2.0}, {-2.0, -2.0, -2.0},
	{0.0, 0.0, 3.0}, {0.0, 0.0, -3.0}, {0.0, 3.0, 0.0}, {0.0, -3.0, 0.0}, {3.0, 0.0, 0.0}, {-3.0, 0.0, 0.0}, {-3.0, 3.0, 3.0}, {3.0, 3.0, 3.0}, {3.0, -3.0, 3.0}, {3.0, 3.0, -3.0}, {-3.0, -3.0, 3.0}, {3.0, -3.0, -3.0}, {-3.0, 3.0, -3.0}, {-3.0, -3.0, -3.0},
	{0.0, 0.0, 4.0}, {0.0, 0.0, -4.0}, {0.0, 4.0, 0.0}, {0.0, -4.0, 0.0}, {4.0, 0.0, 0.0}, {-4.0, 0.0, 0.0}, {-4.0, 4.0, 4.0}, {4.0, 4.0, 4.0}, {4.0, -4.0, 4.0}, {4.0, 4.0, -4.0}, {-4.0, -4.0, 4.0}, {4.0, -4.0, -4.0}, {-4.0, 4.0, -4.0}, {-4.0, -4.0, -4.0},
	{0.0, 0.0, 5.0}, {0.0, 0.0, -5.0}, {0.0, 5.0, 0.0}, {0.0, -5.0, 0.0}, {5.0, 0.0, 0.0}, {-5.0, 0.0, 0.0}, {-5.0, 5.0, 5.0}, {5.0, 5.0, 5.0}, {5.0, -5.0, 5.0}, {5.0, 5.0, -5.0}, {-5.0, -5.0, 5.0}, {5.0, -5.0, -5.0}, {-5.0, 5.0, -5.0}, {-5.0, -5.0, -5.0}
}

enum _:pCvars
{
	cFreezeTime,
	cNewRoundTime,
	cAirDropTime,
	cHelpTime, 
	cMedkitTime,
	cMedkitHealth,
	cPlayersNumShow,
	cPlayerTrail,
	cTeamMateEffect,
	cAllowVoice,
	cSpawnWeaponsTime,
	cAllowToJumpTime,
	cGameNameInfo,
	cGameNameSetInfo,
	cImpulseMultiplier,
	cImpulseGrenRadius,
	cParachuteFallSpeed,
	cChugJugTime,
	cSpecCountAdmins,
	cShowSpectatingMessage,
	cMinPlayersToDuo,
	cUnknockHealth,
	cShowDamage,
	cChestOpeningDelay,
	cMinPlayersToThreesome,
	cMinPlayersToSquad,
	cAirDropOpeningDelay,
	cBlockKillCommand,
	cMaxPlayersInATeam,
	cMaxSupplyBox,
	cCvarGreyMultiplier,
	cCvarGreenMultiplier,
	cCvarBlueMultiplier,
	cCvarPurpleMultiplier,
	cCvarGoldMultiplier,
	cLevelNoBagMax,
	cLevel1BagMax,
	cLevel2BagMax,
	cLevel3BagMax,
	cLevel1HelmetHits,
	cLevel2HelmetHits,
	cLevel3HelmetHits,
	cShowTeammateMsg,
	cMateMessageFlagAccess,
	cImpulseItems,
	cAddRarities,
	cWallLife,
	cWallHealthToTake,
	cGlowWallItem,
	cMaxItemsOnChest,
	cParachuteType,
	cBloodColor,
	cFFA,
	cWinVBucks,
	cHSVBucks,
	cKillVBucks,
	cFinalizeVBucks,
	cLastDamageDelay
}

enum hHuds
{
	hFreezeTime,
	hFreezeTimeEnd,
	hEquipedHud,
	hKilledMate,
	hLostHelmet,
	hPosition,
	hGuspe,
	hDamageHud
}

enum dUserData
{
	iKills,
	iKnocks,
	iPlayerWeaponID,
	iHelpingID,
	iHelperID,
	iKnockerID,
	iWeaponKnocker,
	iNewKillerID,
	iArmorLevel,
	iHelmetEnt,
	iHelmetLevel,
	iInviter,
	iVitoriasSolo,
	iVitoriasDuo,
	iVitoriasSquad,
	iMedKits,
	iBagLevel,
	iUserSupplyID,
	iSpectatingID,
	iChestID,
	iTeamID,
	iUserSysTime,
	iTeammateSpr,
	iImpulserID,
	iVoiceMode,
	iDeathHealth,
	iUserVBucks,
	iUserFrags,
	iUserDeaths,
	Float:fUserGameTime,
	Float:fUserGameTime2,
	bool:bKnockedOut,
	bool:bIsOnPlane,
	bool:bCanUseParachute,
	bool:bAutoMenu,
	bool:bHasGuspe,
	bool:bDiedBleeding,
	bool:bHasChugJug,
	bool:bCantPickup,
	bool:bParachuteOpened,
	bool:bIsUserAlive,
	bool:bIsUserBot,
	bool:bIsTeamLeader,
	bool:bHasWall,
	bool:bUsedGuspe,
	bool:bRoundSounds,
	bool:bCanSeeRarities,
	bool:bCanReceiveInvites,
	bool:b3DCamera,
	szName[MAX_PLAYERS]
}

enum mModels
{
	mAirDrop,
	mTransporter,
	mUserParachute,
	mImpulseGrenadeViewModel,
	mImpulseGrenadePlayerModel,
	mChestModel,
	mWallModel
}

enum cClasses
{
	cAirDrop,
	cTransporter,
	cWeapons,
	cParachute,
	cChest,
	cWall
}

enum sSounds
{
	sAmmoPickup,
	sGunPickup,
	sDamagePain,
	sTransporter,
	sHelmetHit,
	sPlaneDropSound,
	sImpulseGrenadeSound,
	sUsingMedkit,
	sMateKnocked,
	sDeathSound,
	sGuspeSound,
	sAirdropTouchSound,
	sAirDropAppearSound,
	sUnknockingMate,
	sMateUnknocked,
	sCriticalHit,
	sKnockedAnEnemy,
	sParachuteLand,
	sCriticalKill,
	sParachuteOpen,
	sGuspeAlertSound,
	sAirDropLandingSound,
	sTeammateDropSound,
	sSkyDiveSound,
	sRadioAlert,
	sLockedSounds,
	sArmorHitSound,
	sChugJugSound,
	sChestSound,
	sChestOpened,
	sOpeningSound,
	sThanksSound,
	sMateMessage,
	sSupplyOpeningSound,
	sSupplyOpenedSound,
	sSupplyFarLandSound,
	sWallCreateSound,
	sWallHitSound,
	sWallDestroyedSound,
	sCountDownEffect1,
	sCountDownEffect2,
	sVoiceChangeModeSound
}

enum vVecsData
{
	vOrigin,
	vAngles,
	vVelocities,
	vRemoveTime
}

enum vIniData
{
	vecPlane,
	vecWeapons,
	vecChests
}

enum mModelsData
{
	szModelName[MAX_MODEL_LENGTH],
	iWeaponInfoID
}

enum iItensList
{
	iKevlarLv1,
	iKevlarLv2,
	iKevlarLv3,
	iMedKit,
	iHelmetLv1,
	iHelmetLv2,
	iHelmetLv3,
	iBagLv1,
	iBagLv2,
	iBagLv3,
	iImpulseGrenade,
	iGuspe,
	iChugJug,
	iWall
}

enum iItensData
{
	szItemModel[MAX_MODEL_LENGTH],
	iItemID,
	iItemInfoLevel,
	bool:bIsItemEnabled
}

enum nNamesData
{
	nAK47,
	nM4A1,
	nAWP,
	nSCOUT,
	nFAMAS,
	nAUG,
	nSG552,
	nUSP,
	nDEAGLE,
	nXM1014,
	nM3,
	nHEGRENADE,
	nM249,
	nMP5,
	nUMP45,
	nP90,
	nMAC10,
	nTMP,
	nELITE,
	nP250,
	nGLOCK18,
	nGALIL,	
	nG3SG1,
	nSG550
}

new const g_szClassNamesData[cClasses][] =
{
	"pubnite_supplybox",
	"pubnite_transporter",
	"pubnite_weapons",
	"pubnite_parachute",
	"pubnite_chest",
	"pubnite_wall"
}

new g_hHuds[hHuds]
new g_pCvars[pCvars]
new g_iTotalVecs[vVecsData]
new g_iVecsNum[vIniData]
new g_dUserData[MAX_PLAYERS + 1][dUserData]

new g_szWeaponsModels[MAX_PLAYERS][mModelsData], g_iWeaponsNum
new g_szSoundsData[sSounds][MAX_MODEL_LENGTH]
new g_szModelsData[mModels][MAX_MODEL_LENGTH]
new g_szItens[iItensList][iItensData]
new g_cCommands[cCommandsData][MAX_MODEL_LENGTH]
new g_szWeaponsDisplayName[nNamesData][MAX_PLAYERS]

new g_iWeaponRarityValue[MAX_PLAYERS + 1][36]
new g_iDamageDone[MAX_PLAYERS + 1][MAX_PLAYERS + 1]
new g_iLastDamageDone[MAX_PLAYERS + 1][MAX_PLAYERS + 1]

new g_iItensNum[iItensList]
new g_iFreezeTime, g_iPlayerTrailSprite, g_iExplosionSprite, g_iTransporterID, 
g_iTeamsNum, g_iBloodSprite

new g_iAirDropItems[MAX_AIRDROP_ITEMS][MAX_AIRDROP_ITEMS], g_iSupplyNum

new Ham:Ham_Player_ResetMaxSpeed = Ham_Item_PreFrame
new Array:g_arWinSounds

new bool:g_bPlaneSpawned, bool:g_bHasRoundEnded, bool:g_bCanJump
new m_usEventSmokeGrenade

new g_forwardGameWinner, g_forwardGameDescription, g_forwardKnockedOut, g_forwardUnKnockedOut,
g_forwardTeamEliminated, g_forwardRoundStarted, g_forwardCustomItemTouched, 
g_forwardCustomItemCreated, g_forwardCustomItemDropped, g_forwardPlayerBusDrop,
g_forwardPlayerLand, g_forwardUnregisteredWeapon, g_forwardUsedCustomItem

new g_iReturn

new g_mMessageTextMsg, g_mMessageBarTime, g_mMessageScreenFade, g_mMessageHostagePos, 
g_mMessageHostageK, g_mMessageStatusText, g_mMessageScoreInfo, g_mMessageHideWeapon

new g_iParachuteEnt[MAX_PLAYERS + 1]
new g_szMap[MAX_PLAYERS], g_szGameName[MAX_PLAYERS], g_szIniFile[6][125]

new Float:g_fSpawnVecs[MAX_SPAWNS][3]
new Float:g_fMaxZ

new Float:g_fChestPoints[MAX_SPAWNS][3]
new g_iChestNum

new Float:g_fPlaneOrigins[MAX_VECS][3]
new Float:g_fPlaneAngles[MAX_VECS][3]
new Float:g_fPlaneVelocities[MAX_VECS][3]
new Float:g_fPlaneRemoveTime[MAX_VECS]
new g_iRandomDirection

new const g_szSpriteName[] = 		"sprites/pubg/teammate_sprite.spr"

new g_baTeamSprites[bitarray_max(4096) + 1]

new g_iSpawnedWeapNum, g_iChestNumRound, g_iRandomSpawnsNum

new g_iMaxPlayers
new Array:g_arTeams

public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR)

	register_dictionary("effxs_battleroyale.txt")

	CC_SetPrefix("^x04[EFFx S]^x01:")
	
	g_pCvars[cFreezeTime] = register_cvar("pubnite_freezetime", "10")
	g_pCvars[cNewRoundTime] = register_cvar("pubnite_newround_time", "7")
	g_pCvars[cSpawnWeaponsTime] = register_cvar("pubnite_spawnweapons_time", "3")
	g_pCvars[cAirDropTime] = register_cvar("pubnite_airdrop_time", "90")
	g_pCvars[cHelpTime] = register_cvar("pubnite_knock_helptime", "6")
	g_pCvars[cMedkitTime] = register_cvar("pubnite_medkit_time", "5")
	g_pCvars[cMedkitHealth] = register_cvar("pubnite_medkit_health", "60")
	g_pCvars[cPlayersNumShow] = register_cvar("pubnite_players_info", "1")
	g_pCvars[cPlayerTrail] = register_cvar("pubnite_player_trail", "0")
	g_pCvars[cTeamMateEffect] = register_cvar("pubnite_teammate_effect", "1")
	g_pCvars[cAllowToJumpTime] = register_cvar("pubnite_plane_jump_delay", "4")
	g_pCvars[cAllowVoice] = register_cvar("pubnite_allow_voice", "0")
	g_pCvars[cGameNameSetInfo] = register_cvar("pubnite_gamename_set_info", "1")
	g_pCvars[cGameNameInfo] = register_cvar("pubnite_gamename_info", "[PUBNite Mod]")
	g_pCvars[cImpulseMultiplier] = register_cvar("pubnite_impulsegrenade_multiplier", "4.0")
	g_pCvars[cImpulseGrenRadius] = register_cvar("pubnite_impulsegrenade_radius", "200.0")
	g_pCvars[cParachuteFallSpeed] =	register_cvar("pubnite_parachute_fallsped", "-200.0")
	g_pCvars[cChugJugTime] = register_cvar("pubnite_chugjug_time", "15")
	g_pCvars[cSpecCountAdmins] = register_cvar("pubnite_spectating_count_admins", "0")
	g_pCvars[cShowSpectatingMessage] = register_cvar("pubnite_show_spectating_message", "1")
	g_pCvars[cMinPlayersToDuo] = register_cvar("pubnite_min_players_to_duo", "4")
	g_pCvars[cMinPlayersToThreesome] = register_cvar("pubnite_min_players_to_threesome", "10")
	g_pCvars[cMinPlayersToSquad] = register_cvar("pubnite_min_players_to_squad", "16")
	g_pCvars[cUnknockHealth] = register_cvar("pubnite_unknock_health", "20")
	g_pCvars[cShowDamage] = register_cvar("pubnite_show_attacker_damage", "1")
	g_pCvars[cChestOpeningDelay] = register_cvar("pubnite_chest_delay", "2")
	g_pCvars[cAirDropOpeningDelay] = register_cvar("pubnite_airdrop_delay", "5")
	g_pCvars[cBlockKillCommand] = register_cvar("pubnite_block_kill_cmd", "1")
	g_pCvars[cMaxPlayersInATeam] = register_cvar("pubnite_max_players_in_team", "4")
	g_pCvars[cMaxSupplyBox] = register_cvar("pubnite_max_supplybox_per_round", "3")
	g_pCvars[cCvarGreyMultiplier] = register_cvar("pubnite_grey_weapons_dmg_mult", "0.3")
	g_pCvars[cCvarGreenMultiplier] = register_cvar("pubnite_green_weapons_dmg_mult", "0.6")
	g_pCvars[cCvarBlueMultiplier] = register_cvar("pubnite_blue_weapons_dmg_mult", "0.9")
	g_pCvars[cCvarPurpleMultiplier] = register_cvar("pubnite_purple_weapons_dmg_mult", "1.2")
	g_pCvars[cCvarGoldMultiplier] = register_cvar("pubnite_gold_weapons_dmg_mult", "1.5")
	g_pCvars[cLevelNoBagMax] = register_cvar("pubnite_nobag_max_items", "4")
	g_pCvars[cLevel1BagMax] = register_cvar("pubnite_bag_level1_max_items", "6")
	g_pCvars[cLevel2BagMax] = register_cvar("pubnite_bag_level2_max_items", "9")
	g_pCvars[cLevel3BagMax] = register_cvar("pubnite_bag_level3_max_items", "11")
	g_pCvars[cLevel1HelmetHits] = register_cvar("pubnite_level1_helmet_hits", "2")
	g_pCvars[cLevel2HelmetHits] = register_cvar("pubnite_level2_helmet_hits", "3")
	g_pCvars[cLevel3HelmetHits] = register_cvar("pubnite_level3_helmet_hits", "5")
	g_pCvars[cShowTeammateMsg] = register_cvar("pubnite_show_matemessages_to_admin", "2")
	g_pCvars[cMateMessageFlagAccess] = register_cvar("pubnite_show_matemessages_flag", "a")
	g_pCvars[cImpulseItems] = register_cvar("pubnite_impulse_items", "1")
	g_pCvars[cAddRarities] = register_cvar("pubnite_set_rarities", "1")
	g_pCvars[cWallLife] = register_cvar("pubnite_wall_life", "1000")
	g_pCvars[cWallHealthToTake] = register_cvar("pubnite_wall_life_to_take", "50")
	g_pCvars[cGlowWallItem] = register_cvar("pubnite_wall_life_glow", "1")
	g_pCvars[cMaxItemsOnChest] = register_cvar("pubnite_max_items_on_chest", "2")
	g_pCvars[cParachuteType] = register_cvar("pubnite_parachute_type", "0")
	g_pCvars[cBloodColor] = register_cvar("pubnite_blood_color", "255")
	g_pCvars[cFFA] = register_cvar("pubnite_teammate_damage", "0")
	g_pCvars[cWinVBucks] = register_cvar("pubnite_win_vbucks", "100")
	g_pCvars[cHSVBucks] = register_cvar("pubnite_headshot_vbucks", "50")
	g_pCvars[cKillVBucks] = register_cvar("pubnite_kill_Vbucks", "25")
	g_pCvars[cLastDamageDelay] = register_cvar("pubnite_last_damage_delay", "10")
	g_pCvars[cFinalizeVBucks] = register_cvar("pubnite_finalize_vbucks", "15")

	g_mMessageScreenFade = get_user_msgid("ScreenFade")
	g_mMessageTextMsg = get_user_msgid("TextMsg")
	g_mMessageBarTime = get_user_msgid("BarTime")
	g_mMessageHostagePos = get_user_msgid("HostagePos")
	g_mMessageHostageK = get_user_msgid("HostageK")
	g_mMessageStatusText = get_user_msgid("StatusText")
	g_mMessageScoreInfo = get_user_msgid("ScoreInfo")
	g_mMessageHideWeapon = get_user_msgid("HideWeapon")

	m_usEventSmokeGrenade = engfunc(EngFunc_PrecacheEvent, 1, "events/createsmoke.sc")

	remove_entity_name("armoury_entity")
	execCvars()

	g_iMaxPlayers = get_maxplayers()
	g_arTeams = ArrayCreate()
	
	g_forwardGameWinner = CreateMultiForward("pubnite_winner", ET_IGNORE, FP_ARRAY, FP_CELL)
	g_forwardKnockedOut = CreateMultiForward("pubnite_knockedOut", ET_STOP, FP_CELL, FP_CELL, FP_CELL)
	g_forwardUnKnockedOut = CreateMultiForward("pubnite_unknockedOut", ET_STOP, FP_CELL, FP_CELL)
	g_forwardTeamEliminated = CreateMultiForward("pubnite_TeamEliminated", ET_STOP, FP_CELL, FP_CELL)
	g_forwardRoundStarted = CreateMultiForward("pubnite_roundStarted", ET_STOP, FP_CELL, FP_CELL, FP_CELL)
	g_forwardCustomItemTouched = CreateMultiForward("pubnite_customitem_pickedup", ET_STOP, FP_CELL, FP_CELL, FP_CELL, FP_CELL, FP_CELL)
	g_forwardCustomItemCreated = CreateMultiForward("pubnite_customitem_created", ET_STOP, FP_CELL, FP_CELL)
	g_forwardCustomItemDropped = CreateMultiForward("pubnite_customitem_dropped", ET_STOP, FP_CELL, FP_CELL)
	g_forwardPlayerBusDrop = CreateMultiForward("pubnite_player_busdrop", ET_STOP, FP_CELL)
	g_forwardPlayerLand = CreateMultiForward("pubnite_player_land", ET_STOP, FP_CELL)
	g_forwardUnregisteredWeapon = CreateMultiForward("pubnite_noregistered_weapon", ET_STOP, FP_CELL, FP_CELL)
	g_forwardUsedCustomItem = CreateMultiForward("pubnite_customitem_used", ET_STOP, FP_CELL, FP_CELL)
	
	register_menucmd(-2, MENU_KEY_1|MENU_KEY_2|MENU_KEY_5|MENU_KEY_6, "cmdJoinTeam")
	register_menucmd(register_menuid("Team_Select", 1), MENU_KEY_1|MENU_KEY_2|MENU_KEY_5|MENU_KEY_6, "cmdJoinTeam")
	
	set_msg_block(get_user_msgid("Radar"), BLOCK_SET)
	set_msg_block(get_user_msgid("DeathMsg"), BLOCK_SET)
	set_msg_block(get_user_msgid("ClCorpse"), BLOCK_SET)

	register_message(g_mMessageHideWeapon, "message_HideWeapon")
	register_message(g_mMessageTextMsg, "Message_TextMsg")
	register_message(get_user_msgid("StatusValue"), "message_StatusValue")
	register_message(get_user_msgid("StatusIcon"), "message_StatusIcon")
	register_message(get_user_msgid("SendAudio"), "message_SendAudio") 
	
	for(new i;i < sizeof g_hHuds;i++)
	{
		g_hHuds[hHuds:i] = CreateHudSyncObj()
	}
	
	new szRadioCommands[][] = 
	{
		"coverme", "takepoint", "holdpos", 
		"regroup", "followme", "takingfire",
		"go", "fallback", "sticktog", 
		"getinpos", "stormfront", "report",
		"roger", "enemyspot", "needbackup", "sectorclear", 
		"inposition", "reportingin", "getout", 
		"negative", "enemydown"
	}

	for(new i; i < sizeof szRadioCommands; i++)
	{
		register_clcmd(szRadioCommands[i], "ClientCommand_Radio")
	}

	register_clcmd("drop", "cmdDrop")
	register_clcmd("say", "cmdChatSay")
	register_clcmd("say_team", "cmdChatSayTeam")
	register_clcmd("jointeam", "cmdJoinTeam")
	register_clcmd("radio1", "openPUBNiteMenu")
	register_clcmd("radio2", "cmdBag")
	register_clcmd("radio3", "cmdChangeVoiceMode")
	
	register_concmd("pubnite_chest_origins", "cmdChestOriginsMenu", ADMIN_IMMUNITY)
	register_concmd("pubnite_weapons_origins", "cmdWeaponsOriginsMenu", ADMIN_IMMUNITY)
	register_concmd("pubnite_plane_origins", "cmdPlaneOriginsMenu", ADMIN_IMMUNITY)
	register_concmd("pubnite_items_id_list", "cmdItemIdList", ADMIN_IMMUNITY)
	register_concmd("pubnite_give_item", "cmdGiveItem", ADMIN_IMMUNITY, "<name|@all> <item id (type amx_items_id_list)> <item level> <item life>")

	register_forward(FM_AddToFullPack, "forward_AddToFullPack", 1)
	register_forward(FM_CmdStart, "forward_cmdStart")
	register_forward(FM_SetModel, "forward_SetModel")
	register_forward(FM_Touch, "forward_Touch")
	register_forward(FM_PlaybackEvent, "forward_PlaybackEvent", false)
	register_forward(FM_EmitSound, "forward_EmitSound")
	register_forward(FM_Voice_SetClientListening, "forward_SetClientListening")
	register_forward(FM_ClientKill, "forward_ClientKill")

	g_forwardGameDescription = register_forward(FM_GetGameDescription, "forward_setModeDescription")
	
	register_event("CurWeapon", "event_CurWeapon", "be", "1=1")
	register_event("HLTV", "event_NewRound", "a", "1=0", "2=0")
	register_event("ResetHUD", "onResetHUD", "b")

	register_logevent("event_GameWill", 2, "1&Restart_Round_", "1=Game_Commencing")
	
	RegisterHam(Ham_AddPlayerItem, "player", "ham_AddPlayerItem_Post", 1)
	RegisterHam(Ham_Use, "func_vehicle", "ham_UseVehicle", 0)
	RegisterHam(Ham_Use, "func_tracktrain", "ham_UseVehicle", 0)
	RegisterHam(Ham_Spawn, "player", "ham_PlayerSpawn_Pre", 0)
	RegisterHam(Ham_Spawn, "player", "ham_PlayerSpawn_Post", 1)
	RegisterHam(Ham_Killed, "player", "ham_PlayerKilled_Pre", 0)
	RegisterHam(Ham_Killed, "player", "ham_PlayerKilled_Post", 1)
	RegisterHam(Ham_TakeDamage, "player", "ham_PlayerTakeDamage_Pre", 0)
	RegisterHam(Ham_Player_Jump, "player", "ham_Player_Jump_Pre", 0)
	RegisterHam(Ham_Item_Deploy, "weapon_smokegrenade", "ham_SmokeDeploy_Post", 1)
	RegisterHam(Ham_Think, "grenade", "ham_SmokeThink")
	RegisterHam(Ham_BloodColor,"player", "ham_BloodColor")
	RegisterHam(Ham_TraceAttack, "player", "ham_TraceAttack")

	new szConfig[100]
	get_configsdir(szConfig, charsmax(szConfig))
	formatex(szConfig, charsmax(szConfig), "%s/%s", szConfig, FILE_FOLDER)

	formatex(g_szIniFile[1], charsmax(g_szIniFile[]), "%s/pubnite_vectors/%s", szConfig, g_szMap)
	if(!dir_exists(g_szIniFile[1])) 
	{
		mkdir(g_szIniFile[1])
	}
	add(g_szIniFile[1], charsmax(g_szIniFile[]), "/ents_spawn_points.ini")
	
	formatex(g_szIniFile[2], charsmax(g_szIniFile[]), "%s/pubnite_vectors/%s/plane_vecs.ini", szConfig, g_szMap)
	formatex(g_szIniFile[3], charsmax(g_szIniFile[]), "%s/pubnite_management/pubnite_weaponsnames.ini", szConfig)
	formatex(g_szIniFile[4], charsmax(g_szIniFile[]), "%s/pubnite_vectors/%s/chest_points.ini", szConfig, g_szMap)

	if(!readIniData(COMMANDS_FILE) || !readEntsPoints() || !readPlanePoints() || !readWeaponsNames())
	{
		log_amx("[PUBNite Mod]: Config files not loaded.")
		return
	}
	readChestPoints()
	g_fMaxZ = GetMaxHeightWithoutStartOrigin()
}

execCvars()
{
	new szDir[125]
	get_configsdir(szDir, charsmax(szDir))
	formatex(szDir, charsmax(szDir), "%s/%s/pubnite_management/pubnite_cvars.cfg", szDir, FILE_FOLDER)
	if(!file_exists(szDir))
	{
		log_to_file(LOG_FILE, "[PUBNite Mod]: %L", LANG_SERVER, "SERVER_NO_CONFIG_FILE", szDir)
		return
	}
	server_cmd("exec ^"%s^"", szDir)
	
	if(!get_pcvar_num(g_pCvars[cGameNameSetInfo]))
	{
		unregister_forward(FM_GetGameDescription, g_forwardGameDescription)
	}
	else get_pcvar_string(g_pCvars[cGameNameInfo], g_szGameName, charsmax(g_szGameName))
}

public plugin_natives()
{
	register_native("pubnite_is_teammate", "_isTeamMate")
	register_native("pubnite_is_knockedout", "_isUserKnockedOut")
	register_native("pubnite_get_knockerid", "_getKnockerID")
	register_native("pubnite_get_user_team", "_isUserInTeam")
	register_native("pubnite_set_user_team", "_setUserTeam")
	register_native("pubnite_get_user_wins", "_getUserWins")
	register_native("pubnite_set_user_wins", "_SetVictories")
	register_native("pubnite_is_in_countdown", "_IsInCountDown")
	register_native("pubnite_teamsLeft", "_GetTeamsLeft")
	register_native("pubnite_players_remaining", "_GetPlayersLeft")
	register_native("pubnite_get_command", "_GetCommand")
	register_native("pubnite_create_customitem", "_CreateCustomItem")
	register_native("pubnite_create_weapon", "_CreateWeapon")
	register_native("pubnite_force_knockout", "_ForceKnockout")
	register_native("pubnite_able_to_knockout", "_IsAbleToKnockout")
	register_native("pubnite_set_user_parachute", "_SetParachute")
	register_native("pubnite_get_user_parachute", "_GetParachute")
	register_native("pubnite_has_round_ended", "_RoundEnded")
	register_native("pubnite_reset_team_array", "_ResetTeamArray")
	register_native("pubnite_reset_wins", "_ResetWins")
	register_native("pubnite_reset_vbucks", "_ResetVBucks")
	register_native("pubnite_get_user_vbucks", "_GetUserVBucks")
	register_native("pubnite_set_user_vbucks", "_SetUserVBucks")
	register_native("pubnite_is_weapon_registered", "_RegisteredWeapon")
}

public _ResetTeamArray()
{
	g_iTeamsNum = 0
	ArrayClear(g_arTeams)
}

public _ResetWins()
{
	fvault_prune(g_szFVaultSave, 0, get_systime())
	
	new iPlayers[MAX_PLAYERS], playerCount
	get_players(iPlayers, playerCount, "ch")
	for(new i, iPlayer; i < playerCount; i++)
	{
		g_dUserData[(iPlayer = iPlayers[i])][iVitoriasSolo] = g_dUserData[iPlayer][iVitoriasDuo] = g_dUserData[iPlayer][iVitoriasSquad] = 0
	}
}

public _ResetVBucks()
{
	fvault_prune(g_szFVaultVBucks, 0, get_systime())
	
	new iPlayers[MAX_PLAYERS], playerCount
	get_players(iPlayers, playerCount, "ch")
	for(new i; i < playerCount; i++)
	{
		g_dUserData[iPlayers[i]][iUserVBucks] = 0
	}
}

public _GetUserVBucks()
{
	return g_dUserData[get_param(1)][iUserVBucks]
}

public _SetUserVBucks()
{
	new id = get_param(1)
	
	g_dUserData[id][iUserVBucks] = max(get_param(2), 0)
	saveData(id)
}

public _isTeamMate()
{
	return isTeammate(get_param(1), get_param(2))
}

public _isUserKnockedOut()
{
	return g_dUserData[get_param(1)][bKnockedOut]
}

public _isUserInTeam()
{
	return g_dUserData[get_param(1)][iTeamID]
}

public _setUserTeam()
{
	new id = get_param(1), iNewTeamID = get_param(2)
	if((iNewTeamID > 0) && __ArrayFindValue(g_arTeams, iNewTeamID) < 0)
	{
		g_iTeamsNum++
		ArrayPushCell(g_arTeams, (iNewTeamID = g_iTeamsNum))
	}
	
	if(get_param(3) && g_dUserData[id][iTeamID])
	{
		new iPlayers[MAX_PLAYERS], playerCount
		get_players(iPlayers, playerCount, "ch")
		for(new i, iPlayer; i < playerCount; i++)
		{
			iPlayer = iPlayers[i]
			if((id != iPlayer) && isTeammate(iPlayer, id))
			{
				g_dUserData[iPlayer][iTeamID] = iNewTeamID
			}
		}
	}
	g_dUserData[id][iTeamID] = iNewTeamID
}

public _getKnockerID()
{
	return g_dUserData[get_param(1)][iKnockerID]
}

public _getUserWins()
{
	new id = get_param(1)
	if(!is_user_connected(id))
		return -1
		
	new dUserData:iWinType
	switch(get_param(2))
	{
		case 0: iWinType = iVitoriasSolo
		case 1: iWinType = iVitoriasDuo
		default: iWinType = iVitoriasSquad
	}
	return g_dUserData[id][iWinType]
}

public _SetVictories()
{
	new id = get_param(1)
	if(!is_user_connected(id))
		return
		
	new dUserData:iWinType, iType = get_param(3), bool:bSetTheSameValue = false
	switch(iType)
	{
		case 0: iWinType = iVitoriasSolo
		case 1: iWinType = iVitoriasDuo
		case 2: iWinType = iVitoriasSquad
		default:
		{
			bSetTheSameValue = true
		}
	}

	new iValue = get_param(2)
	if(bSetTheSameValue)
	{
		g_dUserData[id][iVitoriasSquad] = g_dUserData[id][iVitoriasDuo] = g_dUserData[id][iVitoriasSolo] = iValue
	}
	else g_dUserData[id][iWinType] = iValue

	saveData(id)
}

public _IsInCountDown()
{
	return (g_iFreezeTime && !g_bPlaneSpawned)
}

public _GetPlayersLeft()
{
	return getPlayersNumInATeam(get_param(1), bool:get_param(2))
}	

public _GetTeamsLeft()
{
	new iReturnValue
	if(get_param(1) > 0)
	{
		iReturnValue = get_param(2) ? getTeamsLeft() : ArraySize(g_arTeams)
	}
	else	iReturnValue = getPlayersWithoutTeam(bool:get_param(2))
	
	return iReturnValue
}

public _GetCommand()
{
	set_string(2, g_cCommands[cCommandsData:get_param(1)], charsmax(g_cCommands[]))
}

public _CreateCustomItem()
{
	new iParamItemId = get_param(1)
	if(!pubnite_is_customitem(iParamItemId))
	{
		log_amx("Couldn't create a custom item, the id passed does not exists!")
		return 0
	}

	new Float:fOrigin[3], iPlayer = get_param(3)
	pev(iPlayer, pev_origin, fOrigin)
	spawnItens(fOrigin, iParamItemId, .iPev3 = get_param(2), .id = iPlayer)
	return 1
}

public _CreateWeapon()
{
	new iWeaponID = get_param(1)
	if(!isWeaponRegistered(iWeaponID))
	{
		log_amx("Couldn't create a weapon, the id passed is not registered!")
		return 0
	}
	else if(!iWeaponID)
	{
		log_amx("Couldn't create a weapon, the id passed is invalid!")
		return 0
	}
	new iWeaponPos = getWeaponPos(iWeaponID)
	if(iWeaponPos == -1)
		return 0
		
	new Float:fOrigin[3], iId = get_param(3)
	pev(iId, pev_origin, fOrigin)

	new bool:bIsValidPlayer = bool:(is_user_valid(iId) && is_user_alive(iId))
	if(bIsValidPlayer)
	{
		g_dUserData[iId][bCantPickup] = true
		set_task(0.2, "resetPickup", iId)
	}
	
	new szModel[MAX_MODEL_LENGTH]
	copy(szModel, charsmax(szModel), g_szWeaponsModels[iWeaponPos][szModelName])
	createWeapon(iWeaponID, szModel, fOrigin, bIsValidPlayer, clamp(get_param(2), RARITY_GREY, RARITY_GOLD), iId)
	return 1
}

public _ForceKnockout()
{
	new iVictim = get_param(1), iAttacker = get_param(2)
	if(is_user_alive(iVictim) && is_user_connected(iAttacker))
	{
		if(isAbleToBeKnockedout(iVictim))
		{
			manageKnockFeature(iVictim, iAttacker)
		}
	}
}

public _IsAbleToKnockout()
{
	return isAbleToBeKnockedout(get_param(1))
}

public _SetParachute()
{
	new id = get_param(1)
	if(is_user_alive(id) && !is_user_bot(id))
	{
		new bool:bSetParachute = bool:get_param(2)
		new bool:bOpenParachute = bool:get_param(3)
		g_dUserData[id][bCanUseParachute] = bSetParachute
		
		clientStopSound(id, true, g_szSoundsData[sSkyDiveSound], .iChannel = CHAN_WEAPON)
		clientPlaySound(id, g_szSoundsData[sSkyDiveSound], true, .iChannel = CHAN_WEAPON, .bPlayForDeads = false)

		if(bSetParachute && bOpenParachute)
		{
			manageParachuteFeature(id, bOpenParachute)
		}
	}
	return g_dUserData[id][bUsedGuspe]
}

public _GetParachute()
{
	return g_dUserData[get_param(1)][bCanUseParachute]
}

public _RoundEnded()
{
	return g_bHasRoundEnded
}

public _RegisteredWeapon()
{
	return isWeaponRegistered(get_param(1))
}

public plugin_precache()
{
	g_arWinSounds = ArrayCreate(MAX_MODEL_LENGTH)

	readIniData(SOUND_EFFECTS_FILE)
	readIniData(ITENS_FILE)
	readIniData(RESOURCES_FILE)
	readIniData(WIN_SOUNDS)
	readIniData(WEAPONS_MODELS)
	
	get_mapname(g_szMap, charsmax(g_szMap))
	precache_model(g_szSpriteName)
	precache_model("models/rpgrocket.mdl")

	g_iBloodSprite = 	precache_model("sprites/blood.spr")
	g_iPlayerTrailSprite = 	precache_model("sprites/smoke.spr")
	g_iExplosionSprite = 	precache_model("sprites/shockwave.spr")
}

public client_infochanged(id)
{
	get_user_info(id, "name", g_dUserData[id][szName], charsmax(g_dUserData[][szName]))
}

public client_connect(id)
{
	loadData(id)
	removeMateSpr(id)
	
	g_dUserData[id][iTeamID] = 0

	g_dUserData[id][bIsUserAlive] = false
	g_dUserData[id][bIsUserBot] = false
	
	g_dUserData[id][bRoundSounds] = true
	g_dUserData[id][bCanSeeRarities] = true
	g_dUserData[id][bCanReceiveInvites] = true
}

public client_putinserver(id)
{
	g_dUserData[id][bIsUserBot] = bool:is_user_bot(id)
	if(!__is_user_bot(id))
	{
		get_user_name(id, g_dUserData[id][szName], charsmax(g_dUserData[][szName]))
		g_dUserData[id][bAutoMenu] = true
	}
}

public client_disconnected(id)
{
	set_task(0.2, "checkNum")
	
	if(__is_user_alive(id))
	{
		if(g_dUserData[id][iTeamID])
		{
			checkTeammates(id)
		}
		
		if(g_dUserData[id][bKnockedOut] && __is_user_alive(g_dUserData[id][iKnockerID]))
		{
			displayMessage(2, g_dUserData[id][iKnockerID], id, g_dUserData[id][iWeaponKnocker])
		}
		else displayMessage(0, id)
	}

	removeMateSpr(id)
	resetUserData(id)
	removeHelmet(id)
	checkTasks(id)
	checkTeam(id)

	g_dUserData[id][iVoiceMode] = 0
	g_dUserData[id][iTeamID] = 0
	g_dUserData[id][bIsTeamLeader] = false

	g_dUserData[id][b3DCamera] = false
	g_dUserData[id][bIsUserAlive] = false
	g_dUserData[id][bIsUserBot] = false
}

public event_GameWill()
{
	clientStopSound(0)
}

public event_NewRound()
{
	removeTasks()
	removeEntities()
	
	g_bCanJump = false
	g_bPlaneSpawned = false
	g_bHasRoundEnded = false
	
	for(new i;i < sizeof g_iItensNum;i++)
	{
		g_iItensNum[iItensList:i] = 0
	}
	
	g_iFreezeTime = (get_pcvar_num(g_pCvars[cFreezeTime]) + 1)

	g_iChestNum = 0
	g_iSupplyNum = 0
	
	new iPlayers[MAX_PLAYERS], iNum
	get_players(iPlayers, iNum, "ch")
	if(iNum > 0)
	{
		checkAllTeams()
		set_task(1.0, "hudCountDown", TASK_COUNTDOWN, .flags = "a", .repeat = g_iFreezeTime)
	}
}

public playersCount()
{
	new iPlayers[MAX_PLAYERS], iNum
	get_players(iPlayers, iNum)
		
	static Float:fOrigin[3]
	static Float:fMins[3], iHull
	static Float:fVec[3]

	static szFormatTime[18]
	formatTime(szFormatTime, pubnite_get_zone_time())
	
	set_dhudmessage(255, 255, 255, 0.87, 0.0, 0, 0.1, 0.5)

	for(new i, iPlayer, iSpectator, iSpecsNum, szKey[2][25], szKeyDescription[2][25], szSpecsMessage[55];i < iNum;i++)
	{
		iPlayer = iPlayers[i]

		if(is_user_connected(iPlayer) && __is_user_alive(iPlayer) && !__is_user_bot(iPlayer))
		{
			if(g_dUserData[iPlayer][iTeamID])
			{
				if(!isTeam(iPlayer))
				{
					checkTeam(iPlayer, true)
					continue
				}
				else if(getPlayersNumInATeam(g_dUserData[iPlayer][iTeamID], true) > 1)
				{
					showMates(iPlayer)
				}
			}

			pev(iPlayer, pev_origin, fOrigin)
			iHull = pev(iPlayer, pev_flags) & FL_DUCKING ? HULL_HEAD : HULL_HUMAN
			if(!isValidOrigin(fOrigin, iHull, 0, iPlayer) && !get_user_noclip(iPlayer) && !(pev(iPlayer, pev_solid) & SOLID_NOT)) 
			{
				if(!(pev(iPlayer, pev_waterlevel)))
				{
					pev(iPlayer, pev_mins, fMins)
					fVec[2] = fOrigin[2]
					for(new o; o < sizeof g_fSize; ++o) 
					{
						fVec[0] = fOrigin[0] - fMins[0] * g_fSize[o][0]
						fVec[1] = fOrigin[1] - fMins[1] * g_fSize[o][1]
						fVec[2] = fOrigin[2] - fMins[2] * g_fSize[o][2]
						if(isValidOrigin(fVec, iHull, 0, iPlayer)) 
						{
							engfunc(EngFunc_SetOrigin, iPlayer, fVec)
							set_pev(iPlayer, pev_velocity, {0.0,0.0,0.0})
							o = sizeof g_fSize
						}
					}
				}
			}
			
			if(get_pcvar_num(g_pCvars[cShowSpectatingMessage]))
			{
				if((iSpectator = getSpecsNum(iPlayer, true)))
				{
					if(g_dUserData[iSpectator][iSpectatingID] != iPlayer)
					{
						g_dUserData[iSpectator][iSpectatingID] = iPlayer
						CC_SendMatched(iPlayer, CC_COLOR_TEAM, "%L", iPlayer, "SERVER_PLAYER_IS_SPECTATING_YOU", g_dUserData[iSpectator][szName])
					}
				}
			}
			
			if((iSpecsNum = getSpecsNum(iPlayer)))
			{
				formatex(szSpecsMessage, charsmax(szSpecsMessage), "%L", iPlayer, "SERVER_WATCHING_YOU", iSpecsNum)
				showStatusTxt(iPlayer, szSpecsMessage)
			}
			else showStatusTxt(iPlayer)

			show_dhudmessage
			(
				iPlayer, 
				"%s^n%d %L%s^n%d %L^n", 
				szFormatTime,
				getPlayersNum(), 
				LANG_PLAYER, "SERVER_ALIVE", 
				(getPlayersNum() > 1) ? "S" : "", 
				g_dUserData[iPlayer][iKills], 
				iPlayer, "SERVER_KILLS", 
				(g_dUserData[iPlayer][iKills] > 1) ? "S" : ""
			)
			
			if(g_bCanJump)
			{
				if(g_dUserData[iPlayer][bIsOnPlane] || g_dUserData[iPlayer][bCanUseParachute])
				{
					if(g_dUserData[iPlayer][bIsOnPlane])
					{
						client_print(iPlayer, print_center, "%L", iPlayer, "SERVER_PLAYERS_IN_THE_PLANE", getPlayersInThePlaneNum())
					}
	
					formatex(szKey[0], charsmax(szKey[]), "%L", iPlayer, "SERVER_SPACE_KEY")
					formatex(szKeyDescription[0], charsmax(szKeyDescription[]), "%L", iPlayer, "SERVER_SPACE_KEY_DESCRIP")
					formatex(szKey[1], charsmax(szKey[]), "%L", iPlayer, "SERVER_USE_KEY")
					formatex(szKeyDescription[1], charsmax(szKeyDescription[]), "%L", iPlayer, "SERVER_USE_KEY_DESCRIP")

					set_dhudmessage(0, 255, 0, 0.73, 0.6, 0, 1.0, 0.5)
					show_dhudmessage(iPlayer, g_dUserData[iPlayer][bIsOnPlane] ? szKey[0] : get_pcvar_num(g_pCvars[cParachuteType]) ? szKey[1] : "")
	
					set_dhudmessage(255, 255, 255, 0.7, 0.63, 0, 1.0, 0.5)
					show_dhudmessage(iPlayer, g_dUserData[iPlayer][bIsOnPlane] ? szKeyDescription[0] : get_pcvar_num(g_pCvars[cParachuteType]) ? szKeyDescription[1] : "")
				}
			}
		}
	}
}

public hudCountDown()
{
	--g_iFreezeTime
	
	new iRGB[3]; iRGB = {0, 255, 0}
	switch(g_iFreezeTime)
	{
		case 4..6:
		{
			iRGB = {255, 255, 0}
		}
		case 3:
		{
			iRGB = {255, 50, 0}
		}
		case 0..2:
		{
			iRGB = {255, 0, 0}
		}
	}
	set_hudmessage(iRGB[0], iRGB[1], iRGB[2], -1.0, 0.34, 0, 0.1, 1.0)
	ShowSyncHudMsg(0, g_hHuds[hFreezeTime], "%L", LANG_PLAYER, "SERVER_ROUNDSTART_HUD_1", g_iFreezeTime, (g_iFreezeTime > 1) ? "s" : "")
	
	if(g_iFreezeTime == 3)
	{
		client_cmd(0, "spk ^"%s^"", g_szSoundsData[sCountDownEffect2])
	}
	else if(g_iFreezeTime > 3)
	{
		client_cmd(0, "spk ^"%s^"", g_szSoundsData[sCountDownEffect1])
	}
	
	if(!g_iFreezeTime)
	{
		ClearSyncHud(0, g_hHuds[hFreezeTime])
		
		if(get_pcvar_num(g_pCvars[cPlayersNumShow]))
		{
			set_task(0.5, "playersCount", TASK_PLAYERSCOUNT, .flags = "b")
		}
		
		new Float:fSpawnWeaponsTime = get_pcvar_float(g_pCvars[cSpawnWeaponsTime])
		set_hudmessage(0, 255, 0, -1.0, 0.34, 0, 1.0, fSpawnWeaponsTime)
		ShowSyncHudMsg(0, g_hHuds[hFreezeTimeEnd], "%L", LANG_PLAYER, "SERVER_ROUNDSTART_HUD_2")
		
		set_task(fSpawnWeaponsTime, "prepareWeaponsSpawn", TASK_WEAPONS)
		checkAllTeams()
	}
}

public prepareWeaponsSpawn()
{
	new iPlayers[MAX_PLAYERS], iNum
	get_players(iPlayers, iNum, "ch")
	
	if(!g_iVecsNum[vecWeapons] || !g_iVecsNum[vecPlane])
	{
		for(new i, iPlayer;i < iNum;i++)
		{	
			iPlayer = iPlayers[i] 
		
			CC_SendMatched(iPlayer, CC_COLOR_GREY, "&x04=====================================")
			CC_SendMatched(iPlayer, CC_COLOR_TEAM, "&x03 ERROR: NO %s POINTS", !g_iVecsNum[vecWeapons] ? "WEAPONS" : "TRANSPORTER")
			CC_SendMatched(iPlayer, CC_COLOR_GREY, "&x04=====================================")
		}
	}

	if(g_iVecsNum[vecPlane])
	{
		ExecuteForward(g_forwardRoundStarted, g_iReturn, iNum, getPlayersWithoutTeam(true), getTeamsLeft())
		createPlane()
	}

	if(g_iVecsNum[vecWeapons])
	{
		set_task(float(get_pcvar_num(g_pCvars[cAirDropTime])), "respawnAirDrop", TASK_SPAWN_AIRDROP, .flags = "b")

		g_iSpawnedWeapNum = 0
		g_iRandomSpawnsNum = g_iVecsNum[vecWeapons]

		SortCustom2D(_:g_fSpawnVecs, g_iVecsNum[vecWeapons], "fnSortPseudoRandom2D")

		if(g_iVecsNum[vecChests] > 1)
		{
			g_iChestNumRound = clamp(((getPlayersNum() / 4) + 1), 1, min(g_iVecsNum[vecChests], MAX_CHESTS))
			SortCustom2D(_:g_fChestPoints, g_iVecsNum[vecChests], "fnSortPseudoRandom2D")
		}
		set_task(0.1, "spawnWeapons", TASK_ADD_WEAPONS, .flags = "a", .repeat = clamp((MIN_SPAWNS_PER_ROUND + floatround(g_iVecsNum[vecWeapons] * 0.3) - (g_iChestNumRound * 4) - (MAX_PLAYERS - iNum)), MIN_SPAWNS_PER_ROUND, g_iVecsNum[vecWeapons])) 
	}
}

public respawnAirDrop()
{
	if(!g_bHasRoundEnded && pubnite_get_redzone_level() <= 2 && g_iSupplyNum < min(get_pcvar_num(g_pCvars[cMaxSupplyBox]), MAX_AIRDROP_ITEMS))
	{
		dropBox()
	}
	else
	{
		remove_task(TASK_SPAWN_AIRDROP)
	}
}

public cmdJoinTeam(id) 
{
	if(!g_bHasRoundEnded && getPlayersNum() < 2)
	{
		g_bHasRoundEnded = true
		set_task(1.0, "restartRound", 1)
	}
}

public client_PreThink(id)
{
	if(!__is_user_alive(id) || __is_user_bot(id))
	{
		return
	}

	if(isUserMoving(id))
	{
		if(task_exists(id + TASK_MEDKIT) || task_exists(id + TASK_CHUG_JUG_HEAL))
		{
			stopUsageFeature(id, 0)
			stopUsageFeature(id, 1)
		}
	
		if(g_dUserData[id][iChestID])
		{
			stopUsageFeature(id, 2)
		}
	
		if(g_dUserData[id][iUserSupplyID])
		{
			stopUsageFeature(id, 3)
		}

		if(task_exists(id + TASK_KNOCK))
		{
			if(g_dUserData[id][iHelpingID])
			{
				cleanData(id, g_dUserData[id][iHelpingID])
			}
		}
	}

	new bool:bIsOnLadder = bool:(entity_get_int(id, EV_INT_movetype) == MOVETYPE_FLY)
	new bool:bIsOnGround = bool:(entity_get_int(id, EV_INT_flags) & FL_ONGROUND)
	if((bIsOnGround || bIsOnGround) && g_dUserData[id][iImpulserID])
	{
		g_dUserData[id][iImpulserID] = 0
		killTrailBeam(id)
	}
	
	if(g_dUserData[id][bCanUseParachute] && (bIsOnLadder || (bIsOnGround && distanceToGround(id) < 120.0)))
	{
		if(g_iParachuteEnt[id] > 0)
		{
			killEntity(g_iParachuteEnt[id])
			g_iParachuteEnt[id] = 0
			
			set_user_gravity(id, 1.0)
		}
			
		g_dUserData[id][bCanUseParachute] = false
		g_dUserData[id][bParachuteOpened] = false
		g_dUserData[id][bUsedGuspe] = false
		
		if(!user_has_weapon(id, CSW_KNIFE))
		{
			ExecuteForward(g_forwardPlayerLand, g_iReturn, id)
			give_item(id, "weapon_knife")
		}
		clientStopSound(id, true, g_szSoundsData[sSkyDiveSound], .iChannel = CHAN_WEAPON)
		clientPlaySound(id, g_szSoundsData[sParachuteLand], true, .iChannel = CHAN_WEAPON)

		killTrailBeam(id)
	}
	
	if(!(get_user_oldbutton(id) & IN_USE))
	{
		if(g_dUserData[id][iChestID])
		{
			stopUsageFeature(id, 2)
		}
		
		if(g_dUserData[id][iUserSupplyID])
		{
			stopUsageFeature(id, 3)
		}

		if(g_dUserData[id][iHelpingID])
		{
			cleanData(id, g_dUserData[id][iHelpingID])
		}
	}
	
	if(!g_dUserData[id][bCanUseParachute])
		return

	manageParachuteFeature(id)
	
	if(g_dUserData[id][bParachuteOpened])
	{
		static Float:fVecVelocity[3]
		entity_get_vector(id, EV_VEC_velocity, fVecVelocity)
		if(fVecVelocity[2] < 0.0) 
		{
			if(g_iParachuteEnt[id] <= 0) 
			{
				g_iParachuteEnt[id] = create_entity("info_target")
				if(g_iParachuteEnt[id] > 0) 
				{
					clientPlaySound(id, g_szSoundsData[sParachuteOpen], true)

					entity_set_string(g_iParachuteEnt[id], EV_SZ_classname, g_szClassNamesData[cParachute])
					entity_set_edict(g_iParachuteEnt[id], EV_ENT_aiment, id)
					entity_set_edict(g_iParachuteEnt[id], EV_ENT_owner, id)
					entity_set_int(g_iParachuteEnt[id], EV_INT_movetype, MOVETYPE_FOLLOW)
					entity_set_model(g_iParachuteEnt[id], g_szModelsData[mUserParachute])
					entity_set_int(g_iParachuteEnt[id], EV_INT_sequence, 0)
					entity_set_int(g_iParachuteEnt[id], EV_INT_gaitsequence, 1)
					entity_set_float(g_iParachuteEnt[id], EV_FL_frame, 0.0)
					entity_set_float(g_iParachuteEnt[id], EV_FL_fuser1, 0.0)
				}
			}

			if(g_iParachuteEnt[id] > 0) 
			{
				static Float:fFallSpeed;fFallSpeed = get_pcvar_float(g_pCvars[cParachuteFallSpeed])
				static Float:fFrame
	
				set_user_gravity(id, 0.1)
				fVecVelocity[2] = (fVecVelocity[2] + 150.0) < fFallSpeed ? (fVecVelocity[2] + 150.0) : fFallSpeed
				entity_set_vector(id, EV_VEC_velocity, fVecVelocity)

				if(entity_get_int(g_iParachuteEnt[id], EV_INT_sequence) == 0) 
				{
					fFrame = entity_get_float(g_iParachuteEnt[id], EV_FL_fuser1) + 1.0
					entity_set_float(g_iParachuteEnt[id], EV_FL_fuser1, fFrame)
					entity_set_float(g_iParachuteEnt[id], EV_FL_frame, fFrame)

					if(fFrame > 100.0) 
					{
						entity_set_float(g_iParachuteEnt[id], EV_FL_animtime, 0.0)
						entity_set_float(g_iParachuteEnt[id], EV_FL_framerate, 0.4)
						entity_set_int(g_iParachuteEnt[id], EV_INT_sequence, 1)
						entity_set_int(g_iParachuteEnt[id], EV_INT_gaitsequence, 1)
						entity_set_float(g_iParachuteEnt[id], EV_FL_frame, 0.0)
						entity_set_float(g_iParachuteEnt[id], EV_FL_fuser1, 0.0)
					}
				}
			}
		}
	}
	else
	{
		if(g_iParachuteEnt[id] > 0)
		{
			clientPlaySound(id, g_szSoundsData[sParachuteLand], true)
			set_user_gravity(id, 1.0)
			
			killEntity(g_iParachuteEnt[id])
			g_iParachuteEnt[id] = 0
		}
	}
}

manageParachuteFeature(id, bool:bOpen = false)
{
	new bool:bUsedParachute = bool:((get_user_button(id) & IN_USE) && !(get_user_oldbutton(id) & IN_USE))
	switch(get_pcvar_num(g_pCvars[cParachuteType]))
	{
		case 1:
		{
			if(!bOpen)
			{
				if(bUsedParachute)
				{
					parachuteFreeMode(id)
				}
			}
			else 
			{
				parachuteFreeMode(id)
			}
		}
		default:
		{
			static Float:fVelocity[3]
			pev(id, pev_velocity, fVelocity)
			if(!g_dUserData[id][bUsedGuspe])
			{
				if(canOpenSafeParachute(distanceToGround(id), fVelocity, g_fDefaultSafeTime))
				{
					g_dUserData[id][bParachuteOpened] = true
				}
			}
			else
			{
				if(canOpenSafeParachute(distanceToGround(id), fVelocity, g_fGuspeSafeTime))
				{
					g_dUserData[id][bParachuteOpened] = true
				}
				else
				{
					if(bUsedParachute)
					{
						parachuteFreeMode(id)
					}
				}
			}
		}
	}
}

public ham_WallTakeDamage(iVictimID, iInflictor, iAttacker, Float:fDamage)
{
	if(!pev_valid(iVictimID) || !is_user_connected(iAttacker))
		return FMRES_IGNORED
	
	if(floatround(fDamage) >= pev(iVictimID, pev_health))
	{
		clientStopSound(iVictimID, true, g_szSoundsData[sWallCreateSound], .iChannel = CHAN_BODY)
		clientPlaySound(iVictimID, g_szSoundsData[sWallDestroyedSound], true, .iChannel = CHAN_BODY)
	}
	else
	{
		static Float:fGameTime;fGameTime = get_gametime()
		if((fGameTime - pev(iVictimID, pev_fuser1)) >= 0.7)
		{
			clientPlaySound(iVictimID, g_szSoundsData[sWallHitSound], true, .iChannel = CHAN_BODY)
			set_pev(iVictimID, pev_fuser1, fGameTime)
		}
	}
	return HAM_IGNORED
}

public removePlayerWall(iEnt)
{
	iEnt -= TASK_WALL_REMOVE
	
	if(!pev_valid(iEnt))
	{
		return
	}

	new iHPToTake = get_pcvar_num(g_pCvars[cWallHealthToTake])
	if(!iHPToTake)
	{
		return
	}

	static iLifeLevels[3], iInitialHealth;iInitialHealth = pev(iEnt, pev_health)
	new iWallHealth = iInitialHealth
	new iCalculator = (iWallHealth / 4)
	
	if(!iLifeLevels[0])
	{
		iLifeLevels[0] = (iWallHealth - iCalculator)
		iLifeLevels[1] = (iLifeLevels[0] - iCalculator)
		iLifeLevels[2] = (iLifeLevels[1] - iCalculator)

		//iLifeLevels[1] = (iWallHealth - iCalculator) - iCalculator
		//iLifeLevels[2] = ((iWallHealth - iCalculator) - iCalculator) - iCalculator
	}
	
	iWallHealth = clamp((iWallHealth - iHPToTake), 0, iInitialHealth)
	set_pev(iEnt, pev_health, float(iWallHealth))
		
	if(iWallHealth > 0)
	{
		if(get_pcvar_num(g_pCvars[cGlowWallItem]))
		{
			new Float:fRGB[3]
			if(iWallHealth >= iLifeLevels[0])
			{
				fRGB = Float:{0.0, 255.0, 0.0}
			}
			else if(iLifeLevels[1] <= iWallHealth <= iLifeLevels[0])
			{
				fRGB = Float:{255.0, 255.0, 0.0}
			}
			else if(iLifeLevels[2] <= iWallHealth <= iLifeLevels[1])
			{
				fRGB = Float:{220.0, 80.0, 0.0}
			}
			else if(0 <= iWallHealth <= iLifeLevels[2])
			{
				fRGB = Float:{255.0, 0.0, 0.0}
			}
			setRendering(iEnt, kRenderFxGlowShell, fRGB, 25.0)
		}
	}
	else
	{	
		clientStopSound(iEnt, true, g_szSoundsData[sWallCreateSound], .iChannel = CHAN_BODY)
		clientPlaySound(iEnt, g_szSoundsData[sWallDestroyedSound], true)
			
		killEntity(iEnt)
		iWallHealth = 0
		return
	}
	set_task(1.0, "removePlayerWall", iEnt + TASK_WALL_REMOVE)
}

public ham_Player_Jump_Pre(id)
{
	if(g_dUserData[id][bIsOnPlane] && g_bCanJump)
	{
		dropPlayer(id)
		return HAM_HANDLED
	}
	
	if(g_dUserData[id][bKnockedOut])
	{
		static iOldbuttons; iOldbuttons = entity_get_int(id, EV_INT_oldbuttons)
		if(!(iOldbuttons & IN_JUMP))
		{
			entity_set_int(id, EV_INT_oldbuttons, (iOldbuttons | IN_JUMP))
			return HAM_HANDLED
		}
		return HAM_SUPERCEDE
	}
	return HAM_HANDLED
}

public setCompleteHeal(id)
{
	id -= TASK_CHUG_JUG_HEAL
	
	g_dUserData[id][iArmorLevel] = 3
	g_dUserData[id][bHasChugJug] = false
	
	ScreenFade(id, {255, 255, 0}, 65)
	cs_set_user_armor(id, MAX_HEALTH, CS_ARMOR_KEVLAR)
	set_user_health(id, MAX_HEALTH)
}

public ham_BloodColor(id)
{
	SetHamReturnInteger(get_pcvar_num(g_pCvars[cBloodColor]))
	return HAM_SUPERCEDE
}

public ham_TraceAttack(victim, attacker, Float:damage, Float:direction[3], tracehandle, damage_type)
{
	if((victim == attacker) || !is_user_connected(victim) || !is_user_connected(attacker)) 
		return HAM_IGNORED

	if(get_tr2(tracehandle, TR_iHitgroup) == HIT_HEAD)
	{
		set_tr2(tracehandle, TR_vecEndPos, {8192.0, 8192.0, 8192.0})

		new origin[3], iPcvarBloodColor = get_pcvar_num(g_pCvars[cBloodColor])
		get_user_origin(victim, origin, 1)

		message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
		write_byte(TE_BLOODSTREAM)
		write_coord(origin[0])
		write_coord(origin[1])
		write_coord(origin[2])
		write_coord(random_num(-1, 1))
		write_coord(random_num(-1, 1))
		write_coord(random_num(-1, 0))
		write_byte(iPcvarBloodColor)
		write_byte(random_num(70, 80))
		message_end()
		
		message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
		write_byte(TE_BLOODSPRITE)
		write_coord(origin[0])
		write_coord(origin[1])
		write_coord(origin[2])
		write_short(g_iBloodSprite)
		write_short(g_iBloodSprite)
		write_byte(iPcvarBloodColor)
		write_byte(15)
		message_end()
	}

	return HAM_IGNORED;
}

public Forward_ClientKill(id)
{
	if(!__is_user_alive(id) || !get_pcvar_num(g_pCvars[cBlockKillCommand]))
		return FMRES_IGNORED

        lockedSound(id)
        return FMRES_SUPERCEDE
} 

public forward_SetClientListening(iReceiver, iSender, bool:bListen)
{
	if(!__is_user_alive(iSender) && __is_user_alive(iReceiver))
	{
		if(!get_pcvar_num(g_pCvars[cAllowVoice]))
		{
			engfunc(EngFunc_SetClientListening, iReceiver, iSender, false)
			forward_return(FMV_CELL, false)
			return FMRES_SUPERCEDE
		}

		if(isTeammate(iSender, iReceiver))
		{
			engfunc(EngFunc_SetClientListening, iReceiver, iSender, true)
			forward_return(FMV_CELL, true)
			return FMRES_SUPERCEDE
		}
		engfunc(EngFunc_SetClientListening, iReceiver, iSender, false)
		forward_return(FMV_CELL, false)
		return FMRES_SUPERCEDE
	}
	else if((g_dUserData[iSender][iVoiceMode] == 1) || (g_dUserData[iReceiver][iVoiceMode] == 1))
	{
		if(!isTeammate(iSender, iReceiver))
		{
			engfunc(EngFunc_SetClientListening, iReceiver, iSender, false)
			forward_return(FMV_CELL, false)
			return FMRES_SUPERCEDE
		}
		engfunc(EngFunc_SetClientListening, iReceiver, iSender, true)
		forward_return(FMV_CELL, true)
		return FMRES_SUPERCEDE
	}		
	else if((g_dUserData[iReceiver][iVoiceMode] > 1) || (g_dUserData[iSender][iVoiceMode] > 1))
	{
		engfunc(EngFunc_SetClientListening, iReceiver, iSender, false)
		forward_return(FMV_CELL, false)
		return FMRES_SUPERCEDE
	}
	engfunc(EngFunc_SetClientListening, iReceiver, iSender, true)
	forward_return(FMV_CELL, true)
	return FMRES_SUPERCEDE
}

public forward_cmdStart(id, uc_handle)
{
	if(!__is_user_alive(id) || __is_user_bot(id))
		return FMRES_IGNORED
		
	static Float:fGameTime;fGameTime = get_gametime()
	
	static iButton;iButton = get_uc(uc_handle, UC_Buttons)
	if((iButton & IN_RELOAD) && canUseChugJug(id))
	{
		cmdUseHealItem(id, 1)
		return FMRES_IGNORED
	}
	
	static bool:bButtonInUse;bButtonInUse = bool:(iButton & IN_USE)
	static bool:bIsInAttack;bIsInAttack = bool:((iButton & IN_ATTACK) || (iButton & IN_ATTACK2))
	
	if(g_dUserData[id][bKnockedOut])
	{
		if(bButtonInUse)
		{
			set_uc(uc_handle, UC_Buttons, (iButton & ~IN_USE) & ~IN_USE)
		}
		
		if(bIsInAttack)
		{
			set_uc(uc_handle, UC_Buttons, (iButton & ~IN_ATTACK) & ~IN_ATTACK2)
		}

		if(get_user_weapon(id) != CSW_KNIFE)
		{
			client_cmd(id, "weapon_knife")
		}
		
		if(pev(id, pev_maxspeed) > KNOCK_SPEED)
		{
			set_pev(id, pev_maxspeed, KNOCK_SPEED)
		}
		return FMRES_IGNORED
	}

	if((fGameTime - g_dUserData[id][fUserGameTime]) >= 0.5)
	{
		if((iButton & IN_ATTACK) 
		&& (iButton & IN_ATTACK2) 
		&& (get_user_weapon(id) == CSW_KNIFE)
		&& g_dUserData[id][bHasWall])
		{
			g_dUserData[id][fUserGameTime] = _:fGameTime
			createWallEntity(id)
			return FMRES_IGNORED
		}
	}

	if(bButtonInUse && !g_bPlaneSpawned)
	{
		if((fGameTime - g_dUserData[id][fUserGameTime]) >= (MESSAGE_DELAY * 2))
		{
			g_dUserData[id][fUserGameTime] = _:fGameTime
			CC_SendMatched(id, CC_COLOR_RED, "%L", id, "SERVER_USE_COMMAND_LOCKED")
			lockedSound(id)
		}
		set_uc(uc_handle, UC_Buttons, (iButton & ~IN_USE) & ~IN_USE)
		return FMRES_IGNORED
	}
	
	static iTarget, iBody
	get_user_aiming(id, iTarget, iBody, DISTANCE_CHECK)
	if(!is_user_connected(iTarget))
	{
		static szClassName[MAX_PLAYERS]
		pev(iTarget, pev_classname, szClassName, charsmax(szClassName))

		static bIsOldButtonNotInUse;bIsOldButtonNotInUse = bool:!(get_user_oldbutton(id) & IN_USE)
		if(g_dUserData[id][iHelpingID])
		{
			cleanData(id, g_dUserData[id][iHelpingID])
		}
		
		if(equal(szClassName, g_szClassNamesData[cChest]))
		{
			pressEButtonInfo(id)
			if(bButtonInUse && !isUserMoving(id))
			{
				if(!task_exists(iTarget + TASK_SPIT_ITEMS))
				{
					new iChestOpeningSound = get_pcvar_num(g_pCvars[cChestOpeningDelay])
					g_dUserData[id][iChestID] = iTarget

					stopUsageFeature(id, 0)
					stopUsageFeature(id, 1)

					clientPlaySound(iTarget, g_szSoundsData[sOpeningSound], true, .iChannel = CHAN_BODY)
					barTime(id, .iTime = iChestOpeningSound)
					set_task(float(iChestOpeningSound), "spitItems", iTarget + TASK_SPIT_ITEMS)
				}
				return FMRES_IGNORED
			}
		}
		else if(equal(szClassName, g_szClassNamesData[cAirDrop]))
		{
			pressEButtonInfo(id)
			if(bButtonInUse && !isUserMoving(id))
			{
				if(!task_exists(iTarget + TASK_AD_SPIT_ITEMS))
				{
					new iADOpeningSound = get_pcvar_num(g_pCvars[cAirDropOpeningDelay])
					g_dUserData[id][iUserSupplyID] = iTarget
					
					stopUsageFeature(id, 0)
					stopUsageFeature(id, 1)

					clientPlaySound(id, g_szSoundsData[sSupplyOpeningSound], true, .iChannel = CHAN_BODY)
					barTime(id, .iTime = iADOpeningSound)
					set_task(float(iADOpeningSound), "airDropSpitItems", iTarget + TASK_AD_SPIT_ITEMS)
				}
				return FMRES_IGNORED
			}
		}
		else
		{
			if(g_dUserData[id][iChestID])
			{
				stopUsageFeature(id, 2)
			}
				
			if(g_dUserData[id][iUserSupplyID])
			{
				stopUsageFeature(id, 3)
			}
			
			if((bButtonInUse && bIsOldButtonNotInUse) && onUsePress(id))
				return FMRES_IGNORED
		}

		if(canUseMedKit(id) && (bButtonInUse && bIsOldButtonNotInUse))
		{
			cmdUseHealItem(id, 0)
		}
	}
	else
	{
		if(bButtonInUse && !isUserMoving(id) && !g_dUserData[id][bKnockedOut] && (get_user_weapon(id) == CSW_KNIFE))
		{
			if(!g_dUserData[iTarget][bKnockedOut] || g_dUserData[iTarget][iHelperID])
				return FMRES_IGNORED
		
			g_dUserData[id][iHelpingID] = iTarget
			g_dUserData[iTarget][iHelperID] = id
			
			if(!task_exists(id + TASK_KNOCK))
			{		
				new Float:fHelpTime = get_pcvar_float(g_pCvars[cHelpTime])
				set_task(fHelpTime, "unknockMate", id + TASK_KNOCK)
				barTime(id, iTarget, floatround(fHelpTime))

				clientPlaySound(id, g_szSoundsData[sUnknockingMate], true)
			}
		}
	}
	return FMRES_IGNORED
}

public spitItems(iEnt)
{
	if(!pev_valid((iEnt -= TASK_SPIT_ITEMS)))
		return

	new Float:fOrigin[3]
	pev(iEnt, pev_origin, fOrigin)
	fOrigin[2] += 20.0

	if(random_num(1, 10) <= M249_CHANCE)
	{
		createWeapon(CSW_M249, "models/w_m249.mdl", fOrigin)
	}
	else
	{
		new iRandom = random_mod(g_iWeaponsNum), szModel[MAX_MODEL_LENGTH]		
		copy(szModel, charsmax(szModel), g_szWeaponsModels[iRandom][szModelName])
		createWeapon(g_szWeaponsModels[iRandom][iWeaponInfoID], szModel, fOrigin, .iRandomRarity = (random_mod(RARITY_BLUE) + 2))
	}
	spawnRandomItem(fOrigin)

	clientPlaySound(iEnt, g_szSoundsData[sChestOpened], true)
	clientStopSound(iEnt, true, g_szSoundsData[sChestOpened])

	createBlast(fOrigin, 200.0, {255, 255, 0})
	killEntity(iEnt)
}

public airDropSpitItems(iEnt)
{
	if(!pev_valid((iEnt -= TASK_AD_SPIT_ITEMS)))
		return

	new Float:fOrigin[3], iSupplyID = pev(iEnt, pev_iuser1)
	pev(iEnt, pev_origin, fOrigin)
	fOrigin[2] += 20.0

	if(g_iAirDropItems[0][iSupplyID])
	{
		createWeapon(CSW_AWP, "models/w_awp.mdl", fOrigin)
	}
	
	if(g_iAirDropItems[1][iSupplyID])
	{
		spawnItens(fOrigin, g_szItens[iMedKit][iItemID])
	}
	
	if(g_iAirDropItems[2][iSupplyID])
	{
		spawnItens(fOrigin, g_szItens[iKevlarLv3][iItemID], 3, .iPev3 = MAX_HEALTH)
	}

	if(g_iAirDropItems[3][iSupplyID])
	{
		spawnItens(fOrigin, g_szItens[iBagLv3][iItemID], 3)
	}
	
	if(g_iAirDropItems[4][iSupplyID])
	{
		spawnItens(fOrigin, g_szItens[iChugJug][iItemID])
	}

	if(g_iAirDropItems[5][iSupplyID])
	{
		spawnItens(fOrigin, g_szItens[iHelmetLv3][iItemID], 3, .iPev3 = get_pcvar_num(g_pCvars[cLevel3HelmetHits]))
	}
	
	if(g_iAirDropItems[6][iSupplyID])
	{
		spawnItens(fOrigin, g_szItens[iGuspe][iItemID])
	}
	
	if(g_iAirDropItems[7][iSupplyID])
	{
		new iItemInfoID
		pubnite_get_customitem(random(pubnite_get_customitem_num()), iItemInfoID, "")
		spawnItens(fOrigin, iItemInfoID, .iPev3 = pubnite_get_customitem_life(iItemInfoID))
	}
	
	clientPlaySound(iEnt, g_szSoundsData[sSupplyOpenedSound], true)
	createBlast(fOrigin, 200.0, {255, 255, 255})
	killEntity(iEnt)
}

public startRegen(id)
{
	id -= TASK_MEDKIT

	ScreenFade(id, {20, 255, 20}, 105)
	set_user_health(id, clamp((get_user_health(id) + get_pcvar_num(g_pCvars[cMedkitHealth])), 0, MAX_HEALTH))
	
	g_dUserData[id][iMedKits]--
}

public unknockMate(id)
{
	id -= TASK_KNOCK

	ExecuteForward(g_forwardUnKnockedOut, g_iReturn, id, g_dUserData[id][iHelpingID])

	clientPlaySound(g_dUserData[id][iHelpingID], g_szSoundsData[sMateUnknocked], true)
	cleanData(id, g_dUserData[id][iHelpingID], true)
}

public forward_setModeDescription() 
{ 
	forward_return(FMV_STRING, g_szGameName)
	return FMRES_SUPERCEDE
}

public ClientCommand_Radio(id) 
{ 
	return PLUGIN_HANDLED 
} 

public cmdItemIdList(id, iLevel, iCid)
{
	if(!cmd_access(id, iLevel, iCid, 1))
		return PLUGIN_HANDLED
		
	for(new i;i < sizeof g_szItens;i++)
	{
		if(!g_szItens[iItensList:i][bIsItemEnabled])
			continue
				
		new szCmdItemName[25]
		getItemNameByID(id, i, szCmdItemName)
		console_print(id, "%d. ID - %d [%s]", (i + 1), g_szItens[iItensList:i][iItemID], szCmdItemName)
	}
	
	console_print(id, "------------- Custom Items -------------")
	for(new i, iCustomItemID, szCustomItemName[MAX_PLAYERS];i < pubnite_get_customitem_num();i++)
	{
		pubnite_get_customitem(i, iCustomItemID, szCustomItemName)
		console_print(id, "%d. ID - %d [%s]", (i + 1), iCustomItemID, szCustomItemName)
	}
	return PLUGIN_HANDLED
}

public cmdGiveItem(id, iLevel, iCid)
{
	if(!cmd_access(id, iLevel, iCid, 3))
		return PLUGIN_HANDLED

	new szTarget[MAX_PLAYERS], szItemID[10], szItemLevel[3], szItemLife[4]
	read_argv(1, szTarget, charsmax(szTarget))
	read_argv(2, szItemID, charsmax(szItemID))
	read_argv(3, szItemLevel, charsmax(szItemLevel))
	read_argv(4, szItemLife, charsmax(szItemLife))

	new iCmdItemID = str_to_num(szItemID)
	new iCmdItemLevel = str_to_num(szItemLevel)
	if(!iCmdItemLevel || (iCmdItemLevel > 3))
	{
		iCmdItemLevel = getItemLevelByID(iCmdItemID)
	}
	new iCmdItemLife = str_to_num(szItemLife)
	if(!iCmdItemLife || (iCmdItemLife > MAX_HEALTH))
	{
		iCmdItemLife = pubnite_is_customitem(iCmdItemID) ? pubnite_get_customitem_life(iCmdItemID) : getItemLife(iCmdItemID, iCmdItemLevel)
	}
	
	new szCmdItemName[25]
	getItemNameByID(id, iCmdItemID, szCmdItemName)
	
	if(!szCmdItemName[0])
	{
		if(pubnite_is_customitem(iCmdItemID))
		{
			for(new i, iCustomItemID, szCustomItemName[MAX_PLAYERS];i < pubnite_get_customitem_num();i++)
			{
				pubnite_get_customitem(i, iCustomItemID, szCustomItemName)
				if(iCustomItemID == iCmdItemID)
				{
					copy(szCmdItemName, charsmax(szCmdItemName), szCustomItemName)
				}
			}
		}
		else
		{
			console_print(id, "%L", id, "SERVER_CMD_INVALID_ITEM")
			return PLUGIN_HANDLED
		}
	}

	new iPlayers[MAX_PLAYERS], iNum
	get_players(iPlayers, iNum, "ch")

	if(szTarget[0] == '@')
	{
		for(new i, iPlayer;i < iNum;i++)
		{
			iPlayer = iPlayers[i]
				
			if(giveWeapons(iPlayer, 0, 0, iCmdItemID, iCmdItemLife, iCmdItemLevel))
			{
				getItemNameByID(iPlayer, iCmdItemID, szCmdItemName)
				CC_SendMatched(iPlayer, CC_COLOR_RED, "%L", iPlayer, "SERVER_ADMIN_GIVE_AN_ITEM_1", g_dUserData[id][szName], szCmdItemName, "SERVER")
			}
		}
	}
	else
	{
		new iTarget = cmd_target(id, szTarget, CMDTARGET_NO_BOTS)
		if(!iTarget)
			return PLUGIN_HANDLED

		if(giveWeapons(iTarget, 0, 0, iCmdItemID, iCmdItemLife, iCmdItemLevel))
		{
			for(new i, iPlayer;i < iNum;i++)
			{
				iPlayer = iPlayers[i]
		
				getItemNameByID(iPlayer, iCmdItemID, szCmdItemName)
				CC_SendMatched(iPlayer, CC_COLOR_RED, "%L", iPlayer, "SERVER_ADMIN_GIVE_AN_ITEM_1", g_dUserData[id][szName], szCmdItemName, g_dUserData[iTarget][szName])
			}
	
			getItemNameByID(iTarget, iCmdItemID, szCmdItemName)
			CC_SendMatched(iTarget, CC_COLOR_RED, "%L", iTarget, "SERVER_ADMIN_GIVE_AN_ITEM_2", g_dUserData[id][szName], szCmdItemName)
		}
	}
	return PLUGIN_HANDLED
}

public cmdWeaponsOriginsMenu(id, iLevel, iCid)
{
	if(!cmd_access(id, iLevel, iCid, 1))
		return PLUGIN_HANDLED

	showMenu(id, 0)
	return PLUGIN_HANDLED
}

public cmdPlaneOriginsMenu(id, iLevel, iCid)
{
	if(!cmd_access(id, iLevel, iCid, 1))
		return PLUGIN_HANDLED

	showMenu(id, 1)
	return PLUGIN_HANDLED
}

public cmdChestOriginsMenu(id, iLevel, iCid)
{
	if(!cmd_access(id, iLevel, iCid, 1))
		return PLUGIN_HANDLED

	showMenu(id, 2)
	return PLUGIN_HANDLED
}

showMenu(id, iType)
{
	new szTittle[60], szItemFormat[60], szType[2]
	formatex(szTittle, charsmax(szTittle), "%L", id, "SERVER_POINTS_MENU")
	new iMenu = menu_create(szTittle, "weapons_point_handler")
	
	num_to_str(iType, szType, charsmax(szType))
	formatex(szItemFormat, charsmax(szItemFormat), "%L", id, "SERVER_ADD_POINT")
	menu_additem(iMenu, szItemFormat, szType)
	
	menu_display(id, iMenu)
}

public weapons_point_handler(id, iMenu, iItem)
{
	if(iItem == MENU_EXIT)
	{
		menu_destroy(iMenu)
		return
	}
	new szData[6], iAccess, item_callback
	menu_item_getinfo(iMenu, iItem, iAccess, szData, charsmax(szData), .callback = item_callback)
	
	new Float:fOrigin[3]
	pev(id, pev_origin, fOrigin)
	
	new szText[80], iData = str_to_num(szData)
	switch(iData)
	{
		case 0, 2:
		{
			formatex(szText, charsmax(szText), "%.0f %.0f %.0f", fOrigin[0], fOrigin[1], fOrigin[2])
			
			new iFile = (iData == 2) ? 4 : (iData + 1)
			if(!file_exists(g_szIniFile[iFile]))
			{
				mkdir(g_szIniFile[iFile][1])
				write_file(g_szIniFile[iFile], "; Auto Generate^n")
			}
			
			write_file(g_szIniFile[iFile], szText)
	
			client_print(id, print_center, "%L", id, "SERVER_POINT_ADDED")
			menu_display(id, iMenu)
		}
		case 1:
		{
			new Float:fAngles[3], Float:fVelocity[3]
			set_pev(id, pev_fixangle, 1)
			pev(id, pev_angles, fAngles)
			velocity_by_aim(id, 300, fVelocity)
			
			new Float:fEndPosition[3]
			getAimEndPosition(id, fEndPosition)
			formatex(szText, charsmax(szText), "%.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f", fOrigin[0], fOrigin[1], fOrigin[2], fAngles[0], fAngles[1], fAngles[2], fVelocity[0], fVelocity[1], fVelocity[2], (get_distance_f(fOrigin, fEndPosition) / xs_vec_len(fVelocity)))
			
			if(!file_exists(g_szIniFile[2]))
			{
				mkdir(g_szIniFile[2][1])
				write_file(g_szIniFile[2], "; Auto Generate^n")
			}
			write_file(g_szIniFile[2], szText)
			
			client_print(id, print_center, "%L", id, "SERVER_POINT_ADDED")
			showMenu(id, 1)
		}
	}
}

public forward_AddToFullPack(es_handle, e, iEnt, iHost, hostflags, player, pSet)
{
	if((iEnt != iHost) && pev_valid(iEnt) && is_user_connected(iHost) && g_dUserData[iHost][bCanSeeRarities])
	{
		static szClassName[MAX_PLAYERS], iRarity;iRarity = pev(iEnt, pev_iuser4)
		pev(iEnt, pev_classname, szClassName, charsmax(szClassName))
		if(isAvaliableClassName(szClassName))
		{
			if(!iRarity)
			{
				iRarity = getItemGlow(pev(iEnt, pev_iuser1), pev(iEnt, pev_iuser2))
			}
			
			new iRGB[3]
			switch(iRarity)
			{
				case RARITY_GREY: 	iRGB = {150, 150, 150}
				case RARITY_GREEN:	iRGB = {0, 255, 0}
				case RARITY_BLUE:	iRGB = {0, 100, 255}
				case RARITY_PURPLE:	iRGB = {255, 0, 255}
				case RARITY_GOLD:	iRGB = {255, 100, 0}
				default:
				{
					iRGB = {0, 0, 0}
				}	
			}
			
			set_es(es_handle, ES_RenderFx, kRenderFxGlowShell)
			set_es(es_handle, ES_RenderColor, iRGB)
			set_es(es_handle, ES_RenderMode, kRenderNormal)
			set_es(es_handle, ES_RenderAmt, 25)
			return FMRES_IGNORED
		}
	}
	
	if(g_dUserData[iHost][iTeamID])
	{
		if(player && iEnt != iHost)
		{
			if(get_pcvar_num(g_pCvars[cTeamMateEffect]) && isTeammate(iEnt, iHost))
			{
				if(g_dUserData[iEnt][bKnockedOut])
				{
					set_es(es_handle, ES_RenderFx, kRenderFxGlowShell)
					set_es(es_handle, ES_RenderColor, {255, 0, 0})
					set_es(es_handle, ES_RenderMode, kRenderNormal)
					set_es(es_handle, ES_RenderAmt, 75)
				}
				else
				{
					set_es(es_handle, ES_RenderFx, kRenderFxDistort)
					set_es(es_handle, ES_RenderMode, kRenderTransAdd)
				}
			}
		}
		else if(__is_user_alive(iHost) && bitarray_check(g_baTeamSprites, iEnt))
		{
			static iOwner, Float:fOrigin[3], Float:fHostOrigin[3]
			if((iOwner = pev(iEnt, pev_owner)) 
			&& is_user_valid(iOwner) 
			&& (iOwner != iHost)
			&& __is_user_alive(iOwner) 
			&& g_dUserData[iOwner][iTeamID] 
			&& (g_dUserData[iOwner][iTeamID] == g_dUserData[iHost][iTeamID])
			&& (iEnt == g_dUserData[iOwner][iTeammateSpr]))
			{
				set_es(es_handle, ES_AimEnt, 0)
				set_es(es_handle, ES_RenderAmt, 255)

				get_es(es_handle, ES_Origin, fOrigin)
				fOrigin[2] += 40.0
				set_es(es_handle, ES_Origin, fOrigin)
				
				pev(iHost, pev_origin, fHostOrigin)
				static Float:fMultiplier;fMultiplier = (get_distance_f(fOrigin, fHostOrigin) * 0.0254) * 0.01
				set_es(es_handle, ES_Scale, floatclamp(fMultiplier, MIN_DISTANCE, MAX_DISTANCE))
			}
		}
	}
	return FMRES_IGNORED
}

public onResetHUD(id)
{
	message_begin(MSG_ONE, g_mMessageHideWeapon, .player = id)
	write_byte(HUD_HIDE)
	message_end()	
}

public message_HideWeapon()
{
	set_msg_arg_int(1, ARG_BYTE, get_msg_arg_int(1) | HUD_HIDE)
}

public Message_TextMsg()
{
	if(get_msg_arg_int(1) == print_center)
    	{
		new szMessage[MAX_PLAYERS]
		get_msg_arg_string(2, szMessage, charsmax(szMessage))

		return (equal(szMessage, "#Terrorist_cant_buy") || equal(szMessage, "#Weapon_Cannot_Be_Dropped") || equal(szMessage, "#CT_cant_buy"))
    	}
    	return PLUGIN_CONTINUE
}

public message_StatusValue()
{
	if(get_msg_arg_int(1) == 2)
	{
		set_msg_arg_int(1, get_msg_argtype(1), 1)
		set_msg_arg_int(2, get_msg_argtype(2), 0)
	}
}

public message_SendAudio(iMsgId, iMsgDest, id)
{
	if(get_msg_block(g_mMessageTextMsg) == BLOCK_NOT)
	{
		set_msg_block(g_mMessageTextMsg, BLOCK_ONCE)
	}
	
	static szArg[20]
	get_msg_arg_string(2, szArg, charsmax(szArg))
	return equal(szArg, "%!MRAD_FIREINHOLE") ? PLUGIN_HANDLED : PLUGIN_CONTINUE
}

public cmdDrop(id)
{
	if(!g_bCanJump || g_bHasRoundEnded || !__is_user_alive(id))
		return

	new iUserWeapon = get_user_weapon(id)
	if(!iUserWeapon)
		return
		
	if((iUserWeapon == CSW_KNIFE) 
	&& g_dUserData[id][bHasGuspe] 
	&& !g_dUserData[id][bKnockedOut]
	&& !task_exists(id + TASK_UP_PLAYER))
	{
		new Float:fOrigin[3], Float:fOldOrigin[3]
		pev(id, pev_origin, fOrigin)
		
		fOldOrigin = fOrigin
		fOrigin[2] = g_fMaxZ
		
		if(!isValidOrigin(fOrigin))
		{
			CC_SendMatched(id, CC_COLOR_RED, "%L", id, "SERVER_INVALID_PLACE_TO_USE")
			lockedSound(id)
			return
		}
		
		if(g_dUserData[id][iTeamID])
		{
			new iMates = -1
			while((iMates = find_ent_in_sphere(iMates, fOldOrigin, 105.0)))
			{
				if(is_user_alive(iMates) 
				&& isTeammate(id, iMates) 
				&& (iMates != id)
				&& !task_exists(iMates + TASK_UP_PLAYER)
				&& !g_dUserData[iMates][bKnockedOut])
				{
					new Float:fMateOrigin[3], Float:fOldMateOrigin[3]
					pev(iMates, pev_origin, fMateOrigin)
				
					fOldMateOrigin = fMateOrigin
					fMateOrigin[2] = g_fMaxZ
					
					if(!isValidOrigin(fMateOrigin))
					{
						CC_SendMatched(iMates, CC_COLOR_RED, "%L", iMates, "SERVER_INVALID_PLACE_TO_USE")
						lockedSound(iMates)
						continue
					}
					setGuspe(iMates, fOldMateOrigin)
				}
			}
		}

		g_dUserData[id][bHasGuspe] = false
		
		setGuspe(id, fOldOrigin)
		clientPlaySound(id, g_szSoundsData[sGuspeSound], true, .iChannel = CHAN_BODY)
		return
	}
	g_dUserData[id][bCantPickup] = true
	set_task(0.2, "resetPickup", id)
}

public upPlayer(id)
{
	id -= TASK_UP_PLAYER
	
	if(!__is_user_alive(id))
		return
	
	new Float:fOrigin[3]
	pev(id, pev_origin, fOrigin)

	fOrigin[2] = g_fMaxZ

	createBlast(fOrigin, 1000.0)
	engfunc(EngFunc_SetOrigin, id, fOrigin)
	
	ScreenFade(id, {255, 255, 255}, 255, 2096, 1024, 0)
	setFreeze(id, 0)
	set_user_noclip(id, 0)
	
	clientPlaySound(id, g_szSoundsData[sSkyDiveSound], true, .iChannel = CHAN_WEAPON, .bPlayForDeads = false)
	
	new iPlayers[MAX_PLAYERS], playerCount
	get_players(iPlayers, playerCount, "ch")
	for(new i, iPlayer; i < playerCount; i++)
	{
		iPlayer = iPlayers[i]
		if(iPlayer != id)
		{
			clientPlaySound(iPlayer, g_szSoundsData[sGuspeAlertSound])
		}
	}
	g_dUserData[id][bCanUseParachute] = true
	g_dUserData[id][bUsedGuspe] = true
}

public cmdChatSayTeam(id)
{
	if(!g_dUserData[id][iTeamID])
	{
		CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_ISNOT_IN_TEAM")
		lockedSound(id)
		return PLUGIN_HANDLED
	}

	new szMessage[192]
	read_argv(1, szMessage, charsmax(szMessage))
	remove_quotes(szMessage)

	if(!szMessage[0])
		return PLUGIN_HANDLED

	CC_SendMatched(id, CC_COLOR_RED, "%L&x04 %s", id, "SERVER_TEAMCHAT_SENDER", szMessage)

	static szFlag[MAX_PLAYERS], iFlag, iListenType
	get_pcvar_string(g_pCvars[cMateMessageFlagAccess], szFlag, charsmax(szFlag))

	static szAdminFormat[50]
	formatex(szAdminFormat, charsmax(szAdminFormat), "&x03[Team ID: %d]&x01 Player: ", g_dUserData[id][iTeamID])

	iFlag = read_flags(szFlag)
	iListenType = get_pcvar_num(g_pCvars[cShowTeammateMsg])

	new iPlayers[MAX_PLAYERS], playerCount, isSenderAlive = __is_user_alive(id)
	get_players(iPlayers, playerCount, "ch")

	for(new i, iPlayer, bool:bIsAdminListen; i < playerCount; i++)
	{
		iPlayer = iPlayers[i]
		bIsAdminListen = bool:((get_user_flags(iPlayer) & iFlag) && (iListenType > 1 || (iListenType && !__is_user_alive(iPlayer))))
		
		if((bIsAdminListen || ((isTeammate(iPlayer, id)) && (isSenderAlive || !__is_user_alive(iPlayer)))))
		{
			clientPlaySound(iPlayer, g_szSoundsData[sMateMessage], .bPlayForDeads = false)
			CC_SendMatched(iPlayer, CC_COLOR_RED, "%s&x04%s&x01 :&x03 %s", bIsAdminListen ? szAdminFormat : "", g_dUserData[id][szName], szMessage)
		}
	}
	return PLUGIN_HANDLED
}

public cmdChatSay(id)
{
	new szMessage[192]
	read_args(szMessage, charsmax(szMessage))
	remove_quotes(szMessage)

	if(equal(szMessage, g_cCommands[cRank]))
	{
		cmdShowRank(id)
		return PLUGIN_HANDLED
	}
	else if(equal(szMessage, g_cCommands[cTeam]))
	{
		cmdTeam(id)
		return PLUGIN_HANDLED
	}
	else if(equal(szMessage, g_cCommands[cGetoutTeam]))
	{
		cmdOutTeam(id)
		return PLUGIN_HANDLED
	}
	else if(equal(szMessage, g_cCommands[cMainMenu]))
	{
		openPUBNiteMenu(id)
		return PLUGIN_HANDLED
	}
	else if(equal(szMessage, g_cCommands[cBag]))
	{
		if(!__is_user_alive(id))
		{
			CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_MUST_BE_ALIVE")
			lockedSound(id)
			return PLUGIN_HANDLED
		}
		cmdBag(id)
		return PLUGIN_HANDLED
	}
	else if((szMessage[0] == g_cCommands[cGiveVBucks][0]) && (containi(szMessage, g_cCommands[cGiveVBucks]) != -1))
	{
		new szCommand[20], szTargetName[MAX_PLAYERS], szValue[10]
		parse(szMessage, szCommand, charsmax(szCommand), szTargetName, charsmax(szTargetName), szValue, charsmax(szValue))

		if(!szTargetName[0])
		{
			new bool:bUsedTheCommandOnly = bool:(strlen(szMessage) <= sizeof szCommand)
			if(bUsedTheCommandOnly)
			{
				CC_SendMatched(id, CC_COLOR_RED, "Usage: %s <name> <value>", g_cCommands[cGiveVBucks])
			}
			return bUsedTheCommandOnly ? PLUGIN_HANDLED : PLUGIN_CONTINUE
		}
		
		new iTarget = cmd_target(id, szTargetName, CMDTARGET_NO_BOTS)
		if(!iTarget || (iTarget == id))
		{
			CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_INVALID_PLAYER")
			lockedSound(id)
			return PLUGIN_HANDLED
		}
		
		new iVBucks = str_to_num(szValue)
		if((iVBucks <= 0) || (g_dUserData[id][iUserVBucks] < iVBucks))
		{
			CC_SendMatched(id, CC_COLOR_RED, "%L", id, "SERVER_INVALID_VALUE")
			lockedSound(id)
			return PLUGIN_HANDLED
		}
		
		CC_SendMatched(id, CC_COLOR_RED, "%L", id, "SERVER_DONATED_SENDER", iVBucks, g_dUserData[iTarget][szName])
		CC_SendMatched(iTarget, CC_COLOR_RED, "%L", iTarget, "SERVER_DONATED_RECEIVER", g_dUserData[id][szName], iVBucks)

		g_dUserData[id][iUserVBucks] -= iVBucks
		g_dUserData[iTarget][iUserVBucks] += iVBucks

		saveData(id)
		saveData(iTarget)
		return PLUGIN_HANDLED
	}
	return PLUGIN_CONTINUE
}

public openPUBNiteMenu(id)
{
	new szMenuTittle[60], szItemFmt[80]
	formatex(szMenuTittle, charsmax(szMenuTittle), "%L", id, "SERVER_MAIN_MENU_TITTLE", g_cCommands[cMainMenu])
	new iMenu = menu_create(szMenuTittle, "pubnite_main_handler")
		
	formatex(szItemFmt, charsmax(szItemFmt), "%L", id, "SERVER_MAIN_MENU_STATISTICS")
	menu_additem(iMenu, szItemFmt)
	
	formatex(szItemFmt, charsmax(szItemFmt), "%L", id, "SERVER_MAIN_MENU_TEAM")
	menu_additem(iMenu, szItemFmt)
	
	formatex(szItemFmt, charsmax(szItemFmt), "\y%L", id, "SERVER_MAIN_MENU_CONFIGURATIONS")
	menu_additem(iMenu, szItemFmt)
	
	formatex(szItemFmt, charsmax(szItemFmt), "%L", id, "SERVER_MAIN_MENU_BAG")
	menu_additem(iMenu, szItemFmt)
	
	formatex(szItemFmt, charsmax(szItemFmt), "%L", id, "SERVER_MAIN_MENU_COMMANDS")
	menu_additem(iMenu, szItemFmt)
	
	formatex(szItemFmt, charsmax(szItemFmt), "%L", id, "SERVER_MAIN_MENU_SHOP")
	menu_additem(iMenu, szItemFmt)
	
	menu_display(id, iMenu)
	return PLUGIN_HANDLED
}

public pubnite_main_handler(id, iMenu, iItem)
{
	if(iItem == MENU_EXIT)
	{
		menu_destroy(iMenu)
		return
	}
	
	switch(iItem)
	{
		case 0: cmdStatistics(id)
		case 1: teamManagement(id)
		case 2: configurationsManagement(id)
		case 3:	cmdBag(id)
		case 4:	openCommands(id)
		case 5:	openShop(id)
	}
	menu_destroy(iMenu)
}

openCommands(id)
{
	new iLen, szMotd[2300]
	
	iLen = formatex(szMotd, charsmax(szMotd),
	"<meta charset=utf-8><body bgcolor=#A4BED6>\
	<table width=100%% cellpadding=2 cellspacing=3 border=3>\
	<tr align=center bgcolor=#52697B>\
	<th width=4%%>%L\
	<th width=30%% align=left><center>%L", id, "SERVER_COMMAND_NAME", id, "SERVER_COMMAND_DESCRIPTION")
	
	iLen += formatex(szMotd[iLen], charsmax(szMotd) - iLen, "<tr align=center>")
	iLen += formatex(szMotd[iLen], charsmax(szMotd) - iLen, "<tr>")
	
	iLen += formatex(szMotd[iLen], charsmax(szMotd) - iLen, "<td>MedKit")
	iLen += formatex(szMotd[iLen], charsmax(szMotd) - iLen, "<td><center>%L", id, "SERVER_MEDKIT_COMMAND_INFO")

	iLen += formatex(szMotd[iLen], charsmax(szMotd) - iLen, "<tr><td>Chug Jug")
	iLen += formatex(szMotd[iLen], charsmax(szMotd) - iLen, "<td><center>%L", id, "SERVER_CHUG_JUG_COMMAND_INFO")
	
	iLen += formatex(szMotd[iLen], charsmax(szMotd) - iLen, "<tr><td>Guspe")
	iLen += formatex(szMotd[iLen], charsmax(szMotd) - iLen, "<td><center>%L", id, "SERVER_GUSPE_COMMAND_INFO")
	
	iLen += formatex(szMotd[iLen], charsmax(szMotd) - iLen, "<tr><td>%L", id, "SERVER_USE_KEY")
	iLen += formatex(szMotd[iLen], charsmax(szMotd) - iLen, "<td><center>%L", id, "SERVER_MANAGE_ENTITIES")
	
	iLen += formatex(szMotd[iLen], charsmax(szMotd) - iLen, "<tr><td>Wall")
	iLen += formatex(szMotd[iLen], charsmax(szMotd) - iLen, "<td><center>%L", id, "SERVER_WALL_COMMAND_INFO")
	
	iLen += formatex(szMotd[iLen], charsmax(szMotd) - iLen, "<tr><td>Voice")
	iLen += formatex(szMotd[iLen], charsmax(szMotd) - iLen, "<td><center><b>C</b> %L", id, "SERVER_WONT_WORK_IF_BINDED")
	
	iLen += formatex(szMotd[iLen], charsmax(szMotd) - iLen, "<tr><td>%L", id, "SERVER_ITEM_BAG")
	iLen += formatex(szMotd[iLen], charsmax(szMotd) - iLen, "<td><center><b>X</b> %L", id, "SERVER_WONT_WORK_IF_BINDED")
	
	iLen += formatex(szMotd[iLen], charsmax(szMotd) - iLen, "<tr><td>MOD Menu")
	iLen += formatex(szMotd[iLen], charsmax(szMotd) - iLen, "<td><center><b>Z</b> %L", id, "SERVER_WONT_WORK_IF_BINDED")
	
	static szTittle[35]
	formatex(szTittle, charsmax(szTittle), "%L", id, "SERVER_COMMAND_NAME")
	show_motd(id, szMotd, szTittle)
}

cmdStatistics(id)
{
	static szMenuTittle[60], szItemFmt[80]
	formatex(szMenuTittle, charsmax(szMenuTittle), "%L", id, "SERVER_MAIN_MENU_STATISTICS")
	new iMenu = menu_create(szMenuTittle, "pubnite_statistics_handler")
		
	formatex(szItemFmt, charsmax(szItemFmt), "%L", id, "SERVER_MAIN_MENU_VICTORIES")
	menu_additem(iMenu, szItemFmt)
	
	formatex(szItemFmt, charsmax(szItemFmt), "%L", id, "SERVER_MAIN_MENU_TOP15")
	menu_additem(iMenu, szItemFmt)
	
	formatex(szItemFmt, charsmax(szItemFmt), "%L", id, "SERVER_MAIN_MENU_TOPVBUCKS")
	menu_additem(iMenu, szItemFmt)
	
	menu_display(id, iMenu)
}

public pubnite_statistics_handler(id, iMenu, iItem)
{
	if(iItem == MENU_EXIT)
	{
		menu_destroy(iMenu)
		return
	}
	
	switch(iItem)
	{
		case 0:	cmdShowRank(id)
		case 1:	client_cmd(id, "say ^"%s^"", g_cCommands[cTop15])
		case 2:	client_cmd(id, "say ^"%s^"", g_cCommands[cTopVBucks])
	}
}

teamManagement(id)
{
	static szMenuTittle[60], szItemFmt[80]
	formatex(szMenuTittle, charsmax(szMenuTittle), "%L", id, "SERVER_TEAMMANAGEMENT_MENU_TITTLE")
	new iMenu = menu_create(szMenuTittle, "pubnite_management_handler")
	
	formatex(szItemFmt, charsmax(szItemFmt), "%s%L", cantMakeTeam(id, .bShowMessage = false) ? "\d" : "\w", id, "SERVER_INVITE_MENU_TEAM")
	menu_additem(iMenu, szItemFmt)

	formatex(szItemFmt, charsmax(szItemFmt), "%s%L", g_dUserData[id][bIsTeamLeader] ? "\w" : "\d", id, "SERVER_KICK_MATE")
	menu_additem(iMenu, szItemFmt)
	
	formatex(szItemFmt, charsmax(szItemFmt), "%s%L", g_dUserData[id][iTeamID] ? "\w" : "\r", id, "SERVER_MAIN_MENU_TEAM_OUT")
	menu_additem(iMenu, szItemFmt)
	
	menu_display(id, iMenu)
}
	
public pubnite_management_handler(id, iMenu, iItem)
{
	if(iItem == MENU_EXIT)
	{
		menu_destroy(iMenu)
		return
	}
	
	switch(iItem)
	{
		case 0:	cmdTeam(id)
		case 1:	cmdTeammatesMenu(id)
		case 2:	cmdOutTeam(id)
	}
}

configurationsManagement(id)
{
	static szMenuTittle[60], szItemFmt[80]
	formatex(szMenuTittle, charsmax(szMenuTittle), "%L", id, "SERVER_MAIN_MENU_CONFIGURATIONS")
	new iMenu = menu_create(szMenuTittle, "pubnite_configs_handler"), szItem[75]
	
	formatex(szItem, charsmax(szItem), "%L", id, "SERVER_MAIN_MENU_AUTO_MENU", g_dUserData[id][bAutoMenu] ? "\y" : "\r", g_dUserData[id][bAutoMenu] ? "[ON]" : "[OFF]")
	menu_additem(iMenu, szItem)
	
	formatex(szItem, charsmax(szItem), "%L", id, "SERVER_MAIN_MENU_ROUND_ROUNDS", g_dUserData[id][bRoundSounds] ? "\y" : "\r", g_dUserData[id][bRoundSounds] ? "[ON]" : "[OFF]")
	menu_additem(iMenu, szItem)
	
	formatex(szItem, charsmax(szItem), "%L", id, "SERVER_MAIN_MENU_RARITIES", g_dUserData[id][bCanSeeRarities] ? "\y" : "\r", g_dUserData[id][bCanSeeRarities] ? "[ON]" : "[OFF]")
	menu_additem(iMenu, szItem)
	
	formatex(szItem, charsmax(szItem), "%L", id, "SERVER_MAIN_MENU_INVITATIONS", g_dUserData[id][bCanReceiveInvites] ? "\y" : "\r", g_dUserData[id][bCanReceiveInvites] ? "[ON]" : "[OFF]")
	menu_additem(iMenu, szItem)

	formatex(szItem, charsmax(szItem), "%L", id, "SERVER_MAIN_MENU_3DCAMERA", g_dUserData[id][b3DCamera] ? "\y" : "\r", g_dUserData[id][b3DCamera] ? "[ON]" : "[OFF]")
	menu_additem(iMenu, szItem)
	
	formatex(szItemFmt, charsmax(szItemFmt), "%L", id, "SERVER_MAIN_MENU_LANGUAGE")
	menu_additem(iMenu, szItemFmt)
	
	menu_display(id, iMenu)
}
	
public pubnite_configs_handler(id, iMenu, iItem)
{
	if(iItem == MENU_EXIT)
	{
		menu_destroy(iMenu)
		return
	}
	
	switch(iItem)
	{
		case 0:
		{
			g_dUserData[id][bAutoMenu] = !g_dUserData[id][bAutoMenu]
			configurationsManagement(id)
		}
		case 1:
		{
			g_dUserData[id][bRoundSounds] = !g_dUserData[id][bRoundSounds]
			configurationsManagement(id)
		}
		case 2:
		{
			g_dUserData[id][bCanSeeRarities] = !g_dUserData[id][bCanSeeRarities]
			configurationsManagement(id)
		}
		case 3:
		{
			g_dUserData[id][bCanReceiveInvites] = !g_dUserData[id][bCanReceiveInvites]
			configurationsManagement(id)
		}
		case 4:
		{
			g_dUserData[id][b3DCamera] = !g_dUserData[id][b3DCamera]

			set_view(id, g_dUserData[id][b3DCamera] ? CAMERA_3RDPERSON : CAMERA_NONE)
			configurationsManagement(id)
		}
		case 5: client_cmd(id, "amx_langmenu")
	}
	menu_destroy(iMenu)
}
	
openShop(id)
{
	static szMenuTittle[60], szItemFmt[80]
	formatex(szMenuTittle, charsmax(szMenuTittle), "%L", id, "SERVER_MAIN_MENU_SHOP")
	new iMenu = menu_create(szMenuTittle, "pubnite_shop_handler")
		
	formatex(szItemFmt, charsmax(szItemFmt), "%L", id, "SERVER_SHOP_MENU_KNIVES")
	menu_additem(iMenu, szItemFmt)
	
	formatex(szItemFmt, charsmax(szItemFmt), "%L", id, "SERVER_SHOP_MENU_PLAYERS_MODELS")
	menu_additem(iMenu, szItemFmt)
	
	menu_display(id, iMenu)
}

public pubnite_shop_handler(id, iMenu, iItem)
{
	if(iItem == MENU_EXIT)
	{
		menu_destroy(iMenu)
		return
	}
	
	switch(iItem)
	{
		case 0:	client_cmd(id, "say ^"%s^"", g_cCommands[cKnifeShop])
		case 1:	client_cmd(id, "say ^"%s^"", g_cCommands[cModelsShop])
	}
}

public cmdTeammatesMenu(id)
{
	if(!g_iFreezeTime)
	{
		CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_TEAM_IN_COUNTDOWN")
		lockedSound(id)
		return PLUGIN_HANDLED
	}

	if(!isTeam(id))
	{
		CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_TEAM_MUST_PLAY")
		lockedSound(id)
		return PLUGIN_HANDLED
	}
	
	if(!g_dUserData[id][iTeamID])
	{
		CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_ISNOT_IN_TEAM")
		lockedSound(id)
		return PLUGIN_HANDLED
	}
	
	if(!g_dUserData[id][bIsTeamLeader])
	{
		CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_NOT_CAPTAIN")
		lockedSound(id)
		return PLUGIN_HANDLED
	}

	static szMenuTittle[60]
	formatex(szMenuTittle, charsmax(szMenuTittle), "%L", id, "SERVER_PLAYERS_MENU")
	new iMenu = menu_create(szMenuTittle, "choose_mates_handler")
	
	new iPlayers[MAX_PLAYERS], playerCount
	get_players(iPlayers, playerCount, "ch")
	for(new i, iPlayer, szTempid[10]; i < playerCount; i++)
	{
		iPlayer = iPlayers[i]
		
		if((iPlayer == id) || !isTeammate(iPlayer, id))
			continue
			
		num_to_str(get_user_userid(iPlayer), szTempid, charsmax(szTempid))
		menu_additem(iMenu, g_dUserData[iPlayer][szName], szTempid)
	}
	menu_display(id, iMenu)
	return PLUGIN_HANDLED
}

public choose_mates_handler(id, iMenu, iItem)
{
	if(iItem == MENU_EXIT)
	{
		menu_destroy(iMenu)
		return
	}

	if(!g_iFreezeTime)
	{
		CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_TEAM_IN_COUNTDOWN")
		lockedSound(id)
		return
	}

	new szData[10], szItemName[MAX_MODEL_LENGTH]
	new _access, item_callback
	menu_item_getinfo(iMenu, iItem, _access, szData,charsmax(szData), szItemName, charsmax(szItemName), item_callback)
	
	new iTarget = find_player("k", str_to_num(szData))
	if(!iTarget || !isTeam(iTarget))
	{
		CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_INVALID_PLAYER")
		lockedSound(id)
		menu_display(id, iMenu)
		return
	}

	if(!isTeammate(id, iTarget))
	{
		CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_YOUR_TEAMMATE")
		menu_display(id, iMenu)
		lockedSound(id)
		return
	}

	CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_KICKED_PLAYER_KICKER", g_dUserData[iTarget][szName])
	CC_SendMatched(iTarget, CC_COLOR_RED, "^x03%L", iTarget, "SERVER_KICKED_PLAYER_KICKED", g_dUserData[id][szName])
	checkTeam(iTarget, true)
}

public cmdBag(id)
{
	if(!__is_user_alive(id)) 
		return PLUGIN_HANDLED

	static szMenuTittle[60]
	formatex(szMenuTittle, charsmax(szMenuTittle), "%L^n\d- %L: %d%%", id, "SERVER_BAG_MENU", id, "SERVER_ITEM_BAG", getPercent(getMaxValue(id, 2), getMaxValue(id, 1)))
	new iMenu = menu_create(szMenuTittle, "item_drop_handler")

	new CsArmorType:iArmorValue, szItemID[10], szItemFormat[25]
	if(cs_get_user_armor(id, iArmorValue) && g_dUserData[id][iArmorLevel])
	{
		num_to_str(getItemIDType(id, 1), szItemID, charsmax(szItemID))

		formatex(szItemFormat, charsmax(szItemFormat), "%L lv. %d", id, "SERVER_ITEM_KEVLAR", g_dUserData[id][iArmorLevel])
		menu_additem(iMenu, szItemFormat, szItemID)
	}
		
	if(g_dUserData[id][iMedKits])
	{
		num_to_str(g_szItens[iMedKit][iItemID], szItemID, charsmax(szItemID))
		formatex(szItemFormat, charsmax(szItemFormat), "MedKit: %d", g_dUserData[id][iMedKits])
		menu_additem(iMenu, szItemFormat, szItemID)
	}
	
	if(g_dUserData[id][iHelmetEnt])
	{
		num_to_str(getItemIDType(id, 0), szItemID, charsmax(szItemID))

		formatex(szItemFormat, charsmax(szItemFormat), "%L lv. %d", id, "SERVER_ITEM_HELMET", g_dUserData[id][iHelmetLevel])
		menu_additem(iMenu, szItemFormat, szItemID)
	}
	
	if(g_dUserData[id][iBagLevel])
	{
		num_to_str(getItemIDType(id, 2), szItemID, charsmax(szItemID))

		formatex(szItemFormat, charsmax(szItemFormat), "%L lv. %d", id, "SERVER_ITEM_BAG", g_dUserData[id][iBagLevel])
		menu_additem(iMenu, szItemFormat, szItemID)
	}
	
	if(user_has_weapon(id, CSW_SMOKEGRENADE))
	{
		num_to_str(g_szItens[iImpulseGrenade][iItemID], szItemID, charsmax(szItemID))
		formatex(szItemFormat, charsmax(szItemFormat), "%L", id, "SERVER_ITEM_IMPULSE")
		menu_additem(iMenu, szItemFormat, szItemID)
	}

	if(g_dUserData[id][bHasGuspe])
	{
		num_to_str(g_szItens[iGuspe][iItemID], szItemID, charsmax(szItemID))
		menu_additem(iMenu, "Guspe", szItemID)
	}
	
	if(g_dUserData[id][bHasWall])
	{
		num_to_str(g_szItens[iWall][iItemID], szItemID, charsmax(szItemID))
		menu_additem(iMenu, "Wall", szItemID)
	}

	if(g_dUserData[id][bHasChugJug])
	{
		num_to_str(g_szItens[iChugJug][iItemID], szItemID, charsmax(szItemID))
		menu_additem(iMenu, "Chug Jug", szItemID)
	}
	
	new iCustomItemNum = pubnite_get_customitem_num()
	if(iCustomItemNum)
	{
		for(new i, iCustomItemID, szCustomItemName[MAX_PLAYERS];i < iCustomItemNum;i++)
		{
			pubnite_get_customitem(i, iCustomItemID, szCustomItemName)
			if(pubnite_has_customitem(id, iCustomItemID))
			{
				num_to_str(iCustomItemID, szItemID, charsmax(szItemID))
				menu_additem(iMenu, szCustomItemName, szItemID)
			}
		}
	}
	
	if(!szItemID[0])
	{
		num_to_str(-1, szItemID, charsmax(szItemID))
		formatex(szItemFormat, charsmax(szItemFormat), "%L", id, "SERVER_NO_ITEMS")
		menu_additem(iMenu, szItemFormat, szItemID)
	}
	
	menu_display(id, iMenu)
	return PLUGIN_HANDLED
}

public item_drop_handler(id, iMenu, iItem)
{
	if((iItem == MENU_EXIT) || !__is_user_alive(id))
	{
		menu_destroy(iMenu)
		return
	}

	new szData[6], szItemName[MAX_PLAYERS]
	new _access, item_callback
	menu_item_getinfo(iMenu, iItem, _access, szData, charsmax(szData), szItemName, charsmax(szItemName), item_callback)
	
	new iMenuItemID = str_to_num(szData)
	if(iMenuItemID == -1)
	{
		CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_NO_ITEMS")
		lockedSound(id)
		return 	
	}
	
	askPlayer(id, iMenuItemID)
	menu_destroy(iMenu)
}

askPlayer(id, iMenuItemID)
{
	if(!__is_user_alive(id)) 
		return

	new szMenuTittle[60], szItemFormat[50]
	formatex(szMenuTittle, charsmax(szMenuTittle), "%L^n\d- %L: %d%%", id, "SERVER_BAG_MENU", id, "SERVER_ITEM_BAG", getPercent(getMaxValue(id, 2), getMaxValue(id, 1)))
	new iMenu = menu_create(szMenuTittle, "item_ask_handler"), szItemID[10]
	num_to_str(iMenuItemID, szItemID, charsmax(szItemID))
	
	formatex(szItemFormat, charsmax(szItemFormat), "%L", id, "SERVER_MAIN_MENU_DROP")
	menu_additem(iMenu, szItemFormat, szItemID)
	
	formatex(szItemFormat, charsmax(szItemFormat), "%s%L", isUsableItem(iMenuItemID) ? "\w" : "\d", id, "SERVER_MAIN_MENU_USE")
	menu_additem(iMenu, szItemFormat, szItemID)
	
	menu_display(id, iMenu)
}

public item_ask_handler(id, iMenu, iItem)
{
	if((iItem == MENU_EXIT) || !__is_user_alive(id))
	{
		menu_destroy(iMenu)
		return
	}
	new szData[6], szItemName[MAX_PLAYERS]
	new _access, item_callback
	menu_item_getinfo(iMenu, iItem, _access, szData, charsmax(szData), szItemName, charsmax(szItemName), item_callback)
	new iMenuItemID = str_to_num(szData)
		
	switch(iItem)
	{
		case 0:	cmdDropItem(id, iMenuItemID)
		case 1:	
		{
			if(!pubnite_is_customitem(iMenuItemID))
			{
				if(!isUsableItem(iMenuItemID))
				{
					lockedSound(id)
					menu_display(id, iMenu)
					return
				}
				cmdUseItem(id, iMenuItemID)
			}
			else ExecuteForward(g_forwardUsedCustomItem, g_iReturn, id, iMenuItemID)
		}
	}
	cmdBag(id)
	menu_destroy(iMenu)
}

public ham_SmokeDeploy_Post(const iSmoke)
{
	static id; id = get_pdata_cbase(iSmoke, m_pPlayer, XTRA_OFS_WEAPON)
	if(is_user_connected(id))
	{
		set_pev(id, pev_viewmodel2, g_szModelsData[mImpulseGrenadeViewModel])
		set_pev(id, pev_weaponmodel2, g_szModelsData[mImpulseGrenadePlayerModel])
	}
	return HAM_IGNORED
}

public cmdChangeVoiceMode(id)
{
	static const szVoiceMode[][] =
	{
		"SERVER_VOICE_HEAR_ALL",
		"SERVER_VOICE_HEAR_TEAM_ONLY",
		"SERVER_VOICE_HEAR_NONE"
	}
	
	g_dUserData[id][iVoiceMode]++
	if(g_dUserData[id][iVoiceMode] >= sizeof szVoiceMode)
	{
		g_dUserData[id][iVoiceMode] = 0
	}
	clientPlaySound(id, g_szSoundsData[sVoiceChangeModeSound], .bPlayForDeads = false)
	CC_SendMatched(id, CC_COLOR_RED, "%L", id, "SERVER_VOICE_MODE", id, szVoiceMode[g_dUserData[id][iVoiceMode]])
	return PLUGIN_HANDLED
}

public event_CurWeapon(id)
{		
	if(task_exists(id + TASK_MEDKIT) || task_exists(id + TASK_CHUG_JUG_HEAL))
	{
		stopUsageFeature(id, 0)
		stopUsageFeature(id, 1)
	}
}

public playImpulseSound(id) 
{
	clientPlaySound(id, g_szSoundsData[sImpulseGrenadeSound], true)
}

public forward_SetModel(iEnt, const szModel[])
{
	if(equal(szModel, "models/w_smokegrenade.mdl"))
	{
		if(entity_get_float(iEnt, EV_FL_gravity) > 0.0)
		{
			set_task(0.9, "playImpulseSound", iEnt)
		}
		engfunc(EngFunc_SetModel, iEnt, g_szItens[iImpulseGrenade][szItemModel])
		return FMRES_SUPERCEDE
	}
	
	if(!pev_valid(iEnt))
		return FMRES_IGNORED
		
	static szClassName[MAX_PLAYERS]
	pev(iEnt, pev_classname, szClassName, charsmax(szClassName))
	if(equal(szClassName, "weaponbox"))
	{
		static iWeaponEnt, iWeaponID
		if((iWeaponEnt = findWeaponAtWeaponBox(iEnt)) && (CSW_P228 <= (iWeaponID = cs_get_weapon_id(iWeaponEnt)) <= CSW_P90))
		{
			if(!isWeaponRegistered(iWeaponID))
				return FMRES_IGNORED

			static Float:fOrigin[3], szModel[MAX_MODEL_LENGTH]
			static iOwner;iOwner = pev(iEnt, pev_owner)
			
			new bool:bIsOwnerConnected = bool:is_user_connected(iOwner)
			pev(bIsOwnerConnected ? iOwner : iEnt, pev_origin, fOrigin)
			if(bIsOwnerConnected)
			{
				g_dUserData[iOwner][bCantPickup] = true
				set_task(0.2, "resetPickup", iOwner)
			}
			
			copy(szModel, charsmax(szModel), g_szWeaponsModels[getWeaponPos(iWeaponID)][szModelName])
			createWeapon(iWeaponID, szModel, fOrigin, true, pev(iWeaponEnt, pev_iuser4), iOwner)
	
			dllfunc(DLLFunc_Think, iEnt)
			return FMRES_SUPERCEDE
		}
	}
	return FMRES_IGNORED
}

public forward_EmitSound(iEnt, channel, const szSample[])
{
	if(equal(szSample, "common/wpn_denyselect.wav")) 
	{ 
		return FMRES_SUPERCEDE 
	} 

	if(equal(szSample, "player/headshot1.wav")
	|| equal(szSample, "player/headshot2.wav")
	|| equal(szSample, "player/headshot3.wav"))
	{ 
		return FMRES_SUPERCEDE 
	} 

	if(!equal(szSample, "weapons/sg_explode.wav") || !pev_valid(iEnt))
	{
		return FMRES_IGNORED
	}
	
	static szClassName[MAX_PLAYERS], Float:fEntOrigin[3], Float:fPlayerOrigin[3], Float:fRadius;fRadius = get_pcvar_float(g_pCvars[cImpulseGrenRadius])
	pev(iEnt, pev_origin, fEntOrigin)
	
	createBlast(fEntOrigin, get_pcvar_float(g_pCvars[cImpulseGrenRadius]))

	new iVictim = -1, iOwner = pev(iEnt, pev_owner)
	while((iVictim = engfunc(EngFunc_FindEntityInSphere, iVictim, fEntOrigin, fRadius)) != 0)
	{
		pev(iVictim, pev_classname, szClassName, charsmax(szClassName))
		if(is_user_alive(iVictim) || isAvaliableClassName(szClassName) && get_pcvar_num(g_pCvars[cImpulseItems]))
		{
			pev(iVictim, pev_origin, fPlayerOrigin)
			if(isAvaliableClassName(szClassName))
			{
				fPlayerOrigin[2] += 15.0
				engfunc(EngFunc_SetOrigin, iVictim, fPlayerOrigin)
			}
			impulseEntity(iVictim, iEnt, iOwner, (fRadius - (get_distance_f(fEntOrigin, fPlayerOrigin) * 0.0254)))
		}
	}
	set_pev(iEnt, pev_flags, pev(iEnt, pev_flags) | FL_KILLME)
	return FMRES_SUPERCEDE
}

public forward_PlaybackEvent(Flags, id, m_usFireEvent)
{
	return (m_usEventSmokeGrenade == m_usFireEvent) ? FMRES_SUPERCEDE : FMRES_IGNORED
}  

public ham_SmokeThink(const iSmoke) 
{	
	const usEvent = 114
	if(pev_valid(iSmoke) && (get_pdata_int(iSmoke, usEvent) & (1 << 1)))
	{ 
		if(~pev(iSmoke, pev_flags) & FL_ONGROUND)
		{
			set_pev(iSmoke, pev_flags, FL_ONGROUND) 
		}
	}
} 

public forward_Touch(iTouched, id)
{	
	if(!pev_valid(iTouched) || !is_user_connected(id)) 
		return HAM_IGNORED
	
	static szClassName[MAX_PLAYERS]
	pev(iTouched, pev_classname, szClassName, charsmax(szClassName))

	if(g_dUserData[id][bKnockedOut])
		return HAM_SUPERCEDE
	
	if(equal(szClassName, g_szClassNamesData[cWeapons]))
	{
		giveWeapons(id, getEntityType(iTouched), iTouched)
	}
	return HAM_IGNORED
}

public ham_PlayerSpawn_Pre(id)
{
	g_dUserData[id][bIsUserAlive] = false
	g_dUserData[id][bIsUserBot] = bool:is_user_bot(id)
	
	if(isTeam(id) && g_bPlaneSpawned)
	{
		set_pev(id, pev_health, 0.0)
		set_pev(id, pev_deadflag, DEAD_DEAD)
			
		CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_REMOVED_FROM_ROUND")
		return HAM_SUPERCEDE
	}
	return HAM_IGNORED
}

public ham_PlayerSpawn_Post(id)
{
	g_dUserData[id][bIsUserAlive] = bool:is_user_alive(id)
	if(__is_user_alive(id) && !__is_user_bot(id))
	{	
		if(g_iParachuteEnt[id] > 0)
		{
			killEntity(g_iParachuteEnt[id])
			g_iParachuteEnt[id] = 0

			set_user_gravity(id, 1.0)
		}

		remove_task(id + TASK_REMOVEHEALTH)
		g_dUserData[id][bKnockedOut] = false
		
		set_user_noclip(id, 0)
		set_user_armor(id, 0)
		strip_user_weapons(id)

		checkTasks(id)
		removeHelmet(id)
		resetUserData(id)
		resetUserSpeed(id)
		clientStopSound(id)
		
		setInvisibility(id, kRenderNormal)
		
		if(g_iVecsNum[vecPlane])
		{
			setDamageble(id, false)
		}
		
		if(g_dUserData[id][bAutoMenu])
		{
			openPUBNiteMenu(id)
		}
	}
	return HAM_IGNORED
}

public message_StatusIcon(iMsgId, iMsgDest, id)
{
	static szIcon[5]
	get_msg_arg_string(2, szIcon, charsmax(szIcon))

	if((szIcon[0] == 'b') && (szIcon[2] == 'y') && (szIcon[3] == 'z'))
	{		
		const offsetBuyZone = 235
		set_pdata_int(id, offsetBuyZone, get_pdata_int(id, offsetBuyZone) & ~(1<<0))
		return PLUGIN_HANDLED
	}
	return PLUGIN_CONTINUE
}
			
public ham_PlayerTakeDamage_Pre(iVictim, iInflictor, iAttacker, Float:fDamage, iDamageBits)
{	
	if(!is_user_connected(iVictim) || !g_bPlaneSpawned || g_bHasRoundEnded)
		return HAM_IGNORED
		
	new bool:bIsAttackerConnected = bool:is_user_connected(iAttacker), bool:bIsNotSelfAttack = bool:(iVictim != iAttacker)
	
	static iVictimFlags
	if(bIsAttackerConnected)
	{
		g_dUserData[iAttacker][iPlayerWeaponID] = (iInflictor != iAttacker) ? CSW_HEGRENADE : get_user_weapon(iAttacker)
		if(bIsNotSelfAttack)
		{
			if(isTeammate(iAttacker, iVictim) && !get_pcvar_num(g_pCvars[cFFA]))
			{
				SetHamReturnInteger(0)
				return HAM_SUPERCEDE
			}

			new iTarget = checkDamageThroughWallItem(iAttacker)
			if(!is_user_alive(iTarget) && pev_valid(iTarget))
			{
				new szClassName[MAX_PLAYERS]
				pev(iTarget, pev_classname, szClassName, charsmax(szClassName))
				if(equal(szClassName, g_szClassNamesData[cWall]))
				{
					SetHamReturnInteger(0)
					return HAM_SUPERCEDE
				}
			}
		
			new Float:fNewDamage = fDamage
			new iTeam = fm_get_user_team(iVictim), bool:bIsTeammate = bool:(iTeam == fm_get_user_team(iAttacker))
			if(bIsTeammate)
			{
				fm_set_user_team(iVictim, (iTeam == 1) ? 2 : 1)
				ExecuteHamB(Ham_TakeDamage, iVictim, iInflictor, iAttacker, fNewDamage, iDamageBits)
				fm_set_user_team(iVictim, iTeam)
				return HAM_SUPERCEDE
			}
			else
			{
				new bool:bCanShowHud = customDamage(fDamage, fNewDamage, iAttacker, bool:(iInflictor != iAttacker))
				
				static Float:fVictimArmor;fVictimArmor = entity_get_float(iVictim, EV_FL_armorvalue)
				static Float:fGameTime; fGameTime = get_gametime()
				if(bCanShowHud && (fGameTime - g_dUserData[iVictim][fUserGameTime]) >= 0.7)
				{
					g_dUserData[iVictim][fUserGameTime] = _:fGameTime
					clientPlaySound(iVictim, g_szSoundsData[(fVictimArmor > 0.0) ? sArmorHitSound : sDamagePain], true)
				}

				if(isHeadShot(iVictim))
				{
					manageHeadShot(iVictim, iAttacker, fNewDamage)
				}
				SetHamParamFloat(4, fNewDamage)
				
				g_iDamageDone[iAttacker][iVictim] += floatround(fNewDamage)
				g_iLastDamageDone[iAttacker][iVictim] = get_systime()
				
				if(get_pcvar_num(g_pCvars[cShowDamage]) && bCanShowHud && fDamage >= 1.0)
				{
					manageHudDisplayment(iAttacker, iVictim, fNewDamage, fVictimArmor)
				}
			}
		}
		iVictimFlags = pev(iVictim, pev_flags)
	}
	else
	{
		static szClassName[MAX_PLAYERS]
		pev(iAttacker, pev_classname, szClassName, charsmax(szClassName))
		if((equal(szClassName, "func_vehicle") || equal(szClassName, "tracktrain")))
		{
			if(pev(iAttacker, pev_iuser4) == iVictim)
			{
				SetHamReturnInteger(0)
				return HAM_SUPERCEDE
			}
		}
		
		new iOwner = pev(iAttacker, pev_owner)
		if(is_user_alive(iOwner) && get_pcvar_num(g_pCvars[cShowDamage]) && fDamage >= 1.0)
		{
			if(isTeammate(iOwner, iVictim) && !get_pcvar_num(g_pCvars[cFFA]))
			{
				SetHamReturnInteger(0)
				return HAM_SUPERCEDE
			}

			g_iDamageDone[iOwner][iVictim] += floatround(fDamage)
			g_iLastDamageDone[iOwner][iVictim] = get_systime()

			manageHudDisplayment(iOwner, iVictim, fDamage)
			return FMRES_IGNORED
		}
		
		if(g_dUserData[iVictim][bCanUseParachute] && pev_valid(g_iTransporterID) && distanceToGround(iVictim) > 250.0)
		{
			SetHamReturnInteger(0)
			return HAM_SUPERCEDE
		}

		iVictimFlags = pev(iVictim, pev_flags)
		if((iDamageBits & DMG_FALL) && (iVictimFlags & FL_ONGROUND))
		{
			setInvisibility(iVictim, kRenderNormal)
			setDamageble(iVictim, true)
			remove_task(iVictim + TASK_SET_DAMAGEBLE)
		}
	}
	
	if(iVictimFlags & FL_FROZEN)
	{
		setFreeze(iVictim, 0)
		set_user_noclip(iVictim, 0)
	}

	if(floatround(fDamage) >= get_user_health(iVictim) && isAbleToBeKnockedout(iVictim))
	{
		manageKnockFeature(iVictim, iAttacker)		
		SetHamReturnInteger(0)
		return HAM_SUPERCEDE
	}
	return HAM_IGNORED
}

manageHudDisplayment(id, iVictim, Float:fDamage, Float:fVictimArmor = 0.0)
{
	if(id == iVictim)
		return

	new Float:fPositions[][] =
	{
		{0.40, 0.41},
		{0.42, 0.43},
		{0.45, 0.47},
		{0.47, 0.51},
		{0.5, 0.4},
		{0.53, 0.42},
		{0.55, 0.51},
		{0.57, 0.55}
	}
	
	static iRGB[3];iRGB = {200, 200, 200}
	if(is_user_alive(iVictim))
	{
		if(isHeadShot(iVictim) || fVictimArmor)
		{
			if(isHeadShot(iVictim))
			{
				iRGB = {255, 255, 0}
			}
			else iRGB = {0, 100, 255}
		}
	}
	
	new iRandom = random_num(0, charsmax(fPositions))
	set_hudmessage(iRGB[0], iRGB[1], iRGB[2], fPositions[iRandom][0], fPositions[iRandom][1], 0, 1.0, 1.4)
	ShowSyncHudMsg(id, g_hHuds[hDamageHud], "%.0f", fDamage)
}

public ham_UseVehicle(const iEntity, const id, const iActivator, const iUseType)
{
	if(!is_user_valid(id) || !__is_user_alive(id))
	{
		return HAM_IGNORED
	}

	if(g_dUserData[id][bKnockedOut])
	{
		static curTime, playerTime[MAX_PLAYERS + 1], msgTrain
		if(playerTime[id] != (curTime = get_systime()) && (msgTrain || (msgTrain = get_user_msgid("Train"))))
		{
			message_begin(MSG_ONE, msgTrain, _, id)
			write_byte(0)
			message_end()
			playerTime[id] = curTime
		}
		return HAM_SUPERCEDE
	}
	else if(iUseType == 2)
	{
		set_pev(iEntity, pev_iuser4, id)
	}
	return HAM_IGNORED
}

public ham_PlayerKilled_Pre(iVictim, iKiller, iShouldGib)
{
	new iNewKiller = (g_dUserData[iVictim][iNewKillerID] = -1)
	if(!is_user_connected(iVictim))
		return HAM_IGNORED

	g_dUserData[iVictim][iDeathHealth] = pev(iVictim, pev_health)
	if(iKiller > g_iMaxPlayers)
	{
		static szClassName[MAX_PLAYERS], iuser4
		pev(iKiller, pev_classname, szClassName, charsmax(szClassName))

		if((equal(szClassName, "func_vehicle") || equal(szClassName, "tracktrain")) && is_user_valid((iuser4 = pev(iKiller, pev_iuser4))))
		{
			SetHamParamEntity(2, (iNewKiller = iKiller = iuser4))
			g_dUserData[iKiller][iPlayerWeaponID] = CSW_VEHICLE
		}
		else if(is_user_valid((iuser4 = pev(iKiller, pev_owner))))
		{
			SetHamParamEntity(2, (iNewKiller = iKiller = iuser4))
		}
		else
		{
			iNewKiller = iKiller = 0
		}
	}
	
	if(task_exists(iVictim + TASK_MEDKIT) 
	|| task_exists(iVictim + TASK_CHUG_JUG_HEAL))
	{
		stopUsageFeature(iVictim, 0)
		stopUsageFeature(iVictim, 1)
	}
	clientStopSound(iVictim, true, g_szSoundsData[sSkyDiveSound], .iChannel = CHAN_WEAPON)

	if(g_iParachuteEnt[iVictim] > 0)
	{
		killEntity(g_iParachuteEnt[iVictim])
		g_iParachuteEnt[iVictim] = 0
	}
	barTime(iVictim, .iTime = 0)

	dropItems(iVictim)
	checkTasks(iVictim)

	clientStopSound(iVictim)
	clientPlaySound(iVictim, g_szSoundsData[sDeathSound], true, .iChannel = CHAN_BODY)
	
	new bool:bIsKillerConnected = bool:is_user_connected(iKiller)
	if(isHeadShot(iVictim) && bIsKillerConnected)
	{
		clientPlaySound(iKiller, g_szSoundsData[sCriticalKill])
	}
	
	if((iVictim != iKiller) && bIsKillerConnected)
	{
		new iTeam = fm_get_user_team(iVictim)
		if(iTeam == fm_get_user_team(iKiller))
		{
			fm_set_user_team(iVictim, (iTeam == 1) ? 2 : 1)
			ExecuteHamB(Ham_Killed, iVictim, iKiller, iShouldGib)
			fm_set_user_team(iVictim, iTeam)
			return HAM_SUPERCEDE
		}
	}
	
	if(g_dUserData[iVictim][iHelmetLevel])
	{
		removeHelmet(iVictim)
	}
	
	if(!g_bHasRoundEnded)
	{
		g_dUserData[iVictim][iNewKillerID] = (iNewKiller >= 0 ? iNewKiller : iKiller)
	}
	return HAM_IGNORED
}

public ham_PlayerKilled_Post(iVictim, iKiller, iShouldGib)
{
	g_dUserData[iVictim][bIsUserAlive] = false
	if(g_dUserData[iVictim][iNewKillerID] >= 0)
	{
		new iAttacker = g_dUserData[iVictim][iNewKillerID]
		if(is_user_connected(iAttacker))
		{
			new iWeaponHolding = get_user_weapon(iAttacker)
			if(!isWeaponRegistered(iWeaponHolding) 
			&& (g_dUserData[iAttacker][iPlayerWeaponID] != CSW_VEHICLE)
			&& (g_dUserData[iAttacker][iPlayerWeaponID] != CSW_HEGRENADE))
			{
				g_dUserData[iAttacker][iPlayerWeaponID] = iWeaponHolding
			}
		}

		ham_ExecuteThings(iVictim, iAttacker, bool:isHeadShot(iVictim))
		g_dUserData[iVictim][iNewKillerID] = -1
	}

	checkNum()
	return HAM_IGNORED
}

ham_ExecuteThings(iVictim, iKiller, bool:bWasHeadShot = false)
{
	new bIsSuicide = bool:(iVictim == iKiller)
	if(!is_user_connected(iKiller) && !g_dUserData[iVictim][iKnockerID] || bIsSuicide && !g_dUserData[iVictim][iKnockerID])
	{
		checkTeammates(iVictim)
		
		new iImpulser = g_dUserData[iVictim][iImpulserID]
		if(iImpulser && (iImpulser != iVictim))
		{
			g_dUserData[iImpulser][iUserVBucks] += get_pcvar_num(g_pCvars[cKillVBucks])

			updateFrags(iImpulser, 1)
			displayMessage(1, iImpulser, iVictim, CSW_SMOKEGRENADE)
		}
		else 
		{
			new iMostDamagerID = getMostDamager(iVictim)
			if(__is_user_alive(iMostDamagerID))
			{
				g_dUserData[iMostDamagerID][iUserVBucks] += get_pcvar_num(g_pCvars[cKillVBucks])

				updateFrags(iMostDamagerID, 1)
				displayMessage(1, iMostDamagerID, iVictim, g_dUserData[iMostDamagerID][iPlayerWeaponID])
			}
			else displayMessage(0, iVictim)
		}
		return
	}
	
	new iVictimKnockerID = g_dUserData[iVictim][iKnockerID]
	if(g_dUserData[iVictim][bDiedBleeding])
	{
		if(is_user_alive(iVictimKnockerID))
		{
			g_dUserData[iVictimKnockerID][iUserVBucks] += get_pcvar_num(g_pCvars[cKillVBucks])
			displayMessage(2, iVictimKnockerID, iVictim, g_dUserData[iVictim][iWeaponKnocker])
		}
		else displayMessage(0, iVictim)
		return
	}
	
	if(!g_dUserData[iVictim][bKnockedOut])
	{
		g_dUserData[iKiller][iUserVBucks] += get_pcvar_num(g_pCvars[bWasHeadShot ? cHSVBucks : cKillVBucks])
		displayMessage(1, iKiller, iVictim, g_dUserData[iKiller][iPlayerWeaponID])
	}
	else
	{	
		new iMessageType = 1, bool:bIsSameKiller = bool:(iVictimKnockerID == iVictim)
		if(iKiller != iVictimKnockerID)
		{
			if(bIsSuicide || !is_user_connected(iKiller))
			{
				if(__is_user_alive(iVictimKnockerID) && !bIsSameKiller)
				{
					iKiller = iVictimKnockerID
					updateFrags(iVictimKnockerID, 1)
				}
				else
				{
					iMessageType = 0
					iKiller = iVictim
				}
			}
			else
			{
				if(__is_user_alive(iVictimKnockerID))
				{
					iMessageType = 3

					g_dUserData[iVictimKnockerID][iUserVBucks] += get_pcvar_num(g_pCvars[cFinalizeVBucks])
					updateFrags(iVictimKnockerID, 1)
					updateFrags(iKiller, -1)
				}
			}
		}
		else g_dUserData[iKiller][iUserVBucks] += get_pcvar_num(g_pCvars[cKillVBucks])

		displayMessage(iMessageType, iKiller, iVictim, iMessageType ? g_dUserData[iKiller][iPlayerWeaponID] : 0)
	}
	checkTeammates(iVictim, iKiller)
}

getMostDamager(iVictimID)
{
	new iPlayers[MAX_PLAYERS], iNum, iDamagerID
	get_players(iPlayers, iNum, "ach")
	for(new i, iPlayer;i < iNum;i++)
	{
		if((iPlayer = iPlayers[i]) == iVictimID)
			continue
			
		if((get_systime() - g_iLastDamageDone[iPlayer][iVictimID]) > get_pcvar_num(g_pCvars[cLastDamageDelay]))
			continue
			
		if(didMinimumDamage(g_iDamageDone[iPlayer][iVictimID], g_dUserData[iVictimID][iDeathHealth]))
			continue
			
		iDamagerID = iPlayer
		break
	}
	return iDamagerID
}

updateFrags(id, iAmmount)
{
	if(!is_user_connected(id))
		return
		
	new iFrags = (get_user_frags(id) + iAmmount)
	set_user_frags(id, iFrags)
 
	updateScoreBoard(id, iFrags)
}

checkTeammates(iVictim, iKiller = 0)
{
	if(!g_dUserData[iVictim][iTeamID] || isTeamKnockAvaliable(iVictim))
		return

	new iPlayers[MAX_PLAYERS], iNum
	get_players(iPlayers, iNum, "ach")
	for(new i, iPlayer, iTeammateKnockerID, iKillerID;i < iNum;i++)
	{
		iPlayer = iPlayers[i]
		
		if(!isTeammate(iPlayer, iVictim))
			continue

		if(g_dUserData[iPlayer][bKnockedOut])
		{
			g_dUserData[iPlayer][bDiedBleeding] = true
	
			iTeammateKnockerID = g_dUserData[iPlayer][iKnockerID]
			if(__is_user_alive(iTeammateKnockerID))
			{
				iKillerID = iTeammateKnockerID
			}
			else 
			{
				if(iKiller)
				{
					iKillerID = g_dUserData[iPlayer][iKnockerID] = iKiller
				}
			}
			printMateDiedHud(iPlayer)
			executeKill(iPlayer, iKillerID)
		}
	}
}

printMateDiedHud(iTeammateIndex)
{
	set_hudmessage(255, 0, 0, -1.0, 0.35, 0, 1.0, 4.0)
	ShowSyncHudMsg(iTeammateIndex, g_hHuds[hKilledMate], "%L", iTeammateIndex, "SERVER_TEAM_DIED")
}

displayMessage(iType, iAttacker, iVictim = 0, iWeaponID = 0)
{
	new iPlayers[MAX_PLAYERS], iNum, iIDToShow, szLeft[25], szWeaponName[MAX_PLAYERS]
	get_players(iPlayers, iNum, "ch")
	
	switch(iType)
	{
		case 0:
		{
			if(!g_bHasRoundEnded)
			{
				new iVictimID = iAttacker ? iAttacker : iVictim
				new szEliminated[20], szRedZoneDeath[35]
				for(new i, iPlayer;i < iNum;i++)
				{
					iPlayer = iPlayers[i]
	
					formatex(szEliminated, charsmax(szEliminated), "%L", iPlayer, "SERVER_ELIMINATED")
					formatex(szRedZoneDeath, charsmax(szRedZoneDeath), "%L", iPlayer, "SERVER_ELIMINATE_REDZONE")
				
					getLeftMessage(iPlayer, szLeft)
					CC_SendMatched(iPlayer, CC_COLOR_RED, "%L", iPlayer, "SERVER_SELF_DEATH", g_dUserData[iVictimID][szName], pubnite_is_in_redzone(iVictimID) ? szRedZoneDeath : szEliminated, szLeft)
				}
			}
			iVictim = iAttacker
		}
		case 1:
		{
			if(!g_bHasRoundEnded)
			{
				for(new i, iPlayer;i < iNum;i++)
				{
					iPlayer = iPlayers[i]
			
					getLeftMessage(iPlayer, szLeft)
					changeWeaponName(iWeaponID, szWeaponName, iPlayer)
					CC_SendMatched(iPlayer, CC_COLOR_GREY, "%L", iPlayer, "SERVER_HAS_KILLED", g_dUserData[iAttacker][szName], iPlayer, "SERVER_KILLED", g_dUserData[iVictim][szName], szWeaponName, szLeft)
				}
			}
			iIDToShow = iAttacker
		}
		case 2:
		{
			if(iAttacker)
			{
				if(!g_bHasRoundEnded)
				{
					g_dUserData[iVictim][bDiedBleeding] = false
					for(new i, iPlayer;i < iNum;i++)
					{
						iPlayer = iPlayers[i]
				
						getLeftMessage(iPlayer, szLeft)
						CC_SendMatched(iPlayer, CC_COLOR_GREY, "%L", iPlayer, "SERVER_FINNALY_KILLED", g_dUserData[iAttacker][szName], g_dUserData[iVictim][szName], szLeft)
					}
				}
				iIDToShow = iAttacker
			}
		}
		case 3:
		{
			for(new i, iPlayer;i < iNum;i++)
			{
				iPlayer = iPlayers[i]
			
				getLeftMessage(iPlayer, szLeft)
				changeWeaponName(iWeaponID, szWeaponName, iPlayer)
				CC_SendMatched(iPlayer, CC_COLOR_GREY, "%L", iPlayer, "SERVER_HAS_KILLED", g_dUserData[iAttacker][szName], iPlayer, "SERVER_FINALIZED", g_dUserData[iVictim][szName], szWeaponName, szLeft)
			}
			
			changeWeaponName(iWeaponID, szWeaponName, iIDToShow)
			getLeftMessage(iAttacker, szLeft)
			
			set_dhudmessage(220, 255, 220, -1.0, 0.65, 0, 1.0, 5.0)
			show_dhudmessage(iAttacker, "%L", iAttacker, "SERVER_YOU_KILLED", iAttacker, "SERVER_FINALIZED", g_dUserData[iVictim][szName], szWeaponName, szLeft)

			iIDToShow = g_dUserData[iVictim][iKnockerID]
		}
	}
	
	if(iIDToShow && !isTeammate(iIDToShow, iVictim))
	{
		g_dUserData[iIDToShow][iKills]++

		changeWeaponName((iType == 3) ? g_dUserData[iVictim][iWeaponKnocker] : iWeaponID, szWeaponName, iIDToShow)
		getLeftMessage(iIDToShow, szLeft)
		
		set_dhudmessage(220, 255, 220, -1.0, 0.65, 0, 1.0, 3.0)
		show_dhudmessage(iIDToShow, "%L", iIDToShow, "SERVER_YOU_KILLED", iIDToShow, "SERVER_KILLED", g_dUserData[iVictim][szName], szWeaponName, szLeft)

		set_dhudmessage(255, 0, 0, -1.0, 0.68, 0, 1.0, 3.0)
		show_dhudmessage(iIDToShow, "%d %L", g_dUserData[iIDToShow][iKills], iIDToShow, "SERVER_KILLS", (g_dUserData[iIDToShow][iKills] > 1) ? "S" : "")
	}
	
	removeKnockInfo(iVictim)
	
	new iPosition = (getTeamsLeft() + getPlayersWithoutTeam(true)) + 1
	new iTotalPlaces = (ArraySize(g_arTeams) + getPlayersWithoutTeam(false))
	
	set_hudmessage(225, 20, 0, -1.0, 0.25, 0, 1.0, 6.0)
	if(g_dUserData[iVictim][iTeamID])
	{
		if(!getPlayersNumInATeam(g_dUserData[iVictim][iTeamID], true))
		{
			for(new i, iPlayer;i < iNum;i++)
			{
				iPlayer = iPlayers[i]
				if((iPlayer == iVictim) || isTeammate(iVictim, iPlayer))
				{
					ShowSyncHudMsg(iPlayer, g_hHuds[hPosition], "%L %L #%d/%d", iPlayer, "SERVER_YOUR_TEAM", iPlayer, "SERVER_PLACED", iPosition, iTotalPlaces)
				}
			}
			ExecuteForward(g_forwardTeamEliminated, g_iReturn, g_dUserData[iVictim][iTeamID], 0)
		}
	}
	else
	{
		ShowSyncHudMsg(iVictim, g_hHuds[hPosition], "%L %L #%d/%d", iVictim, "SERVER_YOU", iVictim, "SERVER_PLACED", iPosition, iTotalPlaces)
	}
	checkNum()
}

getLeftMessage(id, szLeft[25])
{
	new iLeft = getPlayersNum()
	if(roundEnded())
	{
		formatex(szLeft, charsmax(szLeft), "^x03%L", id, "SERVER_ROUND_ENDED")
	}
	else
	{
		formatex(szLeft, charsmax(szLeft), "^x03%d^x01 %L", iLeft, id, "SERVER_LEFT")
	}
}

public takeHealth(id)
{
	id -= TASK_REMOVEHEALTH

	if(g_dUserData[id][iHelperID])
		return 
	
	new iHPToTake = ((g_dUserData[id][iKnocks] * 2) - 1), iUserHealth = get_user_health(id)
	if(isUserMoving(id))
	{
		iHPToTake += random_num(1, 2)
	}
	
	if(iHPToTake >= iUserHealth)
	{
		new iVicKnocker = g_dUserData[id][iKnockerID]
		if(__is_user_alive(iVicKnocker))
		{
			g_dUserData[id][bDiedBleeding] = true
			executeKill(id, iVicKnocker)
		}
		else user_kill(id, 1)
		
		cleanData(g_dUserData[id][iHelperID], id)
		
		remove_task(id + TASK_REMOVEHEALTH)
		return
	}
	
	startBleeding(id)
	set_user_health(id, (iUserHealth - iHPToTake))
}

dropBox()
{
	new iBox = create_entity("info_target")
	if(pev_valid(iBox))
	{	
		for(new i;i < sizeof g_iAirDropItems;i++)
		{
			g_iAirDropItems[i][g_iSupplyNum] = random_num(0, 2)
		}
			
		new Float:fOrigin[3]
		getRandomPoint(fOrigin)
		engfunc(EngFunc_SetOrigin, iBox, fOrigin)
		
		engfunc(EngFunc_SetModel, iBox, g_szModelsData[mAirDrop])
		engfunc(EngFunc_SetSize, iBox, Float:{-28.0, -28.0, -0.1}, Float:{28.0, 28.0, 50.0})
		
		set_pev(iBox, pev_body, 1)
		set_pev(iBox, pev_iuser1, g_iSupplyNum)
		
		clientPlaySound(0, g_szSoundsData[sAirDropAppearSound])
		clientPlaySound(iBox, g_szSoundsData[sAirDropLandingSound], true)
		
		set_pev(iBox, pev_solid, SOLID_SLIDEBOX)
		set_pev(iBox, pev_gravity, 0.05)
		set_pev(iBox, pev_movetype, MOVETYPE_TOSS)
		set_pev(iBox, pev_classname, g_szClassNamesData[cAirDrop])

		g_iSupplyNum++

		set_task(2.0, "killBoxParachute", iBox)
	}
}

public killBoxParachute(iBox)
{
	if(pev_valid(iBox))
	{
		new Float:fSupplyOrigin[3]
		pev(iBox, pev_origin, fSupplyOrigin)
		
		if((distanceToGround(iBox) <= 200.0) && pev(iBox, pev_iuser2) == 0)
		{		
			clientPlaySound(iBox, g_szSoundsData[sAirdropTouchSound], true)

			new iPlayers[MAX_PLAYERS], iNum
			get_players(iPlayers, iNum, "ch")
			for(new i, iPlayer, Float:fUserOrigin[3];i < iNum;i++)
			{
				iPlayer = iPlayers[i]
							
				pev(iPlayer, pev_origin, fUserOrigin)
				if(get_distance_f(fUserOrigin, fSupplyOrigin) >= SUPPLY_DISTANCE_SOUND)
				{
					clientPlaySound(iPlayer, g_szSoundsData[sSupplyFarLandSound])
				}
			}
			
			set_pev(iBox, pev_gravity, 1.0)
			set_pev(iBox, pev_body, 0)
			set_pev(iBox, pev_iuser2, 1)
		}
		else if(pev(iBox, pev_flags) & FL_ONGROUND)
		{
			createBlast(fSupplyOrigin, 200.0, {92, 64, 51})
			return
		}

		new Float:fVelocity[3], Float:fUpdateDelay = 0.3
		pev(iBox, pev_velocity, fVelocity)
		if(fVelocity[2] == 0.0)
		{
			setRendering(iBox, kRenderTransAlpha, Float:{0.0, 0.0, 0.0}, 0.0)
			fUpdateDelay = 0.1
			
			new iSupplyTries = pev(iBox, pev_iuser2)
			set_pev(iBox, pev_iuser2, (iSupplyTries + 1))
			
			if(iSupplyTries > MAX_SUPLLY_TRIES)
			{
				new Float:fOrigin[3]
				getRandomPoint(fOrigin)
				engfunc(EngFunc_SetOrigin, iBox, fOrigin)

				setRendering(iBox, kRenderNormal, Float:{0.0, 0.0, 0.0}, 0.0)
				iSupplyTries = 0
			}
		}
		set_task(fUpdateDelay, "killBoxParachute", iBox)
	}
}

public restartRound(iTime)
{
	server_cmd("sv_restartround %d", iTime)
	set_task(1.7, "setFrags")
}

public setFrags()
{
	const m_iDeaths = 444
	
	new iPlayers[MAX_PLAYERS], iNum
	get_players(iPlayers, iNum, "ch")
	for(new i, id;i < iNum;i++)
	{
		id = iPlayers[i]
		
		set_pdata_int(id, m_iDeaths, g_dUserData[id][iUserDeaths])
		updateFrags(id, g_dUserData[id][iUserFrags])
		
		g_dUserData[id][iUserFrags] = g_dUserData[id][iUserDeaths] = 0
	}
}

public createPlane()
{
	ClearSyncHud(0, g_hHuds[hFreezeTimeEnd])
	
	static Float:fOrigin[3], Float:fAngle[3], Float:fVelocity[3]
	getRandomPlaneDirection(fOrigin, fAngle, fVelocity)
	
	new iEnt = create_entity("info_target")
	fmCreatePlane
	(
		iEnt, 
		g_szClassNamesData[cTransporter], 
		g_szModelsData[mTransporter], 
		fOrigin,
		fVelocity,
		fAngle
	)
	
	g_bPlaneSpawned = true
	g_iTransporterID = iEnt
	fOrigin[2] -= 40.0

	new iPlayers[MAX_PLAYERS], iNum
	get_players(iPlayers, iNum, "ach")
	for(new i, id;i < iNum;i++)
	{
		id = iPlayers[i]
		
		setInvisibility(id, kRenderTransAlpha)
		clientPlaySound(id, g_szSoundsData[sTransporter])
		
		set_pev(id, pev_origin, fOrigin)
		set_pev(id, pev_angles, fAngle)
		set_pev(id, pev_fixangle, 1)
		set_pev(id, pev_velocity, fVelocity)
		set_pev(id, pev_gravity, 0.000001)
		set_pev(id, pev_maxspeed, 0.000001)

		g_dUserData[id][bIsOnPlane] = true
		g_dUserData[id][bCanUseParachute] = false
	}
	
	set_task(get_pcvar_float(g_pCvars[cAllowToJumpTime]), "allowJump")
	set_task(g_fPlaneRemoveTime[g_iRandomDirection], "checkPlaneOrigin", TASK_PLANE)
}

public allowJump()
{
	new iPlayers[MAX_PLAYERS], iNum
	get_players(iPlayers, iNum, "ach")
	for(new i, id;i < iNum;i++)
	{
		id = iPlayers[i]
			
		if(g_dUserData[id][bIsOnPlane])
		{
			clientPlaySound(id, g_szSoundsData[sRadioAlert])
		}
	}
	g_bCanJump = true
}

public checkPlaneOrigin()
{
	new iPlayers[MAX_PLAYERS], iNum
	get_players(iPlayers, iNum, "ach")
	for(new i, id;i < iNum;i++)
	{
		id = iPlayers[i]
			
		if(g_dUserData[id][bIsOnPlane])
		{
			dropPlayer(id)
		}
	}
	
	killEntity(g_iTransporterID)
}

public cmdShowRank(id)
{
	new szMessage[3][50]
	switch(g_dUserData[id][iVitoriasSolo])
	{
		case 0: 	formatex(szMessage[0], charsmax(szMessage[]), "%L", id, "SERVER_NO_WINS")
		case 1: 	formatex(szMessage[0], charsmax(szMessage[]), "%L", id, "SERVER_WON_ONCE")
		default:	formatex(szMessage[0], charsmax(szMessage[]), "%L", id, "SERVER_WON_TWICE", g_dUserData[id][iVitoriasSolo])
	}
	
	switch(g_dUserData[id][iVitoriasDuo])
	{
		case 0: 	formatex(szMessage[1], charsmax(szMessage[]), "%L", id, "SERVER_NO_WINS")
		case 1: 	formatex(szMessage[1], charsmax(szMessage[]), "%L", id, "SERVER_WON_ONCE")
		default:	formatex(szMessage[1], charsmax(szMessage[]), "%L", id, "SERVER_WON_TWICE", g_dUserData[id][iVitoriasDuo])
	}
	
	switch(g_dUserData[id][iVitoriasSquad])
	{
		case 0: 	formatex(szMessage[2], charsmax(szMessage[]), "%L", id, "SERVER_NO_WINS")
		case 1: 	formatex(szMessage[2], charsmax(szMessage[]), "%L", id, "SERVER_WON_ONCE")
		default:	formatex(szMessage[2], charsmax(szMessage[]), "%L", id, "SERVER_WON_TWICE", g_dUserData[id][iVitoriasSquad])
	}
	CC_SendMatched(id, CC_COLOR_GREY, "===========================================")
	CC_SendMatched(id, CC_COLOR_GREY, "Solo: %s", szMessage[0])
	CC_SendMatched(id, CC_COLOR_GREY, "Duo: %s", szMessage[1])
	CC_SendMatched(id, CC_COLOR_GREY, "Squad: %s", szMessage[2])
	CC_SendMatched(id, CC_COLOR_GREY, "===========================================")
	return PLUGIN_HANDLED
}

#if !defined ArrayFindValue
#define ArrayFindValue __ArrayFindValue
#endif 

stock __ArrayFindValue(Array:which, item)
{
	for(new i; i < ArraySize(which); i++)
	{
		if(ArrayGetCell(which, i) == item)
		{
			return i
		}
	}
	return -1
}

public cmdOutTeam(id)
{
	if(!g_dUserData[id][iTeamID])
	{
		CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_ISNOT_IN_TEAM")
		lockedSound(id)
		return PLUGIN_HANDLED
	}

	if(!g_iFreezeTime)
	{
		CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_TEAM_IN_COUNTDOWN")
		lockedSound(id)
		return PLUGIN_HANDLED
	}

	checkTeam(id, true)
	CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_GOT_OUT_OF_TEAM_1")
	return PLUGIN_HANDLED
}

public cmdTeam(id)
{
	if(!g_iFreezeTime)
	{
		CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_TEAM_IN_COUNTDOWN")
		lockedSound(id)
		return PLUGIN_HANDLED
	}

	if(!isTeam(id))
	{
		CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_TEAM_MUST_PLAY")
		lockedSound(id)
		return PLUGIN_HANDLED
	}
	
	if(cantMakeTeam(id))
		return PLUGIN_HANDLED
	
	static szMenuTittle[60]
	formatex(szMenuTittle, charsmax(szMenuTittle), "%L", id, "SERVER_PLAYERS_MENU")
	new iMenu = menu_create(szMenuTittle, "choose_players_handler")
	
	new iPlayers[MAX_PLAYERS], playerCount
	get_players(iPlayers, playerCount, "ach")
	for(new i, iPlayer, szTempid[10]; i < playerCount; i++)
	{
		iPlayer = iPlayers[i]
		
		if((iPlayer == id) 
		|| !g_dUserData[iPlayer][bCanReceiveInvites]
		|| g_dUserData[iPlayer][iTeamID] 
		|| isTeammate(iPlayer, id))
			continue
			
		num_to_str(get_user_userid(iPlayer), szTempid, charsmax(szTempid))
		menu_additem(iMenu, g_dUserData[iPlayer][szName], szTempid)
	}
	menu_display(id, iMenu)
	return PLUGIN_HANDLED
}

public choose_players_handler(id, iMenu, iItem)
{
	if((iItem == MENU_EXIT) || !isTeam(id))
	{
		menu_destroy(iMenu)
		return
	}

	if(!g_iFreezeTime)
	{
		CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_TEAM_IN_COUNTDOWN")
		lockedSound(id)
		return
	}

	new szData[10], szItemName[MAX_MODEL_LENGTH]
	new _access, item_callback
	menu_item_getinfo(iMenu, iItem, _access, szData,charsmax(szData), szItemName, charsmax(szItemName), item_callback)
	
	new iTarget = find_player("k", str_to_num(szData))
	if(!iTarget || !isTeam(iTarget))
	{
		CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_INVALID_PLAYER")
		lockedSound(id)
		menu_display(id, iMenu)
		return
	}
	
	if(cantMakeTeam(id))
		return

	if(!g_dUserData[iTarget][bCanReceiveInvites])
	{
		CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_PLAYER_WONT_RECEIVE")
		menu_display(id, iMenu)
		lockedSound(id)
		return
	}
	
	if(g_dUserData[iTarget][iTeamID])
	{
		CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_PLAYER_ALREADY_IN_TEAM")
		menu_display(id, iMenu)
		lockedSound(id)
		return
	}
	
	if(isTeammate(id, iTarget))
	{
		CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_YOUR_TEAMMATE")
		menu_display(id, iMenu)
		lockedSound(id)
		return
	}

	inviteMenu(id, iTarget, g_dUserData[id][iTeamID])
	CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_PLAYER_INVITED")
}

inviteMenu(id, iTarget, iTeam)
{
	g_dUserData[iTarget][iInviter] = id
	
	static szTittle[80], szItemFmt[15], szTeamID[8]
	formatex(szTittle, charsmax(szTittle), "%s %L", g_dUserData[id][szName], iTarget, "SERVER_INVITE_MENU")
	new iMenu = menu_create(szTittle, "invite_handler")
	
	formatex(szItemFmt, charsmax(szItemFmt), "\y%L", iTarget, "SERVER_YES")
	num_to_str(iTeam, szTeamID, charsmax(szTeamID))
	menu_additem(iMenu, szItemFmt, szTeamID)
	
	formatex(szItemFmt, charsmax(szItemFmt), "\r%L", iTarget, "SERVER_NO")
	menu_additem(iMenu, szItemFmt)

	menu_display(iTarget, iMenu)
}

public invite_handler(id, iMenu, iItem)
{
	if(iItem == MENU_EXIT)
	{
		menu_destroy(iMenu)
		return
	}
	
	if(!isTeam(id))
	{
		CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_TEAM_MUST_PLAY")
		lockedSound(id)
		return
	}
	
	if(!g_iFreezeTime)
	{
		CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_TEAM_IN_COUNTDOWN")
		lockedSound(id)
		return
	}
		
	new iInviterID = g_dUserData[id][iInviter]
	if(!iItem)
	{	
		if(cantMakeTeam(iInviterID, id))
			return

		if(!is_user_connected(iInviterID) || !isTeam(iInviterID))
		{
			CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_INVALID_PLAYER")
			lockedSound(id)
			return
		}
		
		if(g_dUserData[id][iTeamID])
		{
			CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_PLAYER_ALREADY_IN_TEAM")
			menu_display(id, iMenu)
			lockedSound(id)
			return
		}
			
		if(isTeammate(id, iInviterID))
		{
			CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_YOUR_TEAMMATE")
			lockedSound(id)
			return
		}
	
		new szTeamID[6], iAccess, item_callback
		menu_item_getinfo(iMenu, iItem, iAccess, szTeamID, charsmax(szTeamID), .callback = item_callback)
		if(str_to_num(szTeamID) != g_dUserData[iInviterID][iTeamID])
		{
			CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_INVALID_TEAM_REQUEST")
			lockedSound(id)
			return
		}
	
		if(!g_dUserData[iInviterID][iTeamID])
		{
			g_iTeamsNum++
			
			g_dUserData[iInviterID][bIsTeamLeader] = true
			g_dUserData[iInviterID][iTeamID] = g_iTeamsNum

			ArrayPushCell(g_arTeams, g_iTeamsNum)
			createSpr(iInviterID)
		}
		
		g_dUserData[id][iTeamID] = g_iTeamsNum
		createSpr(id)
		
		CC_SendMatched(iInviterID, CC_COLOR_GREY, "%L", iInviterID, "SERVER_ACCEPTED_TEAM_INVITER", g_dUserData[id][szName])
		CC_SendMatched(id, CC_COLOR_GREY, "%L", id, "SERVER_ACCEPTED_TEAM_INVITED", g_dUserData[iInviterID][szName])
	}
	else
	{
		CC_SendMatched(iInviterID, CC_COLOR_GREY, "%L", iInviterID, "SERVER_REFUSED_TEAM_INVITER", g_dUserData[id][szName])
		CC_SendMatched(id, CC_COLOR_GREY, "%L", id, "SERVER_REFUSED_TEAM_INVITED")
	
		lockedSound(id)
	}
	
	g_dUserData[id][iInviter] = 0
}

cantMakeTeam(id, iInviteID = 0, bool:bShowMessage = true)
{
	new iPlayers[MAX_PLAYERS], playerCount, iPlayersInMyTeam;iPlayersInMyTeam = getPlayersNumInATeam(g_dUserData[id][iTeamID])
	get_players(iPlayers, playerCount, "ach")
	if(!iPlayersInMyTeam && (playerCount < get_pcvar_num(g_pCvars[cMinPlayersToDuo])))
	{
		if(bShowMessage)
		{
			CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_TEAM_MIN_PLAYERS_DUO", get_pcvar_num(g_pCvars[cMinPlayersToDuo]))
			lockedSound(id)
		}
		return true
	}
	else if((iPlayersInMyTeam == 2) && (playerCount < get_pcvar_num(g_pCvars[cMinPlayersToThreesome])))
	{
		if(bShowMessage)
		{
			CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_TEAM_MIN_PLAYERS_THREESOME", get_pcvar_num(g_pCvars[cMinPlayersToThreesome]))
			lockedSound(id)
		}
		return true
	}
	else if((iPlayersInMyTeam == 3) && (playerCount < get_pcvar_num(g_pCvars[cMinPlayersToSquad])))
	{
		if(bShowMessage)
		{
			CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_TEAM_MIN_PLAYERS_SQUAD", get_pcvar_num(g_pCvars[cMinPlayersToSquad]))
			lockedSound(id)
		}
		return true
	}
		
	if(iPlayersInMyTeam >= min(get_pcvar_num(g_pCvars[cMaxPlayersInATeam]), MAX_PLAYERS_PER_TEAM))
	{
		if(bShowMessage)
		{
			if(iInviteID)
			{
				CC_SendMatched(iInviteID, CC_COLOR_RED, "^x03%L", iInviteID, "SERVER_TEAM_FULL2", g_dUserData[id][szName])
				lockedSound(iInviteID)
			}
			else
			{
				CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_TEAM_FULL")
				lockedSound(id)
			}
		}
		return true
	}
	return false
}

createSpr(id)
{
	removeMateSpr(id)
	
	g_dUserData[id][iTeammateSpr] = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "env_sprite"))
	if(pev_valid(g_dUserData[id][iTeammateSpr]))
	{	
		static Float:fOrigin[3]
		pev(id, pev_origin, fOrigin)
		fOrigin[2] += 40.0
		
		set_pev(g_dUserData[id][iTeammateSpr], pev_owner, id)
		set_pev(g_dUserData[id][iTeammateSpr], pev_aiment, id)
		set_pev(g_dUserData[id][iTeammateSpr], pev_takedamage, 0.0)
		set_pev(g_dUserData[id][iTeammateSpr], pev_solid, SOLID_NOT)
		set_pev(g_dUserData[id][iTeammateSpr], pev_movetype, MOVETYPE_FOLLOW)

		engfunc(EngFunc_SetOrigin, g_dUserData[id][iTeammateSpr], fOrigin)
		engfunc(EngFunc_SetModel, g_dUserData[id][iTeammateSpr], g_szSpriteName)
			
		set_pev(g_dUserData[id][iTeammateSpr], pev_rendermode, kRenderTransAlpha)
		set_pev(g_dUserData[id][iTeammateSpr], pev_renderamt, 0.0)

		bitarray_set(g_baTeamSprites, g_dUserData[id][iTeammateSpr])
	}
	else g_dUserData[id][iTeammateSpr] = 0
}

removeMateSpr(id)
{
	if(g_dUserData[id][iTeammateSpr])
	{
		remove_entity(g_dUserData[id][iTeammateSpr])
		bitarray_clear(g_baTeamSprites, g_dUserData[id][iTeammateSpr])
		
		g_dUserData[id][iTeammateSpr] = 0
	}
}

showMates(idToShow)
{
	new iPlayers[MAX_PLAYERS], playerCount, iOrigins[3], szHudInfo[135]
	get_players(iPlayers, playerCount, "ach")
	for(new i, iPlayer, szKnockedMatesFmt[110]; i < playerCount; i++)
	{
		iPlayer = iPlayers[i]
		
		if(iPlayer == idToShow)
			continue
			
		if(isTeammate(iPlayer, idToShow))
		{	
			if(__is_user_alive(idToShow))
			{
				get_user_origin(iPlayer, iOrigins)

				message_begin(MSG_ONE_UNRELIABLE, g_mMessageHostagePos, .player = idToShow)
				write_byte(idToShow)
				write_byte(iPlayer)
				write_coord(iOrigins[0])
				write_coord(iOrigins[1])
				write_coord(iOrigins[2])
				message_end()

				message_begin(MSG_ONE_UNRELIABLE, g_mMessageHostageK, .player = idToShow)
				write_byte(iPlayer)
				message_end()
			}

			if(g_dUserData[iPlayer][bKnockedOut])
			{
				formatex(szKnockedMatesFmt, charsmax(szKnockedMatesFmt), "(%L)", idToShow, "SERVER_MATE_KNOCKED")
			}
			formatex(szHudInfo, charsmax(szHudInfo), "%s%s - %d HP %s^n", szHudInfo, g_dUserData[iPlayer][szName], get_user_health(iPlayer), g_dUserData[iPlayer][bKnockedOut] ? szKnockedMatesFmt : "")
		}
	}
	
	if(user_has_weapon(idToShow, CSW_KNIFE))
	{
		set_dhudmessage(255, 255, 255, 0.02, 0.22, 0, 1.0, 0.5)
		show_dhudmessage(idToShow, szHudInfo)
	}
}

barTime(id, iTarget = 0, iTime)
{
	if(is_user_connected(iTarget))
	{
		message_begin(MSG_ONE, g_mMessageBarTime, .player = iTarget)
		write_short(iTime)
		message_end()  
	}

	if(is_user_connected(id))
	{
		message_begin(MSG_ONE, g_mMessageBarTime, .player = id)
		write_short(iTime)
		message_end() 
	}
}

createBlast(Float:fStartOrigin[3], Float:fValue, iRGB[3] = {255, 255, 255})
{
	message_begin_fl(MSG_PVS, SVC_TEMPENTITY, fStartOrigin, 0)
	write_byte(TE_BEAMCYLINDER)
	write_coord_fl(fStartOrigin[0])
	write_coord_fl(fStartOrigin[1])
	write_coord_fl(fStartOrigin[2])
	write_coord_fl(fStartOrigin[0])
	write_coord_fl(fStartOrigin[1])
	write_coord_fl(fStartOrigin[2] + fValue)
	write_short(g_iExplosionSprite)
	write_byte(0)
	write_byte(3)
	write_byte(10)
	write_byte(80)
	write_byte(0)
	write_byte(iRGB[0])
	write_byte(iRGB[1])
	write_byte(iRGB[2])
	write_byte(100)
	write_byte(0)
	message_end()
}

// Code took from Weapon Physics edited by me.
impulseEntity(iVictim, iInflictor, iAttacker, Float:fRadius)
{
	static Float:fEntityVelocity[3], Float:fEntityOrigin[3], Float:fGrenadeOrigin[3], Float:fTemp[3]
	pev(iVictim, pev_velocity, fEntityVelocity)
	pev(iVictim, pev_origin, fEntityOrigin)
	pev(iInflictor, pev_origin, fGrenadeOrigin)
	xs_vec_sub(fEntityOrigin, fGrenadeOrigin, fTemp)
	xs_vec_normalize(fTemp, fTemp)
	xs_vec_mul_scalar(fTemp, fRadius, fTemp)
	xs_vec_mul_scalar(fTemp, get_pcvar_float(g_pCvars[cImpulseMultiplier]), fTemp)
	xs_vec_add(fEntityVelocity, fTemp, fEntityVelocity)
	set_pev(iVictim, pev_velocity, fEntityVelocity)

	if(!is_user_connected(iVictim))
		return
		
	g_dUserData[iAttacker][iPlayerWeaponID] = CSW_SMOKEGRENADE
	new Float:fDamage = (fRadius / 22.5)
	
	if(floatround(fDamage) >= get_user_health(iVictim))
	{
		if(iAttacker != iVictim)
		{
			executeKill(iVictim, iAttacker)
		}
		else
		{
			user_silentkill(iAttacker)
		}
		return
	}
	else setBeamFollow(iVictim, {255, 255, 255}, 100)

	g_dUserData[iVictim][iImpulserID] = iAttacker
	ExecuteHam(Ham_TakeDamage, iVictim, iInflictor, iAttacker, fDamage, DMG_HE)
}

giveWeapons(id, iType, iTouched, iEntityID = 0, iValue = 0, iCmdItemLevel = 0, bool:bPressUseCheck = false)
{
	if(!__is_user_alive(id) || g_dUserData[id][bCantPickup] || g_dUserData[id][bKnockedOut])
		return false
	
	static Float:fGameTime;fGameTime = get_gametime()
	if((fGameTime - g_dUserData[id][fUserGameTime2]) < PICKUP_DELAY)
	{
		return false
	}

	switch(iType)
	{
		case 0:
		{
			new iTouchedItemID = iEntityID ? iEntityID : pev(iTouched, pev_iuser1), iItemLevel = iCmdItemLevel ? iCmdItemLevel : pev(iTouched, pev_iuser2), iItemLife = iValue ? iValue : pev(iTouched, pev_iuser3)
			if(!iItemLevel)
			{
				iItemLevel = 3
			}
			
			static Float:fOrigin[3]
			pev(id, pev_origin, fOrigin)
			
			if((iTouchedItemID == g_szItens[iKevlarLv1][iItemID]) || (iTouchedItemID == g_szItens[iKevlarLv2][iItemID]) || (iTouchedItemID == g_szItens[iKevlarLv3][iItemID]))
			{
				new CsArmorType:iUserKevlar, iPlayerArmor = cs_get_user_armor(id, iUserKevlar)
				if(iPlayerArmor && (iItemLife <= iPlayerArmor))
				{
					if((fGameTime - g_dUserData[id][fUserGameTime]) >= MESSAGE_DELAY)
					{
						g_dUserData[id][fUserGameTime] = _:fGameTime
						CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_LOWER_LEVEL")
						lockedSound(id)
					}
					return false
				}

				if(g_dUserData[id][iArmorLevel])
				{
					spawnItens(fOrigin, getItemIDType(id, 1), g_dUserData[id][iArmorLevel], .id = id, .iPev3 = floatround(entity_get_float(id, EV_FL_armorvalue)))
				}
						
				equipedHud(id, _, "%L lv. %d", id, "SERVER_ITEM_KEVLAR", iItemLevel)
				cs_set_user_armor(id, iItemLife, CS_ARMOR_KEVLAR)
				clientPlaySound(id, g_szSoundsData[sAmmoPickup], true, .iChannel = CHAN_BODY)
						
				g_dUserData[id][iArmorLevel] = iItemLevel
			}
			else if(iTouchedItemID == g_szItens[iMedKit][iItemID])
			{
				if(checkItensNum(id))
				{
					return false
				}
					
				g_dUserData[id][iMedKits]++

				equipedHud(id, g_szItens[iMedKit][iItemID], "MedKit")
				clientPlaySound(id, g_szSoundsData[sGunPickup], true, .iChannel = CHAN_BODY)
			}
			else if((iTouchedItemID == g_szItens[iHelmetLv1][iItemID]) || (iTouchedItemID == g_szItens[iHelmetLv2][iItemID]) || (iTouchedItemID == g_szItens[iHelmetLv3][iItemID]))
			{
				if(pev_valid(g_dUserData[id][iHelmetEnt]) && (pev(g_dUserData[id][iHelmetEnt], pev_iuser3) >= iItemLife))
				{
					if((fGameTime - g_dUserData[id][fUserGameTime]) >= MESSAGE_DELAY)
					{
						g_dUserData[id][fUserGameTime] = _:fGameTime
						CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_LOWER_LEVEL")
						lockedSound(id)
					}
					return false
				}
					
				new iEnt = create_entity("info_target")
				if(pev_valid(iEnt))
				{
					if(g_dUserData[id][iHelmetLevel])
					{	
						spawnItens(fOrigin, getItemIDType(id, 0), g_dUserData[id][iHelmetLevel], .id = id, .iPev3 = pev(g_dUserData[id][iHelmetEnt], pev_iuser3))
						removeHelmet(id)
					}
							
					g_dUserData[id][iHelmetEnt] = iEnt
					g_dUserData[id][iHelmetLevel] = iItemLevel
							
					set_pev(iEnt, pev_movetype, MOVETYPE_FOLLOW)
					set_pev(iEnt, pev_aiment, id)
					set_pev(iEnt, pev_iuser3, iItemLife)
							
					engfunc(EngFunc_SetModel, iEnt, g_szItens[iItensList:getItemIDType(id, 0)][szItemModel])

					equipedHud(id, _, "%L lv. %d", id, "SERVER_ITEM_HELMET", iItemLevel)
					clientPlaySound(id, g_szSoundsData[sGunPickup], true, .iChannel = CHAN_BODY)
				}
			}
			else if((iTouchedItemID == g_szItens[iBagLv1][iItemID]) || (iTouchedItemID == g_szItens[iBagLv2][iItemID]) || (iTouchedItemID == g_szItens[iBagLv3][iItemID]))
			{
				if(iItemLevel < g_dUserData[id][iBagLevel])
				{
					if((fGameTime - g_dUserData[id][fUserGameTime]) >= MESSAGE_DELAY)
					{
						g_dUserData[id][fUserGameTime] = _:fGameTime
						CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_LOWER_LEVEL")
						lockedSound(id)
					}
					return false
				}
					
				if(iItemLevel != g_dUserData[id][iBagLevel])
				{						
					if(g_dUserData[id][iBagLevel])
					{
						spawnItens(fOrigin, getItemIDType(id, 2), g_dUserData[id][iBagLevel], .id = id)
					}
						
					g_dUserData[id][iBagLevel] = iItemLevel
						
					equipedHud(id, _, "%L lv. %d", id, "SERVER_ITEM_BAG", iItemLevel)
					clientPlaySound(id, g_szSoundsData[sGunPickup], true, .iChannel = CHAN_BODY)
				}
				else
				{
					if((fGameTime - g_dUserData[id][fUserGameTime]) >= MESSAGE_DELAY)
					{
						g_dUserData[id][fUserGameTime] = _:fGameTime
						CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_GOT_THE_SAME_ITEM_LEVEL")
						lockedSound(id)
					}
					return false
				}
			}
			else if(iTouchedItemID == g_szItens[iImpulseGrenade][iItemID])
			{
				if(checkItensNum(id))
				{
					return false
				}
					
				if(user_has_weapon(id, CSW_SMOKEGRENADE))
				{
					if((fGameTime - g_dUserData[id][fUserGameTime]) >= MESSAGE_DELAY)
					{
						g_dUserData[id][fUserGameTime] = _:fGameTime
						CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_ALREADY_HAS_IMPULSEGRENADE")
						lockedSound(id)
					}
					return false
				}
					
				give_item(id, "weapon_smokegrenade")
			}
			else if(iTouchedItemID == g_szItens[iGuspe][iItemID])
			{
				if(checkItensNum(id))
				{
					return false
				}

				if(g_dUserData[id][bHasGuspe])
				{
					if((fGameTime - g_dUserData[id][fUserGameTime]) >= MESSAGE_DELAY)
					{
						g_dUserData[id][fUserGameTime] = _:fGameTime
						CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_ALREADY_HAS_X_ITEM", "Guspe")
						lockedSound(id)
					}
					return false
				}
					
				g_dUserData[id][bHasGuspe] = true

				equipedHud(id, g_szItens[iGuspe][iItemID], "Guspe")
				clientPlaySound(id, g_szSoundsData[sGunPickup], true, .iChannel = CHAN_BODY)
			}
			else if(iTouchedItemID == g_szItens[iChugJug][iItemID])
			{
				if(checkItensNum(id))
				{
					return false
				}

				if(g_dUserData[id][bHasChugJug])
				{
					if((fGameTime - g_dUserData[id][fUserGameTime]) >= MESSAGE_DELAY)
					{
						g_dUserData[id][fUserGameTime] = _:fGameTime
						CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_ALREADY_HAS_X_ITEM", "Chug Jug")
						lockedSound(id)
					}
					return false
				}

				g_dUserData[id][bHasChugJug] = true

				equipedHud(id, g_szItens[iChugJug][iItemID], "Chug Jug")
				clientPlaySound(id, g_szSoundsData[sGunPickup], true, .iChannel = CHAN_BODY)
			}
			else if(iTouchedItemID == g_szItens[iWall][iItemID])
			{
				if(checkItensNum(id))
				{
					return false
				}

				if(g_dUserData[id][bHasWall])
				{
					if((fGameTime - g_dUserData[id][fUserGameTime]) >= MESSAGE_DELAY)
					{
						g_dUserData[id][fUserGameTime] = _:fGameTime
						CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_ALREADY_HAS_X_ITEM", "Wall")
						lockedSound(id)
					}
					return false
				}

				g_dUserData[id][bHasWall] = true

				equipedHud(id, g_szItens[iWall][iItemID], "Wall")
				clientPlaySound(id, g_szSoundsData[sGunPickup], true, .iChannel = CHAN_BODY)
			}
			else if(pubnite_is_customitem(iTouchedItemID))
			{
				if(checkItensNum(id))
				{
					return false
				}

				if(pubnite_has_customitem(id, iTouchedItemID))
				{
					if((fGameTime - g_dUserData[id][fUserGameTime]) >= MESSAGE_DELAY)
					{
						g_dUserData[id][fUserGameTime] = _:fGameTime

						new szCustomItemName[MAX_PLAYERS]
						pubnite_customitemname_by_id(iTouchedItemID, szCustomItemName)

						CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_ALREADY_HAS_X_ITEM", szCustomItemName)
						lockedSound(id) 
					}
					return false
				}

				ExecuteForward(g_forwardCustomItemTouched, g_iReturn, id, iTouched, iTouchedItemID, iItemLife, bPressUseCheck)
				return true
			}
			killEntity(iTouched)
		}
		case 1:
		{		
			new iCswWeapon = pev(iTouched, pev_iuser1)
			new bool:bHasWeapon = bool:user_has_weapon(id, iCswWeapon), bool:bIsNotFlashBang = (iCswWeapon != CSW_FLASHBANG)
			if(isGrenade(iCswWeapon) && bHasWeapon && bIsNotFlashBang)
				return false
			
			new iSlot = getWeaponBoxSlot(iCswWeapon)
			if(1 <= iSlot <= 2)
			{
				new iWeapon = getWeaponBoxID(id, iSlot)
				if(iWeapon > 0)
				{
					if(bPressUseCheck)
					{
						dropWeapon(iWeapon, id, iCswWeapon)
					}
					else return false
				}
			}

			if(!bPressUseCheck)
			{
				if(checkItensNum(id))
					return false
			}
			
			new iCustomBpAmmo = pev(iTouched, pev_iuser3)
			new iBpAmmo = iCustomBpAmmo ? iCustomBpAmmo : getMaxBpAmmo(iCswWeapon)

			new szWeap[MAX_PLAYERS]
			get_weaponname(iCswWeapon, szWeap, charsmax(szWeap))

			new iWeapEnt = give_item(id, szWeap)
			if(iWeapEnt > 0)
			{
				set_pev(iWeapEnt, pev_iuser4, (g_iWeaponRarityValue[id][iCswWeapon] = pev(iTouched, pev_iuser4)))
			}
			
			if(!bIsNotFlashBang && bHasWeapon)
			{
				cs_set_user_bpammo(id, CSW_FLASHBANG, 2)
			}
			else cs_set_user_bpammo(id, iCswWeapon, iCustomBpAmmo ? iCustomBpAmmo : random_num((iBpAmmo > 2) ? (iBpAmmo / 2) : iBpAmmo, iBpAmmo))
			
			if(!g_dUserData[id][bCanSeeRarities])
			{
				setScreenFadeAcordingToRarity(id, iTouched)
			}
			printRarityInfo(id, g_iWeaponRarityValue[id][iCswWeapon], iCswWeapon)
			killEntity(iTouched)
		}
	}
	g_dUserData[id][fUserGameTime2] = _:fGameTime
	return true
}

public ham_AddPlayerItem_Post(id, iItem)
{
	static szClassName[MAX_PLAYERS], iWeaponID
	pev(iItem, pev_classname, szClassName, charsmax(szClassName))
	if(equal(szClassName, "weapon_", 7) && (iWeaponID = cs_get_weapon_id(iItem)) < CSW_VEST)
	{
		if((g_iWeaponRarityValue[id][iWeaponID] = pev(iItem, pev_iuser4)))
		{
			if(!g_dUserData[id][bCanSeeRarities])
			{
				setScreenFadeAcordingToRarity(id, iItem)
			}
			printRarityInfo(id, g_iWeaponRarityValue[id][iWeaponID], iWeaponID)
		}
	}
	return HAM_IGNORED
}

getWeaponBoxSlot(iWeaponID)
{
	new iReturnValue
	if(isPrimaryWeapon(iWeaponID))
	{
		iReturnValue = 1
	}
	else if((1 << iWeaponID) & CONST_PISTOLS)
	{
		iReturnValue = 2
	}
	return iReturnValue
}

dropPlayer(id)
{
	resetUserSpeed(id)
	set_pev(id, pev_gravity, 1.0)
	
	ExecuteForward(g_forwardPlayerBusDrop, g_iReturn, id)
	if(get_pcvar_num(g_pCvars[cPlayerTrail]))
	{
		setBeamFollow(id, {255, 255, 255}, 192)
	}
	
	set_task(1.5, "setPlayerDamageble", id + TASK_SET_DAMAGEBLE, .flags = "b")

	clientStopSound(id)
	clientPlaySound(id, g_szSoundsData[sSkyDiveSound], true, .iChannel = CHAN_WEAPON)
	clientPlaySound(id, g_szSoundsData[sPlaneDropSound])

	if(g_dUserData[id][iTeamID])
	{
		clientPlaySound(id, g_szSoundsData[sTeammateDropSound], .bToAllMates = true)
	}
	
	new iPlayers[MAX_PLAYERS], iNum
	get_players(iPlayers, iNum, "ch")
	for(new i, iPlayer;i < iNum;i++)
	{	
		iPlayer = iPlayers[i] 
		CC_SendMatched(iPlayer, CC_COLOR_RED, "%L", iPlayer, "SERVER_SAID_THANKS", g_dUserData[id][szName])
	}	
	clientPlaySound(id, g_szSoundsData[sThanksSound], true, .iChannel = CHAN_BODY)

	g_dUserData[id][bIsOnPlane] = false
	g_dUserData[id][bCanUseParachute] = true
}

public setPlayerDamageble(id)
{
	id -= TASK_SET_DAMAGEBLE
	
	new Float:fOrigin[3]
	pev(id, pev_origin, fOrigin)
	
	new iPlayer = -1, bool:bNoOneAround = true
	while(is_user_valid(iPlayer = find_ent_in_sphere(iPlayer, fOrigin, 65.0)))
	{
		if(__is_user_alive(iPlayer) && (iPlayer != id))
		{
			bNoOneAround = false
		}
	}
	
	static iTimesChecked[MAX_PLAYERS + 1]
	const iMaxChecks = 4
	if(bNoOneAround)
	{
		iTimesChecked[id] = 0
		makePlayerVisible(id)
	}
	else 
	{
		if(++iTimesChecked[id] >= iMaxChecks)
		{
			iTimesChecked[id] = 0
			makePlayerVisible(id)
		}
	}
}

makePlayerVisible(id)
{
	setInvisibility(id, kRenderNormal)
	setDamageble(id, true)
	remove_task(id + TASK_SET_DAMAGEBLE)
}

setBeamFollow(id, iRGB[3], iIntensity)
{
	if(!is_user_connected(id))
		return

	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(TE_BEAMFOLLOW)
	write_short(id)
	write_short(g_iPlayerTrailSprite)
	write_byte(4)
	write_byte(3)
	write_byte(iRGB[0])
	write_byte(iRGB[1])
	write_byte(iRGB[2])
	write_byte(iIntensity)
	message_end()
}

startBleeding(id)
{
	new Float:fOrigin[3], iOrigin[3]
	pev(id, pev_origin, fOrigin)

	iOrigin[0] = floatround(fOrigin[0])
	iOrigin[1] = floatround(fOrigin[1])
	iOrigin[2] = floatround(fOrigin[2])

	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(TE_BLOODSTREAM)
	write_coord(iOrigin[0])
	write_coord(iOrigin[1])
	write_coord(iOrigin[2] + 10)
	write_coord(random_num(-360, 360))
	write_coord(random_num(-360, 360)) 
	write_coord(-10) 
	write_byte(70)
	write_byte(random_num(50, 100))
	message_end()

	for(new i;i < BLEEDS_NUM; i++) 
	{
		message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
		write_byte(TE_WORLDDECAL)
		write_coord(iOrigin[0] + random_num(-100, 100))
		write_coord(iOrigin[1] + random_num(-100, 100))
		write_coord(iOrigin[2] - 36)
		write_byte(190)
		message_end()
	}
}

cleanData(id, iTarget, bool:bUnknock = false)
{	
	if(bUnknock)
	{
		g_dUserData[iTarget][bKnockedOut] = false
		g_dUserData[iTarget][iWeaponKnocker] = 0
		g_dUserData[iTarget][iKnockerID] = 0

		remove_task(iTarget + TASK_REMOVEHEALTH)
		client_cmd(iTarget, "lastinv")
		
		resetUserSpeed(iTarget)

		ScreenFade(id, {200, 200, 200}, 75)
		ScreenFade(iTarget, {255, 255, 255}, 105)
		set_user_health(iTarget, get_pcvar_num(g_pCvars[cUnknockHealth]))
	}
	else
	{
		if(task_exists(id + TASK_KNOCK))
		{
			remove_task(id + TASK_KNOCK)
		}
	}
	g_dUserData[id][iHelpingID] = 0
	g_dUserData[iTarget][iHelperID] = 0

	barTime(id, iTarget, 0)
}

public fnSortPseudoRandom2D(_:a1[], _:a2[])
{
	switch(random_num(0, 60))
	{
		case 0 .. 29: return -1
		case 30: return 0
	}
	return 1
}

public spawnWeapons()
{
	new iEnt, iRandom
	if(g_iVecsNum[vecChests] && g_iChestNum < g_iChestNumRound)
	{
		iEnt = create_entity("info_target")
		if(pev_valid(iEnt))
		{
			engfunc(EngFunc_SetOrigin, iEnt, g_fChestPoints[g_iChestNum++])
			engfunc(EngFunc_SetModel, iEnt, g_szModelsData[mChestModel])
			engfunc(EngFunc_SetSize, iEnt, Float:{-25.0, -22.0, -0.1}, Float:{25.0, 22.0, 30.0})

			set_pev(iEnt, pev_classname, g_szClassNamesData[cChest])
			set_pev(iEnt, pev_solid, SOLID_SLIDEBOX) 
			set_pev(iEnt, pev_movetype, MOVETYPE_TOSS)
			set_pev(iEnt, pev_gravity, 1.0)

			drop_to_floor(iEnt)

			setRendering(iEnt, kRenderFxGlowShell, Float:{220.0, 80.0, 0.0}, 50.0)
			clientPlaySound(iEnt, g_szSoundsData[sChestSound], true, .fNewVolume = 0.15)

			if(!task_exists(TASK_RE_EMITSOUND))
			{
				set_task(7.0, "reEmitChest", TASK_RE_EMITSOUND, .flags = "b")
			}
		}
	}

	iEnt = create_entity("info_target")
	if(pev_valid(iEnt))
	{
		engfunc(EngFunc_SetOrigin, iEnt, g_fSpawnVecs[g_iSpawnedWeapNum++])
		
		set_pev(iEnt, pev_solid, SOLID_TRIGGER) 
		set_pev(iEnt, pev_gravity, 1.0)
		set_pev(iEnt, pev_movetype, MOVETYPE_TOSS)
		set_pev(iEnt, pev_classname, g_szClassNamesData[cWeapons])
		
		if(random_mod(WEAPONS_CHANCE) < 3)
		{
			iRandom = random_mod(g_iWeaponsNum)
			
			engfunc(EngFunc_SetModel, iEnt, g_szWeaponsModels[iRandom][szModelName])
			set_pev(iEnt, pev_iuser1, g_szWeaponsModels[iRandom][iWeaponInfoID])
			
			new iRarity
			switch(g_szWeaponsModels[iRandom][iWeaponInfoID])
			{
				case CSW_FLASHBANG:							iRarity = RARITY_GREEN
				case CSW_HEGRENADE:							iRarity = RARITY_PURPLE
				case CSW_USP, CSW_DEAGLE:						iRarity = random_mod(RARITY_GREEN) + 4 // Purple to Gold
				case CSW_MP5NAVY, CSW_P90, CSW_MAC10, CSW_UMP45, CSW_M3, CSW_XM1014:	iRarity = random_mod(RARITY_BLUE) + 3; // Blue to Gold
				default:
				{
					switch(random_num(0, 22))
					{
						case 11..16:	iRarity = RARITY_GREEN
						case 6..10:	iRarity = RARITY_BLUE
						case 2..5:	iRarity = RARITY_PURPLE
						case 0..1:	iRarity = RARITY_GOLD
						default:	iRarity = RARITY_GREY
					}
				}
			}
			set_pev(iEnt, pev_iuser4, iRarity)
		}
		else
		{
			new bool:bIsNotCustomItem = bool:(random_num(0, 2) > 0)
			if(!bIsNotCustomItem && !pubnite_get_customitem_num())
			{
				bIsNotCustomItem = true
			}	
			new iRandomLevel, iItemInfoID, szItemModelSet[MAX_MODEL_LENGTH]
			
			if(bIsNotCustomItem)
			{
				iRandom = random_mod(sizeof(g_szItens))
				if(!g_szItens[iItensList:iRandom][bIsItemEnabled])
				{
					g_iSpawnedWeapNum--
					remove_entity(iEnt)
					return
				}
					
				iRandomLevel = g_szItens[iItensList:iRandom][iItemInfoLevel]
				iItemInfoID = g_szItens[iItensList:iRandom][iItemID]
				
				copy(szItemModelSet, charsmax(szItemModelSet), g_szItens[iItensList:iRandom][szItemModel])
				
				set_pev(iEnt, pev_iuser2, iRandomLevel)
				set_pev(iEnt, pev_iuser3, getItemLife(iItemInfoID, iRandomLevel))
			}
			else
			{
				new iCustomItemRarity
				pubnite_get_customitem_data(random(pubnite_get_customitem_num()), iItemInfoID, iCustomItemRarity, szItemModelSet)

				set_pev(iEnt, pev_iuser3, pubnite_get_customitem_life(iItemInfoID))
				set_pev(iEnt, pev_iuser4, iCustomItemRarity)
			}
			
			set_pev(iEnt, pev_iuser1, iItemInfoID)
			engfunc(EngFunc_SetModel, iEnt, szItemModelSet)
			
			if(!bIsNotCustomItem)
			{
				ExecuteForward(g_forwardCustomItemCreated, g_iReturn, iEnt, iItemInfoID)
			}
		}
	}
	else
	{
		// Error while spawning weapons
		remove_task(TASK_ADD_WEAPONS)
	}
}

public reEmitChest()
{
	new iEnt = -1, iChestsFound
	while((iEnt = find_ent_by_class(iEnt, g_szClassNamesData[cChest])))
	{
		if(pev_valid(iEnt))
		{
			iChestsFound++
			clientPlaySound(iEnt, g_szSoundsData[sChestSound], true, .fNewVolume = 0.15)
		}
	}
	
	if(!iChestsFound)
	{
		remove_task(TASK_RE_EMITSOUND)
	}
}

roundEnd(id = 0, iMate = 0)
{
	removeTasks()
	if(g_bHasRoundEnded)
		return
		
	g_bHasRoundEnded = true
	
	new iPlayers[MAX_PLAYERS], iNum, iPlayer
	get_players(iPlayers, iNum, "ch")
	
	new iNewRound = get_pcvar_num(g_pCvars[cNewRoundTime])
	if(iNum <= 1 || !__is_user_alive(id))
	{
		for(new i;i < iNum;i++)
		{
			iPlayer = iPlayers[i]

			CC_SendMatched(iPlayer, CC_COLOR_GREY, "%L", iPlayer, "SERVER_NO_WINNER")
			CC_SendMatched(iPlayer, CC_COLOR_GREY, "^x03--------------------------------------------------------------------------")
			CC_SendMatched(iPlayer, CC_COLOR_GREY, "%L", iPlayer, "SERVER_NEW_ROUND_MSG", iNewRound)
		}
		set_task(float(iNewRound), "restartRound", 1)
		return
	}

	new iWinners[MAX_PLAYERS_PER_TEAM], iWinnersNum, szMessage[100], iUserKills = g_dUserData[id][iKills]
	new dUserData:iWinType = iVitoriasSolo

	iWinners[iWinnersNum++] = id
	g_dUserData[id][iWinType]++
	g_dUserData[id][iUserVBucks] += get_pcvar_num(g_pCvars[cWinVBucks])
	
	if(iMate)
	{
		switch(getPlayersNumInATeam(g_dUserData[id][iTeamID]))
		{
			case 2: 	iWinType = iVitoriasDuo
			case 3, 4: 	iWinType = iVitoriasSquad
		}
		
		for(new i;i < iNum;i++)
		{
			iPlayer = iPlayers[i]
			
			if((id != iPlayer) && isTeammate(id, iPlayer))
			{
				if(iWinnersNum < sizeof iWinners)
				{
					iWinners[iWinnersNum++] = iPlayer
				}
				g_dUserData[iPlayer][iWinType]++
				
				checkTasks(iPlayer)
				saveData(iPlayer)
				setDamageble(iPlayer, false)
			}
				
			CC_SendMatched(iPlayer, CC_COLOR_GREY, "%L", iPlayer, "SERVER_PLAYER_TEAM_WIN_MSG")
			CC_SendMatched(iPlayer, CC_COLOR_GREY, "^x03--------------------------------------------------------------------------")
		}
	}
	else
	{
		CC_SendMatched(id, CC_COLOR_GREY, "%L", id, "SERVER_PLAYER_SOLO_WIN_MSG", iUserKills, (iUserKills > 1) ? "s" : "")
		CC_SendMatched(id, CC_COLOR_GREY, "^x03 --------------------------------------------------------------------------")
	}
	new iArrayPass = PrepareArray(iWinners, sizeof iWinners, 0)
	ExecuteForward(g_forwardGameWinner, g_iReturn, iArrayPass, iWinnersNum)
	
	checkTasks(id)
	saveData(id)
	setDamageble(id, false)
		
	for(new i;i < iNum;i++)
	{
		iPlayer = iPlayers[i]

		if(isTeam(iPlayer))
		{
			g_dUserData[iPlayer][iUserFrags] = get_user_frags(iPlayer)
			g_dUserData[iPlayer][iUserDeaths] = cs_get_user_deaths(iPlayer)
		}

		formatex(szMessage, charsmax(szMessage), "%L", iPlayer, iMate ? "SERVER_TEAM_WIN_MSG" : "SERVER_SOLO_WIN_MSG", g_dUserData[id][szName])
		CC_SendMatched(iPlayer, CC_COLOR_GREY, "%s %L", szMessage, iPlayer, "SERVER_NEW_ROUND_MSG", iNewRound)
	
		if(ArraySize(g_arWinSounds))
		{
			new szSound[MAX_MODEL_LENGTH]
			ArrayGetString(g_arWinSounds, random_num(0, ArraySize(g_arWinSounds) - 1), szSound, charsmax(szSound))

			if(__is_user_alive(iPlayer) || !g_dUserData[iPlayer][bRoundSounds]) 
				continue

			clientStopSound(iPlayer)
			clientPlaySound(iPlayer, szSound)
		}
	}
	set_task(float(iNewRound), "restartRound", 1)
}

removeTasks()
{
	remove_task(TASK_SPAWN_AIRDROP)
	remove_task(TASK_WEAPONS)
	remove_task(TASK_COUNTDOWN)
	remove_task(TASK_PLAYERSCOUNT)
	remove_task(TASK_ADD_WEAPONS)
	remove_task(TASK_PLANE)
	remove_task(TASK_RE_EMITSOUND)
}

fmCreatePlane(iEnt, szEntName[], szModel[], Float:fOrigin[3], Float:fVelocity[3], Float:fAngle[3])
{
	if(!pev_valid(iEnt))
		return

	engfunc(EngFunc_SetOrigin, iEnt, fOrigin)
	engfunc(EngFunc_SetModel, iEnt, szModel)
	
	set_pev(iEnt, pev_movetype, MOVETYPE_FLY)
	set_pev(iEnt, pev_solid, SOLID_NOT) 
	set_pev(iEnt, pev_velocity, fVelocity)
	set_pev(iEnt, pev_angles, fAngle)
	set_pev(iEnt, pev_classname, szEntName)
}

removeEntities()
{
	new iEnt
	while((iEnt = find_ent_by_class(iEnt, g_szClassNamesData[cWeapons])))
	{
		remove_entity(iEnt)
	}
	
	while((iEnt = find_ent_by_class(iEnt, g_szClassNamesData[cTransporter])))
	{
		remove_entity(iEnt)
	}
	
	while((iEnt = find_ent_by_class(iEnt, g_szClassNamesData[cAirDrop])))
	{
		remove_entity(iEnt)
	}
	
	while((iEnt = find_ent_by_class(iEnt, g_szClassNamesData[cWall])))
	{
		remove_entity(iEnt)
	}
	
	while((iEnt = find_ent_by_class(iEnt, g_szClassNamesData[cChest])))
	{
		remove_entity(iEnt)
	}
}

public checkNum()
{	
	if(roundEnded())
	{
		new iLastPlayerID = getPlayersNum(1, 0)
		roundEnd(iLastPlayerID, g_dUserData[iLastPlayerID][iTeamID] ? ALL_MATES : 0)
	}
}

bool:roundEnded()
{
	if((getPlayersNum() <= 1) || ((getPlayersNum() <= getTeamWithMostPlayers()) && (getTeamsLeft() == 1)))
	{
		return true 
	}
	return false
}

getPlayersNum(iType = 0, iID = 0)
{
	new iPlayers[MAX_PLAYERS], iNum
	get_players(iPlayers, iNum, "ach")
	return iType ? iPlayers[iID] : iNum
}

checkHeadHits(id, iLevel)
{
	if(pev(g_dUserData[id][iHelmetEnt], pev_iuser3) <= 0)
	{
		CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_HELMET_TOOK_OFF_MSG", iLevel)

		set_hudmessage(255, 0, 0, -1.0, 0.3, 0, 1.0, 5.0)
		ShowSyncHudMsg(id, g_hHuds[hEquipedHud], "%L", id, "SERVER_HELMET_TOOK_OFF_HUD", iLevel)
						
		removeHelmet(id)
	}
}

removeHelmet(id)
{
	killEntity(g_dUserData[id][iHelmetEnt])
	
	g_dUserData[id][iHelmetLevel] = 0
	g_dUserData[id][iHelmetEnt] = 0	
}

getTeamsLeft()
{
	new iTeamNum
	for(new i; i < ArraySize(g_arTeams); i++)
	{
		if(getPlayersNumInATeam(ArrayGetCell(g_arTeams, i), true) > 0)
		{
			iTeamNum++
		}
	}
	return iTeamNum
}

getPlayersWithoutTeam(bool:bAlive = false)
{
	new iPlayers[MAX_PLAYERS], iNum, iPlayersNum
	get_players(iPlayers, iNum, (bAlive ? "ach" : "ch"))
	for(new i, iPlayer;i < iNum;i++)
	{
		iPlayer = iPlayers[i]
		if((!bAlive || __is_user_alive(iPlayer)) && !g_dUserData[iPlayer][iTeamID])
		{
			iPlayersNum++
		}
	}
	return iPlayersNum
}

ScreenFade(id, iRGB[3], iIntensity, iDuration = 4300, iHoldTime = 0, iFade = 0)
{ 
	if(!is_user_connected(id))
		return

	message_begin(MSG_ONE, g_mMessageScreenFade, .player = id)
	write_short(iDuration)
	write_short(iHoldTime)
	write_short(iFade)
	write_byte(iRGB[0])
	write_byte(iRGB[1]) 
	write_byte(iRGB[2]) 
	write_byte(iIntensity) 
	message_end()
}

checkTasks(id, bool:bKnockCheck = false)
{
	if(!bKnockCheck) 
		remove_task(id + TASK_REMOVEHEALTH)
		
	remove_task(id + TASK_KNOCK)
	remove_task(id + TASK_UP_PLAYER)
	remove_task(id + TASK_SET_DAMAGEBLE)
	remove_task(id + TASK_MEDKIT)
	remove_task(id + TASK_CHUG_JUG_HEAL)
	
	if(g_dUserData[id][iChestID])
	{
		stopUsageFeature(id, 2)
	}
	
	if(g_dUserData[id][iUserSupplyID])
	{
		stopUsageFeature(id, 3)
	}
}

saveData(id)
{
	new szAuthID[35]
	get_user_authid(id, szAuthID, charsmax(szAuthID))

	new szData[128]
	formatex(szData, charsmax(szData), "%i %i %i", g_dUserData[id][iVitoriasSolo], g_dUserData[id][iVitoriasDuo], g_dUserData[id][iVitoriasSquad])
	fvault_set_data(g_szFVaultSave, szAuthID, szData)

	formatex(szData, charsmax(szData), "%i", g_dUserData[id][iUserVBucks])
	fvault_set_data(g_szFVaultVBucks, szAuthID, szData)
}

loadData(id) 
{
	new szAuthID[35]
	get_user_authid(id, szAuthID, charsmax(szAuthID))

	new szData[128], szWins[4][7]
	if(fvault_get_data(g_szFVaultSave, szAuthID, szData, charsmax(szData)))
	{
		parse
		(
			szData,
			szWins[0], charsmax(szWins[]),
			szWins[1], charsmax(szWins[]),
			szWins[2], charsmax(szWins[]),
			szWins[3], charsmax(szWins[])
		)
		g_dUserData[id][iVitoriasSolo] = str_to_num(szWins[0])
		g_dUserData[id][iVitoriasDuo] = str_to_num(szWins[1])
		g_dUserData[id][iVitoriasSquad] = str_to_num(szWins[2])
		g_dUserData[id][iUserVBucks] = str_to_num(szWins[3])
	}
	else 
	{
		g_dUserData[id][iVitoriasSolo] = g_dUserData[id][iVitoriasDuo] = g_dUserData[id][iVitoriasSquad] = 0
	}

	if(fvault_get_data(g_szFVaultVBucks, szAuthID, szData, charsmax(szData)))
	{
		g_dUserData[id][iUserVBucks] = str_to_num(szData)
	}
	else g_dUserData[id][iUserVBucks] = 0
}

getRandomPlaneDirection(Float:fOrigin[3], Float:fAngle[3], Float:fVelocity[3])
{
	g_iRandomDirection = random_num(0, g_iVecsNum[vecPlane] - 1)
	
	fOrigin[0] = 	g_fPlaneOrigins[g_iRandomDirection][0]
	fOrigin[1] = 	g_fPlaneOrigins[g_iRandomDirection][1]
	fOrigin[2] = 	g_fPlaneOrigins[g_iRandomDirection][2]
	
	fAngle[0] = 	g_fPlaneAngles[g_iRandomDirection][0]
	fAngle[1] = 	g_fPlaneAngles[g_iRandomDirection][1]
	fAngle[2] = 	g_fPlaneAngles[g_iRandomDirection][2]
	
	fVelocity[0] = 	g_fPlaneVelocities[g_iRandomDirection][0]
	fVelocity[1] = 	g_fPlaneVelocities[g_iRandomDirection][1]
	fVelocity[2] = 	g_fPlaneVelocities[g_iRandomDirection][2]
}

bool:checkItensNum(id)
{
	if(getMaxValue(id, 2) >= getMaxValue(id, 1))
	{
		new Float:fGameTime = get_gametime()
		if((fGameTime - g_dUserData[id][fUserGameTime]) >= MESSAGE_DELAY)
		{
			g_dUserData[id][fUserGameTime] = _:fGameTime
			CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_NO_ENOUGH_SPACE_MSG_1", g_cCommands[cBag])
					
			if(g_dUserData[id][iBagLevel] < 3)
			{
				CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_NO_ENOUGH_SPACE_MSG_2")
			}
			lockedSound(id)
		}
		return true
	}
	return false
}

getMaxBpAmmo(iWeapon)
{
	new iMaxBpAmmo
	switch(iWeapon)
	{
		case CSW_AK47, CSW_M4A1, CSW_FAMAS, CSW_GALIL, CSW_AUG, CSW_SG552, CSW_TMP: 	iMaxBpAmmo = 90
		case CSW_SCOUT, CSW_AWP: 							iMaxBpAmmo = 30
		case CSW_MP5NAVY: 								iMaxBpAmmo = 120
		case CSW_P90, CSW_MAC10, CSW_UMP45: 						iMaxBpAmmo = 100
		
		case CSW_M3, CSW_XM1014:							iMaxBpAmmo = 32

		case CSW_DEAGLE: 								iMaxBpAmmo = 35
		case CSW_USP, CSW_FIVESEVEN:							iMaxBpAmmo = 100
		case CSW_GLOCK18, CSW_ELITE:							iMaxBpAmmo = 120
		case CSW_P228:									iMaxBpAmmo = 52
	
		case CSW_HEGRENADE, CSW_FLASHBANG:						iMaxBpAmmo = 1
	}
	return iMaxBpAmmo
}

dropItems(id, bool:bBagCheck = false)
{
	new Float:fOrigin[3]
	pev(id, pev_origin, fOrigin)
	
	if(g_dUserData[id][iArmorLevel])
	{
		spawnItens(fOrigin, getItemIDType(id, 1), g_dUserData[id][iArmorLevel], .iPev3 = floatround(entity_get_float(id, EV_FL_armorvalue)))
		
		if(bBagCheck)
		{
			g_dUserData[id][iArmorLevel] = 0
			set_user_armor(id, 0)
			return
		}
	}
	
	for(new i, iCustomItemID;i < pubnite_get_customitem_num();i++)
	{
		pubnite_get_customitem_id(i, iCustomItemID)
		if(pubnite_has_customitem(id, iCustomItemID))
		{
			ExecuteForward(g_forwardCustomItemDropped, g_iReturn, id, iCustomItemID)
		}
	}
	
	if(g_dUserData[id][iMedKits])
	{
		for(new i;i < g_dUserData[id][iMedKits];i++)
		{
			spawnItens(fOrigin, g_szItens[iMedKit][iItemID])
		}
		
		if(bBagCheck)
		{
			g_dUserData[id][iMedKits] = 0
			return
		}
	}
	
	if(g_dUserData[id][iHelmetEnt])
	{
		spawnItens(fOrigin, getItemIDType(id, 0), g_dUserData[id][iHelmetLevel])
		
		if(bBagCheck)
		{
			removeHelmet(id)
			return
		}
	}
	
	if(g_dUserData[id][iBagLevel])
	{
		spawnItens(fOrigin, getItemIDType(id, 2), g_dUserData[id][iBagLevel])
	}
	
	if(user_has_weapon(id, CSW_SMOKEGRENADE))
	{
		spawnItens(fOrigin, g_szItens[iImpulseGrenade][iItemID])
		
		if(bBagCheck)
		{
			stripWeapon(id, "weapon_smokegrenade")
			return
		}
	}

	if(g_dUserData[id][bHasGuspe])
	{
		spawnItens(fOrigin, g_szItens[iGuspe][iItemID])
		
		if(bBagCheck)
		{
			g_dUserData[id][bHasGuspe] = false 
			return
		}
	}
	
	if(g_dUserData[id][bHasChugJug])
	{
		spawnItens(fOrigin, g_szItens[iChugJug][iItemID])
		
		if(bBagCheck)
		{
			g_dUserData[id][bHasChugJug] = false 
			return
		}
	}
	
	if(g_dUserData[id][bHasWall])
	{
		spawnItens(fOrigin, g_szItens[iWall][iItemID])
		
		if(bBagCheck)
		{
			g_dUserData[id][bHasWall] = false 
			return
		}
	}
}

getWeaponsNum(id)
{
	new szWeapons[MAX_PLAYERS], iNum, iWeaponsNum
	get_user_weapons(id, szWeapons, iNum)
	for(new i, iWeapon, szWeaponName[MAX_PLAYERS];i < iNum;i++)
	{
		iWeapon = szWeapons[i] 
		if(iWeapon == CSW_KNIFE)
			continue
			
		changeWeaponName(iWeapon, szWeaponName, id)
		if(szWeaponName[0])
		{
			iWeaponsNum++
		}
	}
	return iWeaponsNum
}

getUserItens(id)
{
	new iItensNum
	if(g_dUserData[id][iMedKits])
	{
		iItensNum = g_dUserData[id][iMedKits]
	}

	for(new i, iCustomItemID;i < pubnite_get_customitem_num();i++)
	{
		pubnite_get_customitem_id(i, iCustomItemID)
		if(pubnite_has_customitem(id, iCustomItemID))
		{
			iItensNum++
		}
	}
	
	if(g_dUserData[id][bHasGuspe])
	{
		iItensNum++
	}

	if(g_dUserData[id][bHasChugJug])
	{
		iItensNum++
	}
	
	if(g_dUserData[id][bHasWall])
	{
		iItensNum++
	}

	return iItensNum
}

spawnItens(Float:fOrigin[3], iType, iLevel = 0, id = 0, iPev3 = 0)
{
	if((iType == g_szItens[iHelmetLv1][iItemID])
	|| (iType == g_szItens[iHelmetLv2][iItemID])
	|| (iType == g_szItens[iHelmetLv3][iItemID]) && (iPev3 == 1))
		return
	
	new Float:fEntVelocity[3]
	if(__is_user_alive(id))
	{
		g_dUserData[id][bCantPickup] = true
		set_task(0.2, "resetPickup", id)
		
		velocity_by_aim(id, 400, fEntVelocity)
		fEntVelocity[2] = 100.0
	}
	else
	{
		fEntVelocity[0] = random_float(-250.0, 250.0)
		fEntVelocity[1] = random_float(-250.0, 250.0)
	}
	new iEnt = create_entity("info_target")
	engfunc(EngFunc_SetOrigin, iEnt, fOrigin)
	
	new szModel[MAX_MODEL_LENGTH], iPev4
	if(pubnite_is_customitem(iType))
	{
		pubnite_get_customitem_data(pubnite_find_customitem_which(iType), iType, iPev4, szModel)
	}
	else formatex(szModel, charsmax(szModel), g_szItens[iItensList:iType][szItemModel])
	engfunc(EngFunc_SetModel, iEnt, szModel)

	set_pev(iEnt, pev_velocity, fEntVelocity)
	set_pev(iEnt, pev_iuser1, iType)
	
	set_pev(iEnt, pev_solid, SOLID_TRIGGER)
	set_pev(iEnt, pev_gravity, 1.0)
	set_pev(iEnt, pev_movetype, MOVETYPE_TOSS)
	set_pev(iEnt, pev_classname, g_szClassNamesData[cWeapons])
	set_pev(iEnt, pev_iuser2, iLevel)
	set_pev(iEnt, pev_iuser3, iPev3)

	if(iPev4)
	{
		set_pev(iEnt, pev_iuser4, iPev4)
	}
}

public resetPickup(id) g_dUserData[id][bCantPickup] = false

equipedHud(id, iID = 0, szItem[], any:...)
{
	static szMsg[30]
	vformat(szMsg, charsmax(szMsg), szItem, 4)

	new szDescrip[55]
	if(iID == g_szItens[iMedKit][iItemID])		formatex(szDescrip, charsmax(szDescrip), "%L", id, "SERVER_MEDKIT_COMMAND_INFO")	
	else if(iID == g_szItens[iGuspe][iItemID])	formatex(szDescrip, charsmax(szDescrip), "%L", id, "SERVER_GUSPE_COMMAND_INFO")
	else if(iID == g_szItens[iChugJug][iItemID])	formatex(szDescrip, charsmax(szDescrip), "%L", id, "SERVER_CHUG_JUG_COMMAND_INFO")
	else if(iID == g_szItens[iWall][iItemID])	formatex(szDescrip, charsmax(szDescrip), "%L", id, "SERVER_WALL_COMMAND_INFO")
	
	set_hudmessage(255, 255, 255, -1.0, 0.3, 0, 1.0, 4.0)
	ShowSyncHudMsg(id, g_hHuds[hEquipedHud], "%s %L^n%s", szMsg, id, "SERVER_EQUIPED", szDescrip)
}

stripWeapon(id, szWeapon[])
{
	if(!equal(szWeapon, "weapon_", 7)) 
		return

	new iWeaponId = get_weaponid(szWeapon)
	if(!iWeaponId) 
		return

	new iEnt = -1
	while((iEnt = engfunc(EngFunc_FindEntityByString, iEnt, "classname", szWeapon)) && pev(iEnt, pev_owner) != id) {}
		
	if(!iEnt) 
		return
	
	if(get_user_weapon(id) == iWeaponId) 
	{
		ExecuteHamB(Ham_Weapon_RetireWeapon, iEnt)
	}
	
	if(!ExecuteHamB(Ham_RemovePlayerItem, id, iEnt)) 
		return
		
	ExecuteHamB(Ham_Item_Kill, iEnt)
	set_pev(id, pev_weapons, pev(id, pev_weapons) & ~(1 << iWeaponId))
}

getMaxValue(id, iReturnType)
{
	new cCvarReturn
	switch(iReturnType)
	{
		case 0:
		{
			switch(g_dUserData[id][iHelmetLevel])
			{
				case 1:		cCvarReturn = cLevel1HelmetHits
				case 2:		cCvarReturn = cLevel2HelmetHits
				case 3:		cCvarReturn = cLevel3HelmetHits
			}
		}
		case 1:
		{
			switch(g_dUserData[id][iBagLevel])
			{
				case 0: 	cCvarReturn = cLevelNoBagMax
				case 1:		cCvarReturn = cLevel1BagMax
				case 2:		cCvarReturn = cLevel2BagMax
				case 3:		cCvarReturn = cLevel3BagMax
			}
		}	
		case 2:		return (getUserItens(id) + getWeaponsNum(id))
	}
	return get_pcvar_num(g_pCvars[cCvarReturn])
}

setDamageble(id, bool:bDamageble)
{
	set_pev(id, pev_takedamage, bDamageble ? DAMAGE_AIM : DAMAGE_NO)
	set_pev(id, pev_solid, bDamageble ? SOLID_BBOX : SOLID_NOT)
}

changeWeaponName(iWeaponID, szWeaponName[MAX_PLAYERS], id = 0)
{
	switch(iWeaponID)
	{
		case CSW_AK47: 		formatex(szWeaponName, charsmax(szWeaponName), g_szWeaponsDisplayName[nAK47])
		case CSW_M4A1: 		formatex(szWeaponName, charsmax(szWeaponName), g_szWeaponsDisplayName[nM4A1])
		case CSW_AWP: 		formatex(szWeaponName, charsmax(szWeaponName), g_szWeaponsDisplayName[nAWP])
		case CSW_SCOUT: 	formatex(szWeaponName, charsmax(szWeaponName), g_szWeaponsDisplayName[nSCOUT])
		case CSW_FAMAS: 	formatex(szWeaponName, charsmax(szWeaponName), g_szWeaponsDisplayName[nFAMAS])
		case CSW_AUG: 		formatex(szWeaponName, charsmax(szWeaponName), g_szWeaponsDisplayName[nAUG])
		case CSW_SG552: 	formatex(szWeaponName, charsmax(szWeaponName), g_szWeaponsDisplayName[nSG552])
		case CSW_USP: 		formatex(szWeaponName, charsmax(szWeaponName), g_szWeaponsDisplayName[nUSP])
		case CSW_DEAGLE: 	formatex(szWeaponName, charsmax(szWeaponName), g_szWeaponsDisplayName[nDEAGLE])
		case CSW_XM1014: 	formatex(szWeaponName, charsmax(szWeaponName), g_szWeaponsDisplayName[nXM1014])
		case CSW_M3: 		formatex(szWeaponName, charsmax(szWeaponName), g_szWeaponsDisplayName[nM3])
		case CSW_HEGRENADE: 	formatex(szWeaponName, charsmax(szWeaponName), g_szWeaponsDisplayName[nHEGRENADE])
		case CSW_M249: 		formatex(szWeaponName, charsmax(szWeaponName), g_szWeaponsDisplayName[nM249])
		case CSW_MP5NAVY: 	formatex(szWeaponName, charsmax(szWeaponName), g_szWeaponsDisplayName[nMP5])
		case CSW_UMP45: 	formatex(szWeaponName, charsmax(szWeaponName), g_szWeaponsDisplayName[nUMP45])
		case CSW_P90: 		formatex(szWeaponName, charsmax(szWeaponName), g_szWeaponsDisplayName[nP90])
		case CSW_MAC10:		formatex(szWeaponName, charsmax(szWeaponName), g_szWeaponsDisplayName[nMAC10])
		case CSW_TMP:		formatex(szWeaponName, charsmax(szWeaponName), g_szWeaponsDisplayName[nTMP])
		case CSW_ELITE:		formatex(szWeaponName, charsmax(szWeaponName), g_szWeaponsDisplayName[nELITE])
		case CSW_P228:		formatex(szWeaponName, charsmax(szWeaponName), g_szWeaponsDisplayName[nP250])
		case CSW_GLOCK18:	formatex(szWeaponName, charsmax(szWeaponName), g_szWeaponsDisplayName[nGLOCK18])
		case CSW_GALIL:		formatex(szWeaponName, charsmax(szWeaponName), g_szWeaponsDisplayName[nGALIL])
		case CSW_G3SG1:		formatex(szWeaponName, charsmax(szWeaponName), g_szWeaponsDisplayName[nG3SG1])
		case CSW_SG550:		formatex(szWeaponName, charsmax(szWeaponName), g_szWeaponsDisplayName[nSG550])

		case CSW_KNIFE: 	formatex(szWeaponName, charsmax(szWeaponName), "%L", id, "SERVER_OWN_HANDS")
		case CSW_VEHICLE:	formatex(szWeaponName, charsmax(szWeaponName), "%L", id, "SERVER_VEHICLE")
		case CSW_SMOKEGRENADE:	formatex(szWeaponName, charsmax(szWeaponName), "Impulse Grenade")
	}
}

removeKnockInfo(iVictim)
{
	if(task_exists(iVictim + TASK_REMOVEHEALTH))
	{
		remove_task(iVictim + TASK_REMOVEHEALTH)
	}

	clientStopSound(iVictim)
	
	g_dUserData[iVictim][iKnockerID] = 0
	g_dUserData[iVictim][bKnockedOut] = false
}

getItemIDType(id, idItem)
{
	new iIDToReturn
	switch(idItem)
	{
		case 0:
		{
			switch(g_dUserData[id][iHelmetLevel])
			{
				case 1: iIDToReturn = g_szItens[iHelmetLv1][iItemID]
				case 2: iIDToReturn = g_szItens[iHelmetLv2][iItemID]
				case 3: iIDToReturn = g_szItens[iHelmetLv3][iItemID]
			}
		}
		case 1:
		{
			switch(g_dUserData[id][iArmorLevel])
			{
				case 1: iIDToReturn = g_szItens[iKevlarLv1][iItemID]
				case 2: iIDToReturn = g_szItens[iKevlarLv2][iItemID]
				case 3: iIDToReturn = g_szItens[iKevlarLv3][iItemID]
			}
		}
		case 2:
		{
			switch(g_dUserData[id][iBagLevel])
			{
				case 1: iIDToReturn = g_szItens[iBagLv1][iItemID]
				case 2: iIDToReturn = g_szItens[iBagLv2][iItemID]
				case 3: iIDToReturn = g_szItens[iBagLv3][iItemID]
			}
		}
	}
	return iIDToReturn
}

readIniData(szFileName[])
{
	new szConfig[MAX_PLAYERS]
	get_configsdir(szConfig, charsmax(szConfig))
	formatex(g_szIniFile[0], charsmax(g_szIniFile[]), "%s/%s/pubnite_management/%s.ini", szConfig, FILE_FOLDER, szFileName)
	if(!file_exists(g_szIniFile[0])) 
	{
		log_to_file("pubnite_log.log", "[PUBNite Mod]: %L", LANG_SERVER, "SERVER_NO_CONFIG_FILE", g_szIniFile[0])
		return 0
	}

	new iFile = fopen(g_szIniFile[0], "rt")
	new szBuffer[512], szKey[50], szValue[MAX_MODEL_LENGTH]
	while(!feof(iFile))
	{
		fgets(iFile, szBuffer, charsmax(szBuffer))
		trim(szBuffer)
		
		if(cantReadTheLine(szBuffer))
			continue

		strtok(szBuffer, szKey, charsmax(szKey), szValue, charsmax(szValue), '=')

		trim(szKey)
		trim(szValue)

		// Commands
		if(equal(szFileName, COMMANDS_FILE))
		{
			if(equali(szKey, "RANK_COMMAND"))
			{
				g_cCommands[cRank] = szValue
			}
			else if(equali(szKey, "TEAM_COMMAND"))
			{
				g_cCommands[cTeam] = szValue
			}
			else if(equali(szKey, "OUT_TEAM_COMMAND"))
			{
				g_cCommands[cGetoutTeam] = szValue
			}
			else if(equali(szKey, "BAG_COMMAND"))
			{
				g_cCommands[cBag] = szValue
			}
			else if(equali(szKey, "MAIN_MENU_COMMAND"))
			{
				g_cCommands[cMainMenu] = szValue
			}
			else if(equali(szKey, "TOP15_COMMAND"))
			{
				g_cCommands[cTop15] = szValue
			}
			else if(equali(szKey, "TOPVBUCKS_COMMAND"))
			{
				g_cCommands[cTopVBucks] = szValue
			}
			else if(equali(szKey, "KNIFE_SHOP_COMMAND"))
			{
				g_cCommands[cKnifeShop] = szValue
			}
			else if(equali(szKey, "MODELS_SHOP_COMMAND"))
			{
				g_cCommands[cModelsShop] = szValue
			}
			else if(equali(szKey, "GIVE_VBUCKS_COMMAND"))
			{
				g_cCommands[cGiveVBucks] = szValue
			}
		}
		
		// Sounds
		else if(equal(szFileName, SOUND_EFFECTS_FILE))
		{
			if(equali(szKey, "PICKUP_KEVLAR_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sAmmoPickup] = szValue
				}
			}
			else if(equali(szKey, "PICKUP_ITEM_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sGunPickup] = szValue
				}
			}
			else if(equali(szKey, "DAMAGE_PAIN_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sDamagePain] = szValue
				}
			}
			else if(equali(szKey, "ARMOR_HIT_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sArmorHitSound] = szValue
				}
			}
			else if(equali(szKey, "TRANSPORTER_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sTransporter] = szValue
				}
			}
			else if(equali(szKey, "HELMET_HS_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sHelmetHit] = szValue
				}
			}
			else if(equali(szKey, "TRANSPORTER_DROP_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sPlaneDropSound] = szValue
				}
			}
			else if(equali(szKey, "IMPULSE_GRENADE_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sImpulseGrenadeSound] = szValue
				}
			}
			else if(equali(szKey, "USING_MEDKIT_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sUsingMedkit] = szValue
				}
			}
			else if(equali(szKey, "TEAMMATE_KNOCKED_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sMateKnocked] = szValue
				}
			}
			else if(equali(szKey, "DEATH_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sDeathSound] = szValue
				}
			}
			else if(equali(szKey, "GUSPE_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sGuspeSound] = szValue
				}
			}
			else if(equali(szKey, "SUPPLY_LAND_CLOSE_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sAirdropTouchSound] = szValue
				}
			}
			else if(equali(szKey, "SUPPLY_LAND_FAR_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sSupplyFarLandSound] = szValue
				}
			}
			else if(equali(szKey, "SUPPLY_SPAWN_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sAirDropAppearSound] = szValue
				}
			}
			else if(equali(szKey, "SUPPLY_LANDING_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sAirDropLandingSound] = szValue
				}
			}
			else if(equali(szKey, "SUPPLY_OPENED_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sSupplyOpenedSound] = szValue
				}
			}
			else if(equali(szKey, "SUPPLY_OPENING_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sSupplyOpeningSound] = szValue
				}
			}
			else if(equali(szKey, "UNKNOCKING_MATE_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sUnknockingMate] = szValue
				}
			}
			else if(equali(szKey, "MATE_UNKNOCKED_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sMateUnknocked] = szValue
				}
			}
			else if(equali(szKey, "CRITICAL_HIT_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sCriticalHit] = szValue
				}
			}
			else if(equali(szKey, "KNOCKED_AN_ENEMY_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sKnockedAnEnemy] = szValue
				}
			}
			else if(equali(szKey, "PARACHUTE_LAND_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sParachuteLand] = szValue
				}
			}
			else if(equali(szKey, "CRITICAL_KILL_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sCriticalKill] = szValue
				}
			}
			else if(equali(szKey, "PARACHUTE_OPEN_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sParachuteOpen] = szValue
				}
			}
			else if(equali(szKey, "GUSPE_ALERT_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sGuspeAlertSound] = szValue
				}
			}
			else if(equali(szKey, "TEAMMATE_DROPPED_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sTeammateDropSound] = szValue
				}
			}
			else if(equali(szKey, "SKYDIVE_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sSkyDiveSound] = szValue
				}
			}
			else if(equali(szKey, "RADIO_ALERT_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sRadioAlert] = szValue
				}
			}
			else if(equali(szKey, "LOCKED_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sLockedSounds] = szValue
				}
			}
			else if(equali(szKey, "CHUG_JUG_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sChugJugSound] = szValue
				}
			}
			else if(equali(szKey, "CHEST_LOOP_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sChestSound] = szValue
				}
			}
			else if(equali(szKey, "CHEST_OPENED_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sChestOpened] = szValue
				}
			}
			else if(equali(szKey, "SEARCHING_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sOpeningSound] = szValue
				}
			}
			else if(equali(szKey, "THANKS_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sThanksSound] = szValue
				}
			}
			else if(equali(szKey, "MATE_MESSAGE_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sMateMessage] = szValue
				}
			}
			else if(equali(szKey, "WALL_CREATED_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sWallCreateSound] = szValue
				}
			}
			else if(equali(szKey, "WALL_HIT_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sWallHitSound] = szValue
				}
			}
			else if(equali(szKey, "WALL_DESTROYED_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sWallDestroyedSound] = szValue
				}
			}
			else if(equali(szKey, "COUNTDOWN_EFFECT_BEEPS_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sCountDownEffect1] = szValue
				}
			}
			else if(equali(szKey, "COUNTDOWN_EFFECT_MARIO_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sCountDownEffect2] = szValue
				}
			}
			else if(equali(szKey, "VOICE_CHANGE_MODE_SOUND"))
			{
				if(precacheSound(szValue))
				{
					g_szSoundsData[sVoiceChangeModeSound] = szValue
				}
			}
		}
		// Itens Data
		else if(equal(szFileName, ITENS_FILE))
		{
			// KEVLAR
			if(equali(szKey, "KEVLAR_ENABLED")) 
			{
				g_szItens[iKevlarLv1][bIsItemEnabled] = bool:str_to_num(szValue)
				g_szItens[iKevlarLv2][bIsItemEnabled] = bool:str_to_num(szValue)
				g_szItens[iKevlarLv3][bIsItemEnabled] = bool:str_to_num(szValue)
			}
			else if(equali(szKey, "KEVLAR_LV1_MODEL"))
			{
				if(precacheModel(szValue))
				{
					g_szItens[iKevlarLv1][szItemModel] = szValue
				}
			}
			else if(equali(szKey, "KEVLAR_LV1_ID"))
			{
				g_szItens[iKevlarLv1][iItemID] = str_to_num(szValue)
			}
			else if(equali(szKey, "KEVLAR_LV1_LEVEL"))
			{
				g_szItens[iKevlarLv1][iItemInfoLevel] = str_to_num(szValue)

			}
			else if(equali(szKey, "KEVLAR_LV2_MODEL"))
			{
				if(precacheModel(szValue))
				{
					g_szItens[iKevlarLv2][szItemModel] = szValue
				}
			}
			else if(equali(szKey, "KEVLAR_LV2_ID"))
			{
				g_szItens[iKevlarLv2][iItemID] = str_to_num(szValue)
			}
			else if(equali(szKey, "KEVLAR_LV2_LEVEL"))
			{
				g_szItens[iKevlarLv2][iItemInfoLevel] = str_to_num(szValue)
			}
			else if(equali(szKey, "KEVLAR_LV3_MODEL"))
			{
				if(precacheModel(szValue))
				{
					g_szItens[iKevlarLv3][szItemModel] = szValue
				}
			}
			else if(equali(szKey, "KEVLAR_LV3_ID"))
			{
				g_szItens[iKevlarLv3][iItemID] = str_to_num(szValue)
			}
			else if(equali(szKey, "KEVLAR_LV3_LEVEL"))
			{
				g_szItens[iKevlarLv3][iItemInfoLevel] = str_to_num(szValue)
			}
			
			//MED KIT
			if(equali(szKey, "MEDKIT_ENABLED")) 
			{
				g_szItens[iMedKit][bIsItemEnabled] = bool:str_to_num(szValue)
			}
			else if(equali(szKey, "MEDKIT_MODEL"))
			{
				if(precacheModel(szValue))
				{
					g_szItens[iMedKit][szItemModel] = szValue
				}
			}
			else if(equali(szKey, "MEDKIT_ID"))
			{
				g_szItens[iMedKit][iItemID] = str_to_num(szValue)
			}
			
			// HELMET
			if(equali(szKey, "HELMET_ENABLED")) 
			{
				g_szItens[iHelmetLv1][bIsItemEnabled] = bool:str_to_num(szValue)
				g_szItens[iHelmetLv2][bIsItemEnabled] = bool:str_to_num(szValue)
				g_szItens[iHelmetLv3][bIsItemEnabled] = bool:str_to_num(szValue)
			}
			else if(equali(szKey, "HELMET_LV1_MODEL"))
			{
				if(precacheModel(szValue))
				{
					g_szItens[iHelmetLv1][szItemModel] = szValue
				}
			}
			else if(equali(szKey, "HELMET_LV1_ID"))
			{
				g_szItens[iHelmetLv1][iItemID] = str_to_num(szValue)
			}
			else if(equali(szKey, "HELMET_LV1_LEVEL"))
			{
				g_szItens[iHelmetLv1][iItemInfoLevel] = str_to_num(szValue)
			}
			else if(equali(szKey, "HELMET_LV2_MODEL"))
			{
				if(precacheModel(szValue))
				{
					g_szItens[iHelmetLv2][szItemModel] = szValue
				}
			}
			else if(equali(szKey, "HELMET_LV2_ID"))
			{
				g_szItens[iHelmetLv2][iItemID] = str_to_num(szValue)
			}
			else if(equali(szKey, "HELMET_LV2_LEVEL"))
			{
				g_szItens[iHelmetLv2][iItemInfoLevel] = str_to_num(szValue)
			}
			else if(equali(szKey, "HELMET_LV3_MODEL"))
			{
				if(precacheModel(szValue))
				{
					g_szItens[iHelmetLv3][szItemModel] = szValue
				}
			}
			else if(equali(szKey, "HELMET_LV3_ID"))
			{
				g_szItens[iHelmetLv3][iItemID] = str_to_num(szValue)
			}
			else if(equali(szKey, "HELMET_LV3_LEVEL"))
			{
				g_szItens[iHelmetLv3][iItemInfoLevel] = str_to_num(szValue)
			}
			
			// BAG
			if(equali(szKey, "BAG_ENABLED")) 
			{
				g_szItens[iBagLv1][bIsItemEnabled] = bool:str_to_num(szValue)
				g_szItens[iBagLv2][bIsItemEnabled] = bool:str_to_num(szValue)
				g_szItens[iBagLv3][bIsItemEnabled] = bool:str_to_num(szValue)
			}
			else if(equali(szKey, "BAG_LV1_MODEL"))
			{
				if(precacheModel(szValue))
				{
					g_szItens[iBagLv1][szItemModel] = szValue
				}
			}
			else if(equali(szKey, "BAG_LV1_ID"))
			{
				g_szItens[iBagLv1][iItemID] = str_to_num(szValue)
			}
			else if(equali(szKey, "BAG_LV1_LEVEL"))
			{
				g_szItens[iBagLv1][iItemInfoLevel] = str_to_num(szValue)
			}
			else if(equali(szKey, "BAG_LV2_MODEL"))
			{
				if(precacheModel(szValue))
				{
					g_szItens[iBagLv2][szItemModel] = szValue
				}
			}
			else if(equali(szKey, "BAG_LV2_ID"))
			{
				g_szItens[iBagLv2][iItemID] = str_to_num(szValue)
			}
			else if(equali(szKey, "BAG_LV2_LEVEL"))
			{
				g_szItens[iBagLv2][iItemInfoLevel] = str_to_num(szValue)
			}
			else if(equali(szKey, "BAG_LV3_MODEL"))
			{
				if(precacheModel(szValue))
				{
					g_szItens[iBagLv3][szItemModel] = szValue
				}
			}
			else if(equali(szKey, "BAG_LV3_ID"))
			{
				g_szItens[iBagLv3][iItemID] = str_to_num(szValue)
			}
			else if(equali(szKey, "BAG_LV3_LEVEL"))
			{
				g_szItens[iBagLv3][iItemInfoLevel] = str_to_num(szValue)
			}
			
			// IMPULSE GRENADE
			if(equali(szKey, "IMPULSE_ENABLED")) 
			{
				g_szItens[iImpulseGrenade][bIsItemEnabled] = bool:str_to_num(szValue)
			}
			else if(equali(szKey, "IMPULSE_MODEL"))
			{
				if(precacheModel(szValue))
				{
					g_szItens[iImpulseGrenade][szItemModel] = szValue
				}
			}
			else if(equali(szKey, "IMPULSE_ID"))
			{
				g_szItens[iImpulseGrenade][iItemID] = str_to_num(szValue)
			}
			
			//GUSPE
			if(equali(szKey, "GUSPE_ENABLED")) 
			{
				g_szItens[iGuspe][bIsItemEnabled] = bool:str_to_num(szValue)
			}
			else if(equali(szKey, "GUSPE_MODEL"))
			{
				if(precacheModel(szValue))
				{
					g_szItens[iGuspe][szItemModel] = szValue
				}
			}
			else if(equali(szKey, "GUSPE_ID"))
			{
				g_szItens[iGuspe][iItemID] = str_to_num(szValue)
			}
			
			//CHUG JUG
			if(equali(szKey, "CHUG_JUG_ENABLED")) 
			{
				g_szItens[iChugJug][bIsItemEnabled] = bool:str_to_num(szValue)
			}
			else if(equali(szKey, "CHUG_JUG_MODEL"))
			{
				if(precacheModel(szValue))
				{
					g_szItens[iChugJug][szItemModel] = szValue
				}
			}
			else if(equali(szKey, "CHUG_JUG_ID"))
			{
				g_szItens[iChugJug][iItemID] = str_to_num(szValue)
			}
			
			//WALL
			if(equali(szKey, "WALL_ENABLED")) 
			{
				g_szItens[iWall][bIsItemEnabled] = bool:str_to_num(szValue)
			}
			else if(equali(szKey, "WALL_MODEL"))
			{
				if(precacheModel(szValue))
				{
					g_szItens[iWall][szItemModel] = szValue
				}
			}
			else if(equali(szKey, "WALL_ID"))
			{
				g_szItens[iWall][iItemID] = str_to_num(szValue)
			}
		}
		else if(equal(szFileName, WIN_SOUNDS))
		{
			if(precacheSound(szKey))
			{
				ArrayPushString(g_arWinSounds, szKey)
			}
		}
		else if(equal(szFileName, RESOURCES_FILE))
		{
			if(equali(szKey, "PLANE_MODEL"))
			{
				if(precacheModel(szValue))
				{
					g_szModelsData[mTransporter] = szValue
				}
			}
			else if(equali(szKey, "PLAYER_PARACHUTE_MODEL"))
			{
				if(precacheModel(szValue))
				{
					g_szModelsData[mUserParachute] = szValue
				}
			}
			else if(equali(szKey, "AIRDROP_BOX_MODEL"))
			{
				if(precacheModel(szValue))
				{
					g_szModelsData[mAirDrop] = szValue
				}
			}
			else if(equali(szKey, "IMPULSE_GRENADE_VIEW_MODEL"))
			{				
				if(precacheModel(szValue))
				{
					g_szModelsData[mImpulseGrenadeViewModel] = szValue
				}
			}
			else if(equali(szKey, "IMPULSE_GRENADE_WORLD_MODEL"))
			{		
				if(precacheModel(szValue))
				{
					g_szModelsData[mImpulseGrenadePlayerModel] = szValue
				}
			}
			else if(equali(szKey, "CHEST_MODEL"))
			{		
				if(precacheModel(szValue))
				{
					g_szModelsData[mChestModel] = szValue
				}
			}
			else if(equali(szKey, "WALL_MODEL"))
			{		
				if(precacheModel(szValue))
				{
					g_szModelsData[mWallModel] = szValue
				}
			}
		}
		else if(equal(szFileName, WEAPONS_MODELS))
		{
			static szKeyModel[MAX_MODEL_LENGTH], szKeyModelID[MAX_PLAYERS]
			parse
			(
				szKey, 
				szKeyModel, charsmax(szKeyModel),
				szKeyModelID, charsmax(szKeyModelID)
			)
			
			g_szWeaponsModels[g_iWeaponsNum][iWeaponInfoID] = str_to_num(szKeyModelID)
			if(szValue[0] && file_exists(szValue))
			{
				precacheModel(szValue)
				g_szWeaponsModels[g_iWeaponsNum][szModelName] = szValue
			}
			else
			{
				static szModel[MAX_MODEL_LENGTH]
				replace(szKeyModel, charsmax(szKeyModel), "weapon_", "")
				formatex(szModel, charsmax(szModel), "models/w_%s.mdl", szKeyModel)
				if(containi(szModel, "navy") != -1)
				{
					replace(szModel, charsmax(szModel), "navy", "")
				}
				precacheModel(szModel)
				g_szWeaponsModels[g_iWeaponsNum][szModelName] = szModel
			}
			g_iWeaponsNum++
		}
	}
	fclose(iFile)
	return 1
}

readChestPoints()
{
	g_iVecsNum[vecChests] = 0
	if(!file_exists(g_szIniFile[4])) 
	{
		log_to_file(LOG_FILE, "[PUBNite Mod]: %L", LANG_SERVER, "SERVER_NO_SPAWN_POINTS", g_szIniFile[4])
		return 0
	}

	new iFile = fopen(g_szIniFile[4], "rt")
	new szBuffer[512], iPos[4][8]
	while(!feof(iFile) && (g_iVecsNum[vecChests] < MAX_SPAWNS))
	{
		fgets(iFile, szBuffer, charsmax(szBuffer))
		trim(szBuffer)
		
		if(cantReadTheLine(szBuffer))
			continue

		parse
		(
			szBuffer, 
			iPos[1], charsmax(iPos[]),
			iPos[2], charsmax(iPos[]),  
			iPos[3], charsmax(iPos[])
		)
			
		g_fChestPoints[g_iVecsNum[vecChests]][0] = str_to_float(iPos[1])
		g_fChestPoints[g_iVecsNum[vecChests]][1] = str_to_float(iPos[2])
		g_fChestPoints[g_iVecsNum[vecChests]][2] = str_to_float(iPos[3])

		g_iVecsNum[vecChests]++
	} 
	
	fclose(iFile)
	return (g_iVecsNum[vecChests] ? 1 : 0)
}

readEntsPoints()
{
	g_iVecsNum[vecWeapons] = 0
	if(!file_exists(g_szIniFile[1])) 
	{
		log_to_file(LOG_FILE, "[PUBNite Mod]: %L", LANG_SERVER, "SERVER_NO_SPAWN_POINTS", g_szIniFile[1])
		return 0
	}

	new iFile = fopen(g_szIniFile[1], "rt")
	new szBuffer[512], iPos[4][8]
	while(!feof(iFile) && (g_iVecsNum[vecWeapons] < MAX_SPAWNS))
	{
		fgets(iFile, szBuffer, charsmax(szBuffer))
		trim(szBuffer)
		
		if(cantReadTheLine(szBuffer))
			continue

		parse
		(
			szBuffer, 
			iPos[1], charsmax(iPos[]),
			iPos[2], charsmax(iPos[]),  
			iPos[3], charsmax(iPos[])
		)
			
		g_fSpawnVecs[g_iVecsNum[vecWeapons]][0] = str_to_float(iPos[1])
		g_fSpawnVecs[g_iVecsNum[vecWeapons]][1] = str_to_float(iPos[2])
		g_fSpawnVecs[g_iVecsNum[vecWeapons]][2] = str_to_float(iPos[3])

		g_iVecsNum[vecWeapons]++
	} 
	
	if(g_iVecsNum[vecWeapons] < MIN_SPAWNS_PER_ROUND)
	{
		log_to_file(LOG_FILE, "[PUBNite Mod]: %L", LANG_SERVER, "SERVER_NO_ENOUGH_SPAWN_POINTS", g_iVecsNum[vecWeapons], MIN_SPAWNS_PER_ROUND)
		g_iVecsNum[vecWeapons] = 0
		return 0
	}

	fclose(iFile)
	return (g_iVecsNum[vecWeapons] ? 1 : 0)
}

readWeaponsNames()
{
	if(!file_exists(g_szIniFile[3])) 
	{
		log_to_file(LOG_FILE, "[PUBNite Mod]: %L", LANG_SERVER, "SERVER_NO_CONFIG_FILE", g_szIniFile[3])
		return 0
	}

	new iFile = fopen(g_szIniFile[3], "rt")
	new szBuffer[512], szKey[50], szValue[MAX_MODEL_LENGTH]
	while(!feof(iFile))
	{
		fgets(iFile, szBuffer, charsmax(szBuffer))
		trim(szBuffer)
		
		if(cantReadTheLine(szBuffer))
			continue

		strtok(szBuffer, szKey, charsmax(szKey), szValue, charsmax(szValue), '=')

		trim(szKey)
		trim(szValue)

		if(equal(szKey, "AK47")) 	formatex(g_szWeaponsDisplayName[nAK47], charsmax(g_szWeaponsDisplayName[]), szValue)
		if(equal(szKey, "M4A1")) 	formatex(g_szWeaponsDisplayName[nM4A1], charsmax(g_szWeaponsDisplayName[]), szValue)
		if(equal(szKey, "AWP")) 	formatex(g_szWeaponsDisplayName[nAWP], charsmax(g_szWeaponsDisplayName[]), szValue)
		if(equal(szKey, "SCOUT")) 	formatex(g_szWeaponsDisplayName[nSCOUT], charsmax(g_szWeaponsDisplayName[]), szValue)
		if(equal(szKey, "FAMAS")) 	formatex(g_szWeaponsDisplayName[nFAMAS], charsmax(g_szWeaponsDisplayName[]), szValue)
		if(equal(szKey, "AUG")) 	formatex(g_szWeaponsDisplayName[nAUG], charsmax(g_szWeaponsDisplayName[]), szValue)
		if(equal(szKey, "SG552")) 	formatex(g_szWeaponsDisplayName[nSG552], charsmax(g_szWeaponsDisplayName[]), szValue)
		if(equal(szKey, "USP")) 	formatex(g_szWeaponsDisplayName[nUSP], charsmax(g_szWeaponsDisplayName[]), szValue)
		if(equal(szKey, "DEAGLE")) 	formatex(g_szWeaponsDisplayName[nDEAGLE], charsmax(g_szWeaponsDisplayName[]), szValue)
		if(equal(szKey, "XM1014")) 	formatex(g_szWeaponsDisplayName[nXM1014], charsmax(g_szWeaponsDisplayName[]), szValue)
		if(equal(szKey, "M3")) 		formatex(g_szWeaponsDisplayName[nM3], charsmax(g_szWeaponsDisplayName[]), szValue)
		if(equal(szKey, "HEGRENADE")) 	formatex(g_szWeaponsDisplayName[nHEGRENADE], charsmax(g_szWeaponsDisplayName[]), szValue)
		if(equal(szKey, "M249")) 	formatex(g_szWeaponsDisplayName[nM249], charsmax(g_szWeaponsDisplayName[]), szValue)
		if(equal(szKey, "MP5NAVY")) 	formatex(g_szWeaponsDisplayName[nMP5], charsmax(g_szWeaponsDisplayName[]), szValue)
		if(equal(szKey, "UMP45")) 	formatex(g_szWeaponsDisplayName[nUMP45], charsmax(g_szWeaponsDisplayName[]), szValue)
		if(equal(szKey, "P90")) 	formatex(g_szWeaponsDisplayName[nP90], charsmax(g_szWeaponsDisplayName[]), szValue)
		if(equal(szKey, "MAC10"))	formatex(g_szWeaponsDisplayName[nMAC10], charsmax(g_szWeaponsDisplayName[]), szValue)
		if(equal(szKey, "TMP"))		formatex(g_szWeaponsDisplayName[nTMP], charsmax(g_szWeaponsDisplayName[]), szValue)
		if(equal(szKey, "ELITE"))	formatex(g_szWeaponsDisplayName[nELITE], charsmax(g_szWeaponsDisplayName[]), szValue)
		if(equal(szKey, "P250"))	formatex(g_szWeaponsDisplayName[nP250], charsmax(g_szWeaponsDisplayName[]), szValue)
		if(equal(szKey, "GLOCK18"))	formatex(g_szWeaponsDisplayName[nGLOCK18], charsmax(g_szWeaponsDisplayName[]), szValue)
		if(equal(szKey, "GALIL"))	formatex(g_szWeaponsDisplayName[nGALIL], charsmax(g_szWeaponsDisplayName[]), szValue)
		if(equal(szKey, "G3SG1"))	formatex(g_szWeaponsDisplayName[nG3SG1], charsmax(g_szWeaponsDisplayName[]), szValue)
		if(equal(szKey, "SG550"))	formatex(g_szWeaponsDisplayName[nSG550], charsmax(g_szWeaponsDisplayName[]), szValue)

	}
	fclose(iFile)
	return 1
}

readPlanePoints()
{
	if(!file_exists(g_szIniFile[2])) 
	{
		log_to_file(LOG_FILE, "[PUBNite Mod]: %L", LANG_SERVER, "SERVER_NO_SPAWN_VECTOR_FOUND", g_szIniFile[2])
		return 0
	}

	new iFile = fopen(g_szIniFile[2], "rt")
	new szBuffer[512]
	while(!feof(iFile))
	{
		fgets(iFile, szBuffer, charsmax(szBuffer))
		trim(szBuffer)
		
		if(cantReadTheLine(szBuffer))
			continue

		new szVecs[11][8]
		parse
		(
			szBuffer, 
			szVecs[1], charsmax(szVecs[]),
			szVecs[2], charsmax(szVecs[]),
			szVecs[3], charsmax(szVecs[]),
			szVecs[4], charsmax(szVecs[]),
			szVecs[5], charsmax(szVecs[]),
			szVecs[6], charsmax(szVecs[]),
			szVecs[7], charsmax(szVecs[]),
			szVecs[8], charsmax(szVecs[]),
			szVecs[9], charsmax(szVecs[]),
			szVecs[10], charsmax(szVecs[])
		)
		
		// Origins
		g_fPlaneOrigins[g_iTotalVecs[vOrigin]][0] = str_to_float(szVecs[1])
		g_fPlaneOrigins[g_iTotalVecs[vOrigin]][1] = str_to_float(szVecs[2])
		g_fPlaneOrigins[g_iTotalVecs[vOrigin]][2] = str_to_float(szVecs[3])
		g_iTotalVecs[vOrigin]++
		
		// Angles
		g_fPlaneAngles[g_iTotalVecs[vAngles]][0] = str_to_float(szVecs[4])
		g_fPlaneAngles[g_iTotalVecs[vAngles]][1] = str_to_float(szVecs[5])
		g_fPlaneAngles[g_iTotalVecs[vAngles]][2] = str_to_float(szVecs[6])
		g_iTotalVecs[vAngles]++
			
		// Velocities
		g_fPlaneVelocities[g_iTotalVecs[vVelocities]][0] = str_to_float(szVecs[7])
		g_fPlaneVelocities[g_iTotalVecs[vVelocities]][1] = str_to_float(szVecs[8])
		g_fPlaneVelocities[g_iTotalVecs[vVelocities]][2] = str_to_float(szVecs[9])
		g_iTotalVecs[vVelocities]++

		// Plane Remove time
		g_fPlaneRemoveTime[g_iTotalVecs[vRemoveTime]++] = str_to_float(szVecs[10])

		g_iVecsNum[vecPlane]++

	} 
	
	fclose(iFile)
	return (g_iVecsNum[vecPlane] ? 1 : 0)
}

clientPlaySound(id, szSound[], bool:bIsEffectSound = false, bool:bToAllMates = false, iChannel = CHAN_ITEM, bool:bPlayForDeads = true, Float:fNewVolume = 0.0)
{
	if(bIsEffectSound)
	{
		emit_sound(id, iChannel, szSound, fNewVolume ? fNewVolume : VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
	}
	else 
	{
		new iPlayers[MAX_PLAYERS], iNum
		get_players(iPlayers, iNum, "ch")
		for(new i, iPlayer;i < iNum;i++)
		{
			iPlayer = iPlayers[i]
			
			if(((id == iPlayer) && !bToAllMates) || (bPlayForDeads && isSpectating(iPlayer, id)) || (bToAllMates && isTeammate(id, iPlayer) && (id != iPlayer)))
			{
				playSound(iPlayer, szSound)
			}
		}
	}
}

clientStopSound(id, bool:bIsEffectSound = false, szSound[] = "", iChannel = CHAN_ITEM)
{
	if(!bIsEffectSound)
	{
		client_cmd(id, "stopsound")
		if(id)
		{
			new iPlayers[MAX_PLAYERS], iNum
			get_players(iPlayers, iNum, "bch")
			for(new i, iPlayer;i < iNum;i++)
			{
				iPlayer = iPlayers[i]
				
				if(isSpectating(iPlayer, id))
				{				
					client_cmd(iPlayer, "stopsound")
				}
			}
		}
	}
	else
	{
		emit_sound(id, iChannel, szSound, VOL_NORM, ATTN_NORM, SND_STOP, PITCH_NORM)
	}
}

Float:distanceToGround(id) 
{ 
	new Float:fStart[3], Float:fEnd[3]
	entity_get_vector(id, EV_VEC_origin, fStart)
	if(entity_get_int(id, EV_INT_flags) & FL_DUCKING) 
	{ 
		fStart[2] += 18.0
	} 

	fEnd[0] = fStart[0] 
	fEnd[1] = fStart[1]
	fEnd[2] = fStart[2] - 9999.0

	new iPtr = create_tr2(), Float:fFraction
	engfunc(EngFunc_TraceHull, fStart, fEnd, IGNORE_MONSTERS, HULL_HUMAN, id, iPtr)
	get_tr2(iPtr, TR_flFraction, fFraction)
	free_tr2(iPtr)

	return (fFraction * 9999.0)
} 

precacheSound(szSound[])
{
	if(equal(szSound[strlen(szSound) - 4], ".mp3")) 
	{
		if(file_exists(szSound))
		{
			precache_generic(szSound)
			return true
		}
	}
	else 
	{
		return precache_sound(szSound)
	}
	log_to_file(LOG_FILE, "Sound '%s' not found.", szSound)
	return false
}

precacheModel(szModel[])
{
	if(file_exists(szModel))
	{
		engfunc(EngFunc_PrecacheModel, szModel)

		// Quick&Dirty Fix
		new temp[80]
		copy(temp, (strlen(szModel) - 4), szModel)
		formatex(temp, charsmax(temp), "%st.mdl", temp)
		if(file_exists(temp))
		{
			engfunc(EngFunc_PrecacheModel, temp)
			return true
		}
		copy(temp, (strlen(szModel) - 4), szModel)
		formatex(temp, charsmax(temp), "%sT.mdl", temp)
		if(file_exists(temp))
		{
			engfunc(EngFunc_PrecacheModel, temp)
			return true
		}
		return true
	}
	log_to_file(LOG_FILE, "Model '%s' not found.", szModel)
	return false
}

getPlayersInThePlaneNum()
{
	new iPlayers[MAX_PLAYERS], iNum, iPlayersInPlane
	get_players(iPlayers, iNum, "ach")
	for(new i;i < iNum;i++)
	{
		if(g_dUserData[iPlayers[i]][bIsOnPlane])
		{
			iPlayersInPlane++
		}
	}
	return iPlayersInPlane
}

Float:GetMaxHeightWithoutStartOrigin()
{
	new pcCurrent = CONTENTS_EMPTY, Float:fStartPoint[3]
	fStartPoint[2] = g_fPlaneOrigins[0][2]
	while(pcCurrent != CONTENTS_SKY)
	{
		fStartPoint[2] += 5.0
		pcCurrent = engfunc(EngFunc_PointContents, fStartPoint)
	}
	return (fStartPoint[2] -= 75.0)
}

getItemNameByID(id, sItemID, szFormat[25])
{
	if((sItemID == g_szItens[iKevlarLv1][iItemID])
	|| (sItemID == g_szItens[iKevlarLv2][iItemID])
	|| (sItemID == g_szItens[iKevlarLv3][iItemID]))
	{
		formatex(szFormat, charsmax(szFormat), "%L lv. %d", id, "SERVER_ITEM_KEVLAR", g_szItens[iItensList:sItemID][iItemInfoLevel])
	}
	else if((sItemID == g_szItens[iHelmetLv1][iItemID])
	|| (sItemID == g_szItens[iHelmetLv2][iItemID])
	|| (sItemID == g_szItens[iHelmetLv3][iItemID]))
	{	
		formatex(szFormat, charsmax(szFormat), "%L lv. %d", id, "SERVER_ITEM_HELMET", g_szItens[iItensList:sItemID][iItemInfoLevel])
	}
	else if((sItemID == g_szItens[iBagLv1][iItemID])
	|| (sItemID == g_szItens[iBagLv2][iItemID])
	|| (sItemID == g_szItens[iBagLv3][iItemID]))
	{
		formatex(szFormat, charsmax(szFormat), "%L lv. %d", id, "SERVER_ITEM_BAG", g_szItens[iItensList:sItemID][iItemInfoLevel])
	}
	
	else if(sItemID == g_szItens[iMedKit][iItemID])		formatex(szFormat, charsmax(szFormat), "MedKit")
	else if(sItemID == g_szItens[iImpulseGrenade][iItemID])	formatex(szFormat, charsmax(szFormat), "Impulse Grenade")
	else if(sItemID == g_szItens[iGuspe][iItemID])		formatex(szFormat, charsmax(szFormat), "Guspe")
	else if(sItemID == g_szItens[iChugJug][iItemID])		formatex(szFormat, charsmax(szFormat), "Chug Jug")
	else if(sItemID == g_szItens[iWall][iItemID])		formatex(szFormat, charsmax(szFormat), "Wall")
}

getSpecsNum(id, bool:bReturnType = false)
{
	new iPlayers[MAX_PLAYERS], iNum, iSpecs
	get_players(iPlayers, iNum, "bch")
	for(new i, iPlayer;i < iNum;i++)
	{
		iPlayer = iPlayers[i]
		if(pev(iPlayer, pev_iuser2) == id && (!is_user_admin(iPlayer) || get_pcvar_num(g_pCvars[cSpecCountAdmins])))
		{
			if(bReturnType) return iPlayer
			else iSpecs++
		}
	}
	return bReturnType ? 0 : iSpecs
}

getRandomPoint(Float:fOrigin[3])
{
	while(g_iRandomSpawnsNum-- > 0)
	{
		fOrigin = g_fSpawnVecs[g_iRandomSpawnsNum]
		fOrigin[2] = (g_fMaxZ - 300.0)
		if(isValidOrigin(fOrigin, HULL_LARGE) && !pubnite_origin_inside_redzone(fOrigin[0], fOrigin[1]))
		{
			break
		}
	}

	new iTries
	while(iTries++ < g_iVecsNum[vecWeapons])
	{
		fOrigin = g_fSpawnVecs[random_mod(g_iVecsNum[vecWeapons])]
		fOrigin[2] = (g_fMaxZ - 300.0)
		if(isValidOrigin(fOrigin, HULL_LARGE) && !pubnite_origin_inside_redzone(fOrigin[0], fOrigin[1]))
		{
			break
		}
	}
}

getPlayersNumInATeam(iSquad, bool:bAlive = false)
{
	if(!iSquad)
		return 0

	new iPlayers[MAX_PLAYERS], iNum, iPlayersNum
	get_players(iPlayers, iNum, (bAlive ? "ach" : "ch"))
	for(new i, iPlayer;i < iNum;i++)
	{
		iPlayer = iPlayers[i]
		if((!bAlive || __is_user_alive(iPlayer)) && g_dUserData[iPlayer][iTeamID] == iSquad)
		{
			iPlayersNum++
		}
	}
	return iPlayersNum
}

getTeamWithMostPlayers()
{
	new iReturnValue
	for(new i, iMostValue; i < ArraySize(g_arTeams); i++)
	{
		iMostValue = getPlayersNumInATeam(ArrayGetCell(g_arTeams, i), true)
		if(iMostValue > iReturnValue)
		{
			iReturnValue = iMostValue
		}
	}
	return iReturnValue
}

getKnockedMates(id)
{
	new iPlayers[MAX_PLAYERS], iNum, iPlayersNum
	get_players(iPlayers, iNum, "ach")
	for(new i, iPlayer;i < iNum;i++)
	{
		iPlayer = iPlayers[i]
		
		if(isTeammate(id, iPlayer) && g_dUserData[iPlayer][bKnockedOut])
		{
			iPlayersNum++
		}
	}
	return iPlayersNum
}

setFreeze(id, iFreeze)
{
	new iPevFlags = pev(id, pev_flags)
	if(iFreeze)
	{
		set_pev(id, pev_flags, iPevFlags | FL_FROZEN)
	}
	else set_pev(id, pev_flags, iPevFlags & ~FL_FROZEN)
}

getEntityType(iEnt)
{
	if(pubnite_is_customitem(pev(iEnt, pev_iuser1)))
		return false
		
	static szModel[MAX_MODEL_LENGTH]
	pev(iEnt, pev_model, szModel, charsmax(szModel))
		
	new bool:bContainWeaponModel = true
	for(new i;i < sizeof g_szItens;i++)
	{
		if(equal(szModel, g_szItens[iItensList:i][szItemModel]))
		{
			bContainWeaponModel = false
		}
	}
	return bContainWeaponModel
}

createWeapon(iWeapon, szModel[MAX_MODEL_LENGTH], Float:fOrigin[3], bool:bSetVelocity = false, iRandomRarity = RARITY_GOLD, id = 0)
{
	new iEnt = create_entity("info_target")
	if(pev_valid(iEnt))
	{	
		engfunc(EngFunc_SetOrigin, iEnt, fOrigin)
		engfunc(EngFunc_SetModel, iEnt, szModel)

		if(bSetVelocity)
		{
			new Float:fEntVelocity[3]
			if(!is_user_alive(id))
			{
				fEntVelocity[0] = random_float(-250.0, 250.0)
				fEntVelocity[1] = random_float(-250.0, 250.0)
			}
			else 	
			{
				velocity_by_aim(id, 400, fEntVelocity)
				fEntVelocity[2] = 100.0
			}
			set_pev(iEnt, pev_velocity, fEntVelocity)
		}

		switch(iWeapon)
		{
			case CSW_FLASHBANG:	iRandomRarity = RARITY_GREEN
			case CSW_HEGRENADE:	iRandomRarity = RARITY_PURPLE
		}
		
		set_pev(iEnt, pev_iuser1, iWeapon)
		set_pev(iEnt, pev_iuser4, iRandomRarity)
		set_pev(iEnt, pev_solid, SOLID_TRIGGER)
		set_pev(iEnt, pev_gravity, 1.0)
		set_pev(iEnt, pev_movetype, MOVETYPE_TOSS)
		set_pev(iEnt, pev_classname, g_szClassNamesData[cWeapons])
	}
	return iEnt
}

pressEButtonInfo(id)
{
	if(task_exists(g_dUserData[id][iUserSupplyID] + TASK_AD_SPIT_ITEMS))
		return
		
	static iSysTime;iSysTime = get_systime()
	if((iSysTime - g_dUserData[id][iUserSysTime]) >= PRESS_E_HUD_DELAY)
	{
		g_dUserData[id][iUserSysTime] = iSysTime
		
		set_dhudmessage(255, 255, 255, -1.0, 0.55, 0, 1.0, 1.0)
		show_dhudmessage(id, "%L", id, "SERVER_PRESS_E_BUTTON_TO_OPEN")
	}
}

resetUserData(id)
{
	g_dUserData[id][bIsOnPlane] = false
	g_dUserData[id][bCanUseParachute] = false
	g_dUserData[id][bParachuteOpened] = false
	g_dUserData[id][bHasGuspe] = false
	g_dUserData[id][bDiedBleeding] = false
	g_dUserData[id][bHasChugJug] = false
	g_dUserData[id][bHasWall] = false
	g_dUserData[id][bUsedGuspe] = false

	for(new i;i < sizeof g_iWeaponRarityValue;i++)
	{
		g_iWeaponRarityValue[id][i] = RARITY_NONE
	}
	
	new iPlayers[MAX_PLAYERS], playerCount
	get_players(iPlayers, playerCount, "ch")
	for(new i, iPlayer;i < playerCount; i++)
	{
		g_iDamageDone[id][(iPlayer = iPlayers[i])] = 0
		g_iLastDamageDone[id][iPlayer] = 0
	}
	
	g_dUserData[id][iChestID] = 0
	g_dUserData[id][iUserSupplyID] = 0
	g_dUserData[id][iKnocks] = 0
	g_dUserData[id][iHelpingID] = 0
	g_dUserData[id][iHelperID] = 0
	g_dUserData[id][iKills] = 0
	g_dUserData[id][iKnockerID] = 0
	g_dUserData[id][iNewKillerID] = -1
	g_dUserData[id][iMedKits] = 0
	g_dUserData[id][iSpectatingID] = 0
	g_dUserData[id][iImpulserID] = 0
	g_dUserData[id][iDeathHealth] = 0

	g_dUserData[id][iArmorLevel] = 0
	g_dUserData[id][iHelmetLevel] = 0
	g_dUserData[id][iBagLevel] = 0
}

checkTeam(id, bool:bSendOutMessage = false)
{
	new teamid = g_dUserData[id][iTeamID]
	if(teamid)
	{
		new iPlayers[MAX_PLAYERS], playerCount
		get_players(iPlayers, playerCount, "ch")

		if(getPlayersNumInATeam(teamid) > 2)
		{
			for(new i, iPlayer; (bSendOutMessage && i < playerCount); i++)
			{
				iPlayer = iPlayers[i]
				if((iPlayer != id) && isTeammate(iPlayer, id))
				{
					CC_SendMatched(iPlayer, CC_COLOR_RED, "%L", iPlayer, "SERVER_GOT_OUT_OF_TEAM_2", g_dUserData[id][szName])
					if(g_dUserData[id][bIsTeamLeader])
					{
						setAnotherRandomCaptain(teamid)
						break
					}
				}
			}
		}
		else
		{
			for(new i, iPlayer; i < playerCount; i++)
			{
				iPlayer = iPlayers[i]
				if(isTeammate(id, iPlayer))
				{
					g_dUserData[iPlayer][bIsTeamLeader] = false
					if(iPlayer != id)
					{
						g_dUserData[iPlayer][iTeamID] = 0
					
						removeMateSpr(iPlayer)
						CC_SendMatched(iPlayer, CC_COLOR_RED, "&x03%L", iPlayer, "SERVER_TEAM_CANCELED_DUE_INSUFICIENT_PLAYERS")
					}
				}
			}
			new idx = __ArrayFindValue(g_arTeams, teamid)
			if(idx >= 0) ArrayDeleteItem(g_arTeams, idx)

			ExecuteForward(g_forwardTeamEliminated, g_iReturn, teamid, 1)
		}
	}

	removeMateSpr(id)
	g_dUserData[id][iTeamID] = 0
}

setAnotherRandomCaptain(teamid)
{
	new iPlayers[MAX_PLAYERS], playerCount, iRandomPlayer
	get_players(iPlayers, playerCount, "ch")
	
	do
	{
		iRandomPlayer = iPlayers[random_num(0, playerCount)]
		if(g_dUserData[iRandomPlayer][iTeamID] == teamid)
		{
			g_dUserData[iRandomPlayer][bIsTeamLeader] = true
			break
		}
	}
	while(g_dUserData[iRandomPlayer][iTeamID] != teamid)
}

isUserMoving(id)
{
	static Float:fVecVelocity[3]
	pev(id, pev_velocity, fVecVelocity)
	return ((vector_length(fVecVelocity) > 10.0) || (pev(id, pev_flags) & FL_ONTRAIN))
}

Float:getWeaponRarityDmg(id, iWeapon = 0)
{
	if(!iWeapon)
	{
		iWeapon = g_dUserData[id][iPlayerWeaponID]
	}
	
	if((CSW_P228 <= iWeapon <= CSW_P90) 
	&& (iWeapon != CSW_AWP) 
	&& (iWeapon != CSW_M249) 
	&& (iWeapon != CSW_HEGRENADE) 
	&& g_iWeaponRarityValue[id][iWeapon])
	{
		new iCvarReturn
		switch(g_iWeaponRarityValue[id][iWeapon])
		{
			case RARITY_GREY: 	iCvarReturn = cCvarGreyMultiplier
			case RARITY_GREEN:	iCvarReturn = cCvarGreenMultiplier
			case RARITY_BLUE:	iCvarReturn = cCvarBlueMultiplier
			case RARITY_PURPLE:	iCvarReturn = cCvarPurpleMultiplier
			case RARITY_GOLD:	iCvarReturn = cCvarGoldMultiplier
			default:
			{
				return 1.0
			}
		}
		return get_pcvar_float(g_pCvars[iCvarReturn])
	}
	return 1.0
}

getItemGlow(iItemInfoID, iLevel)
{
	new iRarity
	if(!iLevel)
	{
		if(iItemInfoID == g_szItens[iMedKit][iItemID]) 			iRarity = RARITY_GREEN
		else if(iItemInfoID == g_szItens[iImpulseGrenade][iItemID]) 	iRarity = RARITY_PURPLE
		else if((iItemInfoID == g_szItens[iGuspe][iItemID]) 
		|| (iItemInfoID == g_szItens[iChugJug][iItemID]) 
		|| (iItemInfoID == g_szItens[iWall][iItemID]))
		{
			iRarity = RARITY_GOLD
		}
	}
	else
	{
		switch(iLevel)
		{
			case 1: 	iRarity = RARITY_BLUE
			case 2:		iRarity = RARITY_PURPLE
			case 3:		iRarity = RARITY_GOLD
		}
	}
	return iRarity
}

onUsePress(player) 
{	
	enum _:WboxInfo 
	{
		WboxInfo_Ent,
		WboxInfo_Owner
	}
	
	new Array:wboxInfos = ArrayCreate(WboxInfo)
	static Float:fUserOrigin[3], wboxInfo[WboxInfo], szClassName[MAX_PLAYERS]
	pev(player, pev_origin, fUserOrigin)
	checkEntitiesAround(player, wboxInfos, wboxInfo, g_fMaxDistance, fUserOrigin)
	
	static iHitEnt, iHitGroup
	get_user_aiming(player, iHitEnt, iHitGroup, floatround(g_fMaxDistance))
	if(!iHitEnt)
	{
		static Float:fEndOrigin[3], Float:fMaxAimDistanceCheck;fMaxAimDistanceCheck = 22.0
		getAimEndPosition(player, fEndOrigin)
		iHitEnt = checkEntitiesAround(player, wboxInfos, wboxInfo, fMaxAimDistanceCheck, fEndOrigin)
	}
		
	if(iHitEnt)
	{
		entity_get_string(iHitEnt, EV_SZ_classname, szClassName, charsmax(szClassName))
		if(equal(szClassName, g_szClassNamesData[cWeapons])) 
		{
			giveWeapons(player, getEntityType(iHitEnt), iHitEnt, .bPressUseCheck = true)
			ArrayDestroy(wboxInfos)
			return true
		}
	}
	
	new wboxCount = ArraySize(wboxInfos)
	for(new i; i < wboxCount; i++) 
	{
		static wboxInfo[WboxInfo]
		ArrayGetArray(wboxInfos, i, wboxInfo)
		new iWbox = wboxInfo[WboxInfo_Ent]
		
		if(!pev_valid(iWbox))
			return false
			
		entity_set_edict(iWbox, EV_ENT_owner, wboxInfo[WboxInfo_Owner])
		entity_set_int(iWbox, EV_INT_solid, SOLID_SLIDEBOX)
		relinkEntity(iWbox)
	}
	ArrayDestroy(wboxInfos)
	return false
}

checkEntitiesAround(player, Array:wboxInfos, wboxInfo[], Float:fRadius, Float:fOrigin[3])
{
	static szClassName[MAX_PLAYERS], Float:fEntOrigin[3], Float:fPlayerOrigin[3]
	pev(player, pev_origin, fPlayerOrigin)
	for(new iWbox; (iWbox = find_ent_in_sphere(iWbox, fOrigin, fRadius)) != 0;)
	{
		pev(iWbox, pev_origin, fEntOrigin)
		if(get_distance_f(fEntOrigin, fPlayerOrigin) > g_fMaxDistance)
			continue
			
		entity_get_string(iWbox, EV_SZ_classname, szClassName, charsmax(szClassName))
		if(isAvaliableClassName(szClassName)) 
		{
			manageEntity(iWbox, wboxInfos, wboxInfo)
			return iWbox
		}
	}
	return 0
}

getAimEndPosition(id, Float:fOrigin[3]) 
{
	new Float:fStart[3], Float:fViewOfs[3]
	pev(id, pev_origin, fStart)
	pev(id, pev_view_ofs, fViewOfs)
	xs_vec_add(fStart, fViewOfs, fStart)

	new Float:fDest[3]
	pev(id, pev_v_angle, fDest)
	engfunc(EngFunc_MakeVectors, fDest)
	global_get(glb_v_forward, fDest)
	xs_vec_mul_scalar(fDest, 9999.0, fDest)
	xs_vec_add(fStart, fDest, fDest)

	engfunc(EngFunc_TraceLine, fStart, fDest, 0, id, 0)
	get_tr2(0, TR_vecEndPos, fOrigin)
}  

manageEntity(iWbox, Array:wboxInfos, wboxInfo[])
{
	wboxInfo[0] = iWbox
	wboxInfo[1] = entity_get_edict(iWbox, EV_ENT_owner)
	ArrayPushArray(wboxInfos, wboxInfo)
		
	entity_set_int(iWbox, EV_INT_solid, SOLID_BBOX)
	entity_set_edict(iWbox, EV_ENT_owner, 0)
	relinkEntity(iWbox)
	entity_set_vector(iWbox, EV_VEC_size, Float:{1.0, 0.0, 0.0})
}

relinkEntity(ent) 
{
	static Float:origin[3]
	entity_get_vector(ent, EV_VEC_origin, origin)
	entity_set_origin(ent, origin)
}

getWeaponPos(iWeaponID)
{
	new iWeaponPos = -1
	for(new i;i < g_iWeaponsNum;i++)
	{
		if(iWeaponID == g_szWeaponsModels[i][iWeaponInfoID])
		{
			iWeaponPos = i
			break
		}
	}
	return iWeaponPos
}

dropWeapon(iWeapon, player, iDroppedWeaponID)
{	
	static szClassName[MAX_PLAYERS], iWeaponID, iSupportWeaponID, iPrimaryWeaponID
	pev(iWeapon, pev_classname, szClassName, charsmax(szClassName))
	if(isWeaponRegistered((iWeaponID = get_weaponid(szClassName))))
	{	
		if((checkUserWeapons(player, true) && isSupportWeapons(iDroppedWeaponID) && !checkUserWeapons(player)) 
		|| (checkUserWeapons(player) && !checkUserWeapons(player, true) && !isSupportWeapons(iDroppedWeaponID)))
			return
			
		if(isSupportWeapons(iDroppedWeaponID) && (iSupportWeaponID = checkUserWeapons(player)))
		{
			get_weaponname(iSupportWeaponID, szClassName, charsmax(szClassName))
		}
		else if(checkUserWeapons(player)
		&& (iPrimaryWeaponID = checkUserWeapons(player, true)) 
		&& !isSupportWeapons(iDroppedWeaponID))
		{
			get_weaponname(iPrimaryWeaponID, szClassName, charsmax(szClassName))
		}
		engclient_cmd(player, "drop", szClassName)
	}
	else	
	{
		ExecuteForward(g_forwardUnregisteredWeapon, g_iReturn, player, iWeaponID)
	}
}

checkUserWeapons(id, bool:bCheckWeapon = false)
{
	new szWeapons[MAX_PLAYERS], iNum, iReturnValue
	get_user_weapons(id, szWeapons, iNum)
	for(new i, iWeapon;i < iNum;i++)
	{
		iWeapon = szWeapons[i]
		if((bCheckWeapon && (CONST_RIFLES & (1 << iWeapon))) || (!bCheckWeapon && isSupportWeapons(iWeapon)))
		{
			iReturnValue = iWeapon
			break
		}
	}
	return iReturnValue
}

findWeaponAtWeaponBox(iWeaponBox, iWeaponID = 0)
{
	const m_pNext = 42
	const iLoops = 6

	for(new i = 1, iWeapon; i < iLoops; i++)
	{
		iWeapon = get_pdata_cbase(iWeaponBox, m_WeaponBox_rgpPlayerItems + i, XTRA_OFS_WEAPON)
		while(iWeapon > 0 && pev_valid(iWeapon))
		{
			if(!iWeaponID || iWeaponID == cs_get_weapon_id(iWeapon))
			{
				return iWeapon
			}
			iWeapon = get_pdata_cbase(iWeapon, m_pNext, XTRA_OFS_WEAPON)
		}
	}
	return 0
}

killTrailBeam(id)
{
	if(!is_user_connected(id))
		return

	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(TE_KILLBEAM)
	write_short(id)
	message_end()
}

killEntity(iEnt)
{
	if(iEnt && pev_valid(iEnt))
	{
		engfunc(EngFunc_RemoveEntity, iEnt)
	}
}

setGuspe(id, Float:fOrigin[3])
{
	ScreenFade(id, {255, 255, 255}, 255, 2096, 1024, 1)
	fOrigin[2] += 15.0
	engfunc(EngFunc_SetOrigin, id, fOrigin)
		
	setFreeze(id, 1)
	set_user_noclip(id, 1)
	
	set_task(1.7, "upPlayer", id + TASK_UP_PLAYER)
}

printRarityInfo(id, iRarity, iWeaponID)
{
	if(isGrenade(iWeaponID))
		return
	
	if(iRarity)
	{
		static const g_szRaritiesName[][] =
		{
			"",
			"SERVER_RARITY_WHITE",
			"SERVER_RARITY_GREEN",
			"SERVER_RARITY_BLUE",
			"SERVER_RARITY_PURPLE",
			"SERVER_RARITY_GOLD"
		}
		CC_SendMatched(id, CC_COLOR_RED, "&x03%L", id, "SERVER_RARITY_INFO", id, g_szRaritiesName[iRarity], getWeaponRarityDmg(id, iWeaponID))
	}
}

getItemLife(iItemInfoID, iItemLevel)
{
	new iReturn, cCvarReturn
	if((iItemInfoID == g_szItens[iHelmetLv1][iItemID])
	|| (iItemInfoID == g_szItens[iHelmetLv2][iItemID])
	|| (iItemInfoID == g_szItens[iHelmetLv3][iItemID]))
	{
		switch(iItemLevel)
		{
			case 1:		cCvarReturn = cLevel1HelmetHits
			case 2:		cCvarReturn = cLevel2HelmetHits
			case 3:		cCvarReturn = cLevel3HelmetHits
		}
		iReturn = get_pcvar_num(g_pCvars[cCvarReturn])
	}
	else if((iItemInfoID == g_szItens[iKevlarLv1][iItemID])
	|| (iItemInfoID == g_szItens[iKevlarLv2][iItemID])
	|| (iItemInfoID == g_szItens[iKevlarLv3][iItemID]))
	{
		iReturn = getArmorLife(iItemLevel)
	}
	return iReturn
}

setRendering(iEnt, iRenderFx = kRenderFxNone, Float:fRenderColor[3] = {0.0, 0.0, 0.0}, Float:fRenderAmmt = 0.0)
{
	set_pev(iEnt, pev_renderfx, iRenderFx)
	set_pev(iEnt, pev_rendercolor, fRenderColor)
	set_pev(iEnt, pev_rendermode, kRenderNormal)
	set_pev(iEnt, pev_renderamt, fRenderAmmt)
}

spawnRandomItem(Float:fOrigin[3])
{
	new iEntitiesCreated = 0
	
	const iMinimumValue = 1
	while(canCreateNewItem(iEntitiesCreated))
	{
		if(random_num(1, 6) == iMinimumValue)
		{
			if(canCreateNewItem(iEntitiesCreated))
			{
				spawnItens(fOrigin, g_szItens[iChugJug][iItemID])
				iEntitiesCreated++
			}
		}
		
		if(random_num(1, 4) == iMinimumValue)
		{
			if(canCreateNewItem(iEntitiesCreated))
			{
				spawnItens(fOrigin, g_szItens[iMedKit][iItemID])
				iEntitiesCreated++
			}
		}

		if(random_num(1, 3) == iMinimumValue)
		{
			if(canCreateNewItem(iEntitiesCreated))
			{
				new iItemInfoID
				pubnite_get_customitem(random(pubnite_get_customitem_num()), iItemInfoID, "")
				spawnItens(fOrigin, iItemInfoID, .iPev3 = pubnite_get_customitem_life(iItemInfoID))
		
				iEntitiesCreated++
			}
		}

		if(random_num(1, 4) == iMinimumValue) 
		{
			if(canCreateNewItem(iEntitiesCreated))
			{
				spawnItens(fOrigin, g_szItens[iGuspe][iItemID])
				iEntitiesCreated++
			}
		}
		
		if(random_num(1, 3) == iMinimumValue) 
		{
			if(canCreateNewItem(iEntitiesCreated))
			{
				spawnItens(fOrigin, g_szItens[iHelmetLv3][iItemID], 3, .iPev3 = get_pcvar_num(g_pCvars[cLevel3HelmetHits]))
				iEntitiesCreated++
			}
		}
		
		if(random_num(1, 4) == iMinimumValue)
		{
			if(canCreateNewItem(iEntitiesCreated))
			{
				new iLevel = random_num(2, 3)
				spawnItens(fOrigin, g_szItens[(iLevel == 2) ? iBagLv2 : iBagLv3][iItemID], iLevel)
				iEntitiesCreated++
			}
		}
		
		if(random_num(1, 3) == iMinimumValue)
		{
			if(canCreateNewItem(iEntitiesCreated))
			{
				new iLevel = random_num(2, 3)
				spawnItens(fOrigin, g_szItens[(iLevel == 2) ? iKevlarLv2 : iKevlarLv3][iItemID], iLevel, .iPev3 = getArmorLife(iLevel))
				iEntitiesCreated++
			}
		}
	}
}

createWallEntity(id)
{
	new Float:fOrigin[3]
	originUnitsAhead(id, fOrigin, 110)

	if(isInvalidPlace(fOrigin, id))
	{
		CC_SendMatched(id, CC_COLOR_RED, "%L", id, "SERVER_INVALID_PLACE_TO_USE")
		lockedSound(id)
		return
	}
			
	new iEnt = create_entity("func_wall")
	if(pev_valid(iEnt))
	{
		g_dUserData[id][bHasWall] = false
				
		set_pev(iEnt, pev_origin, fOrigin)
		engfunc(EngFunc_SetModel, iEnt, g_szModelsData[mWallModel])
		set_pev(iEnt, pev_solid, SOLID_BBOX)
		set_pev(iEnt, pev_movetype, MOVETYPE_NOCLIP)
		set_pev(iEnt, pev_iuser1, id)
		engfunc(EngFunc_DropToFloor, iEnt)
		
		clientPlaySound(iEnt, g_szSoundsData[sWallCreateSound], true, .iChannel = CHAN_BODY, .fNewVolume = 0.3)
		set_task(1.0, "removePlayerWall", iEnt + TASK_WALL_REMOVE)
				
		set_pev(iEnt, pev_classname, g_szClassNamesData[cWall])
		set_pev(iEnt, pev_health, floatmax(get_pcvar_float(_:g_pCvars[cWallLife]), float(get_pcvar_num(g_pCvars[cWallHealthToTake]) * 4)))
		set_pev(iEnt, pev_takedamage, DAMAGE_AIM)

		new Float:fViewAngle[3] 
		pev(id, pev_v_angle, fViewAngle) 
		fViewAngle[0] = 0.0
				
		if(((fViewAngle[1] >= 45.0) && (fViewAngle[1] <= 135.0)) 
		|| ((fViewAngle[1] >= -135.0) && (fViewAngle[1] <= -45.0)))
		{
			if((fViewAngle[1] >= 45.0) && (fViewAngle[1] <= 135.0))
				fViewAngle[1] = -90.0
			else 
				fViewAngle[1] = 90.0

			engfunc(EngFunc_SetSize, iEnt, Float:{-100.78, -10.0, -0.44}, Float:{100.78, 6.0, 100.05})
		}
		else
		{
			if((fViewAngle[1] >= -45.0) && (fViewAngle[1] <= 45.0))
				fViewAngle[1] = 180.0
			else
				fViewAngle[1] = 0.0

			engfunc(EngFunc_SetSize, iEnt, Float:{-10.0, -100.78, -0.44}, Float:{6.0, 100.78, 100.05})
		}
				
		RegisterHamFromEntity(Ham_TakeDamage, iEnt, "ham_WallTakeDamage")
		set_pev(iEnt, pev_nextthink, get_gametime() + 1.0)
		set_pev(iEnt, pev_angles, fViewAngle)

		if(~pev(iEnt, pev_flags) & FL_ONGROUND)
		{
			fOrigin[2] -= distanceToGround(iEnt)
			engfunc(EngFunc_SetOrigin, iEnt, fOrigin)
			drop_to_floor(iEnt)
		}
	}
}

parachuteFreeMode(id)
{
	static Float:fGameTime;fGameTime = get_gametime()
	if(!g_dUserData[id][bParachuteOpened])
	{
		if((fGameTime - g_dUserData[id][fUserGameTime2]) >= 0.2)
		{
			g_dUserData[id][fUserGameTime2] = _:fGameTime
			g_dUserData[id][bParachuteOpened] = true
		}
	}
	else 
	{
		if((fGameTime - g_dUserData[id][fUserGameTime2]) >= 2.1)
		{
			g_dUserData[id][fUserGameTime2] = _:fGameTime
			g_dUserData[id][bParachuteOpened] = false
		}
	}
}

bool:customDamage(Float:fDamage, &Float:fNewDamage, iAttacker, bool:bIsHeDamage = false)
{
	if(!get_pcvar_num(g_pCvars[cAddRarities]))
	{
		fNewDamage = fDamage
		return false
	}
	
	fNewDamage = (fDamage * getWeaponRarityDmg(iAttacker, bIsHeDamage ? CSW_HEGRENADE : 0))
	return bool:isWeaponRegistered(g_dUserData[iAttacker][iPlayerWeaponID])
}

isWeaponRegistered(iWeapon, bool:bCheckModelFile = true)
{
	if(bCheckModelFile)
	{
		new iWeaponPos = getWeaponPos(iWeapon)
		if(iWeaponPos == -1)
			return false
			
		return bool:(g_szWeaponsModels[iWeaponPos][iWeaponInfoID] == iWeapon)
	}
	
	new szWeaponName[MAX_PLAYERS]
	changeWeaponName(iWeapon, szWeaponName)
	return bool:(strlen(szWeaponName) > 0)
}

formatTime(szFormatTime[18], iTime)
{
	new iSeconds = (iTime % 60), iMinutes = (iTime / 60)
	if(iSeconds)
	{
		new szMinutes[3]
		if(iMinutes)
		{
			num_to_str(iMinutes, szMinutes, charsmax(szMinutes))
		}
		formatex(szFormatTime, charsmax(szFormatTime), "%s%s%d", szMinutes, iMinutes ? ":" : "", iSeconds)
	}
}

cmdDropItem(id, iMenuItemID)
{	
	new Float:fOrigin[3], iLevel, iPev3
	pev(id, pev_origin, fOrigin)
	
	if(pubnite_is_customitem(iMenuItemID))
	{
		ExecuteForward(g_forwardCustomItemDropped, g_iReturn, id, iMenuItemID)
		return
	}
	
	if(iMenuItemID == -1)
	{
		CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_NO_ITEMS")
		lockedSound(id)
		return 	
	}
	else if((iMenuItemID == g_szItens[iKevlarLv1][iItemID])
	|| (iMenuItemID == g_szItens[iKevlarLv2][iItemID])
	|| (iMenuItemID == g_szItens[iKevlarLv3][iItemID]))
	{
		new CsArmorType:iArmorValue
		if(!g_dUserData[id][iArmorLevel])
		{
			CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_HAVENOT_THAT_ITEM")
			lockedSound(id)
			return 
		}
			
		iLevel = g_dUserData[id][iArmorLevel]
		iPev3 = floatround(entity_get_float(id, EV_FL_armorvalue))
			
		cs_set_user_armor(id, 0, iArmorValue)
		g_dUserData[id][iArmorLevel] = 0
	}
	else if(iMenuItemID == g_szItens[iMedKit][iItemID])
	{
		if(!g_dUserData[id][iMedKits])
		{
			CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_HAVENOT_THAT_ITEM")
			lockedSound(id)
			return 
		}
			
		g_dUserData[id][iMedKits]--
		if(!g_dUserData[id][iMedKits] && task_exists(id + TASK_MEDKIT))
		{
			stopUsageFeature(id, 0)
		}
	}
	else if((iMenuItemID == g_szItens[iHelmetLv1][iItemID])
	|| (iMenuItemID == g_szItens[iHelmetLv2][iItemID])
	|| (iMenuItemID == g_szItens[iHelmetLv3][iItemID]))
	{
		if(!g_dUserData[id][iHelmetEnt])
		{
			CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_HAVENOT_THAT_ITEM")
			lockedSound(id)
			return 
		}
			
		iLevel = g_dUserData[id][iHelmetLevel]
		iPev3 = pev(g_dUserData[id][iHelmetEnt], pev_iuser3)

		removeHelmet(id)
	}
	else if((iMenuItemID == g_szItens[iBagLv1][iItemID])
	|| (iMenuItemID == g_szItens[iBagLv2][iItemID])
	|| (iMenuItemID == g_szItens[iBagLv3][iItemID]))
	{
		if(!g_dUserData[id][iBagLevel])
		{
			CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_HAVENOT_THAT_ITEM")
			lockedSound(id)
			return 
		}
			
		iLevel = g_dUserData[id][iBagLevel]
		g_dUserData[id][iBagLevel] = 0
			
		for(new i;i < (getMaxValue(id, 2) - getMaxValue(id, 1));i++)
		{
			dropItems(id, true)
		}
	}
	else if(iMenuItemID == g_szItens[iImpulseGrenade][iItemID])
	{
		if(!user_has_weapon(id, CSW_SMOKEGRENADE))
		{
			CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_HAVENOT_THAT_ITEM")
			lockedSound(id)
			return 
		}
			
		stripWeapon(id, "weapon_smokegrenade")
		spawnItens(fOrigin, g_szItens[iImpulseGrenade][iItemID], .id = id)
		return
	}
	else if(iMenuItemID == g_szItens[iGuspe][iItemID])
	{
		if(!g_dUserData[id][bHasGuspe])
		{
			CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_HAVENOT_THAT_ITEM")
			lockedSound(id)
			return 
		}
			
		g_dUserData[id][bHasGuspe] = false
	}
	else if(iMenuItemID == g_szItens[iChugJug][iItemID])
	{
		if(!g_dUserData[id][bHasChugJug])
		{
			CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_HAVENOT_THAT_ITEM")
			lockedSound(id)
			return 
		}
			
		g_dUserData[id][bHasChugJug] = false
		if(task_exists(id + TASK_CHUG_JUG_HEAL))
		{
			stopUsageFeature(id, 1)
		}
	}
	else if(iMenuItemID == g_szItens[iWall][iItemID])
	{
		if(!g_dUserData[id][bHasWall])
		{
			CC_SendMatched(id, CC_COLOR_RED, "^x03%L", id, "SERVER_HAVENOT_THAT_ITEM")
			lockedSound(id)
			return 
		}
			
		g_dUserData[id][bHasWall] = false
	}

	spawnItens(fOrigin, iMenuItemID, iLevel, id, iPev3)
}

cmdUseItem(id, iMenuItemID)
{
	if(iMenuItemID == g_szItens[iMedKit][iItemID])
	{
		if(canUseMedKit(id))
		{
			cmdUseHealItem(id, 0)
		}
	}
	else if(iMenuItemID == g_szItens[iChugJug][iItemID])
	{
		if(canUseChugJug(id))
		{
			cmdUseHealItem(id, 1)
		}
	}
	else if(iMenuItemID == g_szItens[iGuspe][iItemID])
	{
		cmdDrop(id)
	}
}

cmdUseHealItem(id, iItemType)
{
	static Float:fGameTime;fGameTime = get_gametime()
	if(iItemType)
	{
		if(!task_exists(id + TASK_CHUG_JUG_HEAL))
		{
			new CsArmorType:iArmorValue
			if((get_user_health(id) >= MAX_HEALTH) && (cs_get_user_armor(id, iArmorValue) >= MAX_HEALTH))
			{
				if((fGameTime - g_dUserData[id][fUserGameTime]) > MESSAGE_DELAY)
				{
					g_dUserData[id][fUserGameTime] = _:fGameTime
					CC_SendMatched(id, CC_COLOR_GREY, "%L", id, "SERVER_FULL_HEALTH")
					lockedSound(id)
				}
				return
			}
			remove_task(id + TASK_MEDKIT)
			new iChugJugTime = get_pcvar_num(g_pCvars[cChugJugTime])
					
			clientPlaySound(id, g_szSoundsData[sChugJugSound], true, .iChannel = CHAN_AUTO)
			
			stopUsageFeature(id, 0)
			stopUsageFeature(id, 2)
			stopUsageFeature(id, 3)
			
			set_task(float(iChugJugTime), "setCompleteHeal", id + TASK_CHUG_JUG_HEAL)
			barTime(id, .iTime = iChugJugTime)
		}
	}
	else
	{
		if(!task_exists(id + TASK_MEDKIT))
		{
			if(get_user_health(id) >= MAX_HEALTH)
			{
				if((fGameTime - g_dUserData[id][fUserGameTime]) > MESSAGE_DELAY)
				{
					g_dUserData[id][fUserGameTime] = _:fGameTime
					CC_SendMatched(id, CC_COLOR_GREY, "%L", id, "SERVER_FULL_HEALTH")
					lockedSound(id)
				}
				return
			}
			remove_task(id + TASK_CHUG_JUG_HEAL)
			new iCvarMedkitTime = get_pcvar_num(g_pCvars[cMedkitTime])
			set_task(float(iCvarMedkitTime), "startRegen", id + TASK_MEDKIT)
				
			clientPlaySound(id, g_szSoundsData[sUsingMedkit], true, .iChannel = CHAN_AUTO)
			stopUsageFeature(id, 1)

			barTime(id, .iTime = iCvarMedkitTime)
		}
	}
}

isUsableItem(iMenuItemID)
{
	if(pubnite_is_customitem(iMenuItemID))
		return 1
		
	if((iMenuItemID == g_szItens[iMedKit][iItemID]) 
	|| (iMenuItemID == g_szItens[iChugJug][iItemID])
	|| (iMenuItemID == g_szItens[iGuspe][iItemID]))
	{
		return 1
	}
	return 0
}

setScreenFadeAcordingToRarity(id, iEnt)
{
	new iRGB[3]
	switch(pev(iEnt, pev_iuser4))
	{
		case RARITY_GREY: 	iRGB = {150, 150, 150}
		case RARITY_GREEN:	iRGB = {0, 255, 0}
		case RARITY_BLUE:	iRGB = {0, 100, 255}
		case RARITY_PURPLE:	iRGB = {255, 0, 255}
		case RARITY_GOLD:	iRGB = {255, 100, 0}
	}
	ScreenFade(id, iRGB, 75)
}

manageHeadShot(iVictim, iAttacker, &Float:fDamageControl)
{
	new iVictimHelmetID = g_dUserData[iVictim][iHelmetEnt]
	if(pev_valid(iVictimHelmetID))
	{
		fDamageControl /= (g_dUserData[iVictim][iHelmetLevel] + 1.0)
		set_pev(iVictimHelmetID, pev_iuser3, (pev(iVictimHelmetID, pev_iuser3) - 1))

		if(floatround(fDamageControl) < get_user_health(iVictim))
		{
			clientPlaySound(iAttacker, g_szSoundsData[sCriticalHit])
		}
					
		clientPlaySound(iVictim, g_szSoundsData[sHelmetHit], true)
		checkHeadHits(iVictim, g_dUserData[iVictim][iHelmetLevel])
	}
}

getItemLevelByID(iCmdItemID)
{
	new iLevelReturn
	if((iCmdItemID == g_szItens[iBagLv1][iItemID])
	|| (iCmdItemID == g_szItens[iKevlarLv1][iItemID])
	|| (iCmdItemID == g_szItens[iHelmetLv1][iItemID]))
	{
		iLevelReturn = 1
	}
	else if((iCmdItemID == g_szItens[iBagLv2][iItemID])
	|| (iCmdItemID == g_szItens[iKevlarLv2][iItemID])
	|| (iCmdItemID == g_szItens[iHelmetLv2][iItemID]))
	{
		iLevelReturn = 2
	}
	else if((iCmdItemID == g_szItens[iBagLv3][iItemID])
	|| (iCmdItemID == g_szItens[iKevlarLv3][iItemID])
	|| (iCmdItemID == g_szItens[iHelmetLv3][iItemID]))
	{
		iLevelReturn = 3
	}
	return iLevelReturn
}

stopUsageFeature(id, iItemToStop)
{
	switch(iItemToStop)
	{
		case 0:
		{
			clientStopSound(id, true, g_szSoundsData[sUsingMedkit], .iChannel = CHAN_AUTO)
			remove_task(id + TASK_MEDKIT)
		}
		case 1:
		{
			clientStopSound(id, true, g_szSoundsData[sChugJugSound], .iChannel = CHAN_AUTO)
			remove_task(id + TASK_CHUG_JUG_HEAL)
		}
		case 2:
		{
			remove_task(g_dUserData[id][iChestID] + TASK_SPIT_ITEMS)
			g_dUserData[id][iChestID] = 0
		}
		case 3:
		{
			clientStopSound(id, true, g_szSoundsData[sSupplyOpeningSound], .iChannel = CHAN_BODY)

			remove_task(g_dUserData[id][iUserSupplyID] + TASK_AD_SPIT_ITEMS)
			g_dUserData[id][iUserSupplyID] = 0
		}
	}
	barTime(id, .iTime = 0)
}

manageKnockFeature(iVictim, iAttacker)	
{
	if(task_exists(iVictim + TASK_UP_PLAYER))
	{
		setFreeze(iVictim, 0)
		g_dUserData[iVictim][bHasGuspe] = true
	}

	set_task(1.5, "takeHealth", iVictim + TASK_REMOVEHEALTH, .flags = "b")

	checkTasks(iVictim, true)
	set_user_health(iVictim, MAX_HEALTH)
		
	clientPlaySound(iVictim, g_szSoundsData[sMateKnocked], .bToAllMates = true)
	clientPlaySound(iVictim, g_szSoundsData[sMateKnocked])
		
	new bool:bIsAttackerConnected = bool:is_user_connected(iAttacker)
	g_dUserData[iVictim][bParachuteOpened] = false
	g_dUserData[iVictim][bKnockedOut] = true
	g_dUserData[iVictim][iWeaponKnocker] = bIsAttackerConnected ? g_dUserData[iAttacker][iPlayerWeaponID] : CSW_KNIFE
	g_dUserData[iVictim][iKnockerID] = (bIsAttackerConnected && (iVictim != iAttacker)) ? iAttacker : iVictim
	g_dUserData[iVictim][iKnocks]++
	
	ExecuteForward(g_forwardKnockedOut, g_iReturn, iAttacker, iVictim, g_dUserData[iVictim][iWeaponKnocker])
	
	static szKillMessage[2][190]
	if(bIsAttackerConnected)
	{
		clientPlaySound(iAttacker, g_szSoundsData[sKnockedAnEnemy])

		static szWeaponName[MAX_PLAYERS]
		changeWeaponName(g_dUserData[iAttacker][iPlayerWeaponID], szWeaponName, iAttacker)
			
		set_dhudmessage(220, 255, 220, -1.0, 0.65, 0, 1.0, 2.0)
		show_dhudmessage(iAttacker, "%L", iAttacker, "SERVER_YOU_KNOCKED_HUD", g_dUserData[iVictim][szName])
		
		changeWeaponName(g_dUserData[iAttacker][iPlayerWeaponID], szWeaponName, iVictim)
		formatex(szKillMessage[0], charsmax(szKillMessage[]), "%L", iVictim, "SERVER_KNOCKED_VICTIM_HUD", g_dUserData[iAttacker][szName])
		formatex(szKillMessage[1], charsmax(szKillMessage[]), "^x03%L", iVictim, "SERVER_KNOCKED_VICTIM_MESSAGE", g_dUserData[iAttacker][szName])
	}
	else
	{
		formatex(szKillMessage[0], charsmax(szKillMessage[]), "%L", iVictim, "SERVER_KNOCKED_BY_FALLING")
		formatex(szKillMessage[1], charsmax(szKillMessage[]), "%L", iVictim, "SERVER_KNOCKED_BY_FALLING")
	}
	set_dhudmessage(220, 255, 220, -1.0, 0.65, 0, 1.0, 2.0)
	show_dhudmessage(iVictim, szKillMessage[0])
}

showStatusTxt(id, szMessage[] = "")
{
	message_begin(MSG_ONE_UNRELIABLE, g_mMessageStatusText, .player = id)  
	write_byte(0)  
	write_string(szMessage)  
	message_end()
}

checkDamageThroughWallItem(iAttacker)
{
	new fEyeOrigin[3], Float:fPlayerOrigin[3], Float:fAimVector[3], Float:fRecVector[3]
    
	pev(iAttacker, pev_v_angle, fAimVector)
	pev(iAttacker, pev_punchangle, fRecVector)
	get_user_origin(iAttacker, fEyeOrigin, 1)
	IVecFVec(fEyeOrigin, fPlayerOrigin)
            
	fAimVector[0] += fRecVector[0]
	fAimVector[1] += fRecVector[1]
	fAimVector[2] += fRecVector[2]
    
	angle_vector(fAimVector, ANGLEVECTOR_FORWARD, fAimVector)
            
	fAimVector[0] = fAimVector[0] * 9999.0 + fPlayerOrigin[0]
	fAimVector[1] = fAimVector[1] * 9999.0 + fPlayerOrigin[1]
	fAimVector[2] = fAimVector[2] * 9999.0 + fPlayerOrigin[2]
    
	new trace = create_tr2()
	engfunc(EngFunc_TraceLine, fPlayerOrigin, fAimVector, DONT_IGNORE_MONSTERS, iAttacker, trace)
	return get_tr2(trace, TR_pHit)
}

executeKill(iVictim, iAttacker)		
{
	if(iAttacker && is_user_connected(iAttacker))
	{
		ExecuteHamB(Ham_Killed, iVictim, iAttacker, 1)
	}
	else user_kill(iVictim, 1)
}

checkAllTeams()
{
	new iPlayers[MAX_PLAYERS], iNum
	get_players(iPlayers, iNum, "ach")
	
	new iTeamNum
	if(iNum < get_pcvar_num(g_pCvars[cMinPlayersToDuo]))
		iTeamNum = 2
			
	else if(iNum < get_pcvar_num(g_pCvars[cMinPlayersToThreesome]))
		iTeamNum = 3
			
	else if(iNum < get_pcvar_num(g_pCvars[cMinPlayersToSquad]))
		iTeamNum = get_pcvar_num(g_pCvars[cMaxPlayersInATeam])
		
	if(iTeamNum)
	{
		get_players(iPlayers, iNum, "ch")
		for(new j, iPlayer; j < iNum; j++)
		{
			for(new i; i < ArraySize(g_arTeams); i++)
			{
				if(getPlayersNumInATeam(i) == iTeamNum)
				{
					iPlayer = iPlayers[j]
					
					if(g_dUserData[iPlayer][iTeamID] == i)
					{
						removeMateSpr(iPlayer)
						g_dUserData[iPlayer][iTeamID] = 0
							
						clientPlaySound(iPlayer, g_szSoundsData[sRadioAlert])
						CC_SendMatched(iPlayer, CC_COLOR_RED, "&x03%L", iPlayer, "SERVER_TEAM_CANCELED_DUE_INSUFICIENT_PLAYERS")
					}
				}
			}
		}
	}
}

updateScoreBoard(id, iFrags)
{
	message_begin(MSG_ALL, g_mMessageScoreInfo)
	write_byte(id)
	write_short(iFrags)
	write_short(get_user_deaths(id))
	write_short(0)
	write_short(get_user_team(id))
	message_end()
}
