#include <amxmodx>
#include <amxmisc>
#include <cstrike>
#include <engine>
#include <fakemeta>
#include <hamsandwich>
#include <cromchat>
#include <pubnite_mod>
#include <nvault>
#include <xs>

#define PLUGIN 				"PUBNite: Players Skins Menu"
#define VERSION 			"1.0"
#define AUTHOR 				"EFFEX"

#define validEntity(%1)			(g_iEntityID[%1] && pev_valid(g_iEntityID[%1]))
#define userItemID(%1)			(g_iUserModel[%1] - 1)

#define OFFSET_INTERNALMODELS 		126
#define MAX_MODELS_SKINS		25
#define TASK_TURNBACK			83218318

enum cModelsArray
{
	cModelName[MAX_PLAYERS],
	cModelFile[MAX_MODEL_LENGTH],
	iModelPrice
}

new const g_szBuySound[] = 		"pubg/effects/model_buy_sound.wav"

new Array:g_arModels
new g_nVaultBet, g_mMessageScreenFade

new bool:g_bHasModel[MAX_PLAYERS + 1][MAX_MODELS_SKINS]
new g_iUserModel[MAX_PLAYERS + 1], g_iEntityID[MAX_PLAYERS + 1]

public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR)

	if(is_plugin_loaded("BattleRoyale Mod") == -1)
	{
		set_fail_state("MOD DISABLED")
	}
	
	CC_SetPrefix("&x04[EFFx S]&x01:")
	
	register_dictionary("effxs_skinshop.txt")
	register_dictionary("effxs_battleroyale.txt")
	
	g_mMessageScreenFade = get_user_msgid("ScreenFade")
	g_nVaultBet = nvault_open("MODELS")
	
	register_forward(FM_AddToFullPack, "forward_AddToFullPack", 1)
	RegisterHam(Ham_Spawn, "player", "ham_PlayerSpawn_Post", 1)

	new szModelsShop[MAX_PLAYERS], szCommandFmt[35]
	pubnite_get_command(cModelsShop, szModelsShop)
	formatex(szCommandFmt, charsmax(szCommandFmt), "say %s", szModelsShop)
	register_clcmd(szCommandFmt, "cmdModels")
}

public plugin_end()
{
	nvault_close(g_nVaultBet)
}

public plugin_precache()
{
	g_arModels = ArrayCreate(cModelsArray)
	
	precache_sound(g_szBuySound)
	readIniData()
}

public client_connect(id)
{
	if(!is_user_bot(id))
	{
		loadData(id)
	}
}

public ham_PlayerSpawn_Post(id)
{
	if(is_user_alive(id) && g_iUserModel[id])
	{
		new arrayData[cModelsArray]
		ArrayGetArray(g_arModels, min(userItemID(id), ArraySize(g_arModels) - 1), arrayData)
		cs_set_user_model(id, arrayData[cModelFile])
	}
}

public cmdModels(id)
{
	static szTittle[60]
	formatex(szTittle, charsmax(szTittle), "PUBNite - Players Models^n\dVBucks: %d", pubnite_get_user_vbucks(id))
	
	new iMenu = menu_create(szTittle, "handler_models")
	for(new i, szPrice[10], arrayData[cModelsArray], szItemFormat[55];i < ArraySize(g_arModels);i++)
	{
		ArrayGetArray(g_arModels, i, arrayData)
		num_to_str(arrayData[iModelPrice], szPrice, charsmax(szPrice))

		formatex
		(
			szItemFormat, charsmax(szItemFormat), 
			"%s - [\r%s%s]", 
			arrayData[cModelName], 
			g_bHasModel[id][i] ? (userItemID(id) == i) ? "\yON\w" : "\rOFF\w" : szPrice, 
			g_bHasModel[id][i] ? "" : " \rVBucks\w"
		)
		menu_additem(iMenu, szItemFormat)
	}
	menu_display(id, iMenu)
	return PLUGIN_HANDLED
}

public forward_AddToFullPack(es_handle, e, iEnt, iHost, hostflags, player, pSet)
{	
	if(is_user_alive(iEnt) || !pev_valid(iEnt))
		return FMRES_IGNORED
		
	if(is_user_alive(iHost) && validEntity(iHost))
	{
		static iOwner;iOwner = pev(iEnt, pev_owner)
		if(is_user_connected(iOwner)
		&& (iOwner == iHost) 
		&& (iEnt == g_iEntityID[iHost]))
		{
			set_es(es_handle, ES_RenderAmt, 255)
		}
	}
	return FMRES_IGNORED
}

public handler_models(id, iMenu, iItem)
{
	if(iItem == MENU_EXIT)
	{
		menu_destroy(iMenu)
		return
	}
	
	new arrayData[cModelsArray]
	ArrayGetArray(g_arModels, iItem, arrayData)
	
	new iUserVBucks = pubnite_get_user_vbucks(id), iPrice = arrayData[iModelPrice]
	if(userItemID(id) == iItem)
	{
		CC_SendMatched(id, CC_COLOR_RED, "%L", id, "SERVER_ALREADY_HAVE_SKIN", arrayData[cModelName])
		menu_display(id, iMenu)
		return
	}
	else if(!g_bHasModel[id][iItem] && (iUserVBucks < iPrice))
	{
		CC_SendMatched(id, CC_COLOR_RED, "%L", id, "SERVER_NOT_ENOUGH_VBUCKS", arrayData[cModelName])
		menu_display(id, iMenu)
		return
	}

	new szModel[MAX_MODEL_LENGTH]
	if(!g_bHasModel[id][iItem])
	{
		askMenu(id, iItem)
		
		new Float:fOrigin[3], iEnt
		originUnitsAhead(id, fOrigin, 110)

		if(validEntity(id))
		{
			iEnt = g_iEntityID[id]

			set_pev(iEnt, pev_origin, fOrigin)
			formatex(szModel, charsmax(szModel), "models/player/%s/%s.mdl", arrayData[cModelFile], arrayData[cModelFile])
			engfunc(EngFunc_SetModel, iEnt, szModel)
			return
		}
		
		if(isInvalidPlace(fOrigin, id))
		{
			CC_SendMatched(id, CC_COLOR_RED, "%L", id, "SERVER_INVALID_PLACE_TO_USE")
			client_cmd(id, "spk buttons/button11")
			return
		}
			
		iEnt = create_entity("info_target")
		if(pev_valid(iEnt))
		{
			g_iEntityID[id] = iEnt
				
			set_pev(iEnt, pev_origin, fOrigin)
			formatex(szModel, charsmax(szModel), "models/player/%s/%s.mdl", arrayData[cModelFile], arrayData[cModelFile])
			engfunc(EngFunc_SetModel, iEnt, szModel)
			set_pev(iEnt, pev_solid, SOLID_NOT)
			set_pev(iEnt, pev_owner, id)
			set_pev(iEnt, pev_movetype, MOVETYPE_NOCLIP)
				
			set_pev(iEnt, pev_rendermode, kRenderTransAlpha)
			set_pev(iEnt, pev_renderamt, 0.0)
				
			static Float:fFloatvector[3]
			fFloatvector[1] = 30.0
			set_pev(iEnt, pev_avelocity, fFloatvector)
		}
	}
	else 
	{
		CC_SendMatched(id, CC_COLOR_RED, "%L", id, "SERVER_YOU_SELECTED", arrayData[cModelName])

		formatex(szModel, charsmax(szModel), arrayData[cModelFile])
		setModel(id, (iItem + 1), szModel)
		
		cmdModels(id)
	}
}

askMenu(id, iItemID)
{
	static szTittle[80]
	formatex(szTittle, charsmax(szTittle), "PUBNite - Players Models^n\d%L^n\dVBucks: %d", id, "SERVER_QUESTION_MENU", pubnite_get_user_vbucks(id))
	
	new iMenu = menu_create(szTittle, "askmenu_handler"), szItemID[10], szItemFmt[15]
	num_to_str(iItemID, szItemID, charsmax(szItemID))
	
	formatex(szItemFmt, charsmax(szItemFmt), "\y%L", id, "SERVER_YES")
	menu_additem(iMenu, szItemFmt, szItemID)
	
	formatex(szItemFmt, charsmax(szItemFmt), "\r%L", id, "SERVER_NO")
	menu_additem(iMenu, szItemFmt)
	
	menu_display(id, iMenu)
	
	set_task(10.0, "turnModelBack", id + TASK_TURNBACK)
}

public askmenu_handler(id, iMenu, iItem)
{
	turnPlayerModelBack(id)
	remove_task(id + TASK_TURNBACK)
	
	switch(iItem)
	{
		case MENU_EXIT:
		{
			menu_destroy(iMenu)
		}
		case 0:
		{
			new szData[10], szItemName[MAX_MODEL_LENGTH], _access, item_callback
			menu_item_getinfo(iMenu, iItem, _access, szData,charsmax(szData), szItemName, charsmax(szItemName), item_callback)
			
			new iItemID = str_to_num(szData), arrayData[cModelsArray], iPrice
			ArrayGetArray(g_arModels, iItemID, arrayData)
				
			CC_SendMatched(id, CC_COLOR_RED, "%L", id, "SERVER_YOU_BOUGHT", arrayData[cModelName], (iPrice = arrayData[iModelPrice]))
				
			message_begin(MSG_ONE, g_mMessageScreenFade, .player = id)
			write_short(4300)
			write_short(0)
			write_short(0)
			write_byte(255)
			write_byte(255) 
			write_byte(255) 
			write_byte(65) 
			message_end()
			
			client_cmd(id, "spk ^"%s^"", g_szBuySound)
			pubnite_set_user_vbucks(id, (pubnite_get_user_vbucks(id) - iPrice))
				
			g_bHasModel[id][iItemID] = true
			g_iUserModel[id] = iItemID + 1
			saveData(id)
		}
		case 1: cmdModels(id)
	}
}

setModel(id, iModelID = 0, szModel[MAX_MODEL_LENGTH] = "")
{
	if(iModelID)
	{
		g_iUserModel[id] = iModelID
		saveData(id)
	}
	
	if(pubnite_is_in_countdown() && is_user_alive(id))
	{
		if(!szModel[0])
		{
			new arrayData[cModelsArray]
			ArrayGetArray(g_arModels, userItemID(id), arrayData)
			copy(szModel, charsmax(szModel), arrayData[cModelFile])
		}
		cs_set_user_model(id, szModel)
	}
}

public turnModelBack(id)
{
	turnPlayerModelBack(id - TASK_TURNBACK)
}

turnPlayerModelBack(id)
{
	if(validEntity(id))
	{
		remove_entity(g_iEntityID[id])
	}
	g_iEntityID[id] = 0

	if(!is_user_connected(id))
		return
	
	show_menu(id, 0, "^n")
	
	if(g_iUserModel[id])
	{
		setModel(id)
	}
	else cs_reset_user_model(id)
}

readIniData()
{
	new szConfig[MAX_PLAYERS], szIniFile[164]
	get_configsdir(szConfig, charsmax(szConfig))
	formatex(szIniFile, charsmax(szIniFile), "%s/pubnite_mod/pubnite_management/pubnite_playersskins.ini", szConfig)
	if(!file_exists(szIniFile)) 
	{
		log_to_file("pubnite_log.log", "[PUBNite Mod]: %L", LANG_SERVER, "SERVER_NO_CONFIG_FILE", szIniFile)
		return
	}

	new szBuffer[512], szKey[50], szValue[MAX_MODEL_LENGTH], arrayData[cModelsArray]
	new szModelName[MAX_PLAYERS], szModel[MAX_MODEL_LENGTH], szModelFile[MAX_MODEL_LENGTH], szPrice[15]
	
	new iFile = fopen(szIniFile, "rt")
	while(!feof(iFile) && (ArraySize(g_arModels) < MAX_MODELS_SKINS))
	{
		fgets(iFile, szBuffer, charsmax(szBuffer))
		trim(szBuffer)
		
		if((szBuffer[0] == EOS) || (szBuffer[0] == ';') || ((szBuffer[0] == '/') && (szBuffer[1] == '/')))
			continue
			
		trim(szKey)
		trim(szValue)
		
		parse
		(
			szBuffer, 
			szModelName, charsmax(szModelName), 
			szModel, charsmax(szModel),
			szPrice, charsmax(szPrice)
		)
		
		formatex(szModelFile, charsmax(szModelFile), "models/player/%s/%s.mdl", szModel, szModel)
		if(file_exists(szModelFile))
		{
			precacheModel(szModelFile)
			
			arrayData[cModelName] = szModelName
			arrayData[cModelFile] = szModel
			arrayData[iModelPrice] = str_to_num(szPrice)

			ArrayPushArray(g_arModels, arrayData)
		}
	}
	fclose(iFile)
}

precacheModel(szModel[])
{
	if(file_exists(szModel))
	{
		precache_model(szModel)

		// Quick&Dirty Fix
		new temp[80]
		copy(temp, (strlen(szModel) - 4), szModel)
		formatex(temp, charsmax(temp), "%st.mdl", temp)
		if(file_exists(temp))
		{
			precache_model(temp)
			return true
		}
		copy(temp, (strlen(szModel) - 4), szModel)
		formatex(temp, charsmax(temp), "%sT.mdl", temp)
		if(file_exists(temp))
		{
			precache_model(temp)
			return true
		}
		return true
	}
	return false
}

saveData(id)
{
	new szSteam[35]
	get_user_authid(id, szSteam, charsmax(szSteam)) 
    
	new vaultkey[64], vaultdata[64]
	format(vaultkey, charsmax(vaultkey), "%s-Save", szSteam)  
	format(vaultdata, charsmax(vaultdata), "%i", g_iUserModel[id])
	
	for(new i;i < MAX_MODELS_SKINS;i++)
	{
		formatex(vaultdata, charsmax(vaultdata), "%s %i", vaultdata, g_bHasModel[id][i])    
	}
	
	nvault_set(g_nVaultBet, vaultkey, vaultdata)
}

loadData(id) 
{
	new szSteam[35]
	get_user_authid(id, szSteam, charsmax(szSteam)) 
    
	new vaultkey[64], vaultdata[64]
	format(vaultkey, charsmax(vaultkey), "%s-Save", szSteam)
	format(vaultdata, charsmax(vaultdata), "%i", g_iUserModel[id])
	
	for(new i;i < MAX_MODELS_SKINS;i++)
	{
		formatex(vaultdata, charsmax(vaultdata), "%s %i", vaultdata, g_bHasModel[id][i])  
	}
	nvault_get(g_nVaultBet, vaultkey, vaultdata, charsmax(vaultdata))
	
	new Data[MAX_MODELS_SKINS][8]
	
	// LOL
	parse(vaultdata, Data[0], charsmax(Data), Data[1], charsmax(Data), Data[2], charsmax(Data), Data[3], charsmax(Data), Data[4], charsmax(Data), Data[5], charsmax(Data),
	Data[6], charsmax(Data), Data[7], charsmax(Data), Data[8], charsmax(Data), Data[9], charsmax(Data), Data[10], charsmax(Data), Data[11], charsmax(Data), Data[12], charsmax(Data),
	Data[13], charsmax(Data), Data[14], charsmax(Data), Data[15], charsmax(Data), Data[16], charsmax(Data), Data[17], charsmax(Data), Data[18], charsmax(Data), Data[19], charsmax(Data),
	Data[20], charsmax(Data), Data[21], charsmax(Data), Data[22], charsmax(Data), Data[23], charsmax(Data), Data[24])
	
	for(new i;i < sizeof Data;i++)
	{
		if(i > 0)
		{
			g_bHasModel[id][i - 1] = bool:str_to_num(Data[i])
		}
		else g_iUserModel[id] = str_to_num(Data[i])
	}
}
