#include <amxmodx>
#include <cstrike>
#include <fakemeta>
#include <fakemeta_util>
#include <engine>
#include <hamsandwich>
#include <pubnite_mod>
#include <cromchat>
#include <fun>
#include <xs>

#define PLUGIN 				"PUBNite: RPG"
#define VERSION 			"1.0"
#define AUTHOR 				"EFFEX"

#if !defined DMG_GRENADE
#define DMG_GRENADE			(1 << 24)
#endif

#define RPG_WORLD_MODEL			"models/pubg/itens/w_rpg.mdl"
#define RPG_WEAPON_NAME			"weapon_p90"
#define CSW_RPG_WEAPON			CSW_P90

#define calculateRadiusDamage(%1,%2)	floatclamp((%1 - (%2 * %1 / g_fRocketRadius)), 0.0, %1)
#define fixedUnsigned16(%1,%2) 		clamp(floatround(%1 * %2), 0, 0xFFFF)
#define getWeaponBoxID(%1,%2) 		get_pdata_cbase(%1, (m_rpgPlayerItems + %2), XTRA_OFS_PLAYER)

#define m_rgAmmo_player_Slot0		376
#define m_pActiveItem			373
#define m_rpgPlayerItems  		367
#define m_flNextAttack     		83
#define m_fInReload 			54
#define m_iClip				51
#define m_iPrimaryAmmoType		49
#define m_flNextPrimaryAttack		46
#define m_iId				43
#define m_pPlayer			41
#define XTRA_OFS_PLAYER  		5
#define XTRA_OFS_WEAPON			4

#define TASK_ROCKET_EXPLODE		80012
#define FIRE_SOUND_TIME			15.0
#define RPG_SLOT			1

new const g_szViewModel[] = 		"models/pubg/itens/v_rpg.mdl"
new const g_szPlayerModel[] = 		"models/pubg/itens/p_rpg.mdl"

new const g_szRpgFireSound[] = 		"pubg/effects/fire_sound.wav"
new const g_szRpgReady[] = 		"pubg/effects/rpg_ready.wav"
new const g_szRockedExplosion[] = 	"pubg/effects/rocket_explosion.wav"
new const g_szRpgReload[] =		"pubg/effects/rpg_reload.wav"

new const g_szRocketModel[] =		"models/rpgrocket.mdl"
new const g_szRocketClassName[] =	"rocket_class"

const DELAYED_MESSAGE =			1

const Float:g_fRocketDamagePlayer =	70.0
const Float:g_fRocketDamageEntities =	150.0
const Float:g_fRocketRadius =		350.0
const Float:g_fRpgAttackDelay =		1.5

new bool:g_bHasRpg[MAX_PLAYERS + 1], g_iRPGBpAmmo[MAX_PLAYERS + 1]

new g_mMessageScreenShake, g_iTrailSprite, g_iParticlesSprite
new g_iRpgItemID

new pCvarRpgMinBullets, pCvarRpgBullets, pCvarRocketVelocity, pCvarSupportWeapon 

public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
		
	register_dictionary("effxs_customitens.txt")

	g_mMessageScreenShake = get_user_msgid("ScreenShake")
	
	pCvarRpgMinBullets = register_cvar("pubnite_rpg_minbullets", "1")
	pCvarRpgBullets = register_cvar("pubnite_rpg_bullets", "15")
	pCvarRocketVelocity = register_cvar("pubnite_rpg_rocket_velocity", "750")
	pCvarSupportWeapon =	register_cvar("pubnite_rpg_support_weapon", "0")
	
	register_clcmd("drop", "cmdDrop")
	register_event("CurWeapon", "event_CurWeapon", "be", "1=1")

	register_forward(FM_SetModel, "forward_SetModel")
	register_forward(FM_Touch, "forward_Touch")
	register_forward(FM_UpdateClientData, "fw_UpdateClientData_Post", 1)
	register_forward(FM_PlaybackEvent, "fw_PlaybackEvent")
	
	RegisterHam(Ham_Item_PostFrame, RPG_WEAPON_NAME, "Item_PostFrame")
	RegisterHam(Ham_Item_Deploy, RPG_WEAPON_NAME, "ham_RpgWeaponDeploy_Post", 1)
	RegisterHam(Ham_TakeDamage, "player", "ham_PlayerTakeDamage_Pre", 0)
	RegisterHam(Ham_Spawn, "player", "ham_PlayerSpawn_Post", 1)
	RegisterHam(Ham_Weapon_Reload, RPG_WEAPON_NAME, "ham_RpgReload", 1)
	 
	g_iRpgItemID = pubnite_register_customitem("RPG", RPG_WORLD_MODEL, RARITY_PURPLE, get_pcvar_num(pCvarRpgBullets), "hasRpg")
	if(!g_iRpgItemID)
	{
		set_fail_state("Couldn't create the RPG item.")
	}
}

public plugin_precache()
{
	g_iTrailSprite = 	precache_model("sprites/smoke.spr")
	g_iParticlesSprite =	precache_model("sprites/explode1.spr")
	
	precache_model(g_szViewModel)
	precache_model(g_szPlayerModel)
	precache_model(g_szRocketModel)
	
	precache_sound(g_szRpgReload)
	precache_sound(g_szRpgReady)
	precache_sound(g_szRockedExplosion)
	precache_sound(g_szRpgFireSound)
}

public hasRpg(id, &ret)
{
	ret = g_bHasRpg[id]
}

public pubnite_customitem_dropped(iPlayer, iCustomItemID)
{
	if((iCustomItemID == g_iRpgItemID) && g_bHasRpg[iPlayer])
	{
		dropRPG(iPlayer)
	}
}

public pubnite_noregistered_weapon(iPlayer, iWeaponID)
{
	if((iWeaponID == CSW_RPG_WEAPON) && g_bHasRpg[iPlayer] && !get_pcvar_num(pCvarSupportWeapon))
	{
		dropRPG(iPlayer)
	}
}

public pubnite_customitem_pickedup(iPlayer, iEntityID, iCustomItemID, iCustomItemLife, bUseButtonPressed)
{
	if((iCustomItemID == g_iRpgItemID) && !g_bHasRpg[iPlayer] && !pubnite_is_knockedout(iPlayer))
	{
		if(pubnite_has_customitem(iPlayer, pubnite_customitemid_by_name("Jetpack")))
		{
			static iSysTime, iMessageDelay[MAX_PLAYERS + 1]
			iSysTime = get_systime()
			if((iSysTime - iMessageDelay[iPlayer]) > DELAYED_MESSAGE)
			{
				iMessageDelay[iPlayer] = iSysTime
				
				CC_SendMatched(iPlayer, CC_COLOR_RED, "&x03%L", iPlayer, "SERVER_CANT_USE_BOTH_RPG_JETPACK")
				client_cmd(iPlayer, "spk buttons/button11")
			}
			return
		}
		
		new iWeapon = getWeaponBoxID(iPlayer, RPG_SLOT)
		if(iWeapon > 0)
		{
			if(!get_pcvar_num(pCvarSupportWeapon) && bUseButtonPressed)
			{
				dropWeapon(iWeapon, iPlayer)
			}
		}
		
		g_bHasRpg[iPlayer] = true
		give_item(iPlayer, RPG_WEAPON_NAME)
		
		new iWeaponEntity = find_ent_by_owner(-1, RPG_WEAPON_NAME, iPlayer)
		if(iWeaponEntity > 0)
		{
			new iPcvarMinBullets = get_pcvar_num(pCvarRpgMinBullets)
			set_pdata_int(iWeaponEntity, m_iClip, clamp(iCustomItemLife, 0, iPcvarMinBullets), XTRA_OFS_WEAPON)
			cs_set_user_bpammo(iPlayer, CSW_RPG_WEAPON, (g_iRPGBpAmmo[iPlayer] = clamp((iCustomItemLife - iPcvarMinBullets), 0, get_pcvar_num(pCvarRpgBullets))))
		}
		engfunc(EngFunc_RemoveEntity, iEntityID)
	}
}

public cmdDrop(id)
{
	if(!is_user_alive(id))
		return PLUGIN_HANDLED
		
	if((get_user_weapon(id) == CSW_RPG_WEAPON) && g_bHasRpg[id])
	{
		dropRPG(id)
		return PLUGIN_HANDLED
	}
	return PLUGIN_CONTINUE
}

public event_CurWeapon(id)
{
	if(read_data(2) == CSW_RPG_WEAPON)
	{
		if(cs_get_user_bpammo(id, CSW_RPG_WEAPON) < g_iRPGBpAmmo[id])
		{
			cs_set_user_bpammo(id, CSW_RPG_WEAPON, g_iRPGBpAmmo[id])
		}
	}
}

dropRPG(iPlayer)
{
	new iClip
	get_user_weapon(iPlayer, iClip)
	pubnite_create_customitem(g_iRpgItemID, (iClip + cs_get_user_bpammo(iPlayer, CSW_RPG_WEAPON)), iPlayer)
	
	if(is_user_alive(iPlayer))
	{
		stripUserWeapon(iPlayer, RPG_WEAPON_NAME)
	}

	g_bHasRpg[iPlayer] = false
}

public ham_RpgReload(const iWeapon)
{
	static id; id = get_pdata_cbase(iWeapon, m_pPlayer, XTRA_OFS_WEAPON)
	if(is_user_connected(id))
	{
		if(get_pdata_int(iWeapon, m_fInReload, XTRA_OFS_WEAPON))
		{	
			new iClip
			get_user_weapon(id, iClip)
			if(iClip >= get_pcvar_num(pCvarRpgMinBullets))
				return HAM_SUPERCEDE
		
			set_pdata_float(id, m_flNextAttack, g_fRpgAttackDelay, XTRA_OFS_PLAYER)
			
			SendWeaponAnim(id, 2)
			emit_sound(id, CHAN_WEAPON, g_szRpgReload, VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
		}
	}
	return HAM_IGNORED
}

public Item_PostFrame(iEnt)
{
	if(get_pdata_int(iEnt, m_iId, XTRA_OFS_WEAPON) != CSW_RPG_WEAPON)
		return HAM_IGNORED

	static id;id = get_pdata_cbase(iEnt, m_pPlayer, XTRA_OFS_WEAPON)
	static fInReload;fInReload = get_pdata_int(iEnt, m_fInReload, XTRA_OFS_WEAPON)
	
	static iAmmoType;iAmmoType = m_rgAmmo_player_Slot0 + get_pdata_int(iEnt, m_iPrimaryAmmoType, XTRA_OFS_WEAPON)
	static iBpAmmo;iBpAmmo = get_pdata_int(id, iAmmoType, XTRA_OFS_PLAYER)
	static iClip;iClip = get_pdata_int(iEnt, m_iClip, XTRA_OFS_WEAPON)
	
	static iRpgBullets;iRpgBullets = get_pcvar_num(pCvarRpgMinBullets)
	if(fInReload && get_pdata_float(id, m_flNextAttack, XTRA_OFS_PLAYER) <= 0.0)
	{
		new j = min(iRpgBullets - iClip, iBpAmmo)
		set_pdata_int(iEnt, m_iClip, iClip + j, XTRA_OFS_WEAPON)
		set_pdata_int(id, iAmmoType, (g_iRPGBpAmmo[id] = (iBpAmmo - j)), XTRA_OFS_PLAYER)
		set_pdata_int(iEnt, m_fInReload, 0, XTRA_OFS_WEAPON)
		set_pdata_float(iEnt, m_flNextPrimaryAttack, 0.2, XTRA_OFS_WEAPON, XTRA_OFS_WEAPON)
		
		fInReload = 0
	}
	return HAM_IGNORED
}

public ham_RpgWeaponDeploy_Post(const iWeapon)
{
	static id; id = get_pdata_cbase(iWeapon, m_pPlayer, XTRA_OFS_WEAPON)
	if(is_user_connected(id))
	{
		if(cs_get_weapon_ammo(iWeapon) < 1)
		{
			ExecuteHamB(Ham_Weapon_PrimaryAttack, iWeapon)
		}
		
		SendWeaponAnim(id, 5)
		emit_sound(id, CHAN_ITEM, g_szRpgReady, VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
		
		set_pev(id, pev_viewmodel2, g_szViewModel)
		set_pev(id, pev_weaponmodel2, g_szPlayerModel)
	}
}

public ham_PlayerSpawn_Post(id)
{
	g_bHasRpg[id] = false
}

public fw_PlaybackEvent(flags, id, eventid, Float:delay, Float:origin[3], Float:angles[3], Float:fparam1, Float:fparam2, iParam1, iParam2, bParam1, bParam2)
{
	if(!is_user_connected(id) 
	|| (get_user_weapon(id) != CSW_RPG_WEAPON)
	|| !g_bHasRpg[id])
		return FMRES_IGNORED
		
	engfunc(EngFunc_PlaybackEvent, flags | FEV_HOSTONLY, id, eventid, delay, origin, angles, fparam1, fparam2, iParam1, iParam2, bParam1, bParam2)
	
	new iRocketEntity = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "info_target"))
	if(pev_valid(iRocketEntity))
	{	
		emit_sound(id, CHAN_WEAPON, "weapons/p90-1.wav", VOL_NORM, ATTN_NORM, SND_STOP, PITCH_NORM)
		
		new Float:fAngle[3], Float:fOrigin[3]
		pev(id, pev_angles, fAngle)
		pev(id, pev_origin, fOrigin)
		
		fOrigin[2] += (pev(id, pev_flags) & FL_DUCKING) ? 10.0 : 15.0
		
		engfunc(EngFunc_SetModel, iRocketEntity, g_szRocketModel)
		engfunc(EngFunc_SetOrigin, iRocketEntity, fOrigin)

		set_pev(iRocketEntity, pev_classname, g_szRocketClassName)
		set_pev(iRocketEntity, pev_solid, SOLID_BBOX)
		set_pev(iRocketEntity, pev_movetype, MOVETYPE_FLY)
		set_pev(iRocketEntity, pev_owner, id)

		new Float:vV_Angle[3], Float:vPunchangle[3]
		pev(id, pev_v_angle, vV_Angle)
		pev(id, pev_punchangle, vPunchangle)
	
		new Float:anglesAim[3]
		xs_vec_add(vV_Angle, vPunchangle, anglesAim)
		engfunc(EngFunc_MakeVectors, anglesAim)
		anglesAim[0] = -anglesAim[0]
		set_pev(iRocketEntity, pev_angles, anglesAim)
	
		message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
		write_byte(TE_BEAMFOLLOW)
		write_short(iRocketEntity)
		write_short(g_iTrailSprite)
		write_byte(10)
		write_byte(3)
		write_byte(220)
		write_byte(70)
		write_byte(0)
		write_byte(255)
		message_end()
			
		static Float:fVelocity[3]
		velocity_by_aim(id, get_pcvar_num(pCvarRocketVelocity), fVelocity)	
		set_pev(iRocketEntity, pev_velocity, fVelocity)
		
		new Float:fEndOrigin[3]
		get_user_hitpoint(id, fEndOrigin)
		if((get_distance_f(fOrigin, fEndOrigin) / xs_vec_len(fVelocity)) > FIRE_SOUND_TIME)
		{
			set_task(FIRE_SOUND_TIME, "explodeRocket", iRocketEntity + TASK_ROCKET_EXPLODE)
		}
		emit_sound(iRocketEntity, CHAN_BODY, g_szRpgFireSound, VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
	}		
	SendWeaponAnim(id, 3)
	
	set_pdata_float(get_pdata_cbase(id, m_pActiveItem, XTRA_OFS_PLAYER), m_flNextPrimaryAttack, 0.5, XTRA_OFS_WEAPON)
	set_pdata_float(id, m_flNextAttack, 0.5, XTRA_OFS_PLAYER)
	return FMRES_SUPERCEDE
}

get_user_hitpoint(id, Float:hOrigin[3])
{
	static Float:fOrigin[3], Float:fvAngle[3], Float:fvOffset[3], Float:fvOrigin[3], Float:feOrigin[3]
	static Float:fTemp[3]
	
	pev(id, pev_origin, fOrigin)
	pev(id, pev_v_angle, fvAngle)
	pev(id, pev_view_ofs, fvOffset)
	
	xs_vec_add(fOrigin, fvOffset, fvOrigin)
	engfunc(EngFunc_AngleVectors, fvAngle, feOrigin, fTemp, fTemp)
	xs_vec_mul_scalar(feOrigin, 8192.0, feOrigin)
	xs_vec_add(fvOrigin, feOrigin, feOrigin)
	
	static tr
	engfunc(EngFunc_TraceLine, fvOrigin, feOrigin, 0, id, tr)
	get_tr2(tr, TR_vecEndPos, hOrigin)
}

public explodeRocket(iEntity)
{
	if(!pev_valid((iEntity -= TASK_ROCKET_EXPLODE)))
		return

	manageDamageAndEffects(iEntity)
	engfunc(EngFunc_RemoveEntity, iEntity)
}

public fw_UpdateClientData_Post(id, sendweapons, cd_handle)
{
	if(!is_user_alive(id) || (get_user_weapon(id) != CSW_RPG_WEAPON))
		return FMRES_IGNORED	
		
	set_cd(cd_handle, CD_flNextAttack, get_gametime() + g_fRpgAttackDelay)
	return FMRES_IGNORED
}

public ham_PlayerTakeDamage_Pre(iVictim, iInflictor, iAttacker, Float:fDamage, iDamageBits)
{	
	if(!is_user_connected(iVictim) || !is_user_connected(iAttacker) || (iDamageBits & DMG_GRENADE))
		return HAM_IGNORED
	
	if(get_user_weapon(iAttacker) == CSW_RPG_WEAPON)
	{
		SetHamReturnInteger(0)
		return HAM_SUPERCEDE
	}
	return HAM_IGNORED
}

public forward_Touch(iToucher, iTouched)
{
	if(!pev_valid(iToucher))
		return FMRES_IGNORED
		
	static szClassNameToucher[MAX_PLAYERS]
	pev(iToucher, pev_classname, szClassNameToucher, charsmax(szClassNameToucher))
	if(equal(szClassNameToucher, g_szRocketClassName))
	{
		manageDamageAndEffects(iToucher)
		engfunc(EngFunc_RemoveEntity, iToucher)
	}
	return FMRES_IGNORED
}

public forward_SetModel(iEnt, szModel[])
{
	if(!pev_valid(iEnt))
		return FMRES_IGNORED
		
	if(equal(szModel, "models/w_p90.mdl"))
	{
		dllfunc(DLLFunc_Think, iEnt)
		return FMRES_SUPERCEDE
	}
	return FMRES_IGNORED
}

// Edited from here - https://forums.alliedmods.net/showpost.php?p=1019061&postcount=4
manageDamageAndEffects(iRocket)
{
	remove_task(iRocket + TASK_ROCKET_EXPLODE)
	emit_sound(iRocket, CHAN_BODY, g_szRpgFireSound, VOL_NORM, ATTN_NORM, SND_STOP, PITCH_NORM)
	emit_sound(iRocket, CHAN_BODY, g_szRockedExplosion, VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
	
	new Float:vExplodeAt[3]
	pev(iRocket, pev_origin, vExplodeAt)
		
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(TE_EXPLOSION)
	write_coord(floatround(vExplodeAt[0]))
	write_coord(floatround(vExplodeAt[1]))
	write_coord(floatround(vExplodeAt[2]))
	write_short(g_iParticlesSprite)
	write_byte(40)
	write_byte(5)
	write_byte(TE_EXPLFLAG_NOSOUND)
	message_end()
	
	new iOwner = pev(iRocket, pev_owner)
	if(!is_user_alive(iOwner))
		return
		
	new id = FM_NULLENT, Float:vOrigin[3], Float:fRadiusDamage, Float:fMaxDamage
	while((id = engfunc(EngFunc_FindEntityInSphere, id, vExplodeAt, g_fRocketRadius)) != 0) 
	{
		if(pev_valid(id))
		{
			if(is_user_connected(id))
			{
				fMaxDamage = g_fRocketDamagePlayer

				message_begin(MSG_ONE, g_mMessageScreenShake, .player = id)
				write_short(fixedUnsigned16(20.0, (1 << 12)))
				write_short(fixedUnsigned16(3.0, (1 << 12)))
				write_short(fixedUnsigned16(5.7, (1 << 8)))
				message_end()
			}
			else fMaxDamage = g_fRocketDamageEntities
			
			if(pev(id, pev_takedamage) != DAMAGE_NO)
			{
				pev(id, pev_origin, vOrigin)
				
				static tr, Float:fFraction
				engfunc(EngFunc_TraceLine, vOrigin, vExplodeAt, 1, -1, tr)
				get_tr2(tr, TR_flFraction, fFraction)
				if(fFraction != 1.0)
					continue

				fRadiusDamage = calculateRadiusDamage(fMaxDamage, get_distance_f(vExplodeAt, vOrigin))
				if(fRadiusDamage >= get_user_health(id))
				{
					if(is_user_connected(id))
					{
						if(pubnite_able_to_knockout(id))
						{
							pubnite_force_knockout(id, iOwner)
						}
						else ExecuteHamB(Ham_Killed, id, iOwner, 1)
					}
					return
				}	
				ExecuteHamB(Ham_TakeDamage, id, iOwner, iRocket, fRadiusDamage, DMG_BLAST)
			}
		}
	}
}

stripUserWeapon(id, szWeapon[])
{
	if(!equal(szWeapon, "weapon_", 7)) 
		return

	new iWeaponId = get_weaponid(szWeapon)
	if(!iWeaponId) 
		return

	new iEnt = -1
	while((iEnt = engfunc(EngFunc_FindEntityByString, iEnt, "classname", szWeapon)) && pev(iEnt, pev_owner) != id) {}
		
	if(!iEnt) 
		return
	
	if(get_user_weapon(id) == iWeaponId) 
	{
		ExecuteHamB(Ham_Weapon_RetireWeapon, iEnt)
	}
	
	if(!ExecuteHamB(Ham_RemovePlayerItem, id, iEnt)) 
		return
		
	ExecuteHamB(Ham_Item_Kill, iEnt)
	set_pev(id, pev_weapons, pev(id, pev_weapons) & ~(1 << iWeaponId))
}

dropWeapon(iWeapon, player)
{	
	static szClassName[MAX_PLAYERS]
	pev(iWeapon, pev_classname, szClassName, charsmax(szClassName))
	engclient_cmd(player, "drop", szClassName)
}

SendWeaponAnim(id, iAnim)
{
	set_pev(id, pev_weaponanim, iAnim)

	message_begin(MSG_ONE_UNRELIABLE, SVC_WEAPONANIM, _, id)
	write_byte(iAnim)
	write_byte(pev(id, pev_body))
	message_end()
}
