#include <amxmodx>
#include <fakemeta>
#include <engine>
#include <hamsandwich>
#include <pubnite_mod>

#define PLUGIN    			"PUBNite: Red Zone"
#define VERSION     			"1.3"
#define AUTHOR     			"ggv/EFFx"

#define TASK_COMPRESSION 		23102511
#define TASK_FIXDISK 			23201221
#define TASK_STOPCOMPRESSION 		23301341
#define TASK_ZONEFIX 			23541141
#define TASK_TIMER 			23603212
#define TASK_SOUND_COMPRESSION		23702255
#define TASK_DAMAGE 			23802203

#define SAFEZONE_APPEAR_TIMES 		4
#define GETTING_TINY_TIMES 		4

#define LAST_SAFEZONE			5
#define WEIGH 				60
#define NUMSIDES 			15

new const ZONE_SPRITE[] = 		"sprites/pubg/pubg_redzone.spr"
new const zone_EntName[] = 		"pubg_redzone"

new const g_szGasStopedSound[] = 	"pubg/effects/redzone_stoped.wav" 
new const g_szGasWallkingSound[] = 	"pubg/effects/redzone_walking.wav"
new const g_szGasFormingSound[] =	"pubg/effects/redzone_forming.wav" 
new const g_szOutSideGas[] =		"pubg/effects/outside_redzone.wav"
new const g_szInsideGas[] =		"pubg/effects/inside_redzone.wav"

new const g_szHitSounds[][] =
{
	"player/bhit_flesh-1.wav",
	"player/bhit_flesh-2.wav",
	"player/bhit_flesh-3.wav",
	"player/bhit_kevlar-1.wav"
}

new const g_szRadioSounds[][] = 
{	 
	"%!MRAD_LOCKNLOAD", 
	"%!MRAD_MOVEOUT", 
	"%!MRAD_LETSGO", 
	"%!MRAD_GO"
}

new const g_szIcons[][] =
{
	"dmg_bio",
	"dmg_gas",
	"stopwatch"
}

new g_bWasInside[33]

new Float:fCurRadius // Current radius
new Float:fLastRadius // Previous radius
new Float:fCurZoneOrigins[3] // Current origins of zone's centre
new Float:fLastZoneOrigins[3] // Previous origins of zone's centre
new Float:Delta_X, Float:Delta_Y, Float:Delta_R
new Float:fHitDamage, Float:fWaitingTime, Float:fDiskSeconds, Float:fCompressionTime

new g_mMessageScreenFade, g_mMessageSendAudio, g_mMessageStatusIcon

new g_iSprite, g_iCompressTime, Seconds, g_CompressionLevel, g_iSystime, g_iTimesTelling[2]
new pcvarZoneSeconds, pcvarZoneAmt, pcvar_updaterate, pCvarWaitTime
new g_ZonePart[NUMSIDES * 2], Float:fDeltaScale, Float:fCurScale

new Float:g_fMaxZ
new bool:g_bCreatedZone

public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	if(is_plugin_loaded("BattleRoyale Mod") == -1)
	{
		set_fail_state("MOD DISABLED")
	}

	register_think(zone_EntName, "fw_Zone_Think")
	register_dictionary("effxs_battleroyale.txt")
	
	g_mMessageScreenFade = get_user_msgid("ScreenFade")
	g_mMessageSendAudio = get_user_msgid("SendAudio")
	g_mMessageStatusIcon = get_user_msgid("StatusIcon")
	
	register_message(g_mMessageSendAudio, "Message_SendAudio") 

	pcvarZoneSeconds = register_cvar("pubnite_redzone_seconds", "15")
	pcvarZoneAmt = register_cvar("pubnite_redzone_renderammount", "500")
	pcvar_updaterate = register_cvar("pubnite_redzone_fps", "8")
	pCvarWaitTime = register_cvar("pubnite_redzone_wait_time", "50")
	
	register_event("DeathMsg", "event_DeathMsg", "a")
	register_logevent("event_NewRound", 2, "1=Round_Start")

	g_fMaxZ = GetMaxHeightWithoutStartOrigin() 
}

public plugin_natives()
{
	register_native("pubnite_is_in_redzone", "_isInRedZone")
	register_native("pubnite_get_redzone_level", "_getRedZoneLevel")
	register_native("pubnite_origin_inside_redzone", "_isOriginInsideRedZone")
	register_native("pubnite_get_zone_time", "_getZoneTime")
}

public _isInRedZone()
{
	return g_CompressionLevel ? isUserInRedZone(get_param(1)) : 0
}

public _isOriginInsideRedZone()
{
	new Float:fOrigins[2]
	fOrigins[0] = get_param_f(1) - fLastZoneOrigins[0]
	fOrigins[1] = get_param_f(2) - fLastZoneOrigins[1]

	return checkOrigin(fOrigins)
}

public _getRedZoneLevel()
{
	return bool:g_CompressionLevel
}

new g_iSysTime2
public _getZoneTime()
{
	static iSysTime;iSysTime = get_systime()
	new iDelay = (iSysTime - g_iSystime), iWaitTime = get_pcvar_num(pCvarWaitTime), iSafeZoneTime = (iWaitTime - iDelay)
	if(iDelay < iWaitTime)
	{
		return iSafeZoneTime
	}
	else
	{
		if(!task_exists(TASK_STOPCOMPRESSION))
		{
			return Seconds
		}
		else
		{
			if(g_iCompressTime)
			{
				if((iSysTime - g_iSysTime2) > 0)
				{
					g_iCompressTime--
					g_iSysTime2 = iSysTime
				}
				return g_iCompressTime
			}
		}
	}
	return 0
}

public pubnite_winner(iWinners[], iWinnersNum)
{
	zone_Disable(false)
}

public event_DeathMsg()
{
	for(new i;i < sizeof g_szIcons;i++)
	{
		writeIcon(read_data(2), g_szIcons[i], {0, 0, 0}, 0)
	}
}

public event_NewRound()
{
	new iPlayers[32], playerCount
	get_players(iPlayers, playerCount, "ch")
	if(playerCount >= 1)
	{   
		for(new i, iPlayer;i < playerCount;i++)
		{
			if(g_bWasInside[(iPlayer = iPlayers[i])])
			{
				g_bWasInside[iPlayer] = false
			}
		}

		zone_Disable(false)

		clientPlaySound(0, g_szGasFormingSound)
		set_task(2.0, "prepareZone")
	}
}

public Message_SendAudio()  
{ 
	new szArg[18] 
	get_msg_arg_string(2, szArg, charsmax(szArg)) 
	for(new i;i < sizeof g_szRadioSounds;i++)
	{
		if(equal(szArg, g_szRadioSounds[i]) && (get_msg_block(g_mMessageSendAudio) == BLOCK_NOT))
		{ 
			set_msg_block(g_mMessageSendAudio, BLOCK_ONCE) 
			return PLUGIN_HANDLED 
		}
	} 
	return PLUGIN_CONTINUE 
}  

public prepareZone()
{
	g_iSystime = get_systime()
	
	zone_Disable()
	CompressionTimer()
}

public plugin_precache()
{
	g_iSprite = precache_model("sprites/laserbeam.spr")
	precache_model(ZONE_SPRITE)

	precache_sound(g_szGasWallkingSound)
	precache_sound(g_szGasStopedSound)
	precache_sound(g_szGasFormingSound)
	precache_sound(g_szOutSideGas)
	precache_sound(g_szInsideGas)
}

public event_ZoneDamage()
{
	new iPlayers[MAX_PLAYERS], playerCount
	get_players(iPlayers, playerCount, "ach")
	for(new i, id; i < playerCount; i++)
	{
		id = iPlayers[i]
		
		if(isUserInRedZone(id))
		{
			if(pev(id, pev_health) > fHitDamage)
			{
				ScreenFade(id, {255, 0, 0})

				if(!g_bWasInside[id])
				{
					clientPlaySound(id, g_szInsideGas)
					
					writeIcon(id, g_szIcons[1], {200, 15, 0}, 1)
					g_bWasInside[id] = true
				}

				set_pev(id, pev_health, pev(id, pev_health) - float(floatround(fHitDamage, floatround_floor)))
				emit_sound(id, 0, g_szHitSounds[random_num(0, sizeof g_szHitSounds - 1)], 1.0, 1.0, 0, 100)
			}
			else
			{
				if(pubnite_is_knockedout(id) && is_user_alive(pubnite_get_knockerid(id)))
				{
					ExecuteHamB(Ham_Killed, id, pubnite_get_knockerid(id), 1)
				}
				else user_kill(id, 1)
			}
		}
		else
		{
			if(g_bWasInside[id])
			{
				g_bWasInside[id] = false

				writeIcon(id, g_szIcons[1], {0, 0, 0}, 0)
				ScreenFade(id, {255, 255, 255})

				client_cmd(id, "stopsound")
				clientPlaySound(id, g_szOutSideGas)
			}
		}
	}
}

public makeZone()
{
	if(g_bCreatedZone)
		return

	g_bCreatedZone = true

	fLastRadius = 6000.0
	fHitDamage = 2.0
	fCompressionTime = 60.0
	g_CompressionLevel = 0

	fLastZoneOrigins[0] = 0.0
	fLastZoneOrigins[1] = 0.0
	fLastZoneOrigins[2] = 512.0
	
	fCurRadius = 1700.0
	if(!g_CompressionLevel)
	{
		zone_Spawn(fLastRadius)
	}
	
	getRandomEye()
	fDiskSeconds = (fWaitingTime + fCompressionTime) * 1.01
	
	if(!task_exists(TASK_DAMAGE))
	{
		set_task(1.5, "event_ZoneDamage", TASK_DAMAGE, .flags = "b")
	}
	
	set_task(fWaitingTime, "fn_Compression", TASK_COMPRESSION)
	fix_disk()
}

public zone_Spawn(Float:Radius)
{
	for(new i, iZone; i < NUMSIDES * 2; i++)
	{
		g_ZonePart[i] = create_entity("info_target")
		iZone = g_ZonePart[i]

		if(!pev_valid(iZone))
			continue
		
		new Float:flOrigins[3], Float:flAngles[3]
		flOrigins[0] = Radius * floatcos(360.0 / (NUMSIDES * 2.0), degrees) * floatcos(360.0 / NUMSIDES * i, degrees)
		flOrigins[1] = Radius * floatcos(360.0 / (NUMSIDES * 2.0), degrees) * floatsin(360.0 / NUMSIDES * i, degrees)
		flOrigins[2] = 512.0
		
		if(i < NUMSIDES)
			flAngles[1] = 360.0 / NUMSIDES * i
		else
			flAngles[1] = 360.0 / NUMSIDES * i + 180
		
		fCurScale = Radius * floatcos(360.0 / (NUMSIDES * 2.0), degrees) * floattan(360.0 / (NUMSIDES * 2.0), degrees) / 8
		fDeltaScale = (fCurScale - (fCurRadius * floatcos(360.0 / (NUMSIDES * 2.0), degrees)* floattan(360.0 / (NUMSIDES * 2.0), degrees) / 8)) / fCompressionTime / get_pcvar_num(pcvar_updaterate)
		
		set_pev(iZone, pev_classname, zone_EntName)
		engfunc(EngFunc_SetModel, iZone, ZONE_SPRITE)
		
		set_pev(iZone, pev_scale, fCurScale)
		set_pev(iZone, pev_origin, flOrigins)
		set_pev(iZone, pev_angles, flAngles)
		set_pev(iZone, pev_iuser1, i)
		
		set_pev(iZone, pev_solid, SOLID_NOT)
		set_pev(iZone, pev_movetype, MOVETYPE_NOCLIP)
		set_pev(iZone, pev_rendermode, kRenderTransAdd)
		set_pev(iZone, pev_renderamt, float(get_pcvar_num(pcvarZoneAmt)))
		
		set_pev(iZone, pev_animtime, get_gametime())
		set_pev(iZone, pev_frame, 0.0)
		set_pev(iZone, pev_framerate, 0.1)
		set_pev(iZone, pev_sequence, 0)
	}
}

public fw_Zone_Think(Ent)
{
	if(!pev_valid(Ent))
		return
	
	new clasadi[15]
	pev(Ent, pev_classname, clasadi, charsmax(clasadi))
	if(!equal(clasadi, zone_EntName))	
	{
		return
	}

	if(pev(Ent, pev_iuser1) == 0)
		fCurScale = fCurScale - fDeltaScale
	
	set_pev(Ent, pev_scale, floatmax(0.0, fCurScale))
	
	if(task_exists(TASK_STOPCOMPRESSION))
		set_pev(Ent, pev_nextthink, get_gametime() + (1.000 / get_pcvar_num(pcvar_updaterate)))
}

public newparams()
{
	fCurRadius = fLastRadius * 0.6
	
	fCurZoneOrigins[0] = fLastZoneOrigins[0] + float(random_num(- floatround(fLastRadius) + floatround(fCurRadius), floatround(fLastRadius) - floatround(fCurRadius)))
	fCurZoneOrigins[1] = fLastZoneOrigins[1] + float(random_num(- fn_Get_Y(), fn_Get_Y()))
	fCurZoneOrigins[2] = 0.0
	
	Delta_X = fCurZoneOrigins[0] - fLastZoneOrigins[0]
	Delta_Y = fCurZoneOrigins[1] - fLastZoneOrigins[1]
	Delta_R = fLastRadius - fCurRadius
}

public fn_Compression()
{
	static Float:fOldOrigins[3], Float:fNewOrigins[3], Float:fVelocity[3]
	
	new iPlayers[32], iNum
	get_players(iPlayers, iNum, "ach")
	for(new i, iPlayer;i < iNum;i++)
	{
		iPlayer = iPlayers[i]
		
		writeIcon(iPlayer, g_szIcons[2], {0, 0, 0}, 0)
		writeIcon(iPlayer, g_szIcons[0], {255, 0, 0}, 1)
	}
	
	g_iCompressTime = floatround(fCompressionTime)
	set_task(1.0, "fix_zone", TASK_ZONEFIX, .flags = "a", .repeat = floatround(fCompressionTime) - 1)
	set_task(fCompressionTime, "fn_StopCompression", TASK_STOPCOMPRESSION)
	set_task((fCompressionTime - 4.0), "playStopCompressionSound", TASK_SOUND_COMPRESSION)
	
	for(new i, iZone; i < NUMSIDES * 2; i++)
	{
		iZone = g_ZonePart[i]
		if(pev_valid(iZone))
		{
			new clasadi[15]
			pev(iZone, pev_classname, clasadi, charsmax(clasadi))
			if(equal(clasadi, zone_EntName))	
			{
				pev(iZone, pev_origin, fOldOrigins)
			
				fNewOrigins[0] = fCurZoneOrigins[0] + (fCurRadius * floatcos(360.0 / (NUMSIDES * 2.0), degrees) * floatcos(360.0 / NUMSIDES * i, degrees))
				fNewOrigins[1] = fCurZoneOrigins[1] + (fCurRadius * floatcos(360.0 / (NUMSIDES * 2.0), degrees) * floatsin(360.0 / NUMSIDES * i, degrees))
				
				fVelocity[0] = (fNewOrigins[0] - fOldOrigins[0]) / fCompressionTime
				fVelocity[1] = (fNewOrigins[1] - fOldOrigins[1]) / fCompressionTime
				
				set_pev(iZone, pev_velocity, fVelocity)
				set_pev(iZone, pev_nextthink, get_gametime() + (2.0 / get_pcvar_num(pcvar_updaterate)))
			}	
		}
	}
	return PLUGIN_HANDLED
}

public fn_StopCompression()
{
	new iPlayers[32], iNum
	get_players(iPlayers, iNum, "ach")
	for(new i;i < iNum;i++)
	{
		writeIcon(iPlayers[i], g_szIcons[0], {0, 0, 0}, 0)
	}
	
	stopRedZone()
	remove_task(TASK_COMPRESSION)
	
	g_iTimesTelling[0] = g_iTimesTelling[1] = 0
	fLastZoneOrigins = fCurZoneOrigins
	fLastRadius = fCurRadius
	fCurScale = fLastRadius * floatcos(360.0 / (NUMSIDES * 2.0), degrees) * floattan(360.0 / (NUMSIDES * 2.0), degrees) / 8

	fHitDamage *= 2.0
	fWaitingTime *= 0.75
	fCompressionTime *= 0.75
	g_CompressionLevel++
			
	new bool:bCanSetTime = true
	switch(g_CompressionLevel)
	{
		case 0, 1, 2:
		{
			newparams()
		}
		case 3, 4:
		{
			fCurRadius = fLastRadius * 0.6
			getRandomEye()
		}
		case LAST_SAFEZONE:
		{
			fCurRadius = 0.0
			fHitDamage /= 2.0
		
			Delta_X = fCurZoneOrigins[0] - fLastZoneOrigins[0]
			Delta_Y = fCurZoneOrigins[1] - fLastZoneOrigins[1]
			Delta_R = fLastRadius - fCurRadius
		}
		default:	bCanSetTime = false
	}
	
	if(bCanSetTime)
	{
		set_task((fWaitingTime + 5.0), "fn_Compression", TASK_COMPRESSION)
		CompressionTimer()
	}
	fDeltaScale = (fCurScale - (fCurRadius * floatcos(360.0 / (NUMSIDES * 2.0), degrees)* floattan(360.0 / (NUMSIDES * 2.0), degrees) / 8)) / fCompressionTime / get_pcvar_num(pcvar_updaterate)
	fDiskSeconds = (fWaitingTime + fCompressionTime) * 1.01
	
	fix_disk()
}

public playStopCompressionSound() clientPlaySound(0, g_szGasStopedSound)

public fix_zone()
{
	fLastZoneOrigins[0] += (Delta_X / fCompressionTime)
	fLastZoneOrigins[1] += (Delta_Y / fCompressionTime)
	fLastRadius -= (Delta_R / fCompressionTime)
}

public fix_disk()
{
	disk_Create(fCurZoneOrigins, fCurRadius, floatmin(fDiskSeconds, 10.0))
	fDiskSeconds -= 10.0
	
	if(fDiskSeconds > 0.0)
		set_task(9.95, "fix_disk", TASK_FIXDISK)
}

public zone_Create(Float:Origins[3], Float:radius)
{
	if(!radius)
		return PLUGIN_HANDLED
	
	Origins[2] = 1023.0
	
	for(new i, iZone; i < NUMSIDES * 2; i++)
	{
		static Float:radialVector[3]
		
		iZone = g_ZonePart[i]

		radialVector[0] = Origins[0] + (radius * floatcos(360.0 / (NUMSIDES * 2.0), degrees) * floatcos(360.0 / NUMSIDES * i, degrees))
		radialVector[1] = Origins[1] + (radius * floatcos(360.0 / (NUMSIDES * 2.0), degrees) * floatsin(360.0 / NUMSIDES * i, degrees))
		radialVector[2] = Origins[2]

		if(pev_valid(iZone))
		{	 
			new clasadi[15]
			pev(iZone, pev_classname, clasadi, charsmax(clasadi))
			if(equal(clasadi, zone_EntName))	
			{		
				set_pev(iZone, pev_origin, radialVector)
				set_pev(iZone, pev_scale, fCurScale)
			}	
		}
	}
	
	return PLUGIN_HANDLED
}

public disk_Create(Float:Origins[3], Float:radius, Float:time)
{
	if(!radius)
		return
	
	new Float:oldorigin[3]
	
	Origins[2] = 1023.0
	oldorigin = Origins
	
	for(new j; j < WEIGH; j++)
	{
		static Float:radialVector[3]
		
		radialVector[0] = Origins[0] + (radius * floatcos(360.0 / WEIGH * j, degrees))
		radialVector[1] = Origins[1] + (radius * floatsin(360.0 / WEIGH * j, degrees))
		radialVector[2] = g_fMaxZ
		
		if(j != 0)
		{
			draw_line(oldorigin, radialVector, time, {255, 255, 255})
		}
		oldorigin = radialVector
	}
}

public CompressionTimer()
{
	new iPlayers[32], iNum
	get_players(iPlayers, iNum, "ach")
	for(new i;i < iNum;i++)
	{
		writeIcon(iPlayers[i], g_szIcons[2], {255, 255, 255}, 1)
	}
	
	if(!fWaitingTime)
	{
		fWaitingTime = float(get_pcvar_num(pcvarZoneSeconds))
	}
	
	Seconds = floatround(fWaitingTime)
	set_task(1.0, "CompressionTimer_Handler", TASK_TIMER, .flags = "b")
}

public CompressionTimer_Handler()
{
	new iPlayers[32], iNum, szMinutes[18], szSeconds[18]
	get_players(iPlayers, iNum, "ch")
	
	new iDelay = (get_systime() - g_iSystime), iWaitTime = get_pcvar_num(pCvarWaitTime), iSafeZoneTime = (iWaitTime - iDelay)
	if((g_iTimesTelling[0] < SAFEZONE_APPEAR_TIMES) && !g_bCreatedZone)
	{
		g_iTimesTelling[0]++
		
		set_hudmessage(255, 255, 255, -1.0, 0.2, 0, 1.0, 1.0)
		for(new i, id;i < iNum;i++)
		{
			id = iPlayers[i]
			
			formatTime(id, szMinutes, szSeconds, iSafeZoneTime)
			show_hudmessage(id, "%L", id, "SERVER_SAFEZONE_WILL_APPEAR", szMinutes, szSeconds)
		}
		return
	}

	if((iDelay >= iWaitTime) && !g_bCreatedZone)
	{
		set_hudmessage(255, 255, 255, -1.0, 0.2, 0, 1.0, 3.5)
		show_hudmessage(0, "%L", LANG_PLAYER, "SERVER_SAFEZONE_SET")
		
		clientPlaySound(0, g_szGasWallkingSound)
		makeZone()
	}
	
	if(iSafeZoneTime >= -4)
		return
	
	switch(Seconds)
	{
		case 0:
		{
			set_hudmessage(255, 130, 20, -1.0, 0.2, 0, 1.0, 4.0)
			show_hudmessage(0, "%L", LANG_PLAYER, "SERVER_REDZONE_GETTING_TINY")

			clientPlaySound(0, g_szGasWallkingSound)
			remove_task(TASK_TIMER)
		}
		default:
		{

			if(g_iTimesTelling[1] < GETTING_TINY_TIMES)
			{
				g_iTimesTelling[1]++
				
				set_hudmessage(255, 130, 20, -1.0, 0.2, 0, 6.0, 1.0)
				for(new i, id;i < iNum;i++)
				{
					id = iPlayers[i]
			
					formatTime(id, szMinutes, szSeconds, Seconds)
					show_hudmessage(id, "%L: %s%s", id, "SERVER_REDZONE_WILL_GET_TINY", szMinutes, szSeconds)
				}
			}
			--Seconds
		}
	}
}

formatTime(id, szMinutes[18], szSeconds[18], iTime)
{
	new iMinutes = (iTime / 60), iSeconds = (iTime % 60)
	if(iMinutes)
	{
		formatex(szMinutes, charsmax(szMinutes), "%d %L%s", iMinutes, id, "SERVER_MINUTES", (iMinutes > 1) ? "s" : "")
	}
	
	if(iSeconds)
	{
		new szPreposition[5]
		formatex(szPreposition, charsmax(szPreposition), " %L ", id, "SERVER_PREPOSITION")
		formatex(szSeconds, charsmax(szSeconds), "%s%d %L%s", iMinutes ? szPreposition : "", iSeconds, id, "SERVER_SECONDS", (iSeconds > 1) ? "s" : "")
	}
}

draw_line(Float:start[3], Float:end[3], Float:time, rgb[3])
{
	engfunc(EngFunc_MessageBegin, MSG_BROADCAST, SVC_TEMPENTITY, start, 0)
	write_byte(TE_BEAMPOINTS)
	engfunc(EngFunc_WriteCoord, start[0])
	engfunc(EngFunc_WriteCoord, start[1])
	engfunc(EngFunc_WriteCoord, start[2])
	engfunc(EngFunc_WriteCoord, end[0])
	engfunc(EngFunc_WriteCoord, end[1])
	engfunc(EngFunc_WriteCoord, end[2])
	write_short(g_iSprite)
	write_byte(1)
	write_byte(3)
	write_byte(max(floatround(time * 10), 1))
	write_byte(30)
	write_byte(0)
	write_byte(rgb[0])
	write_byte(rgb[1])
	write_byte(rgb[2])
	write_byte(150)
	write_byte(20)
	message_end()
}

fn_Get_Y()
{
	return sqroot(floatround(FloatSqr(fLastRadius - fCurRadius) - FloatSqr(fCurZoneOrigins[0] - fLastZoneOrigins[0])))
}

Float:FloatSqr(Float:x)
{
	return x * x
}

isUserInRedZone(id)
{
	new Float:fOrigins[3]
	pev(id, pev_origin, fOrigins)
	
	new Float:fOrigins2[2]
	fOrigins2[0] = fOrigins[0] - fLastZoneOrigins[0]
	fOrigins2[1] = fOrigins[1] - fLastZoneOrigins[1]
	
	return checkOrigin(fOrigins2)
}

checkOrigin(Float:fOrigin[2])
{
	return (FloatSqr(fOrigin[0]) + FloatSqr(fOrigin[1]) >= FloatSqr(fLastRadius))
}

zone_Disable(bool:bRemove = true)
{
	remove_task(TASK_DAMAGE)
	remove_task(TASK_COMPRESSION)
	remove_task(TASK_FIXDISK)
	remove_task(TASK_STOPCOMPRESSION)
	remove_task(TASK_ZONEFIX)
	remove_task(TASK_TIMER)
	remove_task(TASK_SOUND_COMPRESSION)

	g_iTimesTelling[0] = g_iTimesTelling[1] = 0
	g_CompressionLevel = 0	
	fHitDamage = 0.0
	fLastRadius = 0.0
	fWaitingTime = 0.0

	g_bCreatedZone = false

	if(bRemove)
	{
		new ents = -1
		while((ents = find_ent_by_class(ents, zone_EntName)))
		{
			if(pev_valid(ents))
			{
				remove_entity(ents)
			}
		}
	}
	else stopRedZone()
}

stopRedZone()
{
	for(new i, iZone; i < NUMSIDES * 2; i++)
	{
		iZone = g_ZonePart[i]
		if(pev_valid(iZone))
		{	
			new clasadi[15]
			pev(iZone, pev_classname, clasadi, charsmax(clasadi))
			if(equal(clasadi, zone_EntName))	
			{		
				set_pev(iZone, pev_velocity, {0.0, 0.0, 0.0})
			}	
		}
	}
}

ScreenFade(id, iRGB[3])
{ 
	message_begin(MSG_ONE, g_mMessageScreenFade, .player = id)
	write_short(4300)
	write_short(1)
	write_short(0)
	write_byte(iRGB[0])
	write_byte(iRGB[1]) 
	write_byte(iRGB[2]) 
	write_byte(110) 
	message_end()
}

Float:GetMaxHeightWithoutStartOrigin() 
{  
	new pcCurrent, Float:fStartPoint[3]
	while((engfunc(EngFunc_PointContents, fStartPoint) == CONTENTS_EMPTY) || (engfunc(EngFunc_PointContents, fStartPoint) == CONTENTS_SOLID)) 
	{ 
		fStartPoint[2] += 5.0 
	} 
	
	pcCurrent = engfunc(EngFunc_PointContents, fStartPoint)
	if(pcCurrent == CONTENTS_SKY) 
	{ 
		return fStartPoint[2] -= 20.0
	} 
	return 0.0 
}  

clientPlaySound(id, const szSound[])
{
	client_cmd(id, "%s ^"%s^"", (equal(szSound[strlen(szSound) - 4], ".mp3")) ? "mp3 play" : "spk", szSound)
}

writeIcon(id, szIconName[], iRGB[3], iIcon)
{
	message_begin(MSG_ONE, g_mMessageStatusIcon, .player = id)
	write_byte(iIcon)
	write_string(szIconName)
	write_byte(iRGB[0])
	write_byte(iRGB[1])
	write_byte(iRGB[2])
	message_end()
}

getRandomEye()
{
	new iRandom[4]
	for(new i;i < sizeof iRandom;i++)
	{
		iRandom[i] = random_num(600, 3500)
	}
	
	fCurZoneOrigins[0] = fLastZoneOrigins[0] + float(random_num(-3072 + iRandom[0], 3072 - iRandom[1]))
	fCurZoneOrigins[1] = fLastZoneOrigins[1] + float(random_num(-3072 + iRandom[2], 3072 - iRandom[3]))
	fCurZoneOrigins[2] = 512.0
	
	Delta_X = fCurZoneOrigins[0] - fLastZoneOrigins[0]
	Delta_Y = fCurZoneOrigins[1] - fLastZoneOrigins[1]
	Delta_R = fLastRadius - fCurRadius
	
	fix_disk()
}
