#include <amxmodx>
#include <fakemeta>
#include <hamsandwich>
#include <pubnite_mod>
#include <cromchat>
#include <fun>

#define PLUGIN 				"PUBNite: Slurp"
#define VERSION 			"1.0"
#define AUTHOR 				"EFFEX"
	
#define TASK_SLURP			88221281
#define TASK_SCREENFADE			88121022

new bool:g_bHasSlurp[MAX_PLAYERS + 1]
new g_iMessageDelay[MAX_PLAYERS + 1]
new g_iSlurpID

new g_mMessageBarTime
new g_mMessageScreenFade

new const g_szSlurpSound[] = 		"pubg/effects/slurp.wav"
new const g_szPickupSound[] = 		"items/gunpickup2.wav"

const FLASHLIGHT_IMPULSE =		100
const SLURP_DELAY =			2
const MAX_HEALTH =			100
const SLURP_HEALTH =			1
const MAX_HEAL =			75
const MESSAGE_DELAY =			1

public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	g_iSlurpID = pubnite_register_customitem("Slurp", "models/pubg/itens/slurp.mdl", RARITY_PURPLE, 0, "hasSlurp")
	if(!g_iSlurpID)
	{
		set_fail_state("Couldn't create the Slurp item.")
	}
	register_dictionary("effxs_battleroyale.txt")
	register_dictionary("effxs_customitens.txt")

	g_mMessageBarTime = get_user_msgid("BarTime")
	g_mMessageScreenFade = get_user_msgid("ScreenFade")
	
	RegisterHam(Ham_Player_ImpulseCommands, "player", "ham_PlayerImpulse")
	RegisterHam(Ham_Spawn, "player", "ham_PlayerSpawn_Post", 1)
}

public plugin_precache()
{
	precache_sound(g_szSlurpSound)
	precache_sound(g_szPickupSound)
}

public hasSlurp(id, &ret)
{
	ret = g_bHasSlurp[id]
}

public ham_PlayerSpawn_Post(id)
{
	g_bHasSlurp[id] = false
	stopHealing(id)
}

public pubnite_customitem_used(iPlayer, iCustomItemID)
{
	if((iCustomItemID == g_iSlurpID) 
	&& g_bHasSlurp[iPlayer]
	&& !pubnite_is_knockedout(iPlayer))
	{
		useSlurp(iPlayer)
	}
}

public pubnite_customitem_dropped(iPlayer, iCustomItemID)
{
	if((iCustomItemID == g_iSlurpID) && g_bHasSlurp[iPlayer])
	{
		pubnite_create_customitem(g_iSlurpID, 0, iPlayer)
		g_bHasSlurp[iPlayer] = false
	}
}

public pubnite_customitem_pickedup(iPlayer, iEntityID, iCustomItemID, iCustomItemLife)
{
	if((iCustomItemID == g_iSlurpID) 
	&& !g_bHasSlurp[iPlayer] 
	&& !pubnite_is_knockedout(iPlayer))
	{
		g_bHasSlurp[iPlayer] = true
		
		set_hudmessage(255, 255, 255, -1.0, 0.37, 0, 1.0, 5.0)
		show_hudmessage(iPlayer, "%L", iPlayer, "SLURP_EQUIPED")
		
		emit_sound(iPlayer, CHAN_ITEM, g_szPickupSound, VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
		engfunc(EngFunc_RemoveEntity, iEntityID)
	}
}

public client_KnockedOut(iAttacker, iVictim)
{
	if(task_exists(iVictim + TASK_SCREENFADE))
	{
		stopHealing(iVictim)
	}
}

public client_PreThink(id)
{
	if(!is_user_alive(id) || is_user_bot(id))
		return

	if(isUserMoving(id))
	{
		if(task_exists(id + TASK_SCREENFADE))
		{
			stopHealing(id)
		}
	}
}

public ham_PlayerImpulse(id)
{
	if(!is_user_alive(id) || is_user_bot(id) || !g_bHasSlurp[id] || pubnite_is_knockedout(id) || pubnite_has_round_ended())
		return HAM_IGNORED
		
	if((pev(id, pev_impulse) == FLASHLIGHT_IMPULSE)	
	&& (get_user_weapon(id) == CSW_KNIFE) 
	&& !task_exists(id + TASK_SLURP)
	&& !isUserMoving(id))
	{
		useSlurp(id) 
		set_pev(id, pev_impulse, 0)
		return HAM_SUPERCEDE
	}
	return HAM_IGNORED
}

useSlurp(id) 
{
	if(get_user_health(id) >= MAX_HEALTH)
	{
		static iSysTime;iSysTime = get_systime()
		if((iSysTime - g_iMessageDelay[id]) > MESSAGE_DELAY)
		{
			g_iMessageDelay[id] = iSysTime
				
			CC_SendMatched(id, CC_COLOR_GREY, "%L", id, "SERVER_FULL_HEALTH")
			client_cmd(id, "spk buttons/button11")
		}
		return
	}
		
	if(!task_exists(id + TASK_SCREENFADE))
	{
		barTime(id, SLURP_DELAY)
		set_task(float(SLURP_DELAY), "setScreenFade", id + TASK_SCREENFADE)

		emit_sound(id, CHAN_ITEM, g_szSlurpSound, VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
	}
}

public setScreenFade(id)
{
	if(!is_user_alive((id -= TASK_SCREENFADE)))
		return

	g_bHasSlurp[id] = false
	set_task(0.5, "startHealing", id + TASK_SLURP , .flags = "a", .repeat = MAX_HEAL)
	
	message_begin(MSG_ONE, g_mMessageScreenFade, .player = id)
	write_short(4300)
	write_short(0)
	write_short(0)
	write_byte(255)
	write_byte(0) 
	write_byte(255) 
	write_byte(65) 
	message_end()
}

public startHealing(id)
{
	id -= TASK_SLURP
	
	if(!is_user_alive(id))
		return
		
	new iUserHealth = get_user_health(id)
	if(iUserHealth >= MAX_HEALTH)
		return
	
	set_user_health(id, clamp((iUserHealth + SLURP_HEALTH), 0, MAX_HEALTH))
}

stopHealing(id)
{
	emit_sound(id, CHAN_ITEM, g_szSlurpSound, VOL_NORM, ATTN_NORM, SND_STOP, PITCH_NORM)
	barTime(id, 0)
	remove_task(id + TASK_SCREENFADE)
}

barTime(id, iTime)
{
	if(is_user_connected(id))
	{
		message_begin(MSG_ONE, g_mMessageBarTime, .player = id)
		write_short(iTime)
		message_end()  
	}
}

isUserMoving(id)
{
	static Float:fVecVelocity[3]
	pev(id, pev_velocity, fVecVelocity)
	return ((vector_length(fVecVelocity) > 10.0) || (pev(id, pev_flags) & FL_ONTRAIN))
}
