#include <amxmodx>
#include <fakemeta>
#include <xs>
#include <pubnite_mod>

#if AMXX_VERSION_NUM < 183
#define client_disconnected		client_disconnect
#endif

#define DISTANCE 			20 // do not modify

#define TASK_CREATE			30103103
#define TASK_REMOVE_SPRITE 		301031

#define isTeam(%1)			(1 <= get_user_team(%1) <= 2)

new g_iPlayerEnt[MAX_PLAYERS + 1]
new g_hWinHud

new const g_szSpriteName[] = 		"sprites/pubg/victory_royale.spr"
new const g_szWinSound[] = 		"pubg/effects/victory_royale.wav"

public plugin_init() 
{
	register_plugin("PUBNite: Win Sprite", "1.0", "Devil259/EFFx")
	
	g_hWinHud = CreateHudSyncObj()
	
	register_dictionary("effxs_battleroyale.txt")
	register_forward(FM_AddToFullPack , "fwAddToFullPack", 1)
}

public plugin_precache()
{
	precache_model(g_szSpriteName)
	precache_sound(g_szWinSound)
}

public pubnite_winner(iWinners[], iWinnersNum)
{
	new szRandomWinnerName[MAX_PLAYERS], bool:bIsSoloWin = (iWinnersNum == 1)
	for(new i, iWinner;i < iWinnersNum;i++)
	{
		iWinner = iWinners[i]

		screenFade(iWinner, 1)
		client_cmd(iWinner, "spk ^"%s^"", g_szWinSound)
		set_task(1.8, "createSprite", iWinner + TASK_CREATE)

		if(bIsSoloWin && is_user_alive(iWinner))
		{
			get_user_name(iWinner, szRandomWinnerName, charsmax(szRandomWinnerName))
		}
	}

	if(bIsSoloWin)
	{
		new iPlayers[MAX_PLAYERS], iNum
		get_players(iPlayers, iNum, "bch")
		for(new i, iPlayer;i < iNum;i++)
		{
			iPlayer = iPlayers[i]

			if(isTeam(iPlayer))
			{
				set_hudmessage(220, 80, 0, -1.0, 0.35, 0, 1.0, 4.0)
				ShowSyncHudMsg(iPlayer, g_hWinHud, "%s %L", szRandomWinnerName, iPlayer, "SERVER_WON_THE_GAME")
			}
		}
	}
}

public createSprite(id)
{
	id -= TASK_CREATE
	
	screenFade(id, 0)
	displaySprite(id)
}

public fwAddToFullPack(es, e, iEnt, iHost, host_flags, player, p_set)
{
	if(!is_user_connected(iHost))
		return FMRES_IGNORED
	
	if(iEnt == g_iPlayerEnt[iHost])
	{
		if(!is_user_alive(iHost))
			return FMRES_IGNORED
		
		static Float:flOrigin[3] , Float:flVec[3], Float:flViewOffset[3]
		pev(iHost, pev_origin, flOrigin )
		pev(iHost, pev_view_ofs, flViewOffset)
		xs_vec_add(flOrigin, flViewOffset, flOrigin)

		flOrigin[2] += 6.2
		
		velocity_by_aim(iHost, DISTANCE, flVec)
		
		xs_vec_add(flOrigin, flVec, flOrigin)
		engfunc(EngFunc_SetOrigin, iEnt, flOrigin)
		set_es(es, ES_Origin, flOrigin)
		
		set_es(es, ES_RenderMode, kRenderNormal)
		set_es(es, ES_RenderAmt, 200)
	}

	return FMRES_IGNORED
}

public client_putinserver(id)
{
	if(pev_valid(g_iPlayerEnt[id]))
		RemoveEntity(id)
}

public client_disconnected(id)
{
	if(pev_valid(g_iPlayerEnt[id]))
		RemoveEntity(id)
}

screenFade(id, iFade)
{
	message_begin(MSG_ONE, get_user_msgid("ScreenFade"), .player = id)
	write_short(2096)
	write_short(1024)
	write_short(iFade)
	write_byte(255)
	write_byte(255)
	write_byte(255)
	write_byte(255)
	message_end()
}

displaySprite(id)
{
	if(!is_user_connected(id) || g_iPlayerEnt[id])
		return 
	
	g_iPlayerEnt[id] = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "env_sprite"))
	if(!pev_valid(g_iPlayerEnt[id]))
		return
	
	set_pev(g_iPlayerEnt[id], pev_takedamage, 0.0)
	set_pev(g_iPlayerEnt[id], pev_solid, SOLID_NOT)
	set_pev(g_iPlayerEnt[id], pev_movetype, MOVETYPE_FOLLOW)
	
	engfunc(EngFunc_SetModel, g_iPlayerEnt[id], g_szSpriteName)
	
	set_pev(g_iPlayerEnt[id], pev_rendermode, kRenderTransAlpha)
	set_pev(g_iPlayerEnt[id], pev_renderamt, 0.0)

	set_pev(g_iPlayerEnt[id], pev_scale, 0.05)

	set_task(float(get_cvar_num("pubnite_newround_time")), "removeSprite", id + TASK_REMOVE_SPRITE)
}

public removeSprite(id)
{
	id -= TASK_REMOVE_SPRITE
	
	if(!is_user_connected(id) || !pev_valid(g_iPlayerEnt[id]))
		return
	
	RemoveEntity(id)
}

RemoveEntity(id)
{
	engfunc(EngFunc_RemoveEntity, g_iPlayerEnt[id])
	g_iPlayerEnt[id] = 0
}
