#include <amxmodx>
#include <amxmisc>
#include <cromchat>
#include <pubnite_mod>

#define PLUGIN 				"PUBNite: VoteMap"
#define VERSION 			"1.0"
#define AUTHOR 				"EFFx"


#if AMXX_VERSION_NUM < 183
#define client_disconnected		client_disconnect
#endif

#define MAX_PLAYERS	32

// turn on/off the timeleft format
#define USE_TIMELEFT

#define SELECTMAPS			4
#define CHANGE_TIME			10
#define BLOCK_MAPS			10
#define MAX_MAPS 			100

#define getPercent(%1,%2) 		clamp(floatround(((float(%1) / float(%2)) * 100.0)), 0, 100)
#define getMinutesRemaining() 		get_pcvar_num(pCvarTimeleftValue) - ((get_systime() - g_iTimeLeft) / ONE_MINUTE)

new g_sVoteMap[SELECTMAPS + 2][MAX_PLAYERS], g_iVoteCount[SELECTMAPS + 2], g_iVoteMapNum, 
g_iMapCount, g_sMap[MAX_MAPS][MAX_PLAYERS], g_szMapName[MAX_PLAYERS], g_iMapInMenu[SELECTMAPS + 1]

new bool:g_bVotemapStarted, bool:g_bStartVotemapLater, g_iVoteExtend
new g_szMap[MAX_PLAYERS], bool:g_bRockedTheVote[33], bool:g_bVoted[33]

#if !defined USE_TIMELEFT
new pCvarMinPlayers, pCvarMaxRounds, g_iRoundsPassed
#else
const TEN_MINUTES = 600
const FIVE_MINUTES = 300
const ONE_MINUTE = 60

new pCvarTimeleftValue, g_iTimePassed, g_iPrints = TEN_MINUTES, g_iTimeLeft
#endif

new pCvarHudTime, pCvarVoteDelay

public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	register_dictionary("timeleft.txt")
	register_dictionary("effxs_pubnite_votemap.txt")
	
	CC_SetPrefix("&x04[EFFx S]&x01")
	
	register_clcmd("say rtv", "cmdRTV")
	register_clcmd("say .rtv", "cmdRTV")
	register_clcmd("pubnite_votemap", "startVoteMap", ADMIN_KICK)
	
	pCvarHudTime = register_cvar("pubnite_votemap_countdown_time", "7")
	pCvarVoteDelay = register_cvar("pubnite_votemap_vote_delay", "8")
	
	#if defined USE_TIMELEFT
	register_clcmd("say timeleft", "showTimeLeft")
	register_clcmd("say .timeleft", "showTimeLeft")
		
	pCvarTimeleftValue = register_cvar("pubnite_votemap_timeleft", "25")
	#else
	pCvarMaxRounds = register_cvar("pubnite_votemap_rounds", "20")
	pCvarMinPlayers = register_cvar("pubnite_votemap_min_players", "8")
	#endif
}

public plugin_cfg()
{
	get_mapname(g_szMapName, charsmax(g_szMapName))
	loadMaps()
	
	#if defined USE_TIMELEFT
	pCvarTimeleftValue = register_cvar("pubnite_votemap_timeleft", "25")
	
	new iTimeLeft = (get_pcvar_num(pCvarTimeleftValue) * ONE_MINUTE)
	switch(iTimeLeft)
	{
		case TEN_MINUTES: 	
		{
			g_iTimePassed = g_iPrints = FIVE_MINUTES
		}
		case FIVE_MINUTES:	
		{
			g_iTimePassed = (FIVE_MINUTES - ONE_MINUTE)
			g_iPrints = ONE_MINUTE
		}
		case ONE_MINUTE:	
		{
			set_task(float(ONE_MINUTE), "forceVotemap")
		}
		default:
		{
			if(iTimeLeft > TEN_MINUTES)
			{
				g_iTimePassed = (iTimeLeft - TEN_MINUTES)
			}
			else if((iTimeLeft > FIVE_MINUTES) && (iTimeLeft < TEN_MINUTES))
			{
				g_iPrints = FIVE_MINUTES
				g_iTimePassed = (iTimeLeft - FIVE_MINUTES)
			}
			else
			{
				g_iPrints = ONE_MINUTE
				g_iTimePassed = (iTimeLeft - ONE_MINUTE)
			}
		}
	}
	
	g_iTimeLeft = get_systime()
	set_task(float(g_iTimePassed), "printTimeLeft")
	#endif
}

#if defined USE_TIMELEFT
public showTimeLeft(id)
{
	new iMinutesRemaining = getMinutesRemaining()
	if(iMinutesRemaining > 1)
	{
		new szNum[7]
		num_to_word(iMinutesRemaining, szNum, charsmax(szNum))
		client_cmd(id, "spk ^"vox/%s minutes remaining^"", szNum)
	
		CC_SendMatched(id, CC_COLOR_RED, "%L:&x04 %d&x01 %L.", id, "TIME_LEFT", iMinutesRemaining, id, (iMinutesRemaining > 1) ? "MINUTES" : "MINUTE")
	}
	else CC_SendMatched(id, CC_COLOR_RED, "%L.", id, "NO_T_LIMIT")
}

public printTimeLeft()
{
	new iNextTask, szNum[7]
	switch(g_iPrints)
	{
		case TEN_MINUTES:	
		{
			iNextTask = g_iPrints = FIVE_MINUTES
		}
		case FIVE_MINUTES:	
		{
			iNextTask = (FIVE_MINUTES - ONE_MINUTE)
			g_iPrints = ONE_MINUTE
		}
		default:		
		{
			iNextTask = ONE_MINUTE
		}
	}
	
	new iMinutesRemaining = getMinutesRemaining()
	num_to_word(iMinutesRemaining, szNum, charsmax(szNum))
	client_cmd(0, "spk ^"vox/%s minutes remaining^"", szNum)
	
	set_hudmessage(255, 255, 255, -1.0, 0.8, 0, 1.0, 3.5)
	show_hudmessage(0, "%d %L", iMinutesRemaining, LANG_PLAYER, (iMinutesRemaining > 1) ? "MINUTES" : "MINUTE")
	
	set_task(float(iNextTask), (iNextTask == ONE_MINUTE) ? "forceVotemap" : "printTimeLeft")
}
#endif

public pubnite_winner(iW[], iNum)
{
	#if defined USE_TIMELEFT
	if(g_bStartVotemapLater)
	{
		forceVotemap()
	}
	#else
	if(!g_bVotemapStarted)
	{
		new iPlayers[MAX_PLAYERS], iPlayersNum
		get_players(iPlayers, iPlayersNum, "ch")
	
		g_iRoundsPassed++
		if((g_iRoundsPassed >= get_pcvar_num(pCvarMaxRounds)) && (iPlayersNum >= get_pcvar_num(pCvarMinPlayers)))
		{
			forceVotemap()
		}
	}
	#endif
	
	
	if(g_bVotemapStarted && g_szMap[0])
	{
		set_task(1.0, "nextMap", .flags = "a", .repeat = (CHANGE_TIME + 1))
	}
}

public startVoteMap(id, iLevel, iCid)
{
	if(cmd_access(id, iLevel, iCid, 1))
	{
		if(!g_bVotemapStarted)
		{
			forceVotemap()
		}
	}
}

public client_disconnected(id)
{
	g_bRockedTheVote[id] = false
	g_bVoted[id] = false
}

public cmdRTV(id)
{
	if(g_bRockedTheVote[id] || g_bVotemapStarted)
		return PLUGIN_HANDLED

	new iPlayers[MAX_PLAYERS], iNum, iRTVNum = getRTV()
	get_players(iPlayers, iNum, "ch")
	if(iNum < 3)
		return PLUGIN_HANDLED

	g_bRockedTheVote[id] = true

	new iNeeded = (iNum / 2)
	if(iRTVNum == iNeeded)
	{
		for(new i, iPlayer;i < iNum;i++)
		{
			iPlayer = iPlayers[i]
			CC_SendMatched(iPlayer, CC_COLOR_GREY, "%L", iPlayer, "SERVER_RTV_ENOUGH")
		}
		forceVotemap()
	}
	else 
	{
		new szName[MAX_PLAYERS]
		get_user_name(id, szName, charsmax(szName))
		
		for(new i, iPlayer;i < iNum;i++)
		{
			iPlayer = iPlayers[i]
			CC_SendMatched(iPlayer, CC_COLOR_GREY, "%L", iPlayer, "SERVER_ROCKED_THE_VOTE", szName, (iNeeded - iRTVNum))
		}
	}
	return PLUGIN_HANDLED
}

public printHudMessage()
{
	static iHudTime
	if(!iHudTime)
		iHudTime = (get_pcvar_num(pCvarHudTime) + 1)
	
	iHudTime--
	if(iHudTime > 0)
	{
		new szSound[8]
		num_to_word(iHudTime, szSound, charsmax(szSound))
		client_cmd(0, "spk fvox/%s", szSound)
	
		set_hudmessage(0, 200, 0, -1.0, 0.26, 0, 1.0, 1.0)
		show_hudmessage(0, "%L", LANG_PLAYER, "SERVER_VOTEMAP_WILL_START", iHudTime, (iHudTime > 1) ? "s" : "")
	}
	else 
	{
		new iPlayers[MAX_PLAYERS], iNum, iVoteDelay = get_pcvar_num(pCvarVoteDelay)
		get_players(iPlayers, iNum, "ch")
		for(new i, iPlayer;i < iNum;i++)
		{
			iPlayer = iPlayers[i]
			
			set_task(1.0, "printMaps", iPlayer, .flags = "a", .repeat = iVoteDelay)
			client_cmd(iPlayer, "spk Gman/Gman_Choose2")
		}
		set_task(float(iVoteDelay), "checkVotes")
	}
}

public printMaps(id)
{
	static iMenu, szMenu[256]
	formatex(szMenu, charsmax(szMenu), "\y[ \wPUBNite - \r%L \y]", id, "SERVER_VOTEMAP_TITTLE")	
	iMenu = menu_create(szMenu, "votemenu_handler")
	
	new iPlayers[MAX_PLAYERS], iNum
	get_players(iPlayers, iNum, "ch")
	
	new szItem[50]
	for(new i;i < g_iVoteMapNum;i++)
	{
		formatex(szItem, charsmax(szItem), "%s - \d(%d%%)", g_sVoteMap[i], getPercent(g_iVoteCount[i], getTotalVoteValue()))
		menu_additem(iMenu, szItem)
	}
	
	formatex(szItem, charsmax(szItem), "%L - \d(%d%%)", id, "SERVER_VOTEMAP_EXTEND_OPTION", getPercent(g_iVoteExtend, getTotalVoteValue()))
	menu_additem(iMenu, szItem)
	
	menu_display(id, iMenu)
}

public votemenu_handler(id, iMenu, iKey)
{
	if((iKey == MENU_EXIT) || g_bVoted[id])
	{
		menu_destroy(iMenu)
		return
	}
	
	new szName[MAX_PLAYERS]
	get_user_name(id, szName, charsmax(szName))
	
	client_cmd(0, "spk buttons/button3")

	new bool:bIsMapKey = false
	for(new i;i < g_iVoteMapNum;i++)
	{
		if(g_sVoteMap[iKey][0] && equal(g_sVoteMap[iKey], g_sVoteMap[i]))
		{
			bIsMapKey = true
		}
	}

	new iPlayers[MAX_PLAYERS], iNum, iPlayer
	get_players(iPlayers, iNum, "ch")

	if(bIsMapKey)
	{
		for(new i;i < iNum;i++)
		{
			iPlayer = iPlayers[i]
			CC_SendMatched(iPlayer, CC_COLOR_GREY, "%L", iPlayer, "SERVER_CHOOSED_MAP", szName, g_sVoteMap[iKey])
		}
		g_iVoteCount[iKey]++
	}
	else 
	{
		for(new i;i < iNum;i++)
		{
			iPlayer = iPlayers[i]
			CC_SendMatched(iPlayer, CC_COLOR_GREY, "%L", iPlayer, "SERVER_CHOOSED_EXTEND", szName)
		}
		g_iVoteExtend++
	}
	g_bVoted[id] = true
}

public checkVotes()
{
	new iMapsVotes
	for(new i;i < SELECTMAPS + 1;i++)
	{
		iMapsVotes += g_iVoteCount[i]
	}

	new iPlayers[MAX_PLAYERS], iNum, iPlayer, iTimeLeft = get_pcvar_num(pCvarTimeleftValue)
	get_players(iPlayers, iNum, "ch")
	if(g_iVoteExtend >= iMapsVotes)
	{
		for(new i;i < iNum;i++)
		{
			iPlayer = iPlayers[i]

			g_bVoted[iPlayer] = false

			CC_SendMatched(iPlayer, CC_COLOR_TEAM, "%L", iPlayer, "SERVER_VOTEMAP_ENDED_2")
			
			#if !defined USE_TIMELEFT
				CC_SendMatched(iPlayer, CC_COLOR_TEAM, "%L", iPlayer, "SERVER_VOTEMAP_EXTEND", get_pcvar_num(pCvarMaxRounds))
			#else
				CC_SendMatched(iPlayer, CC_COLOR_TEAM, "%L", iPlayer, "SERVER_VOTEMAP_EXTEND2", iTimeLeft, iPlayer, (iTimeLeft > 1) ? "MINUTES" : "MINUTE")
			#endif
		}
		g_iVoteExtend = 0
		#if !defined USE_TIMELEFT
			g_iRoundsPassed = 0
		#else	
			g_bStartVotemapLater = false
			g_iPrints = TEN_MINUTES
		#endif
		g_iVoteMapNum = 0
		g_bVotemapStarted = false

		for(new i;i < SELECTMAPS+1;i++)
		{
			g_iVoteCount[i] = 0
		}
	}
	else
	{
		new b
		for(new a; a < SELECTMAPS+1; a++)
		{
			if(g_iVoteCount[b] < g_iVoteCount[a])		
				b = a	
		}	
	
		if(!g_iVoteCount[b])
		{
			new map = random(g_iVoteMapNum - 1)
			for(new i;i < iNum;i++)
			{
				iPlayer = iPlayers[i]
				CC_SendMatched(iPlayer, CC_COLOR_TEAM, "%L", iPlayer, "SERVER_VOTEMAP_ENDED_1", g_sVoteMap[map])
			}

			copy(g_szMap, charsmax(g_szMap), g_sVoteMap[map])
		}
		else
		{	
			for(new i;i < iNum;i++)
			{
				iPlayer = iPlayers[i]	
				CC_SendMatched(iPlayer, CC_COLOR_TEAM, "%L", iPlayer, "SERVER_VOTEMAP_ENDED_1", g_sVoteMap[b])
			}
			copy(g_szMap, charsmax(g_szMap), g_sVoteMap[b]) 
		}
	
		for(new i;i < iNum;i++)
		{
			iPlayer = iPlayers[i]
			CC_SendMatched(iPlayer, CC_COLOR_TEAM, "%L", iPlayer, "SERVER_VOTEMAP_CHANGE_NR")
		}
	}
	show_menu(0, 0, "^n")
}

public nextMap()
{
	static g_iChangeTime
	if(!g_iChangeTime)
		g_iChangeTime = (CHANGE_TIME + 1)
	
	g_iChangeTime--
	
	set_hudmessage(255, 255, 255, 0.15, 0.30, 0, 0.0, 1.0)
	show_hudmessage(0, "%L", LANG_PLAYER, "SERVER_VOTEMAP_CHANGE", g_iChangeTime)

	if(g_iChangeTime <= 0)
	{
		server_cmd("changelevel %s", g_szMap)
	}
}

public forceVotemap()
{
	if(g_bVotemapStarted)
		return

	#if defined USE_TIMELEFT
	if(!pubnite_is_in_countdown() && !g_bStartVotemapLater)
	{
		new iPlayers[MAX_PLAYERS], iNum
		get_players(iPlayers, iNum, "ch")

		for(new i, iPlayer;i < iNum;i++)
		{
			iPlayer = iPlayers[i]
			CC_SendMatched(iPlayer, CC_COLOR_RED, "%L", iPlayer, "SERVER_VOTE_NEXT_ROUNDEND")
		}
		
		g_bStartVotemapLater = true
		return
	}
	#endif
	
	getMaps()
	
	g_bVotemapStarted = true
	set_task(1.0, "printHudMessage", .flags = "a", .repeat = (get_pcvar_num(pCvarHudTime) + 1))
}

getRTV()
{
	new iPlayers[MAX_PLAYERS], iNum, iRTVNum
	get_players(iPlayers, iNum, "ch")
	for(new i;i < iNum;i++)
	{
		if(g_bRockedTheVote[iPlayers[i]])
		{
			iRTVNum++
		}
	}
	return iRTVNum
}

loadMaps()
{
	static buff[256], szDir[60], szConfigs[94]
	get_configsdir(szDir, charsmax(szDir))
	formatex(szConfigs, charsmax(szConfigs), "%s/maps.ini", szDir)

	new fp = fopen(szConfigs, "rt")	
	if(!fp) 
	{
		static szFailState[50]
		formatex(szFailState, charsmax(szFailState), "[PUBNite]: %L", LANG_PLAYER, "SERVER_ARCHIVE_NOT_FOUND", szConfigs)
		set_fail_state(szFailState)
	}

	while(!feof(fp) && g_iMapCount < MAX_MAPS)
	{
		fgets(fp, buff, charsmax(buff))
		trim(buff) 
		remove_quotes(buff)
			
		if(!buff[0] || (buff[0] == ';') || equal(buff, g_szMapName)) 
			continue
			
		copy(g_sMap[g_iMapCount++], charsmax(g_sMap[]), buff)
	}
	fclose(fp) 
	
	new szFailMessage[100]
	if(!g_iMapCount) 
	{
		formatex(szFailMessage, charsmax(szFailMessage), "[PUBNite]: %L", LANG_SERVER, "SERVER_NO_MAPS_FOUND")
		set_fail_state(szFailMessage)
	}
	else if(g_iMapCount == 1)
	{
		formatex(szFailMessage, charsmax(szFailMessage), "[PUBNite]: %L", LANG_SERVER, "SERVER_INSUFFICIENT_MAPS_FOUND")
		set_fail_state(szFailMessage)	
	}
}

getMaps()
{
	for(new i, iMapID;i < g_iMapCount;i++)
	{
		while(isMapInMenu(iMapID))
		{
			iMapID = random(g_iMapCount)
		}
		g_iMapInMenu[g_iVoteMapNum] = iMapID
		copy(g_sVoteMap[g_iVoteMapNum++], charsmax(g_sVoteMap[]), g_sMap[iMapID])
		
		if(g_iVoteMapNum > SELECTMAPS)
			break
	}
}

bool:isMapInMenu(MapId)
{
	for(new i; i < g_iVoteMapNum; i++)
	{
		if(g_iMapInMenu[i] == MapId)
		{
			return true
		}
	}
	return false
}

getTotalVoteValue()
{
	new iReturnValue
	for(new i;i < g_iVoteMapNum;i++)
	{
		iReturnValue += g_iVoteCount[i]
	}
	return (iReturnValue + g_iVoteExtend)
}
