#include <amxmodx>
#include <fvault>
#include <pubnite_mod>

#define PLUGIN 			"PUBNite: Winners Top 15"
#define VERSION 		"1.0"
#define AUTHOR 			"guipatinador/EFFx"

#if AMXX_VERSION_NUM < 183
#define client_disconnected	client_disconnect
#endif

#define g_VaultNames		"PUBNite_names"

enum _:FvaultData 
{
	szSteamID[35],
	szSkillP_Data[128]
}

new g_szAuthID[MAX_PLAYERS + 1][35]
new g_szName[MAX_PLAYERS + 1][32]

public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	if(is_plugin_loaded("BattleRoyale Mod") == -1)
	{
		set_fail_state("MOD DISABLED")
	}
	
	new szTop15[MAX_PLAYERS], szCommandFmt[35]
	pubnite_get_command(cTop15, szTop15)
	formatex(szCommandFmt, charsmax(szCommandFmt), "say %s", szTop15)
	register_clcmd(szCommandFmt, "cmdPUBNiteTop15")
}

public client_authorized(id)
{
	getData(id)
}

public client_infochanged(id)
{
	getData(id)
}

public cmdPUBNiteTop15(id)
{
	new iLen, szMotd[2300]
	iLen = formatex(szMotd, charsmax(szMotd),
	"<body bgcolor=#A4BED6>\
	<table width=100%% cellpadding=2 cellspacing=3 border=3>\
	<tr align=center bgcolor=#52697B>\
	<th width=4%%>#\
	<th width=30%% align=left>Player\
	<th width=8%% align=center>Solo\
	<th width=8%% align=center>Duo\
	<th width=8%% align=center>Squad")
	
	new Array:aKey = ArrayCreate(35)
	new Array:aData = ArrayCreate(128)
	new Array:aAll = ArrayCreate(FvaultData)
	
	fvault_load(g_szFVaultSave, aKey, aData)
	
	new iArraySize = ArraySize(aKey)
	new iData[FvaultData]
	
	for(new i; i < iArraySize; i++)
	{
		ArrayGetString(aKey, i, iData[szSteamID], charsmax(iData[szSteamID]))
		ArrayGetString(aData, i, iData[szSkillP_Data], charsmax(iData[szSkillP_Data]))
		
		ArrayPushArray(aAll, iData)
	}
	
	ArraySort(aAll, "SortData")
	
	new szPlayerWonRoundsSolo[7]
	new szPlayerWonRoundsDuo[7]
	new szPlayerWonRoundsSquad[7]
	
	new szName[22]
	new iSize = clamp(iArraySize, 0, 15)
	
	for(new j, iPlaces; j < iSize; j++ )
	{
		ArrayGetArray(aAll, j, iData)
		fvault_get_data(g_VaultNames, iData[szSteamID], szName, charsmax(szName))
		
		replace_all(szName, charsmax(szName), "<", "[")
		replace_all(szName, charsmax(szName), ">", "]")
		
		if(!szName[0])
			continue

		iPlaces++
		parse
		(
			iData[szSkillP_Data], 
			szPlayerWonRoundsSolo, charsmax(szPlayerWonRoundsSolo),
			szPlayerWonRoundsDuo, charsmax(szPlayerWonRoundsDuo),
			szPlayerWonRoundsSquad, charsmax(szPlayerWonRoundsSquad)
		)

		iLen += formatex(szMotd[iLen], charsmax(szMotd) - iLen, "<tr align=center>")
		iLen += formatex(szMotd[iLen], charsmax(szMotd) - iLen, "<td>%i.", iPlaces)
		iLen += formatex(szMotd[iLen], charsmax(szMotd) - iLen, "<td align=left>%s", szName)
		iLen += formatex(szMotd[iLen], charsmax(szMotd) - iLen, "<td>%s", szPlayerWonRoundsSolo)
		iLen += formatex(szMotd[iLen], charsmax(szMotd) - iLen, "<td>%s", szPlayerWonRoundsDuo)
		iLen += formatex(szMotd[iLen], charsmax(szMotd) - iLen, "<td>%s", szPlayerWonRoundsSquad)
	}
	
	iLen += formatex(szMotd[iLen], charsmax(szMotd) - iLen, "</table></body>")
	show_motd(id, szMotd, "PUBNite Top Wins")
	
	ArrayDestroy(aKey)
	ArrayDestroy(aData)
	ArrayDestroy(aAll)
}

public SortData(Array:aArray, iItem1, iItem2, iData[], iDataSize)
{
	new Data1[FvaultData]
	new Data2[FvaultData]
	
	ArrayGetArray(aArray, iItem1, Data1)
	ArrayGetArray(aArray, iItem2, Data2)
	
	new szPoints_1[7]
	parse(Data1[szSkillP_Data], szPoints_1, charsmax(szPoints_1))
	
	new szPoints_2[7]
	parse(Data2[szSkillP_Data], szPoints_2, charsmax(szPoints_2))
	
	new iCount1 = str_to_num(szPoints_1)
	new iCount2 = str_to_num(szPoints_2)
	
	return (iCount1 > iCount2) ? -1 : ((iCount1 < iCount2) ? 1 : 0)
}

getData(id)
{
	if(!is_user_bot(id))
	{
		get_user_authid(id, g_szAuthID[id], charsmax(g_szAuthID[]))
		get_user_info(id, "name", g_szName[id], charsmax(g_szName[]))
		fvault_set_data(g_VaultNames, g_szAuthID[id], g_szName[id])
	}
}
