#if defined _pubnite_mod_included
    #endinput
#endif

#define _pubnite_mod_included

#if !defined pev
#include <fakemeta>
#endif

#define MAX_PLAYERS_PER_TEAM 		16

#if !defined MAX_PLAYERS
#define MAX_PLAYERS			32
#endif

#if !defined MAX_MODEL_LENGTH
#define MAX_MODEL_LENGTH		64
#endif

stock const g_szFVaultSave[] =		"PUBNite_Wins"
stock const g_szFVaultVBucks[] =	"PUBNite_VBucks"

/**
* change the player origin X units forward
*/
stock originUnitsAhead(id, Float:fOrigin[3], iUnits)
{
	new Float:fForward[3]
	pev(id, pev_v_angle, fForward)
	pev(id, pev_origin, fOrigin)

	engfunc(EngFunc_MakeVectors, fForward)
	global_get(glb_v_forward, fForward)

	fOrigin[0] += fForward[0] * iUnits
	fOrigin[1] += fForward[1] * iUnits
}

stock bool:isInvalidPlace(Float:fOrigin[3], id)
{
	return bool:(!isValidOrigin(fOrigin) || pev(id, pev_waterlevel) > 0)
}

stock bool:isValidOrigin(const Float:fOrigin[3], iHull = HULL_HUMAN, iFlag = IGNORE_MONSTERS, id = 0)
{
	new HandleTraceHull 
	if(engfunc(EngFunc_PointContents, fOrigin) == CONTENTS_EMPTY)
	{
		engfunc(EngFunc_TraceHull, fOrigin, fOrigin, iFlag, iHull, id, HandleTraceHull)
		if(get_tr2(HandleTraceHull, TR_InOpen) && !(get_tr2(HandleTraceHull, TR_StartSolid) || get_tr2(HandleTraceHull, TR_AllSolid))) 
		{
			return true
		}    
	}
	return false
}

enum _:rRarity
{
	RARITY_NONE,
	RARITY_GREY,
	RARITY_GREEN,
	RARITY_BLUE,
	RARITY_PURPLE,
	RARITY_GOLD
}

enum cCommandsData
{
	cRank,
	cTeam,
	cGetoutTeam,
	cBag,
	cMainMenu,
	cTop15,
	cTopVBucks,
	cModelsShop,
	cKnifeShop,
	cGiveVBucks
}

/**
* Pass the winner(s) ID
* @iWinners			all avaliable winners' ID
* @iWinnersNum			how many players won
*/
forward pubnite_winner(iWinners[], iWinnersNum)

/**
* Called when a player is knocked out
* @iAttacker		Knocker ID
* @iVictim		Victim ID
* @iWeaponID		Weapon used to knock the victim
*/
forward client_KnockedOut(iAttacker, iVictim, iWeaponID)

/**
* Executed when a team is either cancelled or all players are dead.
* @iTeamID		The teamID.
*/
forward pubnite_TeamEliminated(iTeamID)

/**
* Executed when the round has started
* @iPlayersNum		Pass how many players are playing.
* @iSoloNum		How many solos.
* @iTeamNum		How many trio/squads.
*/
forward pubnite_roundStarted(iPlayersNum, iSoloNum, iTeamNum)

/**
* Executed when a customized item is created
* @iEntityID			the entity ID
* @iCustomItemID		the custom item ID
*/
forward pubnite_customitem_created(iEntityID, iCustomItemID)

/**
* Executed when a customized item is picked up
* @iPlayer			player's id
* @iEntityID			the entity ID
* @iCustomItemID		the custom item ID
* @iCustomItemLife		the custom item life
* @bUseButtonPressed		checks if the item has been got by pressing E button
*/
forward pubnite_customitem_pickedup(iPlayer, iEntityID, iCustomItemID, iCustomItemLife, bUseButtonPressed)

/**
* Executed when a customized item is dropped
* @iPlayer		the player ID
* @iCustomItemID	the custom item ID
*/
forward pubnite_customitem_dropped(iPlayer, iCustomItemID)

/**
* Executed when a customized item is used by the bag menu
* @iPlayer		the player ID
* @iCustomItemID	the custom item ID
*/
forward pubnite_customitem_used(iPlayer, iCustomItemID)

/**
* Executed when the player jump from the bus
* @iPlayer		the player ID
*/
forward pubnite_player_busdrop(iPlayer)

/**
* Executed when the player lands (after jumping from the bus)
* @iPlayer		the player ID
*/
forward pubnite_player_land(iPlayer)

/**
* Executed when a customized weapon is dropped
* NOTE: If you're using a customized weapon which uses a determined weapon
* that forward will be executed when you're picking another weapon from the same slot.
* @iPlayer		the player ID
* @iWeaponID		the weapon ID
*/
forward pubnite_noregistered_weapon(iPlayer, iWeaponID)

/**
* Checks if the user is outside the safe zone
*@id			the id of the user to check if he's in the redzone
*/
native pubnite_is_in_redzone(id)

/**
* Checks if the user is knocked out
*@id			the id of the user to check if he's knocked out.
*/
native pubnite_is_knockedout(id)

/*
* gets the redzone compression level
*/
native pubnite_get_redzone_level()

/**
* Checks if the attacker and the victim are teammates
* @iAttacker		the id of the attacker
* @iVictim		the id of the victim
*/
native pubnite_is_teammate(iAttacker, iVictim)

/**
* Gets the win ammount of the player
* @id			the id of the player to check
* @iWinType		(0 = Solo wins | 1 = Duo Wins | 2 = Trio/Squad Wins | 3 = All Types)
*/
native pubnite_get_user_wins(id, iWinType)

/**
* Set/Take victories from a player
*@id			the id of the user to take/give.
*@iWins			the value to take/give
*@iWinType		(0 = Solo wins | 1 = Duo Wins | 2 = Trio/Squad Wins)
*/
native pubnite_set_user_wins(id, iWins, iWinType)

/**
* Checks if the user is in a team and return it's ID
*@id			the id of the user to check if he's in a team
*/
native pubnite_get_user_team(id)

/**
* Set a new team to target(s)
*@id			the id of the user to change the team
*@iNewTeam		new team id
*@bSetTeammatesToo	if you want the teammates of the @id follow the same teamid as well.
*/
native pubnite_set_user_team(id, iNewTeam, bool:bSetTeammatesToo)

/**
* Checks if is in the countdown.
*/
native pubnite_is_in_countdown()

/**
* Get player knocker's ID
*/
native pubnite_get_knockerid(id)

/**
* Return how many players a team has.
* @iTeam		TeamID to check
*/
native pubnite_players_remaining(iTeam, bool:bCheckAlive)

/**
* Checks if an origin is inside safe zone
* @fOriginX		fOrigin[0]
* @fOriginY		fOrigin[1]
*/
native pubnite_origin_inside_redzone(Float:fOriginX, Float:fOriginY)

/**
* Return how many solo/teams is remaining
* @iCheckSoloPlayers	(0 = Check only solo players | 1 = check teams left)
* @bCheckAlivesOnly	true or false to return only alive/dead players
*/
native pubnite_teamsLeft(iCheckSoloPlayers, bool:bCheckAlivesOnly)

/**
* Return how many seconds to the redzone exec
*/
native pubnite_get_zone_time()

/** Gives the mod's command string
* @cCommand		all avaliable commands, check the top to see which are they.
* @szString		string with the command string
*/
native pubnite_get_command(cCommandsData:cCommand, szString[MAX_PLAYERS])

/**
* Checks if the ID passed is a customized item
* @iCustomItemID	the customized ID to check
*/
native pubnite_is_customitem(iCustomItemID)

/**
* Checks if the player has a determined custom item
* @iPlayer		the player id
* @iCustomItemID	the custom item id to check
*/
native pubnite_has_customitem(id, iCustomItemID)

/** Return a customized item data
* @iCustomItem		the customized item you want to get
* @iParamItemID		the customized item's ID
* @iParamItemRarity	the customized item's rarity
* @szParamItemModel	the customized item's w_ model
*/
native pubnite_get_customitem_data(iCustomItem, &iParamItemID, &iParamItemRarity, szParamItemModel[MAX_MODEL_LENGTH])

/** Return how many customized items has been created
*/
native pubnite_get_customitem_num()

/** Return a customized item ID only
* @iCustomItem		which customized item you want to return
* @iCustomItemID	the custom item ID
*/
native pubnite_get_customitem_id(iCustomItem, &iCustomItemID)

/** Return a customized item information
* @iCustomItem		which customized item you want to return
* @iCustomItemID	the ID of the returned item
* @szCustomItemName	the name of the returned item
*/
native pubnite_get_customitem(iCustomItem, &iCustomItemID, szCustomItemName[MAX_PLAYERS])

/** Register a customized item
* @szCustomItemName	the customized item display name
* @szCustomItemModel	the customized item model
* @iCustomItemRarity	the rarity
* @iCustomItemLife	the life
* @szCustomItemFunc	the customized item function that returns if the user has the item
*/
native pubnite_register_customitem(szCustomItemName[MAX_PLAYERS], szCustomItemModel[MAX_MODEL_LENGTH], iCustomItemRarity, iCustomItemLife, szCustomItemFunc[MAX_PLAYERS])

/** Return a customized item ID by it's name
* @szCustomItemName	the name to check
*/
native pubnite_customitemid_by_name(szCustomItemName[MAX_PLAYERS])

/** Return a customized item name by it's ID
* @iCustomItemID	the id to check
* @szCustomItemName	the string to save the name
*/
native pubnite_customitemname_by_id(iCustomItemID, szCustomItemName[MAX_PLAYERS])

/** Return a customized item rarity by it's ID
* @iCustomItemID	the customized item ID
*/
native pubnite_customitem_rarity_by_id(iCustomItemID)

/** Return a customized item life by it's ID
* @iCustomItemID	the customized item ID
*/
native pubnite_get_customitem_life(iCustomItemID)

/** Change the custom item life
* @iCustomItemID	the customized item ID
* @iNewRarityValue	the new customized rarity
*/
native pubnite_change_item_rarity(iCustomItemID, iNewRarityValue)

/** Change the custom item life
* @iCustomItemID	the customized item ID
* @iNewLifeValue	the new customized life
*/
native pubnite_change_item_life(iCustomItemID, iNewLifeValue)

/** Return a customized item position on the array
* @iCustomItemID	the customized item ID
*/
native pubnite_find_customitem_which(iCustomItemID)

/** Creates a determined item
* @iCustomItemID	the customized item ID
* @iCustomItemLife	the customized item life
* @iId			the id to get the origin
*/
native pubnite_create_customitem(iCustomItemID, iCustomItemLife, iId)

/** Creates a weapon with basic data
* @iWeaponID		the weapon ID
* @iWeaponRarity	the weapon rarity
* @iId			the id to get the origin
* NOTE: If iId is a player and he's dead, the mode will set random velocity automatically
* as example: death.
*/
native pubnite_create_weapon(iWeaponID, iWeaponRarity, iId)

/** Knocks a player
* @iVictim		the victim id
* @iAttacker		the attacker id
*/
native pubnite_force_knockout(iVictim, Attacker)

/** Checks if the id passed is able to be knocked out
* @id			the victim id
*/
native pubnite_able_to_knockout(id)

/** Set/took parachute of a player
* @id			the player id
* @bSetParachute	set/took parachute ability
* @bDeployParachute	Open/close user parachute
*/
native pubnite_set_user_parachute(id, bool:bSetParachute, bool:bDeployParachute = false)

/** Checks if the id passed is currently using the parachute
* @id			the player id
*/
native pubnite_get_user_parachute(id)

/** Checks if the round has ended
*/
native pubnite_has_round_ended()

/** Remove all teams ID inside the array
*/
native pubnite_reset_team_array()

/** Gets player's VBucks
* @id			player's id
*/
native pubnite_get_user_vbucks(id)

/** Sets VBucks to the player
* @id			player's id
* @iVBucksValue		vbuck value
*/
native pubnite_set_user_vbucks(id, iVBucksValue)

/** Remove all players' wins value
*/
native pubnite_reset_wins()

/** Remove all players' vbucks value
*/
native pubnite_reset_vbucks()

/** Returns if the weapon id passed is registered on the MOD
* @iWeaponID		the weaponid to check
*/
native pubnite_is_weapon_registered(iWeaponID)