#include <amxmodx>
#include <fakemeta>
#include <hamsandwich>

#define JUMP_DISTANCE 120 		// Минимальная дистанция, при которой происходит торможение
#define BHOP_SPEED_X 0.75 		// Коэфициент торможения после приземления

const OFFSET_PAINSHOCK = 108

new bool:g_is_alive[33]
new in_air[33], old_in_air[33]
new origin1[33][3], origin2[33][3]

public plugin_init()
{
	register_plugin("BHOP BLOCK", "1.6", "Leo_[BH]")
	
	register_forward(FM_PlayerPreThink, "fw_clientPreThink", 0)
	
	register_forward(FM_ClientDisconnect, "fw_ClientDisconnect")
	RegisterHam(Ham_Spawn, "player", "fw_PlayerSpawn_Post", 1)
	RegisterHam(Ham_Killed, "player", "fw_PlayerKilled")
}

public fw_clientPreThink(id)
{
	if(!g_is_alive[id]) return PLUGIN_CONTINUE
	
	old_in_air[id] = in_air[id]
	
	if(pev(id, pev_flags) & FL_ONGROUND)
	{
		in_air[id] = 0
	}
	else
	{
		in_air[id] = 1
	}
	
	if(!old_in_air[id] && in_air[id]) // Мгновение назад был на земле, а сейчас - в воздухе
	{
		get_user_origin(id, origin1[id])
	}
	
	if(old_in_air[id] && !in_air[id]) // Мгновение назад был в воздухе, а сейчас - на земле
	{
		get_user_origin(id, origin2[id])
		
		if(get_distance(origin1[id], origin2[id]) > JUMP_DISTANCE)
		{
			set_pdata_float(id, OFFSET_PAINSHOCK, BHOP_SPEED_X) // Тормозим игрока
		}
	}
	
	return PLUGIN_CONTINUE
}

public fw_ClientDisconnect(id)
{
	g_is_alive[id] = false
	in_air[id] = 0
	old_in_air[id] = 0
}

public fw_PlayerSpawn_Post(id)
{
	if(is_user_alive(id))
	{
		g_is_alive[id] = true
	}
}

public fw_PlayerKilled(victim, attacker)
{
	g_is_alive[victim] = false
	in_air[victim] = 0
	old_in_air[victim] = 0
}

// Другие мои плагины: http://vk.com/cs_rain