#include <amxmodx>
#include <hamsandwich>
#include <cstrike>

new const Plugin[]	= "Chameleon"
new const Version[]	= "0.1"
new const Author[]	= "Dark_Style"

new p_on, p_cost, p_msg_show_time, p_prefix

new b_has_chameleon[ 33 ]

new szPrefix[ 64 ]

new const t_models[][] =
{
	"arctic",
	"guerilla",
	"leet",
	"terror"
}

new const ct_models[][] =
{
	"gign",
	"gsg9",
	"sas",
	"urban"
}

public plugin_init()
{
	register_plugin( Plugin, Version, Author )
	register_cvar( "chameleon_version", Version, FCVAR_SERVER|FCVAR_SPONLY  )
	
	RegisterHam( Ham_Spawn,  "player", "fw_Spawn",  1 )
	RegisterHam( Ham_Killed, "player", "fw_killed", 1 )
	
	register_clcmd( "say /chameleon",	"ClientCommand_Chameleon"	)
	register_clcmd( "say_team /chameleon",	"ClientCommand_Chameleon"	)
	
	p_on		= register_cvar( "chameleon",		"1"		)
	p_cost		= register_cvar( "chameleon_cost",	"1600"		)
	p_msg_show_time	= register_cvar( "chameleon_msg",	"240.0"		)
	p_prefix	= register_cvar( "chameleon_prefix",	"chameleon"	)
}

public client_connect( id )
{
	b_has_chameleon[ id ] = false
}

public client_disconnect( id )
{
	b_has_chameleon[ id ] = false
}

public client_putinserver( id )
{
	b_has_chameleon[ id ] = false 
	
	set_task( get_pcvar_float( p_msg_show_time ), "ChamMsg", id, _, _, "b" )
}

public fw_killed( victim )
{
	b_has_chameleon[ victim ] = false
	cs_reset_user_model( victim )
}

public ClientCommand_Chameleon( id )
{
	if( get_pcvar_num( p_on ) )
	{
		static iMoney
		iMoney = get_pcvar_num( p_cost )
		
		get_pcvar_string( p_prefix, szPrefix, charsmax( szPrefix ) )
		
		if( b_has_chameleon[ id ] )
		{
			Cham( id, "^4[%s] you already have this item!", szPrefix )
		}
		else if( cs_get_user_money( id ) < iMoney )
		{
			Cham( id, "^4[%s] you don't have enough money!", szPrefix )
		}
		else if( !is_user_alive( id ) )
		{
			Cham( id, "^4[%s] you must be alive!", szPrefix )
		}
		else
		{
			switch( cs_get_user_team( id ) )
			{
				case CS_TEAM_T:
				{
					cs_set_user_model( id, ct_models[ random( sizeof ct_models - 1 ) ] )
					cs_set_user_money( id, cs_get_user_money( id ) - iMoney )
					Cham( id, "^4[%s] Now you will look like the enemy!", szPrefix )
					b_has_chameleon[ id ] = true
				}
				case CS_TEAM_CT:
				{
					cs_set_user_model( id, t_models[ random( sizeof t_models - 1 ) ] )
					cs_set_user_money( id, cs_get_user_money( id ) - iMoney )
					Cham( id, "^4[%s] Now you will look like the enemy!", szPrefix )
					b_has_chameleon[ id ] = true
				}
				default:
				{
					cs_reset_user_model( id )
					b_has_chameleon[ id ] = false 
				}
			}
		}
	}
}

public fw_Spawn( id )
{
	if( is_user_alive( id ) && get_pcvar_num( p_cost ) == 1 )
	{
		if( b_has_chameleon[ id ] )
		{
			switch( cs_get_user_team( id ) )
			{
				case CS_TEAM_T:
				{
					cs_set_user_model( id, ct_models[ random( sizeof ct_models - 1 ) ] )
					cs_set_user_money( id, cs_get_user_money( id ) - get_pcvar_num( p_cost ) )
					get_pcvar_string( p_prefix, szPrefix, charsmax( szPrefix ) )
					Cham( id, "^4[%s] Now you will look like the enemy!", szPrefix )
					b_has_chameleon[ id ] = true 
				}
				case CS_TEAM_CT:
				{
					cs_set_user_model( id, ct_models[ random( sizeof ct_models - 1 ) ] )
					cs_set_user_money( id, cs_get_user_money( id ) - get_pcvar_num( p_cost ) )
					get_pcvar_string( p_prefix, szPrefix, charsmax( szPrefix ) )
					Cham( id, "^4[%s] Now you will look like the enemy!", szPrefix )
					b_has_chameleon[ id ] = true 
				}
			}
		}
	}
}

public ChamMsg( id )
{
	if( is_user_connected( id ) )
	{
		get_pcvar_string( p_prefix, szPrefix, charsmax( szPrefix ) )
		
		Cham( 0, "^4[%s] type /chameleon to look like the enemy!", szPrefix )
		Cham( 0, "^4[%s] cl_minimodels must be set to 0 if you want the plugin to works correctly!", szPrefix )
	}
}	
	
/*START - ColorChat */
stock Cham(const id, const input[], any:...){
	new count = 1, players[32];
	static msg[ 191 ];
	vformat(msg, 190, input, 3);
	if (id) players[0] = id; else get_players(players , count , "ch"); {
		for (new i = 0; i < count; i++){
			if (is_user_connected(players[i])){
				message_begin(MSG_ONE_UNRELIABLE , get_user_msgid("SayText"), _, players[i]);
				write_byte(players[i]);
				write_string(msg);
				message_end();}}}
}
/*END - ColorChat */