/*
	Status Icon Kills Counter		     v. 0.3
	by serfreeman1337		http://gf.hldm.org/
*/

#include <amxmodx>
#include <hamsandwich>

new sprites[][] = {
	"",
	"number_1",
	"number_2",
	"number_3",
	"number_4",
	"number_5",
	"number_6",
	"number_7",
	"number_8",
	"number_9"
}

new g_maxplayers,g_statusicon

new cvColor,cvBlinkTime,cvOverCount

new idid[33]
new clor[3]

new Float:blinkTime
new overCountSpr[40]

#define RESETBLINK_TASKID	45454

public plugin_init(){
	register_plugin("Kills Counter","0.3","serfreeman1337")
	
	g_maxplayers = get_maxplayers()
	g_statusicon = get_user_msgid("StatusIcon")
	
	cvColor = register_cvar("ks_color","255 255 0")
	cvBlinkTime = register_cvar("ks_blink_time","2.0")
	cvOverCount = register_cvar("ks_over_count_spr","dmg_rad")
	
	RegisterHam(Ham_Killed,"player","fw_PlayerKilled",1)
	RegisterHam(Ham_Spawn,"player","fw_PlayerSpawn",1)
}

public plugin_cfg(){
	new data[20],raw[3][5]
	get_pcvar_string(cvColor,data,19)
	
	parse(data,raw[0],4,raw[1],4,raw[2],4)
	
	clor[0] = str_to_num(raw[0])
	clor[1] = str_to_num(raw[1])
	clor[2] = str_to_num(raw[2])
	
	blinkTime = get_pcvar_float(cvBlinkTime)
	get_pcvar_string(cvOverCount,overCountSpr,39)
}

public fw_PlayerSpawn(id)
	icon(id,0)
	
public fw_PlayerKilled(victim,killer){
	if(0 < killer <= g_maxplayers){
		if(get_user_team(killer) != get_user_team(victim) && ExecuteHam(Ham_IsAlive,killer))
			icon(killer,1)
	}
	
	icon(victim,0)
}

public icon(id,style){
	if(!style){
		if(!idid[id])
			return PLUGIN_CONTINUE
			
		message_begin(MSG_ONE,g_statusicon,_,id)
		write_byte(0) 
		write_string(idid[id] < 10 ? sprites[idid[id]] : overCountSpr)
		message_end()
		
		idid[id] = 0
		
		return PLUGIN_CONTINUE
	}
	
	if(0 < idid[id] < 10){
		message_begin(MSG_ONE,g_statusicon,_,id)
		write_byte(0) 
		write_string(sprites[idid[id]])
		message_end()
	}
	
	idid[id] ++

	message_begin(MSG_ONE,g_statusicon,_,id)
	write_byte(blinkTime > 0.0 ? 2 : 1) 
	write_string(idid[id] < 10 ? sprites[idid[id]] : overCountSpr)
	write_byte(clor[0])
	write_byte(clor[1])
	write_byte(clor[2])
	message_end()
	
	if(blinkTime > 0.0){
		remove_task(RESETBLINK_TASKID + id)
		set_task(2.0,"resetblink",RESETBLINK_TASKID + id)
	}
	
	return PLUGIN_CONTINUE
}

public resetblink(tId){
	new id = tId - RESETBLINK_TASKID
	
	if(!is_user_connected(id))
		return
	
	message_begin(MSG_ONE,g_statusicon,_,id)
	write_byte(1) 
	write_string(idid[id] < 10 ? sprites[idid[id]] : overCountSpr)
	write_byte(clor[0])
	write_byte(clor[1])
	write_byte(clor[2])
	message_end()
}
