#include <amxmodx>
#include <fakemeta>
#include <engine>
#include <cstrike>
#include <colorchat>

#pragma semicolon 1

#define UPDATEINTERVAL 1.0

#define ECHOCMD

#define FLAG ADMIN_IMMUNITY

new const PLUGIN[] = "SpecList";
new const VERSION[] = "1.2a";
new const AUTHOR[] = "SasaiLalka";

new gMaxPlayers;
new gCvarOn;
new gCvarImmunity;
new bool:gOnOff[33] = { true, ... };

public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR);
	
	register_cvar(PLUGIN, VERSION, FCVAR_SERVER, 0.0);
	gCvarOn = register_cvar("amx_speclist", "1", 0, 0.0);
	gCvarImmunity = register_cvar("amx_speclist_immunity", "1", 0, 0.0);
	
	register_clcmd("say /spec", "cmdSpecList", -1, "");
	register_clcmd("say_team /spec", "cmdSpecList", -1, "");
	
	gMaxPlayers = get_maxplayers();
	
	set_task(UPDATEINTERVAL, "tskShowSpec", 123094, "", 0, "b", 0);
}

public cmdSpecList(id)
{
	if( gOnOff[id] )
	{
		ColorChat(id, RED, "^1[^4SpecList^1] Список наблюдателей ^3Выключен.");
		gOnOff[id] = false;
	}
	else
	{
		ColorChat(id, BLUE, "^1[^4SpecList^1] Список наблюдателей ^3Включен.");
		gOnOff[id] = true;
	}
	
	#if defined ECHOCMD
	return PLUGIN_CONTINUE;
	#else
	return PLUGIN_HANDLED;
	#endif
}

public tskShowSpec()
{
	if( !get_pcvar_num(gCvarOn) )
	{
		return PLUGIN_CONTINUE;
	}
	
	static szHud[1102];
	static szName[34];
	static bool:send;
	
	for( new alive = 1; alive <= gMaxPlayers; alive++ )
	{
		new bool:sendTo[33];
		send = false;
		
		if( !is_user_alive(alive) )
		{
			continue;
		}

		sendTo[alive] = true;

		get_user_name(alive, szName, 32);
		format(szHud, 245, "Игрок: %s^nHP: %d | Armor: %d^n^nНаблюдают:^n", szName, get_user_health(alive), get_user_armor(alive));
		
		for( new dead = 1; dead <= gMaxPlayers; dead++ )
		{
			if( is_user_connected(dead) )
			{
				if( is_user_alive(dead)
				|| is_user_bot(dead) )
				{
					continue;
				}
				
				if( pev(dead, pev_iuser2) == alive )
				{
					if( !(get_pcvar_num(gCvarImmunity)&&get_user_flags(dead, 0)&FLAG) )
					{
						get_user_name(dead, szName, 32);
						add(szName, 33, "^n", 0);
						add(szHud, 1101, szName, 0);
						send = true;
					}

					sendTo[dead] = true;
					
				}
			}
		}
		
		if( send == true )
		{
			for( new i = 1; i <= gMaxPlayers; i++ )
			{
				if( sendTo[i] == true
				&& gOnOff[i] == true )
				{
					set_hudmessage(255, 255, 0, 0.75, 0.15, 0, 0.0, UPDATEINTERVAL + 0.1, 0.0, 0.0, -1);
					
					show_hudmessage(i, szHud);
				}
			}
		}
	}
	
	return PLUGIN_CONTINUE;
}

public client_connect(id)
{
	gOnOff[id] = true;
}

public client_disconnect(id)
{
	gOnOff[id] = true;
}
