#include <amxmodx>
#include <amxmisc>
#include <reapi>
#include <fakemeta>
#include <hamsandwich>

#include <auw>

new const PLUGIN_NAME[] = "Advanced Ultimate Weapons";
new const PLUGIN_VERSION[] = "0.0.3-Alpha";

enum _:eCvarsData
{
	FLAG_ACCESS[5],
	MENU_ACCESS_TYPE,
	DISCOUNT,
	Float: BUYTIME,
	MENU_ROUND,
	BUYZONE,
	MENU_DAMAGE,
	CMD_ACCESS[5],
	GIVE_TYPE,
	TRACE_TYPE
}; new g_pCvar[eCvarsData];

#define var_weaponkey var_iuser4
#define var_modelview var_noise1
#define var_modelplayer var_noise2
#define var_modelworld var_message
#define var_weapontrace var_iuser2
#define var_weaponflags var_iuser1

#define getWeaponKey(%0) get_entvar(%0, var_weaponkey)
#define getWeaponModelView(%0,%1,%2) get_entvar(%0, var_modelview, %1, %2)
#define getWeaponModelPlayer(%0,%1,%2) get_entvar(%0, var_modelplayer, %1, %2)
#define getWeaponModelWorld(%0,%1,%2) get_entvar(%0, var_modelworld, %1, %2)
#define getWeaponTrace(%0) get_entvar(%0, var_weapontrace)
#define getWeaponFlags(%0) get_entvar(%0, var_weaponflags)

#define setWeaponKey(%0,%1) set_entvar(%0, var_iuser4, %1)
#define setWeaponModelView(%0,%1) set_entvar(%0, var_modelview, %1)
#define setWeaponModelPlayer(%0,%1) set_entvar(%0, var_modelplayer, %1)
#define setWeaponModelWorld(%0,%1) set_entvar(%0, var_modelworld, %1)
#define setWeaponTrace(%0,%1) set_entvar(%0, var_weapontrace, %1)
#define setWeaponFlags(%0,%1) set_entvar(%0, var_weaponflags, %1)

#define IsComment(%0) (%0[0] == EOS || %0[0] == 10 || %0[0] == 13 || %0[0] == ';' || %0[0] == '#' || (%0[0] == '/' && %0[1] == '/'))
#define rg_get_user_money(%0) get_member(%0, m_iAccount)
#define IMPULSE_OFFSET 1000
#define MAXWEAPONS 128

#define IsPlayer(%1) bool:(%1 && %1 <= MAX_PLAYERS)
#define get_bit(%1,%2) (%1 & (1 << (%2 & 31)))
#define set_bit(%1,%2) (%1 |= (1 << (%2 & 31)))
#define reset_bit(%1,%2) (%1 &= ~(1 << (%2 & 31)))

new g_bClientConnected;
new Array: g_aWeaponData;
new Trie: g_tWeaponClcmd;
new g_iWeaponsCount;
new g_iLaserBeam;
new g_pCvarBuyTime;
new g_iClcmdIndex[MAXWEAPONS];
new const sFile[] = "ultimate_weapons.ini";

public plugin_init()
{
	register_plugin(PLUGIN_NAME, PLUGIN_VERSION, "steelzzz");

	register_clcmd("say /ultimate", "Command_ShowUltimateMenu");
	register_concmd("buyultimate", "Command_ShowUltimateMenu");
	register_concmd("weapons_give", "Command_GiveWeapon");

	RegisterHam(Ham_TraceAttack, "player", "CWeapon_TraceAttack_Post", .Post = true);
	RegisterHam(Ham_TraceAttack, "info_target", "CWeapon_TraceAttack_Post", .Post = true);
	RegisterHam(Ham_TraceAttack, "func_breakable", "CWeapon_TraceAttack_Post", .Post = true);
	RegisterHam(Ham_TraceAttack, "hostage_entity", "CWeapon_TraceAttack_Post", .Post = true);
	RegisterHam(Ham_TraceAttack, "worldspawn", "CWeapon_TraceAttack_Post", .Post = true);
	RegisterHam(Ham_Touch, "weaponbox", "CWeapon_Touch_Pre", .Post = false);

	RegisterHookChain(RG_CBasePlayerWeapon_DefaultDeploy, "CWeapon_DefaultDeploy_Pre", .post = false);
	RegisterHookChain(RG_CWeaponBox_SetModel, "CWeapon_SetModel_Pre", .post = false);

	register_forward(FM_ClientDisconnect, "FM_ClientDisconnect_Pre", ._post = false);

	register_dictionary("ultimate_weapons.txt");
}

public plugin_cfg()
{
	register_cvar("auw_version", PLUGIN_VERSION, FCVAR_SERVER | FCVAR_SPONLY);

	bind_pcvar_string(create_cvar("weapons_flag", "t", .description = fmt("%L", LANG_SERVER, "CVAR_WEAPONS_FLAG")), g_pCvar[FLAG_ACCESS], sizeof(g_pCvar[FLAG_ACCESS]));
	bind_pcvar_num(create_cvar("weapons_access", "1", .description = fmt("%L", LANG_SERVER, "CVAR_WEAPONS_ACCESS"), .has_min = true, .min_val = 0.0, .has_max = true, .max_val = 2.0), g_pCvar[MENU_ACCESS_TYPE]);
	bind_pcvar_num(create_cvar("weapons_disc", "30", .description = fmt("%L", LANG_SERVER, "CVAR_WEAPONS_DISC"), .has_min = true, .min_val = 0.0, .has_max = true, .max_val = 100.0), g_pCvar[DISCOUNT]);
	bind_pcvar_float(create_cvar("weapons_time", "2.0", .description = fmt("%L", LANG_SERVER, "CVAR_WEAPONS_TIME"), .has_min = true, .min_val = 0.0), g_pCvar[BUYTIME]);
	bind_pcvar_num(create_cvar("weapons_firstround", "1", .description = fmt("%L", LANG_SERVER, "CVAR_WEAPONS_FIRSTROUND"), .has_min = true, .min_val = 0.0), g_pCvar[MENU_ROUND]);
	bind_pcvar_num(create_cvar("weapons_zone", "1", .description = fmt("%L", LANG_SERVER, "CVAR_WEAPONS_ZONE"), .has_min = true, .min_val = 0.0, .has_max = true, .max_val = 1.0), g_pCvar[BUYZONE]);
	bind_pcvar_num(create_cvar("weapons_menu_dmg", "0", .description = fmt("%L", LANG_SERVER, "CVAR_WEAPONS_MENU_DMG"), .has_min = true, .min_val = 0.0, .has_max = true, .max_val = 1.0), g_pCvar[MENU_DAMAGE]);
	bind_pcvar_string(create_cvar("weapons_cmd_access", "t", .description = fmt("%L", LANG_SERVER, "CVAR_WEAPONS_CMD_ACCESS")), g_pCvar[CMD_ACCESS], sizeof(g_pCvar[CMD_ACCESS]));
	bind_pcvar_num(create_cvar("weapons_give_type", "2", .description = fmt("%L", LANG_SERVER, "CVAR_WEAPONS_GIVE_TYPE"), .has_min = true, .min_val = 0.0, .has_max = true, .max_val = 2.0), g_pCvar[GIVE_TYPE]);
	bind_pcvar_num(create_cvar("weapons_trace_type", "0", .description = fmt("%L", LANG_SERVER, "CVAR_WEAPONS_TRACE_TYPE"), .has_min = true, .min_val = 0.0, .has_max = true, .max_val = 1.0), g_pCvar[TRACE_TYPE]);

	g_pCvarBuyTime = get_cvar_pointer("mp_buytime");

	AutoExecConfig(true, "ultimate_weapons");
}

public plugin_natives()
{
	register_native("weapons_get_weapon_uid", "Native_GetWeaponUid", false);
	register_native("weapons_give_weapon", "Native_GiveWeapon", false);
	register_native("weapons_valid_weapon", "Native_ValidWeapon", false);
	register_native("weapons_get_weapons_data", "Native_GetWeaponsData", false);
}

public Native_GetWeaponUid(iPlugin, iParams)
{
	enum { arg_buyname = 1 };

	new sWeaponName[32];
	get_string(arg_buyname, sWeaponName, charsmax(sWeaponName));

	new iWeaponId;

	if(!TrieGetCell(g_tWeaponClcmd, sWeaponName, iWeaponId))
	{
		return -1;
	}

	return iWeaponId + IMPULSE_OFFSET;
}

public Native_GiveWeapon(iPlugin, iParams)
{
	enum { arg_player = 1, arg_weaponname };

	new iPlayer = get_param(arg_player);

	if(!is_user_connected(iPlayer))
	{
		return false;
	}
	
	new sWeaponName[32];
	get_string(arg_weaponname, sWeaponName, charsmax(sWeaponName));

	new iWeaponId;

	if(!TrieGetCell(g_tWeaponClcmd, sWeaponName, iWeaponId))
	{
		return false;
	}

	giveItem(iPlayer, iWeaponId, 0);

	return true;
}

public Native_ValidWeapon(iPlugin, iParams)
{
	enum { arg_item = 1, arg_uid };

	new iItem = get_param(arg_item);

	if(is_nullent(iItem))
	{
		return false;
	}
	
	new iKey = get_param(arg_uid);

	return bool:(IsCustomWeapon(iItem, iKey));
}

public Native_GetWeaponsData(iPlugin, iParams)
{
	enum { arg_uid = 1, arg_array };

	new iKey = get_param(arg_uid) - IMPULSE_OFFSET;

	if(!(0 <= iKey < g_iWeaponsCount))
	{
		return false;
	}

	new aData[eData];
	ArrayGetArray(g_aWeaponData, iKey, aData);

	return set_array(arg_array, aData, eData);
}

public client_putinserver(iPlayer)
{
	if(is_user_hltv(iPlayer) || is_user_bot(iPlayer))
	{
		return;
	}

	set_bit(g_bClientConnected, iPlayer);
}

public FM_ClientDisconnect_Pre(iPlayer)
{
	reset_bit(g_bClientConnected, iPlayer);
}

getClcmdIndex(iIndex)
{
	for(new i = 0; i < MAXWEAPONS; i++)
	{
		if(iIndex == g_iClcmdIndex[i])
		{
			return i;
		}
	}

	return NULLENT;
}

public Command_GiveWeapon_EX(iPlayer, iAccess, iIndex)
{
	new iWeaponId = getClcmdIndex(iIndex);

	if(iWeaponId == NULLENT)
	{
		return PLUGIN_HANDLED;
	}

	if(g_pCvar[FLAG_ACCESS] && !(get_user_flags(iPlayer) & read_flags(g_pCvar[CMD_ACCESS])))
	{
		console_print(iPlayer, "%L", iPlayer, "CONSOLE_NO_ACCESS");
		return PLUGIN_HANDLED;
	}

	giveItem(iPlayer, iWeaponId, 1);

	return PLUGIN_HANDLED;
}

public Command_GiveWeapon(iPlayer)
{
	if(g_pCvar[FLAG_ACCESS] && !(get_user_flags(iPlayer) & read_flags(g_pCvar[CMD_ACCESS])))
	{
		console_print(iPlayer, "%L", iPlayer, "CONSOLE_NO_ACCESS");
		return PLUGIN_HANDLED;
	}

	new sTarget[64];
	new sArg[64];
	
	read_argv(1, sTarget, charsmax(sTarget));
	trim(sTarget);
	remove_quotes(sTarget);

	read_argv(2, sArg, charsmax(sArg));
	trim(sArg);
	remove_quotes(sArg);

	if(sArg[0] == EOS || sTarget[0] == EOS)
	{
		console_print(iPlayer, "%L", iPlayer, "CONSOLE_USAGE");
		return PLUGIN_HANDLED;
	}

	new iFindPlayer = cmd_target(iPlayer, sTarget, CMDTARGET_ALLOW_SELF)

	if(!iFindPlayer)
	{
		return PLUGIN_HANDLED;
	}

	if(!get_bit(g_bClientConnected, iFindPlayer))
	{
		return PLUGIN_HANDLED;
	}

	new iWeaponId;

	if(!TrieGetCell(g_tWeaponClcmd, sArg, iWeaponId))
	{
		console_print(iPlayer, "%L", iPlayer, "CONSOLE_WEAPONS_NOTFOUND");
		return PLUGIN_HANDLED;
	}

	new aData[eData];

	ArrayGetArray(g_aWeaponData, iWeaponId, aData);

	if(aData[MENU_WEAPON_ADD] == 0)
	{
		return PLUGIN_HANDLED;
	}

	giveItem(iFindPlayer, iWeaponId, 0);

	return PLUGIN_HANDLED;
}

giveItem(iPlayer, iKey, iBuy)
{
	new aData[eData];
	new iCost;
	static iMoney; iMoney = rg_get_user_money(iPlayer);

	ArrayGetArray(g_aWeaponData, iKey, aData);

	if(iBuy)
	{
		if(aData[WEAPON_ACCESS_FLAGS] && !(get_user_flags(iPlayer) & aData[WEAPON_ACCESS_FLAGS]))
		{
			client_print_color(iPlayer, print_team_default, "%L", iPlayer, "CHAT_NO_ACCESS");
			return;
		}

		if(get_member_game(m_iTotalRoundsPlayed) + 1 < aData[WEAPON_ALLOW_ROUND])
		{
			client_print_color(iPlayer, print_team_default, "%L", iPlayer, "CHAT_ROUNDS", aData[WEAPON_ALLOW_ROUND]);
			return;
		}

		new Float: flBuyTime = (get_pcvar_float(g_pCvarBuyTime) * 60) * g_pCvar[BUYTIME];

		if(get_gametime() - Float: get_member_game(m_fRoundStartTime) > flBuyTime)
		{
			client_print(iPlayer, print_center, "%L", iPlayer, "CENTER_BUYTIME", floatround(flBuyTime));
			return;
		}

		if(g_pCvar[BUYZONE])
		{
			if(!rg_get_user_buyzone(iPlayer))
			{
				client_print(iPlayer, print_center, "%L", iPlayer, "CENTER_NOT_IN_BUYZONE");
				return;
			}
		}

		if(aData[WEAPON_COST] > 0)
		{
			iCost = (g_pCvar[DISCOUNT] > 0) ? aData[WEAPON_COST] - getPercentNum(aData[WEAPON_COST], g_pCvar[DISCOUNT]) : aData[WEAPON_COST];

			if(iMoney < iCost)
			{
				client_print_color(iPlayer, print_team_default, "%L", iPlayer, "СHAT_NO_MONEY");
				return;
			}
		}
	}

	new iWeapon = rg_create_entity(aData[WEAPON_REFERENCE]);

	if(is_nullent(iWeapon))
	{
		return;
	}

	new Float: vecOrigin[3];

	get_entvar(iPlayer, var_origin, vecOrigin);
	set_entvar(iWeapon, var_origin, vecOrigin);
	set_entvar(iWeapon, var_impulse, iKey + IMPULSE_OFFSET);
	setWeaponKey(iWeapon, iKey + IMPULSE_OFFSET);
	setWeaponModelView(iWeapon, aData[WEAPON_MODEL_VIEW]);
	setWeaponModelPlayer(iWeapon, aData[WEAPON_MODEL_PLAYER]);
	setWeaponModelWorld(iWeapon, aData[WEAPON_MODEL_WORLD]);
	setWeaponTrace(iWeapon, aData[WEAPON_TRACE]);
	setWeaponFlags(iWeapon, aData[WEAPON_ACCESS_FLAGS]);
	set_entvar(iWeapon, var_spawnflags, SF_NORESPAWN);
	dllfunc(DLLFunc_Spawn, iWeapon);

	if(!aData[WEAPON_SLOT])
	{
		switch(rg_get_iteminfo(iWeapon, ItemInfo_iSlot))
		{
			case 0:
			{
				aData[WEAPON_SLOT] = PRIMARY_WEAPON_SLOT;
			}
			case 1:
			{
				aData[WEAPON_SLOT] = PISTOL_SLOT;
			}
		}

		ArraySetArray(g_aWeaponData, iKey, aData);
	}	

	if(WeaponIdType: aData[WEAPON_ID] != WEAPON_KNIFE)
	{
		dropWeapons(iPlayer, aData[WEAPON_SLOT]);
	}
	else
	{
		rg_remove_item(iPlayer, "weapon_knife");
	}

	dllfunc(DLLFunc_Touch, iWeapon, iPlayer);

	static iOwner; iOwner = get_entvar(iWeapon, var_owner);

	if(iOwner != iPlayer || is_nullent(iOwner))
	{
		if(!is_nullent(iWeapon))
		{
			engfunc(EngFunc_RemoveEntity, iWeapon);
		}
		return;
	}

	set_member(iWeapon, m_Weapon_flBaseDamage, Float: get_member(iWeapon, m_Weapon_flBaseDamage) * aData[WEAPON_DAMAGE]);

	if(WeaponIdType: aData[WEAPON_ID] != WEAPON_KNIFE)
	{
		rg_set_user_ammo(iPlayer, WeaponIdType: aData[WEAPON_ID], aData[WEAPON_AMMO]);
		rg_set_user_bpammo(iPlayer, WeaponIdType: aData[WEAPON_ID], aData[WEAPON_BPAMMO]);
		rg_set_iteminfo(iWeapon, ItemInfo_iMaxClip, aData[WEAPON_AMMO]);
		rg_set_iteminfo(iWeapon, ItemInfo_iMaxAmmo1, aData[WEAPON_BPAMMO]);
	}

	if(iBuy)
	{
		rg_add_account(iPlayer, iMoney - iCost, AS_SET);
		client_print_color(iPlayer, print_team_default, "%L", iPlayer, "CHAT_WEAPON_BUY", aData[MENU_NAME_ITEM]);
	}
	else
	{
		client_print_color(iPlayer, print_team_default, "%L", iPlayer, "CHAT_WEAPON_GET", aData[MENU_NAME_ITEM]);
	}
}

public CWeapon_Touch_Pre(iEntity, iPlayer)
{
	if(is_nullent(iEntity))
	{
		return HAM_IGNORED;
	}

	if(!get_bit(g_bClientConnected, iPlayer) || !IsPlayer(iPlayer)) // fix?
	{
		return HAM_IGNORED;
	}

	if(IsCustomWeapon(iEntity, get_entvar(iEntity, var_impulse)))
	{
		if(getWeaponFlags(iEntity) && !(get_user_flags(iPlayer) & getWeaponFlags(iEntity)))
		{
			if(get_entvar(iPlayer, var_fuser4) > get_gametime())
			{
				return HAM_SUPERCEDE;
			}

			client_print(iPlayer, print_center, "%L", iPlayer, "CENTER_NO_ACCESS");
			set_entvar(iPlayer, var_fuser4, get_gametime() + 3.0);
			return HAM_SUPERCEDE;
		}
	}

	return HAM_IGNORED;
}

public CWeapon_DefaultDeploy_Pre(iItem, sViewModel[], sWeaponModel[], iAnim, sAnimExt[], iSkipLocal)
{
	if(is_nullent(iItem))
	{
		return HC_CONTINUE;
	}

	if(IsCustomWeapon(iItem, getWeaponKey(iItem)))
	{
		static sView[64], sPlayer[64];

		getWeaponModelView(iItem, sView, sizeof(sView));
		getWeaponModelPlayer(iItem, sPlayer, sizeof(sPlayer));
		SetHookChainArg(2, ATYPE_STRING, sView);
		SetHookChainArg(3, ATYPE_STRING, sPlayer);
	}

	return HC_CONTINUE;
}

public CWeapon_SetModel_Pre(iEntity, sModel[])
{
	if(is_nullent(iEntity))
	{
		return HC_CONTINUE;
	}

	new iWeapon = GetWeaponBox(iEntity);

	if(is_nullent(iWeapon))
	{
		return HC_CONTINUE;
	}
	
	if(IsCustomWeapon(iWeapon, getWeaponKey(iWeapon)))
	{
		static sViewModel[64];
		getWeaponModelWorld(iWeapon, sViewModel, sizeof(sViewModel));

		if(sViewModel[0])
		{
			SetHookChainArg(2, ATYPE_STRING, sViewModel);
		}

		setWeaponFlags(iEntity, getWeaponFlags(iWeapon));
		set_entvar(iEntity, var_impulse, getWeaponKey(iWeapon));
	}
	
	return HC_CONTINUE;
}

GetWeaponBox(iEntity)
{
	for(new i = 0, iWeapon; i < MAX_ITEM_TYPES; i++)
	{
		iWeapon = get_member(iEntity, m_WeaponBox_rgpPlayerItems, i);

		if(!is_nullent(iWeapon))
		{
			return iWeapon;
		}
	}

	return NULLENT;
}

public CWeapon_TraceAttack_Post(iVictim, iAttacker, Float: flDamage, Float: vecDirection[3], iTrace, iBitsDamage)
{
	if(!get_bit(g_bClientConnected, iAttacker))
	{
		return;
	}

	static iItem; iItem = get_member(iAttacker, m_pActiveItem);

	if(is_nullent(iItem))
	{
		return;
	}

	new WeaponIdType: iId; iId = get_member(iItem, m_iId);

	if(iId == WEAPON_KNIFE)
	{
		return;
	}

	if(!IsCustomWeapon(iItem, getWeaponKey(iItem)))
	{
		return;
	}

	new Float: vecEndPos[3];
	get_tr2(iTrace, TR_vecEndPos, vecEndPos);

	if(!getWeaponTrace(iItem))
	{
		return;
	}

	if(g_pCvar[TRACE_TYPE])
	{	
		message_begin(MSG_BROADCAST, SVC_TEMPENTITY);
		write_byte(TE_BEAMENTPOINT);
		write_short(iAttacker | 0x1000);
		engfunc(EngFunc_WriteCoord, vecEndPos[0]);
		engfunc(EngFunc_WriteCoord, vecEndPos[1]);
		engfunc(EngFunc_WriteCoord, vecEndPos[2]);
		write_short(g_iLaserBeam);
		write_byte(0);
		write_byte(0);
		write_byte(1);
		write_byte(10);
		write_byte(0);
		write_byte(255); // r
		write_byte(215); // g
		write_byte(0); //b
		write_byte(200); // alpha
		write_byte(255);
		message_end();
	}
	else
	{
		new vecOrigin[3];
		get_entvar(iAttacker, var_origin, vecOrigin);

		message_begin(MSG_BROADCAST, SVC_TEMPENTITY);
		write_byte(TE_TRACER);
		engfunc(EngFunc_WriteCoord, vecOrigin[0]);
		engfunc(EngFunc_WriteCoord, vecOrigin[1]);
		engfunc(EngFunc_WriteCoord, vecOrigin[2]);
		engfunc(EngFunc_WriteCoord, vecEndPos[0]);
		engfunc(EngFunc_WriteCoord, vecEndPos[1]);
		engfunc(EngFunc_WriteCoord, vecEndPos[2]);
		message_end();
	}

	return;
}

public Command_ShowUltimateMenu(iPlayer)
{
	if(g_pCvar[MENU_ACCESS_TYPE] == 0)
	{
		client_print_color(iPlayer, print_team_default, "%L", iPlayer, "CHAT_BUY_DISABLE");
		return PLUGIN_HANDLED;
	}
	else if(g_pCvar[MENU_ACCESS_TYPE] == 2)
	{
		if(g_pCvar[FLAG_ACCESS] && !(get_user_flags(iPlayer) & read_flags(g_pCvar[FLAG_ACCESS])))
		{
			client_print_color(iPlayer, print_team_default, "%L", iPlayer, "CHAT_NO_ACCESS");
			return PLUGIN_HANDLED;
		}
	}

	if(get_member_game(m_iTotalRoundsPlayed) + 1 < g_pCvar[MENU_ROUND])
	{
		client_print_color(iPlayer, print_team_default, "%L", iPlayer, "CHAT_ROUNDS", g_pCvar[MENU_ROUND]);
		return PLUGIN_HANDLED;
	}

	new sText[128];
	new sDiscount[30];
	new aData[eData];
	new iCost;

	formatex(sText, charsmax(sText), "%L", iPlayer, "MENU_TITLE");
	new hMenu = menu_create(sText, "ShopMenuHandler");
	// maybe add callback?

	for(new i = 0; i < g_iWeaponsCount; i++)
	{
		ArrayGetArray(g_aWeaponData, i, aData);

		if(aData[MENU_WEAPON_ADD] == 0 || aData[MENU_WEAPON_ADD] == 2)
		{
			continue;
		}

		if(aData[WEAPON_COST] < 0)
		{
			continue;
		}


		if(g_pCvar[DISCOUNT] > 0)
		{
			iCost = aData[WEAPON_COST] - getPercentNum(aData[WEAPON_COST], g_pCvar[DISCOUNT]);

			if(getPercentNum(aData[WEAPON_COST], g_pCvar[DISCOUNT]) > 0)
			{
				formatex(sDiscount, charsmax(sDiscount), "%L", iPlayer, "MENU_DISCOUNT", g_pCvar[DISCOUNT]);
			}
		}
		else
		{
			iCost = aData[WEAPON_COST];
		}

		if(g_pCvar[MENU_DAMAGE] > 0)
		{
			formatex(sText, charsmax(sText), "%s%s %L %s \R\y%d", rg_get_user_money(iPlayer) >= iCost ? "\w" : "\d", aData[MENU_NAME_ITEM], iPlayer, "MENU_DAMAGE", floatround(aData[WEAPON_DAMAGE] * 100), sDiscount, iCost);
		}
		else
		{
			formatex(sText, charsmax(sText), "%s%s\R\y%d", rg_get_user_money(iPlayer) >= iCost ? "\w" : "\d", aData[MENU_NAME_ITEM], iCost);
		}

		menu_additem(hMenu, sText);
	}

	formatex(sText, charsmax(sText), "%L", iPlayer, "MENU_NEXT");
	menu_setprop(hMenu, MPROP_NEXTNAME, sText);
	formatex(sText, charsmax(sText), "%L", iPlayer, "MENU_BACK");
	menu_setprop(hMenu, MPROP_BACKNAME, sText);
	formatex(sText, charsmax(sText), "%L", iPlayer, "MENU_EXIT");
	menu_setprop(hMenu, MPROP_EXITNAME, sText);

	menu_display(iPlayer, hMenu, 0);

	return PLUGIN_HANDLED;
}

public ShopMenuHandler(iPlayer, hMenu, iItem)
{
	if(!is_user_alive(iPlayer) || iItem == MENU_EXIT)
	{
		menu_destroy(hMenu);
		return PLUGIN_HANDLED;
	}

	new sData[6], sName[64], iAccess, iCallback;
	menu_item_getinfo(hMenu, iItem, iAccess, sData, charsmax(sData), sName, charsmax(sName), iCallback);

	menu_destroy(hMenu);

	giveItem(iPlayer, iItem, 1);

	return PLUGIN_HANDLED;	
}

public plugin_precache()
{
	g_iLaserBeam = precache_model("sprites/laserbeam.spr");

	g_aWeaponData = ArrayCreate(eData);
	g_tWeaponClcmd = TrieCreate();

	CFile_Load();
}

public CFile_Load()
{
	new sPath[128];

	get_configsdir(sPath, charsmax(sPath));
	format(sPath, charsmax(sPath), "%s/%s", sPath, sFile);

	new iFile = fopen(sPath, "rt");
	new sLine[512];
	
	new aData[eData];
	new sWeaponClcmd[64];
	new sWeaponCost[6];
	new sWeaponAmmo[4];
	new iWeaponBpAmmo[4];
	new sWeaponDamage[5];
	new sWeaponAllowRound[3];
	new sWeaponTrace[3];
	new sWeaponMenuAdd[3];
	new sWeaponAccessFlag[10];

	if(!iFile)
	{
		log_amx("[DEBUG]: No file found ^"%s^".", sPath);
		return;
	}

	while(!feof(iFile))
	{
		fgets(iFile, sLine, charsmax(sLine));
		replace(sLine, charsmax(sLine), "^n", "");

		if(IsComment(sLine))
		{
			continue;
		}

		trim(sLine);

		parse(sLine,
			 aData[WEAPON_REFERENCE], charsmax(aData),
			 sWeaponClcmd, charsmax(sWeaponClcmd),
			 aData[MENU_NAME_ITEM], charsmax(aData),
			 sWeaponCost, charsmax(sWeaponCost),
			 sWeaponAmmo, charsmax(sWeaponAmmo),
			 iWeaponBpAmmo, charsmax(iWeaponBpAmmo),
			 sWeaponDamage, charsmax(sWeaponDamage),
			 sWeaponAllowRound, charsmax(sWeaponAllowRound),
			 sWeaponTrace, charsmax(sWeaponTrace),
			 sWeaponMenuAdd, charsmax(sWeaponMenuAdd),
			 sWeaponAccessFlag, charsmax(sWeaponAccessFlag),
			 aData[WEAPON_MODEL_VIEW], charsmax(aData),
			 aData[WEAPON_MODEL_PLAYER], charsmax(aData),
			 aData[WEAPON_MODEL_WORLD], charsmax(aData)
		);

		if(aData[WEAPON_MODEL_VIEW][0])
		{
			if(!file_exists(aData[WEAPON_MODEL_VIEW]))
			{
				set_fail_state("[Error] Model was not found (%s)", aData[WEAPON_MODEL_VIEW]);
			}
			else
			{
				precache_model(aData[WEAPON_MODEL_VIEW]);
			}
		}		

		if(aData[WEAPON_MODEL_PLAYER][0])
		{
			if(!file_exists(aData[WEAPON_MODEL_PLAYER]))
			{
				set_fail_state("[Error] Model was not found (%s)", aData[WEAPON_MODEL_PLAYER]);
			}
			else
			{
				precache_model(aData[WEAPON_MODEL_PLAYER]);
			}
		}

		if(aData[WEAPON_MODEL_WORLD][0])
		{
			if(!file_exists(aData[WEAPON_MODEL_WORLD]))
			{
				set_fail_state("[Error] Model was not found (%s)", aData[WEAPON_MODEL_WORLD]);
			}
			else
			{
				precache_model(aData[WEAPON_MODEL_WORLD]);
			}
		}

		if(sWeaponAccessFlag[0])
		{
			if(sWeaponAccessFlag[0] == '0') // xd
			{
				aData[WEAPON_ACCESS_FLAGS] = 0;
			}
			else
			{
				aData[WEAPON_ACCESS_FLAGS] = read_flags(sWeaponAccessFlag);
			}
		}

		aData[WEAPON_ID] = rg_get_weapon_info(aData[WEAPON_REFERENCE], WI_ID);
		aData[WEAPON_COST] = str_to_num(sWeaponCost);
		aData[WEAPON_AMMO] = str_to_num(sWeaponAmmo);
		aData[WEAPON_BPAMMO] = str_to_num(iWeaponBpAmmo);
		aData[WEAPON_DAMAGE] = str_to_float(sWeaponDamage);
		aData[WEAPON_ALLOW_ROUND] = str_to_num(sWeaponAllowRound);
		aData[WEAPON_TRACE] = str_to_num(sWeaponTrace);
		aData[MENU_WEAPON_ADD] = str_to_num(sWeaponMenuAdd);

		TrieSetCell(g_tWeaponClcmd, sWeaponClcmd, ArrayPushArray(g_aWeaponData, aData));

		g_iClcmdIndex[g_iWeaponsCount] = register_clcmd(sWeaponClcmd, "Command_GiveWeapon_EX");
		g_iWeaponsCount++;
	}

	fclose(iFile);
}

public plugin_end()
{
	ArrayDestroy(g_aWeaponData);
	TrieDestroy(g_tWeaponClcmd);
}

stock bool:rg_get_user_buyzone(const pIndex)
{
    new iSignals[UnifiedSignals];

    get_member(pIndex, m_signals, iSignals);

    return bool:(SignalState:iSignals[US_State] & SIGNAL_BUY);
}

bool: IsCustomWeapon(iItem, iKey)
{
	if(0 <= iKey - IMPULSE_OFFSET < g_iWeaponsCount)
	{
		if(get_entvar(iItem, var_impulse) == iKey)
		{
			return true;
		}
	}

	return false;
}

getPercentNum(iNumber, iPercent)
{
	return floatround(float(iNumber) * (float(iPercent) / 100.0)); // blya
}

enum
{
	APPEND_SLOT = 0,
	REMOVE_SLOT = 1,
	DROP_SLOT = 2
};

dropWeapons(iPlayer, InventorySlotType: iSlot)
{
	if(g_pCvar[GIVE_TYPE] == APPEND_SLOT)
	{
		return;
	}

	static iItem; iItem = get_member(iPlayer, m_rgpPlayerItems, iSlot);
	
	if(is_nullent(iItem))
	{
		return;
	}

	static iNext;

	do
	{
		if(!is_nullent(iItem))
		{
			iNext = get_member(iItem, m_pNext);

			switch(g_pCvar[GIVE_TYPE])
			{
				case REMOVE_SLOT:
				{
					rg_remove_items_by_slot(iPlayer, iSlot);
				}
				
				case DROP_SLOT:
				{
					rg_drop_items_by_slot(iPlayer, iSlot);
				}
			}
		}
	}
	while((iItem = iNext) > 0);
}