#if defined _auw_included
	#endinput
#endif
#define _auw_included

enum _:eData
{
	WEAPON_REFERENCE[32],
	WEAPON_ID,
	InventorySlotType: WEAPON_SLOT,
	MENU_NAME_ITEM[64],
	WEAPON_COST,
	WEAPON_AMMO,
	WEAPON_BPAMMO,
	Float: WEAPON_DAMAGE,
	WEAPON_ALLOW_ROUND,
	WEAPON_TRACE,
	MENU_WEAPON_ADD,
	WEAPON_ACCESS_FLAGS,
	WEAPON_MODEL_VIEW[64],
	WEAPON_MODEL_PLAYER[64],
	WEAPON_MODEL_WORLD[64]
};

/**
* Retrieves UID by weapon name
*
* @param sWeaponName           Weapon Name
*
* @return                      UID otherwise -1
*/
native weapons_get_weapon_uid(const sWeaponName[]);

/**
* Give weapon by weapon name
*
* @param iPlayer			   id
* @param sWeaponName           Weapon Name
*
* @return                      true/false
*/
native weapons_give_weapon(iPlayer, const sWeaponName[]);

/**
* Checks if the weapon is custom
*
* @param iItem		           Weapon Index
* @param iKey		           UID
*
* @return                      true/false
*/
native weapons_valid_weapon(iItem, iKey);

/**
* Writes weapon data to array
*
* @param iKey		           UID
* @param aData	          	   Array Data
*
* @return                      true/false
*/
native weapons_get_weapons_data(iKey, aData[eData]);