// *************************************************************************************
// 	Плагин загружен с www.neugomon.ru
// 	Автор: neugomon [ https://neugomon.ru/members/1/ ]
// 	Официальная тема поддержки: https://neugomon.ru/threads/3291/
// 	При копировании материала ссылка на сайт www.neugomon.ru ОБЯЗАТЕЛЬНА!
// *************************************************************************************

#include <amxmodx>
#include <reapi>

// #define TEST			// Для теста команда в чат /duel. работать будет при любом кол-ве игроков :D Доступ с флагом ADMIN_RCON
#define HITWALL		3 	// Сколько раз надо по стене ударить, чтобы вызвать дуель
#define VOTETODUEL	10 	// Через сколько секунд считать, что противник зассал
#define HEALTHONDUEL	65	// Сколько HP ставить игрокам на время дуели. 0 - будет столько, сколько осталось за время раунда.
#define SETAIMONOPP		// Разворачивать игроков друг к другу лицом
#define ANNOUNCE		// Показывать сообщение, когда остаются игрока 1 х 1

enum _:TEAMS
{
	TT,
	CT
}

new HookChain:HookChain_CBasePlayer_PreThink,
	HookChain:HookChain_SV_StartSound;

new Float:g_fKnifePos[TEAMS][3];
new g_iInsider, g_iOpponent;

new Float:g_fHitWall[33];
new g_iHitWall[33];

const TASK_VOTE_DUEL = 100;
#if AMXX_VERSION_NUM < 183
	#include <colorchat>
	#define client_disconnected client_disconnect
#endif
#if !defined REAPI_VERSION || REAPI_VERSION < 5091
	#error Oh, no... Needed ReAPI >= 5.0.91
#endif

public plugin_init()
{
	register_plugin("Knife Duel with Teleport", "1.2", "neygomon"); // thanks Mistrick for code by Search Spawns
	
	HookChain_SV_StartSound = RegisterHookChain(RH_SV_StartSound, "SV_StartSound_Post", true);
	DisableHookChain((HookChain_CBasePlayer_PreThink = RegisterHookChain(RG_CBasePlayer_PreThink, "CBasePlayer_PreThink_Post", true)));
	RegisterHookChain(RG_CBasePlayer_Killed, "CBasePlayer_Killed_Post", true);
	RegisterHookChain(RG_CSGameRules_CheckMapConditions, "CheckMapConditions_Post", true);	
	FindSpawnsForDuel();
	
	register_menucmd(register_menuid("VoteToDuel"), MENU_KEY_1|MENU_KEY_2, "VoteHandler");
#if defined TEST
	register_clcmd("say /duel", "test");
#endif	
}
#if defined TEST
public test(id)
{
	if(is_user_alive(id) && get_user_flags(id) & ADMIN_RCON)
	{
		new ent, ent2;
		IsValidPlayersNum(ent, ent2);
		
		g_iOpponent = TeamName:get_member(id, m_iTeam) == TEAM_TERRORIST ? ent2 : ent;
		g_iInsider = id;

		DisableHookChain(HookChain_SV_StartSound);
		GoToDuel();
	}
	return 1;
}
#endif	
public client_disconnected(id)
{
	if(id == g_iInsider || id == g_iOpponent)
		DuelDidNotTake();
}

public CheckMapConditions_Post()
{
	if(g_iInsider) 
		DuelDidNotTake();
}

public SV_StartSound_Post(const recipients, const entity, const channel, const sample[], const volume, Float:attenuation, const fFlags, const pitch)
{
	// if(strcmp(sample, "weapons/knife_hitwall1.wav") == 0)
	if(sample[0] == 'w' && sample[7] == '/' && sample[8] == 'k' && sample[13] == '_' && sample[17] == 'w') // вангую говно в error логах
	{
		new Float:fGameTime = get_gametime();
		if(fGameTime - g_fHitWall[entity] > 1.0)
			g_iHitWall[entity] = 0;
		else
		{
			new ent1, ent2;
			if(g_iHitWall[entity] == HITWALL - 1 && IsValidPlayersNum(ent1, ent2) && !g_iOpponent)
			{
				VoteToTheDuel(entity, TeamName:get_member(entity, m_iTeam) == TEAM_TERRORIST ? ent2 : ent1);
				DisableHookChain(HookChain_SV_StartSound);
			}
		}
		g_iHitWall[entity]++;
		g_fHitWall[entity] = fGameTime;	
	}
}

public CBasePlayer_PreThink_Post(id)
{
	if(g_iInsider == id || g_iOpponent == id)
	{
		if(is_user_alive(id))
		{
			if(get_member(get_member(id, m_pActiveItem), m_iId) != WEAPON_KNIFE)
				engclient_cmd(id, "weapon_knife");
		}
	}
}

public CBasePlayer_Killed_Post(const victim, const killer)
{
	if(g_iInsider)
	{
		if(task_exists(TASK_VOTE_DUEL))
			DuelDidNotTake();
		else if(g_iOpponent)
		{
			if(victim == g_iInsider || victim == g_iOpponent)
				DuelDidNotTake();
		}
		return;
	}	
#if defined ANNOUNCE
	new ent1, ent2;
	if(IsValidPlayersNum(ent1, ent2))
	{
		client_print_color(
			ent1, 
			print_team_default,
			"^1[^4Knife Duel^1] ^4Вы остались^3 1 x 1^4! Хотите knife дуель? Чиркните ^3%d раза ^4по стене.", 
				HITWALL
		);
		client_print_color(
			ent2, 
			print_team_default,
			"^1[^4Knife Duel^1] ^4Вы остались^3 1 x 1^4! Хотите knife дуель? Чиркните ^3%d раза ^4по стене.", 
				HITWALL
		);
	}
#endif
}

VoteToTheDuel(id, opponent)
{
	new nameId[32], nameOpp[32], sMenu[200];
	get_user_name(id, nameId, charsmax(nameId));
	get_user_name(opponent, nameOpp, charsmax(nameOpp));
	
	formatex(
		sMenu, charsmax(sMenu), 
		"\r%s\y, Вас вызвал на дуэль \r%s^n\wВы согласны?^n^n\r1. \wДа. Сделаю фарш.^n\r2. \wНет. Я очкую", 
			nameOpp, nameId
	);
	
	show_menu(opponent, MENU_KEY_1|MENU_KEY_2, sMenu, VOTETODUEL, "VoteToDuel");
	set_task(float(VOTETODUEL), "DuelDidNotTake", TASK_VOTE_DUEL);
	
	g_iInsider = id;
	return PLUGIN_HANDLED;
}

public VoteHandler(id, key)
{
	switch(key)
	{
		case 0:
		{
			g_iOpponent = id;
			remove_task(TASK_VOTE_DUEL);
			GoToDuel();
		}
		case 1:
		{
			new name[32]; 
			get_user_name(id, name, charsmax(name));
			client_print_color(
				g_iInsider, 
				print_team_default, 
				"^1[^4Knife Duel^1] ^4Игрок ^3%s ^4ссыканул и отказался от дуэли :\", 
					name
			);
			DuelDidNotTake();
		}
	}
	return PLUGIN_HANDLED;
}

public DuelDidNotTake()
{
	DisableHookChain(HookChain_CBasePlayer_PreThink);
	EnableHookChain(HookChain_SV_StartSound);
	remove_task(TASK_VOTE_DUEL);
	
	g_iInsider = 0;
	g_iOpponent = 0;
}

// Idea by Mistrick
// Thanks ^_^
FindSpawnsForDuel()
{
	new ent = rg_find_ent_by_class(-1, "info_player_start");
	get_entvar(ent, var_origin, g_fKnifePos[TT]);
	
	new ent2 = ent, bool:bFindPlace;
	new Float:distance = 1000.0;
	
	while(distance > 100.0 && !bFindPlace)
	{
		while((ent2 = rg_find_ent_by_class(ent2, "info_player_start")))
		{
			get_entvar(ent2, var_origin, g_fKnifePos[CT]);
			if(get_distance_f(g_fKnifePos[TT], g_fKnifePos[CT]) > distance)
			{
				bFindPlace = true;
				break;
			}
		}
		distance -= 100.0;
		ent2 = ent;
	}
	if(!bFindPlace)
		set_fail_state("spawns for duel not found :( govnomap...");
}

GoToDuel()
{
	if(is_user_alive(g_iInsider) && is_user_alive(g_iOpponent))
	{	
		set_entvar(g_iInsider, var_origin, g_fKnifePos[0]);
		set_entvar(g_iOpponent, var_origin, g_fKnifePos[1]);
	#if defined SETAIMONOPP	
		entity_set_aim(g_iInsider, g_iOpponent);
		entity_set_aim(g_iOpponent, g_iInsider);
	#endif	
	#if HEALTHONDUEL > 0
		set_entvar(g_iInsider, var_health, float(HEALTHONDUEL));
		set_entvar(g_iOpponent, var_health, float(HEALTHONDUEL));
	#endif
		EnableHookChain(HookChain_CBasePlayer_PreThink);
		
		set_hudmessage(255, 100, 0, -1.0, 0.3, 0, 6.0, 1.0, 0.1, 0.5, -1);
		show_hudmessage(0, "Дуэль началась! Приятного зрелища ;)");
	}
}

stock IsValidPlayersNum(&idT = 0, &idCT = 0)
{
	new pl[32], tt, ct;
	get_players(pl, tt, "ae", "TERRORIST"); 
	idT = pl[0];
	get_players(pl, ct, "ae", "CT"); 
	idCT = pl[0];
	return (tt == 1 && ct == 1);
}
	
stock entity_set_aim(id, ent)
{
	new Float:vOrigin[3], Float:vEntOrigin[3]; 
	get_entvar(id, var_origin, vOrigin);
	get_entvar(ent, var_origin, vEntOrigin);
	
	vOrigin[0] -= vEntOrigin[0];
	vOrigin[1] -= vEntOrigin[1];
	vOrigin[2] -= vEntOrigin[2];
	
	new Float:vNewAngles[3], Float:vAimVector[3], Float:v_length;
	v_length = vector_length(vOrigin);

	vAimVector[0] = vOrigin[0] / v_length;
	vAimVector[1] = vOrigin[1] / v_length;
	vAimVector[2] = vOrigin[2] / v_length;
	
	vector_to_angle(vAimVector, vNewAngles);
	
	vNewAngles[0] *= -1;
	vNewAngles[1] += 180;
	
	set_entvar(id, var_angles, vNewAngles);
	set_entvar(id, var_fixangle, 1);
}