#include <amxmodx>
#include <fakemeta>
#include <hamsandwich>

#define ACCESS_IMMUNITY ADMIN_RCON	// Иммунитет для админов при балансе (Админы игнорируются любым балансом(по числу/по скиллу))
#define SCORE_DIFF	2		// Разница в счете между командами (Вкл. аланс по скиллу, если одна команда перееигрывает другую на n раундов)
#define PLAYER_DIFF	1		// Разница в кол-ве игроков в командах (При входе на сервер, чтоб равномерно заполнять команды)
#define MIN_PLAYERS	10		// Минимальное кол-во игроков на сервере для баланса по силам ()
#define ROUND_BSKILL	3		// Каждые n раундов баланс по скиллу (Ну а че, нахер каждый раунд по скиллу то уравнивать?)	
#define PL_IGNORE_NUM	3		// Каждые n перемещений в командах для одного игрока (баланс по кол-ву игроков) (Чтобы не кидало одного и того же)
#define PL_IGNORE_SKILL	3		// Каждые n замен по скиллу игрока может перемещать  (Чтобы не кидало одного и того же)
// #define NO_ROUND			// Поддержка бесконечного раунда. Для CSDM, GG и тд.

const VGUIMenu 	= 114;	// Не трогать!
const OLDMenu 	= 96;	// Не трогать!
#define fm_get_user_team(%0) get_pdata_int(%0, 114, 5)

#if !defined NO_ROUND
new g_iRoundCount;
new g_iScoreTt, g_iScoreCt;
#endif
new g_iNumTt, g_iNumCt;
new bool:g_bChangeTeam[33];
new g_iSkipNPl[33], g_iSkipSPl[33];

public plugin_init()
{
	#define VERSION "1.20"
	register_plugin("Lite TeamBalancer", VERSION, "neygomon");
	register_cvar("lite_teambalancer", VERSION, FCVAR_SERVER | FCVAR_SPONLY);
	
	register_clcmd("chooseteam", "ShowMenu");
	register_menucmd(register_menuid("Team Menu"), MENU_KEY_1|MENU_KEY_2|MENU_KEY_6|MENU_KEY_0, "TeamMenuHandler");
	register_message(OLDMenu, "mShowMenu");
	register_message(VGUIMenu, "mShowMenu");

	RegisterHam(Ham_Spawn, "player", "fwdPlayerSpawnPre", false);
#if defined NO_ROUND
	register_event("DeathMsg", "LeRoundEnd", "a", "1>0");
#else
	register_event("TeamScore", "eTeamScore", "a");
	register_event("HLTV", "eRoundStart", "a", "1=0", "2=0");
	register_logevent("LeRoundEnd", 2, "1=Round_End");	
	register_logevent("LeRestartRound", 2, "1&Restart_Round_");
#endif	
	set_task(1.5, "ChangeMPcvars");
}

public ChangeMPcvars()
{
	set_cvar_num("mp_autoteambalance", 0);
	set_cvar_num("mp_limitteams", 0);
}

public client_disconnected(id)
{
	g_bChangeTeam[id] = false;
	g_iSkipSPl[id] = 0;
	g_iSkipNPl[id] = 0;
}
#if !defined NO_ROUND
public eTeamScore()
{
	static szTeam[2]; read_data(1, szTeam, charsmax(szTeam));
	
	switch(szTeam[0])
	{
		case 'T': g_iScoreTt = read_data(2);
		case 'C': g_iScoreCt = read_data(2);
	}
}

public LeRestartRound()
{
	g_iRoundCount = 0;
	LeRoundEnd();
}

public eRoundStart()
	g_iRoundCount++;
#endif
public LeRoundEnd()
{
	static players[32], pnum, iTransferNum, i;
	
	GetUsersInTeam(g_iNumTt, g_iNumCt);

	if((iTransferNum = abs(g_iNumTt - g_iNumCt) / 2) >= 1)
	{
		static szName[32], TtCt; TtCt = (g_iNumTt > g_iNumCt);
		get_players(players, pnum, "e", TtCt ? "TERRORIST" : "CT");

		for(i = 0; i < pnum; i++)
		{
			if(!g_iSkipNPl[players[i]]-- && ~get_user_flags(players[i]) & ACCESS_IMMUNITY)
			{
				get_user_name(players[i], szName, charsmax(szName));
				ChatColor(0, "^1[^4Lite TeamBalancer^1] ^3%s ^4был перенеcён за команду ^3%s^4.", szName, TtCt ? "контр-террористов" : "террористов");
				g_bChangeTeam[players[i]] = true;
				g_iSkipNPl[players[i]] = PL_IGNORE_NUM;			
				if(--iTransferNum < 1) break;
			}	
		}
	}
#if !defined NO_ROUND	
	if(g_iRoundCount % ROUND_BSKILL || get_playersnum() < MIN_PLAYERS || abs(g_iScoreTt - g_iScoreCt) < SCORE_DIFF)
		return;	

	new Ent1, Ent2, iCurr, iCache[2];
	new Pr = (g_iScoreTt > g_iScoreCt);
	
	get_players(players, pnum);
	for(i = 0; i < pnum; i++)
	{
		if(g_iSkipSPl[players[i]]-- || get_user_flags(players[i]) & ACCESS_IMMUNITY) continue;
		
		switch(fm_get_user_team(players[i]))
		{
			case 1:
			{	
				iCurr = get_user_frags(players[i]) - get_user_deaths(players[i]);
				if((Pr && iCurr > iCache[0]) || (!Pr && iCurr < iCache[0]))
				{					
					Ent1 = players[i];
					iCache[0] = iCurr;
				}	
			}
			case 2:
			{			
				iCurr = get_user_frags(players[i]) - get_user_deaths(players[i]);
				if((Pr && iCurr < iCache[1]) || (!Pr && iCurr > iCache[1]))
				{					
					Ent2 = players[i];
					iCache[1] = iCurr;
				}	
			}
		}
	}	
	if(!Ent1 || !Ent2) return;
	static szName1[32], szName2[32];
	get_user_name(Pr ? Ent1 : Ent2, szName1, charsmax(szName1));
	get_user_name(Pr ? Ent2 : Ent1, szName2, charsmax(szName2));
	ChatColor(0, "^1[^4Lite TeamBalancer^1] ^4Сильный ^3%s ^4был замен на слабого ^3%s^4.", szName1, szName2);
	g_bChangeTeam[Ent1] = g_bChangeTeam[Ent2] = true;
	g_iSkipSPl[Ent1] = g_iSkipSPl[Ent2] = PL_IGNORE_SKILL;	
#endif	
}

public mShowMenu(const msg, const nDest, const nClient)
{
	if(msg == OLDMenu)
	{
		static szArg4[20]; get_msg_arg_string(4, szArg4, charsmax(szArg4));
		if(contain(szArg4, "Team_Select") == -1)
			return PLUGIN_CONTINUE;
	}
	else if(get_msg_arg_int(1) != 2)
		return PLUGIN_CONTINUE;
	
	set_pdata_int(nClient, 205, 0);
	ShowMenu(nClient);
	return PLUGIN_HANDLED;
}

public ShowMenu(id)
{
	new szMenu[256], iKeys = MENU_KEY_0;
	
	GetUsersInTeam(g_iNumTt, g_iNumCt);
	
	add(szMenu, charsmax(szMenu), "\yВыбор команды:^n^n");
	
	if((g_iNumTt - g_iNumCt) >= PLAYER_DIFF)
		add(szMenu, charsmax(szMenu), "\y1. \dТеррористы^n");
	else
	{
		add(szMenu, charsmax(szMenu), "\y1. \wТеррористы^n");
		iKeys |= MENU_KEY_1;
	}
	if((g_iNumCt - g_iNumTt) >= PLAYER_DIFF)
		add(szMenu, charsmax(szMenu), "\y2. \dКонтр-террористы^n^n");
	else
	{
		add(szMenu, charsmax(szMenu), "\y2. \wКонтр-террористы^n^n");
		iKeys |= MENU_KEY_2;
	}
	if(fm_get_user_team(id) == 3)
		add(szMenu, charsmax(szMenu), "\y6. \dНаблюдение^n^n^n");
	else
	{
		add(szMenu, charsmax(szMenu), "\y6. \wНаблюдение^n^n^n");
		iKeys |= MENU_KEY_6;
	}
	add(szMenu, charsmax(szMenu), "\y0. \wВыход");
	return show_menu(id, iKeys, szMenu, -1, "Team Menu");
}

public TeamMenuHandler(id, iKey)
{
	switch(iKey)
	{
		case 0:
		{
			set_pdata_int(id, 125, get_pdata_int(id, 125) & ~(1<<8));
			engclient_cmd(id, "jointeam", "1");
		}
		case 1:
		{
			set_pdata_int(id, 125, get_pdata_int(id, 125) & ~(1<<8));
			engclient_cmd(id, "jointeam", "2");
		}
		case 5:
		{
			user_kill(id, 1);
			engclient_cmd(id, "jointeam", "6");
		}
	}
	return PLUGIN_HANDLED;
}

public fwdPlayerSpawnPre(id)
{
	if(!g_bChangeTeam[id]) return;
	
	switch(fm_get_user_team(id))
	{
		case 1: fm_set_user_team(id, 2);
		case 2: fm_set_user_team(id, 1);
	}
	g_bChangeTeam[id] = false;
}

stock ChatColor(const id, const szMessage[], any:...)
{
	static pnum, players[32], szMsg[190], IdMsg; 
	vformat(szMsg, charsmax(szMsg), szMessage, 3);
	
	if(!IdMsg) IdMsg = get_user_msgid("SayText");
	
	if(id) 
	{ 
		players[0] = id;
		pnum = 1; 
	} 
	else get_players(players, pnum, "ch");
	
	for(new i; i < pnum; i++)
	{
		message_begin(MSG_ONE, IdMsg, .player = players[i]);
		write_byte(players[i]);
		write_string(szMsg);
		message_end();
	}
}

stock GetUsersInTeam(&tt, &ct)
{
	static players[32]; 
	get_players(players, tt, "e", "TERRORIST");
	get_players(players, ct, "e", "CT");
}

stock fm_set_user_team(id, team)
{
	set_pdata_int(id, 114, team, 5);
	dllfunc(DLLFunc_ClientUserInfoChanged, id, engfunc(EngFunc_GetInfoKeyBuffer, id))
	
	static mTeamInfo; 
	if(!mTeamInfo)
		mTeamInfo = get_user_msgid("TeamInfo");

	message_begin(MSG_ALL, mTeamInfo)
	write_byte(id);
	write_string(team == 1 ? "TERRORIST" : "CT");
	message_end();
}