///////////////////////////////////////////
//// Файл скачан с https://my-amxx.ru/ ////
///////////////////////////////////////////

#include <amxmodx>
#include <reapi>
#if AMXX_VERSION_NUM < 183
	#include <colorchat>
#endif

#define VIP_ACCESS_FLAG 	ADMIN_LEVEL_H 	// Флаг доступа к VIP функциям
#define ALLOWED_ROUND 		1 		// С какого раунда выдавать аммуницию при спавне
#define MAX_NUM_ON_ROUND 	2 		// Сколько раз за раунд можно брать оружия из меню
#define TIME_ACTIVE_MENU	15		// Количество секунд, в течение которых будет доступно меню в начале раунда
#define ROUND_FAMAS_GALIL	2		// С какого раунда можно взять Famas и Galil
#define ROUND_AK47_M4A1		3		// С какого раунда можно взять AK47 и M4A1
#define ROUND_AWP		4		// С какого раунда можно взять AWP
//#define ADMIN_LOADER				// Поддержка admin loader by neygomon для вывода окончания привилегии
#define VIP_TAG_TAB				// VIP тег в ScoreBoard
#define SELECT_PISTOLS				// Добавить пункт в VipMenu с выбором пистолета (deagle, usp, glock). Если закомментировано - выдаваться будет всегда deagle

new g_szMapPrefixes[][] = // Список префиксов карт, где плагин будет выключаться
{
	"as_",
	"awp_",
	"cs_",
	"aim_",
	"$"
}

#define is_user_vip(%0) (get_user_flags(%0) & VIP_ACCESS_FLAG)
#if !defined MAX_PLAYERS
	const MAX_PLAYERS = 32;
#endif

#if defined SELECT_PISTOLS
enum Pistols 
{
	DEAGLE = 1,
	USP,
	GLOCK
};
#endif
new g_iRoundCount, 
	g_iRoundStartTime;
new HookChain:g_hookSpawn;
new g_iCountUse[MAX_PLAYERS + 1];
#if defined SELECT_PISTOLS
new Pistols:g_iSelectedPistol[MAX_PLAYERS + 1],
	bool:g_bGivenByMenuPistol[MAX_PLAYERS + 1];
#endif
new g_iMenuIndex;
#if defined ADMIN_LOADER
	native admin_expired(index);
#endif
public plugin_init()
{
	register_plugin("Lite VIP System", "1.5", "neygomon");
	
	new map[32];
	get_mapname(map, charsmax(map));
	for(new i; i < sizeof g_szMapPrefixes; ++i)
	{
		if(containi(map, g_szMapPrefixes[i]) != -1)
		{
			log_amx("Played map '%s'. Plugin stopped by mapPrefix '%s'!", map, g_szMapPrefixes[i]);
			pause("d");
			return;
		}
	}
	
	RegisterHookChain(RG_CSGameRules_RestartRound, 	"CSGameRules_RestartRound_Pre", false);
	DisableHookChain((g_hookSpawn = RegisterHookChain(RG_CBasePlayer_Spawn, "CBasePlayer_Spawn_Post", true)));
	
	register_clcmd("vipmenu", "ClcmdVipMenu");
	register_clcmd("say vipmenu", "ClcmdVipMenu");
	register_clcmd("say /vipmenu", "ClcmdVipMenu");
	
	if(file_exists("adminka.txt"))
		register_clcmd("say /adminka", "ClcmdSayAdminka");
	if(file_exists("vipka.txt"))
		register_clcmd("say /vipka", "ClcmdSayVipka");
	
	g_iMenuIndex = register_menuid("Vip Menu");
#if defined SELECT_PISTOLS
	register_menucmd(g_iMenuIndex, MENU_KEY_0|MENU_KEY_1|MENU_KEY_2|MENU_KEY_3|MENU_KEY_4|MENU_KEY_5|MENU_KEY_6, "VipMenu_Handler");
#else
	register_menucmd(g_iMenuIndex, MENU_KEY_0|MENU_KEY_1|MENU_KEY_2|MENU_KEY_3|MENU_KEY_4|MENU_KEY_5, "VipMenu_Handler");
#endif
#if defined VIP_TAG_TAB
	if(!get_member_game(m_bMapHasVIPSafetyZone))
		register_message(get_user_msgid("ScoreAttrib"), "msgScoreAttrib");
#endif
}

public client_putinserver(id)
{
	g_iCountUse[id] = MAX_NUM_ON_ROUND;
#if defined SELECT_PISTOLS
	g_iSelectedPistol[id] = DEAGLE;
#endif
}

public CSGameRules_RestartRound_Pre()
{
	if(get_member_game(m_bCompleteReset))
	{
		g_iRoundCount = 0;
		DisableHookChain(g_hookSpawn);
	}
	if(++g_iRoundCount >= ALLOWED_ROUND)
		EnableHookChain(g_hookSpawn);
		
	arrayset(g_iCountUse, MAX_NUM_ON_ROUND, sizeof g_iCountUse);
	g_iRoundStartTime = get_systime();
	UTIL_DisableVipMenu();
}

public CBasePlayer_Spawn_Post(const id)
{
	if(!is_user_connected(id))
		return;
	if(!is_user_vip(id))
		return;
		
	UTIL_give_item(id, "weapon_hegrenade",  GT_APPEND, 0);
	UTIL_give_item(id, "weapon_flashbang",  GT_APPEND, 2);
	UTIL_give_item(id, "weapon_smokegrenade", GT_APPEND, 0);
#if defined SELECT_PISTOLS
	g_bGivenByMenuPistol[id] = false;
	UTIL_give_pistol(id);
#else
	UTIL_give_item(id, "weapon_deagle", GT_REPLACE, 35);
#endif
	rg_set_user_armor(id, 100, ARMOR_VESTHELM);
	if(get_member(id, m_iTeam) == TEAM_CT)
		rg_give_defusekit(id);
}

public ClcmdVipMenu(id)
{
	if(!is_user_vip(id))
	{
		client_print_color(id, print_team_default, "^1[^4VIP^1] Только ^4VIP-игрок ^1может пользоваться этой командой!");
		return PLUGIN_HANDLED;
	}
	if(!is_user_alive(id))
	{
		client_print_color(id, print_team_default, "^1[^4VIP^1] Для использования данной команды вы должны быть ^4живы^1!");
		return PLUGIN_HANDLED;
	}
	if(get_systime() - g_iRoundStartTime > TIME_ACTIVE_MENU)
	{
		client_print_color(id, print_team_default, "^1[^4VIP^1] Данная команда доступна только в течение ^4%d сек^1 с начала раунда!", TIME_ACTIVE_MENU);
		return PLUGIN_HANDLED;
	}
	if(!g_iCountUse[id])
	{
		client_print_color(id, print_team_default, "^1[^4VIP^1] Вы уже брали ^4%d ^1оружия из меню в этом раунде!", MAX_NUM_ON_ROUND);
		return PLUGIN_HANDLED;
	}
	
	new iLen, szMenu[512], iKey = MENU_KEY_0;
#if defined ADMIN_LOADER	
	new exp = admin_expired(id);
	if(exp > 0)
	{
		exp -= get_systime();
		if(exp > 0)
		{
			new days = exp / 86400;
			if(days)
				iLen = formatex(szMenu, charsmax(szMenu), "\d[\rVIP Menu\d] \wВыбери себе пушку :)^nОсталось %d дн^n^n", days);
			else	iLen = formatex(szMenu, charsmax(szMenu), "\d[\rVIP Menu\d] \wВыбери себе пушку :)^nПоследний день^n^n");
		}
		else
		{
			client_print_color(id, print_team_default, "^1[^4VIP^1] Действие VIP привилегий истекло!");
			return PLUGIN_HANDLED;
		}
	}
	else	iLen = formatex(szMenu, charsmax(szMenu), "\d[\rVIP Menu\d] \wВыбери себе пушку :)^n^n");
#else
	iLen = formatex(szMenu, charsmax(szMenu), "\d[\rVIP Menu\d] \wВыбери себе пушку :)^n^n");
#endif
	if(g_iRoundCount < ROUND_FAMAS_GALIL)
	{
		iLen += formatex(szMenu[iLen], charsmax(szMenu) - iLen, 
			"\y1. \dВзять \rGalil \d[\wс %d раунда\d]^n\y2. \dВзять \rFamas \d[\wс %d раунда\d]^n", 
				ROUND_FAMAS_GALIL, 
				ROUND_FAMAS_GALIL
		);
	}
	else
	{
		iKey |= MENU_KEY_1|MENU_KEY_2;
		iLen += formatex(szMenu[iLen], charsmax(szMenu) - iLen, "\y1. \wВзять \rGalil^n\y2. \wВзять \rFamas^n");
	}
	
	if(g_iRoundCount < ROUND_AK47_M4A1)
	{
		iLen += formatex(szMenu[iLen], charsmax(szMenu) - iLen, 
			"\y3. \dВзять \rAK47 \d[\wс %d раунда\d]^n\y4. \dВзять \rM4A1 \d[\wс %d раунда\d]^n", 
				ROUND_AK47_M4A1, 
				ROUND_AK47_M4A1
		);
	}
	else
	{
		iKey |= MENU_KEY_3|MENU_KEY_4;
		iLen += formatex(szMenu[iLen], charsmax(szMenu) - iLen, "\y3. \wВзять \rAK47^n\y4. \wВзять \rM4A1^n");
	}
	
	if(g_iRoundCount < ROUND_AWP) 
		iLen += formatex(szMenu[iLen], charsmax(szMenu) - iLen, "\y5. \dВзять \rAWP \d[\wс %d раунда\d]^n", ROUND_AWP);
	else
	{
		iKey |= MENU_KEY_5;
		iLen += formatex(szMenu[iLen], charsmax(szMenu) - iLen, "\y5. \wВзять AWP^n");
	}
#if defined SELECT_PISTOLS	
	iKey |= MENU_KEY_6
	
	switch(g_iSelectedPistol[id])
	{
		case DEAGLE: 	iLen += formatex(szMenu[iLen], charsmax(szMenu) - iLen, "\y6. \yПистолет \d[\wDeagle\d]^n^n");
		case USP: 	iLen += formatex(szMenu[iLen], charsmax(szMenu) - iLen, "\y6. \yПистолет \d[\wUSP\d]^n^n");
		case GLOCK: 	iLen += formatex(szMenu[iLen], charsmax(szMenu) - iLen, "\y6. \yПистолет \d[\wGlock18\d]^n^n");
	}
	
	formatex(szMenu[iLen], charsmax(szMenu) - iLen, "\y0. \wВыход");
#else	
	formatex(szMenu[iLen], charsmax(szMenu) - iLen, "^n\y0. \wВыход");
#endif	
	show_menu(id, iKey, szMenu, -1, "Vip Menu");
	return PLUGIN_HANDLED;
}

public ClcmdSayAdminka(id)
	show_motd(id, "adminka.txt", "Admin Privileges");
	
public ClcmdSayVipka(id)
	show_motd(id, "vipka.txt", "VIP Privileges");

public VipMenu_Handler(id, iKey)
{
	static const szChoosedBP[]   = { 90, 90, 90, 90, 30 };
	static const szChoosedWP[][] = { "weapon_galil", "weapon_famas", "weapon_ak47", "weapon_m4a1", "weapon_awp" };	

	if(sizeof szChoosedBP > iKey)
	{
		UTIL_give_item(id, szChoosedWP[iKey], GT_REPLACE, szChoosedBP[iKey]);
		
		g_iCountUse[id]--;
	}
#if defined SELECT_PISTOLS
	else if(iKey == sizeof szChoosedBP)
	{
		switch(g_iSelectedPistol[id])
		{
			case DEAGLE: 	g_iSelectedPistol[id] = USP;
			case USP: 	g_iSelectedPistol[id] = GLOCK;
			case GLOCK: 	g_iSelectedPistol[id] = DEAGLE;
		}
		
		if(!g_bGivenByMenuPistol[id])
		{
			UTIL_give_pistol(id);
			g_bGivenByMenuPistol[id] = true;
		}
		
		ClcmdVipMenu(id);
	}
#endif	
	return PLUGIN_HANDLED;
}
#if defined VIP_TAG_TAB
	public msgScoreAttrib()
	{
		if(is_user_vip(get_msg_arg_int(1)) && !get_msg_arg_int(2))
			set_msg_arg_int(2, ARG_BYTE, (1<<2));
	}
#endif
UTIL_DisableVipMenu()
{
	new players[MAX_PLAYERS], pnum;
	get_players(players, pnum);
	for(new i, menu, keys; i < pnum; ++i)
	{
		if(get_user_menu(players[i], menu, keys))
		{
			if(menu == g_iMenuIndex)
				show_menu(players[i], 0, "", 0);
		}
	}
}

UTIL_give_item(id, weapon[], GiveType:GtState, ammount)
{
	rg_give_item(id, weapon, GtState);
	if(ammount)
		rg_set_user_bpammo(id, rg_get_weapon_info(weapon, WI_ID), ammount);
}
#if defined SELECT_PISTOLS
	UTIL_give_pistol(id)
	{
		switch(g_iSelectedPistol[id])
		{
			case DEAGLE: 	UTIL_give_item(id, "weapon_deagle", GT_REPLACE, 35);
			case USP: 	UTIL_give_item(id, "weapon_usp", GT_REPLACE, 100);
			case GLOCK: 	UTIL_give_item(id, "weapon_glock18", GT_REPLACE, 120);
		}
	}
#endif