/*
	neygomon created ^_^ | http://www.neugomon.ru
	
	No Players Map - для пустых серверов =) Меняет карту на заданную
	Особенности:
		* Вызывает голосование если на сервере игроков меньше чем указано
		* Если сервер пустой, то карта меняется на указанную
		* Если карта в плагине и текущая карта на сервере совпадают - плагин отключается
		* Карту меняет в начале раунда, аля Last Round
		* Сообщения в чат о результатах голосования

	Credits: 
		* death_error. За идею
	
	Information: 
		* Скальпель, соси болт причмокивая :)
*/


#include <amxmodx>

#if AMXX_VERSION_NUM < 183
	#define engine_changelevel(%0) server_cmd("changelevel %s", %0)
#endif

#define MIN_PLAYERS	5		// Минимум игроков, после которых начинают считаться проверки
#define NUM_CHECKS	3		// Число проверок пустого сервера или с малым кол-вом игроков. Далее запуск голосования.
#define VOTETIME	20		// Время голосования
#define MAP		"cs_mansion32"	// Карта, на которую менять
#define NO_ROUND			// Поддержка бесконечного раунда

new iSelectKey[2];
#if !defined NO_ROUND
new bool:g_bChangeMap;
new bool:g_bFirstRound = true;
#endif
public plugin_init()
{
#define PLUGIN 	"No Players Map"
#define VERSION "1.03"
	register_plugin(PLUGIN, VERSION, "neygomon");

	new map[32]; get_mapname(map, charsmax(map));
	if(!strcmp(map, MAP))
	{
		log_amx("Plugin %s[%s] stopped! Curr map %s contains in plugin %s", PLUGIN, VERSION, map, MAP);
		pause("ad");
		return;
	}
#if defined NO_ROUND
	set_task(60.0, "eRoundStart", .flags="b");
#else	
	register_event("HLTV", "eRoundStart", "a", "1=0", "2=0");
	register_logevent("LeRestartRound", 2, "1&Restart_Round_");
#endif
	register_menucmd(register_menuid(PLUGIN), MENU_KEY_1|MENU_KEY_2, "NPMHandler");	
}
#if !defined NO_ROUND
public LeRestartRound()
	g_bFirstRound = true;
#endif
public eRoundStart()
{
	static players[32], iCheck, iCheck2, pl; 
#if !defined NO_ROUND
	if(g_bChangeMap)
	{
		engine_changelevel(MAP);
		return PLUGIN_CONTINUE;
	}
	if(g_bFirstRound)
	{
		iCheck = iCheck2 = 0;
		g_bFirstRound = false;
	}
#endif	
	get_players(players, pl, "ch");
	if(!pl)
	{
		if(++iCheck >= NUM_CHECKS)
			engine_changelevel(MAP);
	}
	else if(pl < MIN_PLAYERS)
	{
		if(++iCheck2 >= NUM_CHECKS)
		{
			new szMenu[256], iLen, iKeys = MENU_KEY_1|MENU_KEY_2;
			iLen = formatex(szMenu, charsmax(szMenu), "\d[\r%s\d] \yНа сервере мало игроков \d[\r%d чел\d]^n\wСменить карту на \r%s\w?^n^n", PLUGIN, pl, MAP);
			iLen += formatex(szMenu[iLen], charsmax(szMenu) - iLen, "\r1. \wДа^n");
			iLen += formatex(szMenu[iLen], charsmax(szMenu) - iLen, "\r2. \wНет^n");
			
			set_task(float(VOTETIME), "CheckResult");
			return show_menu(0, iKeys, szMenu, VOTETIME, PLUGIN);
		}
	}
	return PLUGIN_CONTINUE;
}

public NPMHandler(id, iKey)
{
	switch(iKey)
	{
		case 0: iSelectKey[0]++;
		case 1: iSelectKey[1]++;
	}
	return PLUGIN_HANDLED;
}

public CheckResult()
{
	if((iSelectKey[0] > iSelectKey[1]) || (!iSelectKey[0] && !iSelectKey[1]))
	{
		ChatColor("^1[^4%s^1] ^4Голосование состоялось! Следующая карта ^3%s", PLUGIN, MAP);
#if defined NO_ROUND
		engine_changelevel(MAP);
#else		
		g_bChangeMap = true;
#endif		
		return;
	}
	ChatColor("^1[^4%s^1] ^4Голосование ^3не ^4состоялось! В след. раунде спрошу еще раз :D", PLUGIN);
	arrayset(iSelectKey, 0, sizeof iSelectKey);
}

stock ChatColor(const szMessage[], any:...)
{
	static pnum, players[32], szMsg[190], IdMsg; 
	vformat(szMsg, charsmax(szMsg), szMessage, 2);
	
	if(!IdMsg) IdMsg = get_user_msgid("SayText");
	
	get_players(players, pnum, "ch");
	
	for(new i; i < pnum; i++)
	{
		message_begin(MSG_ONE, IdMsg, .player = players[i]);
		write_byte(players[i]);
		write_string(szMsg);
		message_end();
	}
}