// Copyright  2016 Vaqtincha
/******************************************************************
*	Credits: to
*
*	- ConnorMcLeod for plugin "Weapon Models"
*
*******************************************************************/

#define VERSION "0.0.1"

#define MAX_MODEL_LENGTH 	64
#define MAX_PATH_LENGTH 	128
#define MAX_PLAYERS			32
#define MAX_PARAMETERS		4

#include <amxmodx>
#include <fakemeta>
#include <hamsandwich>

#define AllocString(%1) 		engfunc(EngFunc_AllocString,%1)
#define SetModel(%1,%2) 		engfunc(EngFunc_SetModel,%1,%2)
#define IsPlayer(%1)			(1 <= %1 <= g_iMaxPlayers)

new Trie:g_tViewModels
new Trie:g_tWeaponModels
new Trie:g_tWorldModels
new g_iAccess, g_iMaxPlayers

public plugin_precache()
{
	new szConfigFile[MAX_PATH_LENGTH], szMsg[128]
	get_localinfo("amxx_configsdir", szConfigFile, charsmax(szConfigFile))
	add(szConfigFile, charsmax(szConfigFile), "/weapons_skins.ini")

	if(!file_exists(szConfigFile))
	{
		formatex(szMsg, charsmax(szMsg), "[ERROR] Config file ^"%s^" not found!", szConfigFile)
		set_fail_state(szMsg)
		return
	}
	new iFilePointer = fopen(szConfigFile, "rt")
	if(!iFilePointer)
	{
		return
	}

	new Trie:tRegisterWeaponDeploy = TrieCreate()
	new szDatas[192], szSetting[12], szSymb[3], szFlags[32]
	new szWeaponClass[32]
	new szViewModel[MAX_MODEL_LENGTH], szWeaponModel[MAX_MODEL_LENGTH], szWorldModel[MAX_MODEL_LENGTH]
	new szOldWorldModel[MAX_MODEL_LENGTH]

	while(!feof(iFilePointer))
	{
		fgets(iFilePointer, szDatas, charsmax(szDatas))
		trim(szDatas)
		if(!szDatas[0] || szDatas[0] == ';' || szDatas[0] == '#')
		{
			continue
		}
		if(equal(szDatas, "AccessFlag", 10))
		{
			parse(szDatas, szSetting, charsmax(szSetting), szSymb, charsmax(szSymb), szFlags, charsmax(szFlags))
			g_iAccess = read_flags(szFlags)
			continue
		}
		if(parse(szDatas, szWeaponClass, charsmax(szWeaponClass), 
		szViewModel, charsmax(szViewModel), szWeaponModel, charsmax(szWeaponModel),
		szWorldModel, charsmax(szWorldModel)) == MAX_PARAMETERS)
		{
			if(!TrieKeyExists(tRegisterWeaponDeploy, szWeaponClass))
			{
				TrieSetCell
				(
					tRegisterWeaponDeploy,
					szWeaponClass,
					RegisterHam(Ham_Item_Deploy, szWeaponClass, "ItemDeploy_Post", true)
				)
			}
			format(szViewModel, charsmax(szViewModel), "models/%s.mdl", szViewModel)
			if(file_exists(szViewModel))
			{
				if(!g_tViewModels)
				{
					g_tViewModels = TrieCreate()
				}
				TrieSetCell(g_tViewModels, szWeaponClass, AllocString(szViewModel))
				precache_model(szViewModel)
			}
			format(szWeaponModel, charsmax(szWeaponModel), "models/%s.mdl", szWeaponModel)
			if(file_exists(szWeaponModel))
			{
				if(!g_tWeaponModels)
				{
					g_tWeaponModels = TrieCreate()
				}
				TrieSetCell(g_tWeaponModels, szWeaponClass, AllocString(szWeaponModel))
				precache_model(szWeaponModel)
			}
			format(szWorldModel, charsmax(szWorldModel), "models/%s.mdl", szWorldModel)
			if(file_exists(szWorldModel))
			{
				if(!g_tWorldModels)
				{
					g_tWorldModels = TrieCreate()
				}
				if(szWeaponClass[10] == 'n') // weapon_mp5navy
				{
					// replace(szWeaponClass, charsmax(szWeaponClass), "navy", "")
					szWeaponClass[10] = EOS
				}
				formatex(szOldWorldModel, charsmax(szOldWorldModel), "models/w_%s.mdl", szWeaponClass[7])
				if(!TrieKeyExists(g_tWorldModels, szOldWorldModel))
				{
					TrieSetString(g_tWorldModels, szOldWorldModel, szWorldModel)
					precache_model(szWorldModel)
				}
			}
		}
	}
	fclose(iFilePointer)
	TrieDestroy(tRegisterWeaponDeploy)
}

public plugin_init()
{
	register_plugin("Weapons Skins Manager", VERSION, "Vaqtincha")

	if(g_tWorldModels)
	{
		register_forward(FM_SetModel, "SetModel_Pre", 0)
	}
	g_iMaxPlayers = get_maxplayers()
}

public ItemDeploy_Post(wEnt)
{
	if(wEnt <= 0)
		return

	const m_pPlayer = 41

	new id = get_pdata_cbase(wEnt, m_pPlayer, .linuxdiff = 4)
	if(IsPlayer(id) && get_user_flags(id) & g_iAccess)
	{
		new iszNewModel, szWeaponClass[32]
		pev(wEnt, pev_classname, szWeaponClass, charsmax(szWeaponClass))
		if(g_tViewModels)
		{
			if(TrieGetCell(g_tViewModels, szWeaponClass, iszNewModel))
			{
				set_pev(id, pev_viewmodel, iszNewModel)
			}
		}
		if(g_tWeaponModels)
		{
			if(TrieGetCell(g_tWeaponModels, szWeaponClass, iszNewModel))
			{
				set_pev(id, pev_weaponmodel, iszNewModel)
			}
		}
	}
}

public SetModel_Pre(iEnt, const szModel[])
{
	// if(!pev_valid(iEnt))
		// return FMRES_IGNORED

	new id = pev(iEnt, pev_owner)
	if(!IsPlayer(id) || ~get_user_flags(id) & g_iAccess)
		return FMRES_IGNORED

	new szNewModel[MAX_MODEL_LENGTH]
	if(TrieGetString(g_tWorldModels, szModel, szNewModel, charsmax(szNewModel)))
	{
		SetModel(iEnt, szNewModel)
		return FMRES_SUPERCEDE
	}
	return FMRES_IGNORED
}

public plugin_end()
{
	if(g_tViewModels)
		TrieDestroy(g_tViewModels)
	if(g_tWeaponModels)
		TrieDestroy(g_tWeaponModels)
	if(g_tWorldModels)
		TrieDestroy(g_tWorldModels)
}