function bsp_chatclose()
{
    bootbox.dialog('<h3 class="green">Внимание!</h3> Насколько часов/минут хотите закрыть чат? <br>',
        [{
            "label" : "24 часа",
            callback : function()
            {
                if(getCookie('bsp_chat') == undefined) setCookie('bsp_chat', 1, {expires: 86400});

                $('#bspanel-minichat').fadeOut(300);
            }
        },{
            "label" : "10 часов",
            callback : function()
            {
                if(getCookie('bsp_chat') == undefined) setCookie('bsp_chat', 1, {expires: 36000});
                

                $('#bspanel-minichat').fadeOut(300);
            }
        },{
            "label" : "5 часов",
            callback : function()
            {
                if(getCookie('bsp_chat') == undefined) setCookie('bsp_chat', 1, {expires: 18000});
                

                $('#bspanel-minichat').fadeOut(300);
            }
        },{
            "label" : "1 час",
            callback : function()
            {
                if(getCookie('bsp_chat') == undefined) setCookie('bsp_chat', 1, {expires: 3600});
                

                $('#bspanel-minichat').fadeOut(300);
            }
        },{
            "label" : "30 минут",
            callback : function()
            {
                if(getCookie('bsp_chat') == undefined) setCookie('bsp_chat', 1, {expires: 1800});
                

                $('#bspanel-minichat').fadeOut(300);
            }
        },{
            "label" : "Закрыть",
            "style" : "margin-top: 30px",
        }]
    );

    $('.time_close_chat').text($('#time_closechat').val()+' секунда');

    $('#time_closechat').keyup(function(){
        var tcc = $('#time_closechat').val();
        $('.time_close_chat').text(tcc+' секунда');
    });
}

function minichat_emoji(id)
{
    $('#bspanel_chatmsg').val($('#bspanel_chatmsg').val()+'[emoji_'+id+']').focus();
}

function minichat_send()
{
    if($('#bspanel_chatmsg').val() == ''){
        $('#bspanel_chatmsg').focus();
        return false;
    } else {
        $.ajax({
            type: 'POST',
            url: home+'chat/action/send',
            data: 'text='+$('#bspanel_chatmsg').val()+'&login='+$('#bspanel_chatlogin').val(),
            dataType: 'json',
            success: function(arr)
            {
                $.each(arr, function(i, val)
                {
                    if(i == 'e')
                        bootbox.dialog('<h3 class="red">Внимание!</h3>'+val,
                            [{
                                "label" : "OK",
                                "class" : "btn-small btn-primary"
                            }]
                        );

                    if(i == 's')
                    {
                        $('#bspanel_chatmsg').val('');
                        $('#bspanel_chatlogin').val('');
                        bspanel_updchat(false);
                    }               
                })
            }
        });
    }
}

function minichat_readers(go)
{
    if(bspanel_upmini_chat)
        $.get(home+'chat/section/read/id/1', function(readers)
        {   
            $('#minichat_readers').html(readers);
            $('#minichat_readers_modal').html(readers);

            if(!go)
                setTimeout(function() {minichat_readers(false)}, 3000);
        });
}

function minichat_writers(go)
{
    write = '';

    if(go)
        write = '/write/1';

    if(bspanel_upmini_chat)
        $.get(home+'chat/section/write/id/1'+write, function(writers)
        {
            $('#minichat_writers').html(writers);
            
            if(!go)
                setTimeout(function() {minichat_writers(false)}, 3000);
        });
}

function bspanel_updchat(go)
{
    var block = document.getElementById("bspanel_minidialog");

    if(bspanel_upmini_chat)
    {
        $.get(home+'chat/action/get', function(data){
            $('#bspanel_minidialog').html(data)
            block.scrollTop = block.scrollHeight;

            $('.spoiler').click(function(){
                $(this).parent().children('div.spoiler_main').toggle(0);
            });

            $('pre code').each(function(i, block){
                hljs.highlightBlock(block);
            });
        });

        mininotice_load(true);
        block.scrollTop = block.scrollHeight;
    }

    if(go)
    {
        spoilers = $('.spoiler_main');
        update = true;
        for(var i = 0; i < spoilers.length; i++)
        {
            if(spoilers[i].style.display == 'block')
            {
                setTimeout(function() {bspanel_updchat(true)}, 4000);
                return false;
            }
        }

        setTimeout(function() {bspanel_updchat(true)}, 4000);
    }
}

function miniusers_online()
{
    bootbox.dialog('<h3 class="green">Пользователи онлайн</h3><div id="chat_readers_modal" class="informer" style="font-size: 15px;font-family: Luminari, fantasy;background: #ff000026;border-radius: 10px;"></div>',
        [{
            "label" : "Закрыть",
        }]
    );
}

function mininotice()
{
    $.getJSON(home+'chat/section/notice', function(data)
    {
        $.each(data, function(i, val)
        {
            $.get(home+'chat/section/notice/go/section/id/'+data['id'], function(data){mininotice_load();});

            if(i == 'notice')
                bootbox.dialog('<h3>Уведомления <i class="far fa-bell right"></i><a href="#" class="close" id="close_notice_modal"></a></h3>'+val,
                    [{
                        "label" : "Закрыть",
                        callback : function(){$.get(home+'chat/section/notice/go/section/id/'+data['id'], function(data){mininotice_load();})}
                    }]
                );
        });
    });
}

function chat_reply(login)
{
    $('#bspanel_chatmsg').val('');
    $('#bspanel_chatlogin').val(login);
    $('#bspanel_chatmsg').val(login+', '+$('#bspanel_chatmsg').val()).focus();

    return false;
}

function mininotice_load(go)
{
    $.get(home+'chat/section/notice/check', function(data)
    {
        if(data == 0)
            document.getElementById('notice_minichat').className = 'notice_chat__check';
        else
            document.getElementById('notice_minichat').className = '';

        if(go)
            setTimeout(function(){mininotice_load(true)}, 4000);
    });
}

function minichat_msg_edit(id, type)
{
    if(type == 'edit')
    {
        $.get(home+'chat/section/edit/id/'+id, function(data){
            bootbox.dialog('<h3 class="green">Выбранное сообщение</h3><div id="msg_edit_id" class="informer blue" style="height: 100px;overflow: scroll;">'+data+'</div><div style="padding: 10px;"><div onclick="bbcode(\'[spoiler]\', \'[/spoiler]\', \'edit\')" class="btn btn-short btn-gray right">Спойлер</div><div onclick="bbcode(\'[code]\', \'[/code]\', \'edit\')" class="btn btn-short btn-gray right">Подсветка</div><div onclick="bbcode(\'[quote]\', \'[/quote]\', \'edit\')" class="btn btn-short btn-gray right">Цитата</div><div onclick="bbcode(\'[url=http://\', \']Название[/url]\', \'edit\')" class="btn btn-short btn-gray right">Ссылка</div></div><div class="space"><div class="input_pad"><textarea id="edit" rows="4" type="text" placeholder="Введите текст" style="resize: auth;">'+data+'</textarea></div>',
                [{
                    "label" : "Продолжить",
                    callback : function(){minichat_msg_edit(id, 'edit_go')},
                },{
                    "label" : "Закрыть",
                }]
            );
        });
    }else{
        $.ajax({
            type: 'POST',
            url: home+'chat/section/edit/go',
            data: 'edit='+$('#edit').val()+'&id='+id,
            dataType: 'json',
            success: function(data)
            {
                $.each(data, function(i, val)
                {
                    if(i == 'e')
                        bootbox.dialog('<h3 class="red">Внимание!</h3>'+val,
                            [{
                                "label" : "OK",
                            }]
                        );

                    if(i == 's')
                    {
                        chat_dialog(false);
                        loading(0)
                    }

                });
            }
        });
    }
}

function minichat_msg_del(id, user)
{
    bootbox.dialog('<h3 class="red">Выберите операцию</h3>',
        [{
            "label" : "Удалить выбранное сообщение",
            "class" : "btn-small btn-primary",
            callback: function(){
                $('#msg_'+id).css('display', 'none');
                minichat_msg_del_go(id, '?id=1')
            }
        },{
            "label" : "Удалить все отправленное сообщение",
            "class" : "btn-small btn-primary",
            callback: function(){
                $('.user_'+user).css('display', 'none');
                minichat_msg_del_go(user, '?user=1')
            }
        },{
            "label" : "Отмена",
            "class" : "btn-small btn-primary"
        }]
    );

    return false;
}

function minichat_msg_del_go(id, type)
{

    $.getJSON(home+'chat/section/delete/id/'+id+'/go/'+type, function(data)
    {
        $.each(data, function(i, val)
        {
            if(i == 'e')
                bootbox.dialog('<h3 class="red">Ошибка</h3>'+val,
                    [{
                        "label" : "OK",
                        "class" : "btn-small btn-primary",
                    }]
                );

            if(i == 's')
                bspanel_updchat(true);
        });
    });

    return false;
}