// Запуск сервера
function server_start(id, ctrl)
{
	wait[id] = true;

	loading(1);

	$('#status_'+id).html('Выполняется...');

	$.getJSON(home+'control/id/'+ctrl+'/server/'+id+'/section/action/action/start',
	function(data)
	{
		wait[id] = false;

		$.each(data, function(i, val)
		{
			if(i == 'e')
				bootbox.dialog('<h3 class="red">Ошибка</h3>'+val,
					[{
						"label" : "OK",
						"class" : "btn-small btn-primary",
					}]
				);
			
			update_info(id, ctrl);
			update_status(id, ctrl);

			loading(0)
		});
	});
}

// Перезапуск сервера
function server_restart(id, ctrl)
{
	wait[id] = true;

	loading(1);

	$('#status_'+id).html('Выполняется...');

	$.getJSON(home+'control/id/'+ctrl+'/server/'+id+'/section/action/action/restart',
	function(data)
	{
		wait[id] = false;

		$.each(data, function(i, val)
		{
			if(i == 'e')
				bootbox.dialog('<h3 class="red">Ошибка</h3>'+val,
					[{
						"label" : "OK",
						"class" : "btn-small btn-primary",
					}]
				);

			update_info(id, ctrl);
			update_status(id, ctrl);

			loading(0)
		});
	});
}

// Выключение сервера
function server_stop(id, ctrl)
{
	wait[id] = true;

	loading(1);

	$('#status_'+id).html('Выполняется...');

	$.getJSON(home+'control/id/'+ctrl+'/server/'+id+'/section/action/action/stop',
	function(data)
	{
		wait[id] = false;

		$.each(data, function(i, val)
		{
			if(i == 'e')
				bootbox.dialog('<h3 class="red">Ошибка</h3>'+val,
					[{
						"label" : "OK",
						"class" : "btn-small btn-primary",
					}]
				);

			update_info(id, ctrl);
			update_status(id, ctrl);

			loading(0)
		});
	});
}

// Смена карты (получение списка)
function server_change(id, ctrl)
{
	if($('#maps_list_'+id).html() != '')
	{
		$('#maps_close_'+id).css('display', 'block');
		$('#maps_list_'+id).css('display', 'block');
	}else{
		loading(1);

		$.getJSON(home+'control/id/'+ctrl+'/server/'+id+'/section/action/action/change',
		function(data)
		{
			$.each(data, function(i, val)
			{
				if(i == 'e')
					bootbox.dialog('<h3 class="red">Ошибка</h3>'+val,
						[{
							"label" : "OK",
							"class" : "btn-small btn-primary",
						}]
					);

				if(i == 'maps')
				{
					$('#maps_close_'+id).css('display', 'block');
					$('#maps_list_'+id).css('display', 'block');
					$('#maps_list_'+id).html(val);
				}

				loading(0)
			});
		});
	}
}

// Смена карты
function server_change_map(id, ctrl, map)
{
	wait[id] = true;

	loading(1);

	$('#status_'+id).html('Выполняется...');

	server_change_close(id);

	$.getJSON(home+'control/id/'+ctrl+'/server/'+id+'/section/action/action/change/change/'+map,
	function(data)
	{
		wait[id] = false;

		$.each(data, function(i, val)
		{
			if(i == 'e')
				bootbox.dialog('<h3 class="red">Ошибка</h3>'+val,
					[{
						"label" : "OK",
						"class" : "btn-small btn-primary",
					}]
				);

			update_info(id, ctrl);
			update_status(id, ctrl);

			loading(0)
		});
	});
}

// Скрытие списка карт
function server_change_close(id)
{
	$('#maps_close_'+id).css('display', 'none');
	$('#maps_list_'+id).css('display', 'none');
}

// Переустановка сервера (подтверждение)
function server_reinstall(id, ctrl)
{
	bootbox.dialog('<h3 class="red">Внимание</h3> После переустановки, все текущие файлы будут удалены.',
		[{
			"label" : "Подтвердить",
			"class" : "btn-small btn-primary",
			callback: function() {server_reinstall_go(id, ctrl);}
		},{
			"label" : "Отмена",
			"class" : "btn-small btn-primary",
		}]
		
	);
}

// Переустановка сервера
function server_reinstall_go(id, ctrl)
{
	wait[id] = true;

	loading(1);

	$('#status_'+id).html('Выполняется...');

	$.getJSON(home+'control/id/'+ctrl+'/server/'+id+'/section/action/action/reinstall', function(data)
	{
		wait[id] = false;

		$.each(data, function(i, val)
		{
			if(i == 'e')
				bootbox.dialog('<h3 class="red">Ошибка</h3>'+val,
					[{
						"label" : "OK",
						"class" : "btn-small btn-primary",
					}]
				);

			update_info(id, ctrl);
			update_status(id, ctrl);

			loading(0)
		});
	});
}

// Обновление сервера
function server_update(id, ctrl)
{
	wait[id] = true;

	loading(1);

	$('#status_'+id).html('Выполняется...');

	$.getJSON(home+'control/id/'+ctrl+'/server/'+id+'/section/action/action/update', function(data)
	{
		wait[id] = false;

		$.each(data, function(i, val)
		{
			if(i == 'e')
				bootbox.dialog('<h3 class="red">Ошибка</h3>'+val,
					[{
						"label" : "OK",
						"class" : "btn-small btn-primary",
					}]
				);

			update_info(id, ctrl);
			update_status(id, ctrl);

			loading(0)
		});
	});
}

// Обновление информации сервера
function update_info(id, ctrl, go = false)
{
	if(wait[id] == true)
	{
		if(go)
			setTimeout(function() {update_info(id, ctrl, true)}, 3000);

		return false;
	}

	$.getJSON(home+'control/id/'+ctrl+'/server/'+id+'/section/scan/mon', function(data)
	{
		$.each(data, function(i, val)
		{
			if(i == 'time' && $('#time_'+id).html() != val && val != '')
				$('#time_'+id).html(val);

			if(i == 'time_end' && $('#time_end_'+id).html() != val && val != '')
				$('#time_end_'+id).html(val);

			if(i == 'name' && $('#name_'+id).html() != val)
				$('#name_'+id).html(val);

			if(i == 'status' && $('#status_'+id).html() != val)
				$('#status_'+id).html(val);

			if(i == 'online' && $('#online_'+id).html() != val)
				$('#online_'+id).html(val);

			if(i == 'image' && $('#image_'+id).html() != val)
				$('#image_'+id).html(val);

			if(i == 'buttons' && $('#buttons_'+id).html() != val)
				$('#buttons_'+id).html(val);
		});
		
		if(go)
			setTimeout(function() {update_info(id, ctrl, true)}, 2000);
	});
}

// Проверка статуса сервера
function update_status(id, ctrl, go = false)
{
	$.get(home+'control/id/'+ctrl+'/server/'+id+'/section/scan/status', function(data)
	{
		if(go)
			setTimeout(function() {update_status(id, ctrl, true)}, 2000);
	});
}


function update_resources(id, ctrl, go = false)
{
	$.getJSON(home+'control/id/'+ctrl+'/server/'+id+'/section/scan/resources', function(data)
	{
		$.each(data, function(i, val)
		{
			if(i == 'cpu')
			{
				w = 309/100*parseInt(val);

				$('#cpu_'+id).css('width', w+'px');
				$('#cpu_'+id+'_val').html(val+'%');
			}

			if(i == 'ram')
			{
				w = 309/100*parseInt(val);

				$('#ram_'+id).css('width', w+'px');
				$('#ram_'+id+'_val').html(val+'%');
			}

			if(i == 'hdd')
			{
				w = 309/100*parseInt(val);

				$('#hdd_'+id).css('width', w+'px');
				$('#hdd_'+id+'_val').html(val+'%');
			}
		});

		if(go)
			setTimeout(function() {update_resources(id, ctrl, true)}, 5000);
	});
}

// Удаление сервера (подтверждение)
function server_delete(id, ctrl)
{
	bootbox.dialog('<h3 class="red">Внимание</h3> Вы уверены, что хотите удалить сервер #'+id+'?.',
		[{
			"label" : "Подтвердить",
			"class" : "btn-small btn-primary",
			callback: function() {server_delete_go(id, ctrl);}
		},{
			"label" : "Отмена",
			"class" : "btn-small btn-primary",
		}]
		
	);
}

// Удаление сервера
function server_delete_go(id, ctrl)
{
	wait[id] = true;

	loading(1);

	$('#status_'+id).html('Выполняется...');

	$.getJSON(home+'control/id/'+ctrl+'/server/'+id+'/section/action/action/delete', function(data)
	{
		wait[id] = false;

		$.each(data, function(i, val)
		{
			if(i == 'e')
			{
				bootbox.dialog('<h3 class="red">Ошибка</h3>'+val,
					[{
						"label" : "OK",
						"class" : "btn-small btn-primary",
					}]
				);

				update_info(id, ctrl);
				update_status(id, ctrl);
			}

			if(i == 's')
				location.reload();

			loading(0)
		});
	});
}