$('#create').ajaxForm({
	dataType: 'json',
	success: function(data)
	{
		$.each(data, function(i, val)
		{
			if(i == 'e')
				bootbox.dialog('<h3 class="red">Ошибка</h3>'+val,
					[{
						"label" : "OK",
						"class" : "btn-small btn-primary",
					}]
				);

			if(i == 's')
				location.href=home+'forum/';
		});

		loading(0);

		return false;
	}
});

$('#send').ajaxForm({
	dataType: 'json',
	success: function(data)
	{
		$.each(data, function(i, val)
		{
			if(i == 'e')
				bootbox.dialog('<h3 class="red">Ошибка</h3>'+val,
					[{
						"label" : "OK",
						"class" : "btn-small btn-primary",
					}]
				);

			if(i == 's')
				location.href=home+'forum/';
		});

		loading(0);

		return false;
	}
});

$('#answer').ajaxForm({
	dataType: 'json',
	success: function(data)
	{
		$.each(data, function(i, val)
		{
			if(i == 'e')
				bootbox.dialog('<h3 class="red">Ошибка</h3>'+val,
					[{
						"label" : "OK",
						"class" : "btn-small btn-primary",
					}]
				);

			if(i == 's')
				location.href=home+'forum/';
		});

		loading(0);

		return false;
	}
});

function clearFileUpload(id)
{
	fileField = document.getElementById(id);
	parentNod = fileField.parentNode;
	tmpForm = document.createElement("form");
	parentNod.replaceChild(tmpForm,fileField);
	tmpForm.appendChild(fileField);
	tmpForm.reset();
	parentNod.replaceChild(fileField,tmpForm);
}

function bbcode(bbbegin, bbend)
{
	form = document.getElementById('text');
	begin = form.value.substr(0, form.selectionStart);
	end = form.value.substr(form.selectionEnd);
	sel = form.value.substr(form.selectionStart, form.selectionEnd-form.selectionStart);
	var text = form.firstChild;
	form.value = begin+bbbegin+sel+bbend+end;
	selPos = bbbegin.length+begin.length+sel.length+bbend.length;
	form.setSelectionRange(begin.length, selPos);

	return false;
}

jQuery.event.props.push('dataTransfer');

var maxFiles = 8;
var dataArray = [];

$('#uploaded-files').hide();

$('#drop-files').on('drop', function(e)
{
	var files = e.dataTransfer.files;

	if(files.length <= maxFiles)
	{
		for(i = 0; i < files.length; i++)
		{
			if(files[i].size < (1024*1024*1))
				loadInView(files[i]);
			else
				alert('Слишком большой файл. Максимально 1024Kb.');
		}
	}else{
		alert('Нельзя загружать больше '+maxFiles+' изображений.');
		files.length = 0;
	}

	return false;
});

$('#img').on('change', function()
{
   	var files = $(this)[0].files;

	if(files.length <= maxFiles)
	{
		for(i = 0; i < files.length; i++)
		{
			if(files[i].size < (1024*1024*1))
				loadInView(files[i]);
			else
				alert('Слишком большой файл. Максимально 1024Kb.');
		}
	}else{
		alert('Нельзя загружать больше '+maxFiles+' изображений.'); 
		files.length = 0;
	}

	clearFileUpload('img');
});

var upload = 0;
var files = 0;

function loadInView(file)
{
	if(files < 0)
		files = 0;

	$('#uploaded-holder').css('display', 'inline-block');

	if(!file.type.match('image.*'))
	{
		$('#drop-files p').html('Файл не является изображением.');

		return false;
	}

	files = files+1;

	if(files <= maxFiles)
		$('#upload-button').css({'display' : 'block'});
	else{
		alert('Нельзя загружать больше '+maxFiles+' изображений.');
		
		files = files-1;

		return false;
	}

	var fileReader = new FileReader();

	fileReader.onload = (function(file){
		return function(e){
			dataArray.push({name : file.name, value : this.result, check : null, sel : null});
			addImage((dataArray.length-1));
		};
	})(file);

	fileReader.readAsDataURL(file);

	return false;
}

function delImage(id)
{
	$(this).empty();
	dataArray.splice(id, 1);
	$('#dropped-files > .img-block').remove();
	addImage(-1);

	return false;
}

function addImage(ind)
{
	if(ind < 0 )
	{
		start = 0;
		end = dataArray.length;
		files = files-1;
	}else{
		start = ind;
		end = ind+1;
	}

	if(dataArray.length == 0)
	{
		$('#upload-button').hide();
		$('#uploaded-holder').hide();
	}

	for(i = start; i < end; i++)
		if($('#dropped-files > .img-block').length <= maxFiles)
			$('#dropped-files').append('<div class="img-block" id="img-'+i+'"><div class="image" style="background: url('+dataArray[i].value+'); background-size: contain;"></div><a href="#" onclick="return delImage(\''+i+'\')" class="drop-button">Удалить</a></div>'); 

	return false;
}

function restartFiles(go)
{
	$('#loading-bar .loading-color').css({'width' : '0%'});
	$('#loading').css({'display' : 'none'});
	$('#loading-content').html(' ');
	$('#upload-button').hide();
	$('#dropped-files > .img-block').remove();
	$('#uploaded-holder').hide();
	dataArray.length = 0;
	if(go != 1)
		files = upload;

	return false;
}

$('#dropped-files #upload-button .delete').click(restartFiles);

$('#upload-button .upload').click(function()
{
	$("#loading").show();

	var totalPercent = 100 / dataArray.length;
	var x = 0;

	$('#loading-content').html('Загружен '+dataArray[0].name);

	$.each(dataArray, function(index, file)
	{
		upload = upload + 1;

		$.post(home+'forum/section/upload', dataArray[index], function(data)
		{
			var fileName = dataArray[index].name;
			++x;

			$('#loading-bar .loading-color').css({'width' : totalPercent*(x)+'%'});

			if(totalPercent*(x) == 100)
			{
				$('#loading-content').html('Загрузка завершена.');
				setTimeout(restartFiles(1), 1000);
			}else if(totalPercent*(x) < 100)
				$('#loading-content').html('Загружается '+fileName);

			var dataSplit = data.split(':');

			if(dataSplit[1] == 'ok')
			{
				$('#uploaded-files').append('<div class="img-block"><div class="image" style="background: url('+home+'upload/forum/'+dataSplit[0]+'); background-size: contain;"></div><a target="_blank" href="'+home+'upload/'+dataSplit[0]+'" class="success-button">Загружено</a></div>');
				$('#img-input').append('<input name="img[]" value="'+dataSplit[0]+'" type="hidden"></div>');
			}else
				$('#uploaded-files').append(data);
		});

		if(upload == maxFiles)
			$('#upload_block').hide();
	});

	$('#uploaded-files').show();

	return false;
});

$('#drop-files').on('dragenter', function()
{
	$(this).css({'border-color' : '#74b084'});

	return false;
});

$('#drop-files').on('drop', function()
{
	$(this).css({'border-color' : '#dcdcdc'});
	files = files-1;

	return false;
});
