<?php
	header('Content-Type: text/html; charset=utf-8');

	date_default_timezone_set('Asia/Almaty');

	@ini_set('display_errors', TRUE);
	@ini_set('html_errors', TRUE);
	@ini_set('error_reporting', E_ALL ^ E_WARNING ^ E_NOTICE ^ E_STRICT);

	DEFINE('BSP', TRUE);
	DEFINE('DIR', dirname('index.php'));
	DEFINE('ROOT', DIR.'/');
	DEFINE('SYS', ROOT.'system/');
	DEFINE('TPL', ROOT.'template/');
	DEFINE('TEMP', ROOT.'temp/');
	DEFINE('FILES', ROOT.'files/');
	DEFINE('DATA', SYS.'data/');
	DEFINE('LIB', SYS.'library/');
	DEFINE('ENG', SYS.'engine/');
	DEFINE('SEC', SYS.'sections/');

	$device = isset($_COOKIE['bsp_device']) ? $_COOKIE['bsp_device'] : '!mobile';
	$start_point = $_SERVER['REQUEST_TIME'];

	$mcache = new Memcache;
	$mcache->connect('127.0.0.1', 11211) or exit('Ошибка: Данная панель устанавливается только <a href="https://justhost.ru/services/vps">vps сервер</a>:<a href="http://shop.ftpby.ru/shop?id=23">купить скрипт</a>');

	// Настройки
	include(DATA.'config.php');
	include(DATA.'engine.php');
	include(DATA.'mysql.php');
	include(DATA.'params.php');

	// Библиотеки
	include(LIB.'sql.php');
	include(LIB.'html.php');
	include(LIB.'system.php');

	$uip = sys::ip();

	if(!isset($_COOKIE['bsp_device']))
	{
		include(LIB.'mbsp.php');

		$device = $mbsp->isMobile() ? 'mobile' : '!mobile';

		sys::cookie('bsp_device', $device, 14);

		if($device == 'mobile')
			sys::back();
	}

	// Распределитель
	if($device == '!mobile')
		include(SYS.'distributor.php');
	else
		include(SYS.'mdistributor.php');

	// Выхлоп
	echo $html->arr['all'];
?>
