function firewall(type, id)
{
	loading(1);

	switch(type)
	{
		case 'info':
			action = 'info';
			address = $('#editip').val();
			break;

		case 'block': case 'blocksub':
			action = 'block';
			address = $('#addip').val();
			break;

		case 'unblock':
			action = 'unblock';
			address = $('#editip').val();
			break;

		default:
			return false;
	}

	if(id)
		address = id;

	subnetwork = '';

	if(type == 'blocksub')
		subnetwork = '&subnetwork=true';

	$.ajax({
		type: 'POST',
		url: home+'servers/id/'+server+'/section/settings/subsection/firewall/action/'+action+'/go',
		data: 'address='+address+subnetwork,
		dataType: 'json',
		success: function(data)
		{
			$.each(data, function(i, val)
			{
				if(i == 'e')
					bootbox.dialog('<h3 class="red">Ошибка</h3>'+val,
						[{
							"label" : "Продолжить",
							"class" : "btn-small btn-primary",
						}]
					);

				if(i == 'i')
				{
					bootbox.dialog('<h3 class="blue">Внимание</h3>'+val,
						[{
							"label" : "Разблокировать",
							"class" : "btn-success",
							callback: function(){firewall('unblock', data['id'])}
						},{
							"label" : "Отмена"
						}]
					);
				}

				if(i == 's')
					location.reload();

				if(i == 'info')
					$('#whois').html(val);
			});

			loading(0)
		}
	});
}