function plugin_confirm(action, id)
{
	switch(action)
	{
		case 'install':
			text = 'Вы уверены, что хотите <u>установить</u> данный плагин?';
		break;

		case 'buy':
			text = 'Вы уверены, что хотите <u>купить и уставить</u> данный плагин?';
		break;

		case 'update':
			text = 'Вы уверены, что хотите <u>обновить</u> данный плагин?';
		break;

		case 'delete':
			text = 'Вы уверены, что хотите <u>удалить</u> данный плагин?';
		break;
	}

	bootbox.dialog('<h3 class="blue">Внимание</h3>'+text,
		[{
			"label" : "Подтвердить",
			"class" : "btn-success",
			callback: function(){
				switch(action)
				{
					case 'install': case 'buy':
						plugin_install(id);
					break;

					case 'update':
						plugin_update(id);
					break;

					case 'delete':
						plugin_delete(id);
				}
			}
		},{
			"label" : "Отмена"
		}]
	);
}

function plugin_install(id, next)
{
	loading(1);

	$.getJSON(home+'servers/id/'+server+'/section/addons/subsection/install/plugin/'+id+'/go', function(arr)
	{
		$.each(arr, function(i, val)
		{
			if(i == 'e')
			{
				if(arr['pid'] !== undefined)
				{
					if(arr['required'] !== undefined)
					{
						if(arr['select'] !== undefined)
							bootbox.dialog('<h3 class="red">Ошибка</h3>'+val+'<p>Родитель: <select id="choice">'+arr['select']+'</select></p>',
								[{
									"label" : "Установить",
									'class' : 'btn-success',
									callback: function(){plugin_install($('#choice').val(), id)}
								},{
									"label" : "Отмена"
								}]
							);
						else
							bootbox.dialog('<h3 class="red">Ошибка</h3>'+val+'<p>Родитель: <u>'+arr['pname']+'</u></p>',
								[{
									"label" : "Установить",
									'class' : 'btn-success',
									callback: function(){plugin_install(arr['pid'], id)}
								},{
									"label" : "Отмена"
								}]
							);
					}else
						bootbox.dialog('<h3 class="red">Ошибка</h3>'+val+'<p>Плагин: <u>'+arr['pname']+'</u></p>',
							[{
								"label" : "Удалить",
								'class' : 'btn-error',
								callback: function(){plugin_delete(arr['pid'], id)}
							},{
								"label" : "Отмена"
							}]
						);
				}else
					bootbox.dialog('<h3 class="red">Ошибка</h3>'+val,
						[{
							"label" : "Продолжить",
						}]
					);
			}

			if(i == 's')
			{
				if(val == 'cfg')
				{
					$('#act_'+id).html('<div class="buttons mini float-left margin-left-0"><a href="'+home+'servers/id/'+server+'/section/addons/subsection/plugin/plugin/'+id+'"><div class="btn border">Настроить</div></a></div>');
					$('#act_'+id).append('<div class="buttons mini float-left margin-left-0"><div class="btn red border" onclick="plugin_confirm(\'delete\', \''+id+'\')">Удалить</div></div>');
				}else
					$('#act_'+id).html('<div class="buttons mini float-left margin-left-0"><div class="btn red border" onclick="plugin_confirm(\'delete\', \''+id+'\')">Удалить</div></div>');

				if(next)
					plugin_install(next);
			}
		});

		loading(0)
	});
}

function plugin_update(id)
{
	loading(1);

	$.getJSON(home+'servers/id/'+server+'/section/addons/subsection/update/plugin/'+id+'/go', function(arr)
	{
		$.each(arr, function(i, val)
		{
			if(i == 'e')
			{
				if(arr['pid'] !== undefined)
				{
					if(arr['required'])
						bootbox.dialog('<h3 class="red">Ошибка</h3>'+val+'<p>Родитель: <u>'+arr['pname']+'</u></p>',
							[{
								"label" : "Установить",
								'class' : 'btn-error',
								callback: function(){plugin_install(arr['pid'], id)}
							},{
								"label" : "Отмена"
							}]
						);
					else
						bootbox.dialog('<h3 class="red">Ошибка</h3>'+val+'<p>Плагин: <u>'+arr['pname']+'</u></p>',
							[{
								"label" : "Удалить",
								'class' : 'btn-error',
								callback: function(){plugin_delete(arr['pid'], id)}
							},{
								"label" : "Отмена"
							}]
						);
				}else
					bootbox.dialog('<h3 class="red">Ошибка</h3>'+val,
						[{
							"label" : "Продолжить",
						}]
					);
			}

			if(i == 's')
				location.reload();
		});

		loading(0)
	});
}

function plugin_delete(id, next)
{
	loading(1);

	$.getJSON(home+'servers/id/'+server+'/section/addons/subsection/delete/plugin/'+id+'/go', function(arr)
	{
		$.each(arr, function(i, val)
		{
			if(i == 'e')
				bootbox.dialog('<h3 class="red">Ошибка</h3>'+val,
					[{
						"label" : "Продолжить",
					}]
				);

			if(i == 'i')
			{
				bootbox.dialog('<h3 class="green">Внимание</h3>Необходимо установить следующий плагин: <u>'+arr['pname']+'</u></p>',
					[{
						"label" : "Установить",
						'class' : 'btn-success',
						callback: function(){plugin_install(i)}
					},{
						"label" : "Отмена"
					}]
				);
			}

			if(i == 's')
			{
				$('#act_'+id).html('<div class="buttons mini float-left margin-left-0"><div class="btn green border" onclick="plugin_confirm(\'install\', \''+id+'\')">Установить</div></div>');

				if(next)
					plugin_install(next);
			}
		});

		loading(0)
	});
}

function plugins_search(go, sort, cat)
{
	if($('#search').val() == '')
	{
		$('#search_block').css('display', 'none');
		return;
	}
	loading(1);

	if(go) go = '/go'; else go = '';

	$.ajax({
		type: 'POST',
		url: home+'servers/id/'+server+'/section/addons/subsection/search/sort/'+sort+'/cat/'+cat+'/'+go,
		data: 'text='+$('#search').val(),
		dataType: 'json',
		success: function(data)
		{
			$.each(data, function(i, val)
			{
				if(i == 'e')
					bootbox.dialog('<h3 class="red">Ошибка</h3>'+val,
						[{
							"label" : "Продолжить",
						}]
					);

				if(i == 's')
				{
					if(val != '')
					{
						$('#search_result').show()
						$('#search_result').html('<p class="rubric only">Результаты поиска</p>'+val);
					}else
						$('#search_result').hide()
				}
			});

			loading(0);
		}
	});
}

function plugins_rating(action, plugin)
{
	$.get(home+'servers/id/'+server+'/section/addons/subsection/rating/plugin/'+plugin+'/rating/'+action, function(data)
	{
		if(data == 'done')
			return false;

		$('#plugin_'+plugin+'_rating').html(data);
	});
}