/*
	Plugin author by DT.Sakulekingz (KIN)
*/
	
	#include <amxmodx>
	#include <amxmisc>
	
	#define PLUGIN	"Team Score"
	#define VERSION	"2.0"
	#define AUTHOR	"DT.Sakulekingz(KIN)"
	#define LOADING	"^n^t%s v%s, Copyright (C) 2009 by %s^n"
	#define SCORECSO			"sprites/score.spr"
	
	new ct_score, terrorist_score;
	new iconstatus;
new user_icons[32][192];
new icon_origin[3] = {0,0,0}
new pcv_show;
new pcv_iloc;
	
	public plugin_init()
	{
	register_plugin(PLUGIN, VERSION, AUTHOR);
	server_print(LOADING,PLUGIN,VERSION,AUTHOR);
	register_event("TeamScore", "team_score", "a");
	set_task(1.0,"score_round",_,_,_,"b")
	register_plugin(PLUGIN, VERSION, AUTHOR)
	register_event ("CurWeapon", "update_icon", "ab")
	register_event("DeathMsg", "event_death", "a")
	pcv_show = register_cvar("amx_show_weapon_icon", "1");
	pcv_iloc = register_cvar("amx_show_weapon_icon_location", "1");
	register_concmd("amx_weapon_icon", "weapon_icon_toggle", ADMIN_CVAR, "Toggle display of the weapon icon on/off (default on)")
	
	check_icon_loc();
	}
	
	public team_score()
	{
		new team[32];
		read_data(1,team,31);
		if (equal(team,"CT"))
		{
			ct_score = read_data(2);
		}
		else if (equal(team,"TERRORIST"))
		{
			terrorist_score = read_data(2);
		}
	}
	
	public score_round()
	{
		precache_model(SCORECSO);
		set_hudmessage(0, 70, 200, -1.0, 0.02, 0, 0.5, 2.0, 0.08, 2.0, 145);
		show_hudmessage(0,"   %d                      ", terrorist_score);
		
		set_hudmessage(200, 0, 0, -1.0, 0.02, 0, 0.5, 2.0, 0.08, 2.0, 146);
		show_hudmessage(0,"                                     %d", ct_score);
	}

public update_icon(id) {
	check_icon_loc();
	if(!get_pcvar_num(pcv_show) || get_pcvar_num(pcv_iloc) == 0)
		return PLUGIN_CONTINUE;
	
	if(is_user_alive(id))
	{
		new iwpn, wclip, wammo, sprite[192], icon_color[3] = {0, 160, 0}
		
		remove_weapon_icon(id)
		
		iwpn = get_user_weapon(id, wclip, wammo)
		switch(iwpn) {
			case CSW_P228: sprite = "score"
				case CSW_SCOUT: sprite = "score"
				case CSW_HEGRENADE: sprite = "score"
				case CSW_XM1014: sprite = "score"
				case CSW_C4: sprite = "score"
				case CSW_MAC10: sprite = "score"
				case CSW_AUG: sprite = "score"
				case CSW_SMOKEGRENADE: sprite = "score"
				case CSW_ELITE: sprite = "score"
				case CSW_FIVESEVEN: sprite = "score"
				case CSW_UMP45: sprite = "score"
				case CSW_SG550: sprite = "score"
				case CSW_GALIL: sprite = "score"
				case CSW_FAMAS: sprite = "score"
				case CSW_USP: sprite = "score"
				case CSW_MP5NAVY: sprite = "score"
				case CSW_M249: sprite = "score"
				case CSW_M3: sprite = "score"
				case CSW_M4A1: sprite = "score"
				case CSW_TMP: sprite = "score"
				case CSW_G3SG1: sprite = "score"
				case CSW_FLASHBANG: sprite = "score"
				case CSW_DEAGLE: sprite = "score"
				case CSW_SG552: sprite = "score"
				case CSW_AK47: sprite = "score"
				case CSW_KNIFE: sprite = "score"
				case CSW_P90: sprite = "score"
				case CSW_VEST: sprite = "score"
				case CSW_VESTHELM: sprite = "score"
				case CSW_GLOCK18: sprite = "score"
				case CSW_AWP: sprite = "score"
				case 0: sprite = ""
				default: sprite = ""
		}
		if (is_user_ok(id)) {
			if (equali(sprite, "") || !is_user_ok(id)) {
				remove_weapon_icon(id)
				} else {
				// draw the sprite itself (only on a human user's screen)
				// marker ////////////////////////////////////////////////////////////////////////////////
				message_begin(MSG_ONE,iconstatus,icon_origin,id);
				write_byte(1); // status (0=hide, 1=show, 2=flash)
				write_string(sprite); // sprite name
				
				/*
				4 stages - Normal, 1 Clip, No Clip + Some ammo, Completely Out
				
				*/
				
				// ammo check, this is for the color of the icon
				get_user_ammo(id, iwpn, wammo, wclip) // update vars correctly
				if (wclip == 0 && wammo == 0) icon_color = {0, 0, 255} // outta ammo!
				if (wclip == wammo || wclip > wammo) icon_color = {255, 150, 150} // last clip!
				if (wammo > 0 && wclip == 0) icon_color = {255, 100, 100} // almost out!
				// attempt at percentage max clip & % red/green color
				// 1: Get max ammo for weapon
				//maxammo = maxclip(iwpn);
				
				
				write_byte(icon_color[0]); // red
				write_byte(icon_color[1]); // green
				write_byte(icon_color[2]); // blue
				message_end();
			}
			user_icons[id] = sprite;
		}
	}
	return PLUGIN_CONTINUE
} 

public weapon_icon_toggle(id) {
	new toggle[32], players[32], num, player, status[32] = "enabled"
	read_argv(1, toggle, 1)
	
	if (equali(toggle, "1")) {
		status = "enabled"
		} else if (equali(toggle, "0")) {
		status = "disabled"
		} else if (equali(toggle, "")) {
		console_print(id, "Usage: amx_weapon_icon <1/0> - Toggles wether or not showing the user's current weapon as an icon")
		console_print(id, "Weapon Icon is currently %s", status)
		return PLUGIN_HANDLED
	}
	
	set_cvar_string("amx_show_weapon_icon", toggle)
	client_print(0, print_chat, "Weapon Icon is now %s", status)
	get_players(players, num)
	for (new i=0; i<num; i++) {
		player = players[i]
		if (!equali(user_icons[player], "") && !equali(players[i], "") && is_user_ok(id)) {
			remove_weapon_icon(i)
		}
	}
	return PLUGIN_CONTINUE
}

public remove_weapon_icon(id) {
	if (is_user_ok(id)) {
		message_begin(MSG_ONE,iconstatus,icon_origin,id);
		write_byte(0);
		write_string(user_icons[id]);
		message_end();
	}
}

public is_user_ok(id) {
	// check if the user is "ok": they are connected, not a bot, and alive
	if (is_user_connected(id) && !is_user_bot(id) && is_user_alive(id))
		return true
	return false
}

public event_death() {
	new player = read_data(2) // the dead player's ID (1-32)
	if (is_user_connected(player) && !is_user_bot(player)) { // remove icon
		message_begin(MSG_ONE,iconstatus,icon_origin,player);
		write_byte(0);
		write_string(user_icons[player]);
		message_end();
	}
}

public check_icon_loc() {
	if(!get_pcvar_num(pcv_iloc))
		return PLUGIN_CONTINUE;
	new value = get_pcvar_num(pcv_iloc);
	if (value == 0)
		iconstatus = 0;
	if (value == 1)
		iconstatus = get_user_msgid("StatusIcon");
	if (value == 2)
		iconstatus = get_user_msgid("Scenario");
	return PLUGIN_CONTINUE;
}
