#include <amxmodx>
#include <fakemeta>

#define CHECK_TIME 30 // Время в сек, которое дается на ввод капчи.
//#define HLTV_BOT_KICK // Раскомментируйте, чтобы кикать серверных ботов и HLTV.
//#define BLOCK_VOICE // Блокировать микрофон, если не прошел проверку. Не используете эту опцию, если есть плагины с голосовым чатом.
#define IMMUNITY_FLAGS ADMIN_IMMUNITY // Не проверять игрока с иммунитетом.

#if defined BLOCK_VOICE
	#define	GetBit(%1,%2)		(%1 & (1 << (%2 & 31)))
	#define	SetBit(%1,%2)		%1 |= (1 << (%2 & 31))
	#define	ResetBit(%1,%2)		%1 &= ~(1 << (%2 & 31))
	new g_bBlockVoice;
#endif

new Trie:RealPlayers, Captcha[33], szSteamID[33][25], iFile[] = {"addons/amxmodx/data/[Captcha] RealPlayers.ini"};

const VGUIMenu = 114;
const OLDMenu = 96;

public plugin_cfg()
{
	RealPlayers = TrieCreate();
	new File = fopen(iFile, "rt"), Data[25];
	while(!feof(File))
	{
		fgets(File, Data, charsmax(Data)), trim(Data);
		if(!Data[0] || Data[0] == ';') continue;
		TrieSetCell(RealPlayers, Data, 0);
	}
	fclose(File);
}

public plugin_init()
{
	#define VERSION "1.3a"
	register_plugin("Captcha", VERSION, "Factor");
	register_cvar("Captcha", VERSION, FCVAR_SERVER | FCVAR_SPONLY);
	
	register_message(OLDMenu, "ShowCaptcha");
	register_message(VGUIMenu, "ShowCaptcha");
	
	register_clcmd("chooseteam", "ChooseTeam_Hook"), register_clcmd("jointeam", "ChooseTeam_Hook"), register_clcmd("joinclass", "ChooseTeam_Hook"), register_clcmd("menuselect", "ChooseTeam_Hook");
	register_clcmd("say", "Say_Hook"), register_clcmd("say_team", "Say_Hook");
	
	#if defined BLOCK_VOICE
		register_forward(FM_Voice_SetClientListening, "fwdSetClientListening");
	#endif
}

public ShowCaptcha(const iMsg, const iMsgDest, const iClient)
{
	if(Captcha[iClient] != 1)
	{
		if(iMsg == OLDMenu)
		{
			static szArg4[20]; get_msg_arg_string(4, szArg4, charsmax(szArg4));
			if(contain(szArg4, "Team_Select") == -1) return PLUGIN_HANDLED;
		}
		else if(get_msg_arg_int(1) != 2) return PLUGIN_HANDLED;
		set_pdata_int(iClient, 205, 0);
		
		#if defined CHECK_TIME
			if(float(CHECK_TIME) >= 15.0) set_task(float(CHECK_TIME), "KickPlayer", iClient);
			else set_task(15.0, "KickPlayer", iClient);
		#endif
		
		GenerateCaptcha(iClient);
		
		return PLUGIN_HANDLED;
	}
	
	return PLUGIN_CONTINUE;
}

public Say_Hook(client)
{
	if(Captcha[client] != 1)
	{
		new szMessage[16]; // [7] optimal
		read_args(szMessage, 15), remove_quotes(szMessage), trim(szMessage);
		
		if(str_to_num(szMessage) == Captcha[client])
		{
			#if defined CHECK_TIME
				remove_task(client);
			#endif
			
			#if defined BLOCK_VOICE
				ResetBit(g_bBlockVoice, client);
			#endif
			
			show_menu(client, 0, "^n", 1);
			
			Captcha[client] = 1;
			TrieSetCell(RealPlayers, szSteamID[client], 0);
			write_file(iFile, szSteamID[client], - 1);
			engclient_cmd(client, "jointeam", "0");
		}
		else KickPlayer(client);
		
		return PLUGIN_HANDLED;
	}
	
	return PLUGIN_CONTINUE;
}

public client_putinserver(client)
{
	#if !defined HLTV_BOT_KICK
		if(is_user_bot(client) || is_user_hltv(client)) return PLUGIN_HANDLED;
	#endif
	
	get_user_authid(client, szSteamID[client], charsmax(szSteamID));
	
	if(TrieKeyExists(RealPlayers, szSteamID[client]) || user_with_immunity(client) || is_user_steam(client))
	{
		Captcha[client] = 1;
		return PLUGIN_HANDLED;
	}
	
	#if defined BLOCK_VOICE
		else SetBit(g_bBlockVoice, client);
	#endif
	
	return PLUGIN_CONTINUE;
}

public client_disconnect(client)
{
	#if defined CHECK_TIME
		remove_task(client);
	#endif
	
	Captcha[client] = 0;
}

public ChooseTeam_Hook(client)
{
	if(Captcha[client] != 1)
	{
		GenerateCaptcha(client);
		return PLUGIN_HANDLED;
	}
	
	return PLUGIN_CONTINUE;
}

public GenerateCaptcha(client)
{
	new Text_Menu[156];
	Captcha[client] = random_num(1000, 9999);
	formatex(Text_Menu, charsmax(Text_Menu), "\r[Капча]\w Однократная проверка на бота.^nВведите \y%d\w в чат для входа на сервер.", Captcha[client]);
	client_print(client, print_chat, "[Капча] Новая капча сгенерирована.");
	show_menu(client, MENU_KEY_0, Text_Menu);
}

public KickPlayer(client) server_cmd("kick ^"#%d^" ^"Вы не прошли проверку на робота, попробуйте снова.^"", get_user_userid(client));

#if defined BLOCK_VOICE
public fwdSetClientListening(receiver, sender)
{
	if(receiver != sender && GetBit(g_bBlockVoice, sender))
	{
		engfunc(EngFunc_SetClientListening, receiver, sender, false);
		return FMRES_SUPERCEDE;
	}
	return FMRES_IGNORED;
}
#endif

bool:user_with_immunity(client)  
{  
	if(get_user_flags(client) & IMMUNITY_FLAGS) return true;
	return false;
}

stock is_user_steam(client)
{
    new dp_pointer;
	
    if(dp_pointer || (dp_pointer = get_cvar_pointer("dp_r_id_provider")))
    {
        server_cmd("dp_clientinfo %d", client);
        server_exec();
        return (get_pcvar_num(dp_pointer) == 2) ? 1 : 0;
    }
	
    return 0;
}