#if defined _colorchat_included
#endinput
#endif
#define _colorchat_included

#define NORMAL DontChange
#define GREEN DontChange
#define RED Red
#define BLUE Blue
#define GREY Grey
#define ColorChat client_print_color

#define MAX_TRANSLATION_LENGTH 2048

enum {DontChange = 0, Grey = -1, Red = -2,Blue = -3};

#define print_team_default DontChange
#define print_team_grey Grey
#define print_team_red Red
#define print_team_blue Blue

stock client_print_color(id, sender, const fmt[], any:...)
{
	if (id && !is_user_connected(id))
	{
		return 0;
	}
	if (sender < Blue || sender > 32)
	{
		sender = DontChange;
	}
	else if (sender < DontChange)
	{
		sender = -sender + 32;
	}
	static const szTeamName[][] ={"", "TERRORIST", "CT"};
	new szMessage[191];
	new iParams = numargs();
	if (id)
	{
		if (iParams == 3)
		{
			copy(szMessage, charsmax(szMessage), fmt);
		}
		else
		{
			vformat(szMessage, charsmax(szMessage), fmt, 4);
		}
		if (sender > (32 - Grey))
		{
			if (sender > (32 - Blue))
			{
				sender = id;
			}
			else
			{
				_CC_TeamInfo(id, sender, szTeamName[sender - (32 - Grey)]);
			}
		}
		_CC_SayText(id, sender, szMessage);
	}
	else
	{
		new iPlayers[32], iNum;
		get_players(iPlayers, iNum, "ch");
		if (!iNum)
		{
			return 0;
		}
		new iMlNumber, i, j;
		new Array:aStoreML = ArrayCreate();
		if (iParams >= 5)
		{
			for (j = 3; j < iParams; j++)
			{
				if (getarg(j) == LANG_PLAYER)
				{
					i = 0;
					while ((szMessage[i] = getarg(j + 1, i++))) {}
					if (GetLangTransKey(szMessage) != TransKey_Bad)
					{
						ArrayPushCell(aStoreML, j++);
						iMlNumber++;
					}
				}
			}
		}
		if (!iMlNumber)
		{
			if (iParams == 3)
			{
				copy(szMessage, charsmax(szMessage), fmt);
			}
			else
			{
				vformat(szMessage, charsmax(szMessage), fmt, 4);
			}
			if (0 < sender < (32 - Blue))
			{
				if (sender > (32 - Grey))
				{
					_CC_TeamInfo(0, sender, szTeamName[sender - (32 - Grey)]);
				}
				_CC_SayText(0, sender, szMessage);
				return 1;
			}
		}
		if (sender > (32 - Blue))
		{
			sender = 0;
		}

		for (--iNum; iNum >= 0; iNum--)
		{
			id = iPlayers[iNum];
			if (iMlNumber)
			{
				for (j = 0; j < iMlNumber; j++)
				{
					setarg(ArrayGetCell(aStoreML, j), _, id);
				}
				vformat(szMessage, charsmax(szMessage), fmt, 4);
			}
			if (sender > (32 - Grey))
			{
				_CC_TeamInfo(id, sender, szTeamName[sender - (32 - Grey)]);
			}
			_CC_SayText(id, sender, szMessage);
		}
		ArrayDestroy(aStoreML);
	}
	return 1;
}

stock _CC_TeamInfo(iReceiver, iSender, szTeam[])
{
	static iTeamInfo = 0;
	if (!iTeamInfo)
	{
		iTeamInfo = get_user_msgid("TeamInfo");
	}
	message_begin(iReceiver ? MSG_ONE : MSG_ALL, iTeamInfo, _, iReceiver);
	write_byte(iSender);
	write_string(szTeam);
	message_end();
}

stock _CC_SayText(iReceiver, iSender, szMessage[])
{
	static iSayText = 0;
	if (!iSayText)
	{
		iSayText = get_user_msgid("SayText");
	}
	for (new i = 0; i < 192; i++)
	{
		if (szMessage[i] == 0) break;
		if (szMessage[i] == '%' ||
		szMessage[i] == '#')
		szMessage[i] = ' ';
	}
	message_begin(iReceiver ? MSG_ONE : MSG_ALL, iSayText, _, iReceiver);
	write_byte(iSender ? iSender : iReceiver);
	if (szMessage[0] > 4)
	{
		write_byte(1);
		szMessage[192 - 2 - 1] = 0;
		write_string(szMessage);
	}
	else
	{
		szMessage[192 - 1 - 1] = 0;
		write_string(szMessage);
	}
	message_end();
}

new _translation_szBuffer[MAX_TRANSLATION_LENGTH];

stock register_dictionary_colored(const filename[])
{
	if (!register_dictionary(filename))
	{
		return 0;
	}
	new szFileName[256];
	get_localinfo("amxx_datadir", szFileName, charsmax(szFileName));
	format(szFileName, charsmax(szFileName), "%s/lang/%s", szFileName, filename);
	new fp = fopen(szFileName, "rt");
	if (!fp)
	{
		log_amx("Failed to open %s", szFileName);
		return 0;
	}
	new szLang[3], szKey[64], TransKey:iKey;
	while (!feof(fp))
	{
		fgets(fp, _translation_szBuffer, charsmax(_translation_szBuffer));
		trim(_translation_szBuffer);

		if (_translation_szBuffer[0] == '[')
		{
			strtok(_translation_szBuffer[1], szLang, charsmax(szLang), _translation_szBuffer, 1, ']');
		}
		else if (_translation_szBuffer[0])
		{
			strbreak(_translation_szBuffer, szKey, charsmax(szKey), _translation_szBuffer, charsmax(_translation_szBuffer));
			iKey = GetLangTransKey(szKey);
			if (iKey != TransKey_Bad)
			{
				replace_all(_translation_szBuffer, charsmax(_translation_szBuffer), "!g", "^4");
				replace_all(_translation_szBuffer, charsmax(_translation_szBuffer), "!t", "^3");
				replace_all(_translation_szBuffer, charsmax(_translation_szBuffer), "!n", "^1");
				replace_all(_translation_szBuffer, charsmax(_translation_szBuffer), "^^4", "^4");
				replace_all(_translation_szBuffer, charsmax(_translation_szBuffer), "^^3", "^3");
				replace_all(_translation_szBuffer, charsmax(_translation_szBuffer), "^^1", "^1");
				replace_all(_translation_szBuffer, charsmax(_translation_szBuffer), "^^n", "^n");
				replace_all(_translation_szBuffer, charsmax(_translation_szBuffer), "^^t", "^t");
				AddTranslation(szLang, iKey, _translation_szBuffer[2]);
			}
		}
	}
	fclose(fp);
	return 1;
}

#define register_dictionary register_dictionary_colored