#include <amxmodx>

#if AMXX_VERSION_NUM < 183
	#include <colorchat>
#endif

enum _:DATA
{
	AUTH[32], 
	MSG[128]
};
new Array:g_aData, g_PlayerData[DATA];
new g_szMessage[33][128];

public plugin_init()
	register_plugin("Connect Info", "1.0", "Hypa_[KZ]");

public plugin_cfg()
{
	g_aData = ArrayCreate(DATA);

	new buff[256], fp = fopen("addons/amxmodx/configs/connect_info.ini", "rt");
	if(!fp) return set_fail_state("File ^"addons/amxmodx/configs/connect_info.ini^" not found");

	while(!feof(fp))
	{
		fgets(fp, buff, charsmax(buff));
		if(buff[0] && buff[0] != ';' && parse(buff, g_PlayerData[AUTH], charsmax(g_PlayerData[AUTH]), g_PlayerData[MSG], charsmax(g_PlayerData[MSG])))
			ArrayPushArray(g_aData, g_PlayerData);
	}
	return fclose(fp);
}

public client_putinserver(id)
{
	SearchClient(id);
	
	if(g_szMessage[id][0])
		set_task(5.0, "ShowInfo", id);
}

public ShowInfo(id)
{
	new szName[32];	get_user_name(id, szName, charsmax(szName));
	
	replace_all(g_szMessage[id], charsmax(g_szMessage[]), "!n", "^1");
	replace_all(g_szMessage[id], charsmax(g_szMessage[]), "!t", "^3");
	replace_all(g_szMessage[id], charsmax(g_szMessage[]), "!g", "^4");
	replace_all(g_szMessage[id], charsmax(g_szMessage[]), "%name%", szName);
	
	client_print_color(0, print_team_default, "%s", g_szMessage[id]);
}

stock SearchClient(const id)
{
	new szIP[16]; 	 get_user_ip(id, szIP, charsmax(szIP), 1);
	new szAuthid[25];get_user_authid(id, szAuthid, charsmax(szAuthid));

	for(new i, flags = get_user_flags(id); i < ArraySize(g_aData); i++)
	{
		ArrayGetArray(g_aData, i, g_PlayerData);
		
		switch(g_PlayerData[AUTH][0])
		{
			case '#':
			{
				if(is_user_steam(id))
					return copy(g_szMessage[id], charsmax(g_szMessage[]), g_PlayerData[MSG]);
			}
			case '*':	return copy(g_szMessage[id], charsmax(g_szMessage[]), g_PlayerData[MSG]);
			case 'S', 'V':
			{
				if(strcmp(g_PlayerData[AUTH], szAuthid) == 0)
					return copy(g_szMessage[id], charsmax(g_szMessage[]), g_PlayerData[MSG]);
			}
			default:
			{
				if(isdigit(g_PlayerData[AUTH][0]))
				{
					if(strcmp(g_PlayerData[AUTH], szIP) == 0)
						return copy(g_szMessage[id], charsmax(g_szMessage[]), g_PlayerData[MSG]);
				}
				else if(flags & read_flags(g_PlayerData[AUTH]))
					return copy(g_szMessage[id], charsmax(g_szMessage[]), g_PlayerData[MSG]);
			}
		}
	}
	return g_szMessage[id][0] = 0;
}

stock bool:is_user_steam(id)
{
	static dp_pointer;
	if(dp_pointer || (dp_pointer = get_cvar_pointer("dp_r_id_provider")))
	{
		server_cmd("dp_clientinfo %d", id);
		server_exec();
		return (get_pcvar_num(dp_pointer) == 2) ? true : false;
	}
	return false;
}
