/**
* Credits: Arkshine, https://forums.alliedmods.net/showpost.php?p=1567176&postcount=16
*
*/

#include <amxmodx>
#include <fakemeta>
#include <engine>
#include <fun>
#include <csx>

/* Settings */
	/* Enable action only for the privileged */
// #define ACCESS_FLAGS    ( ADMIN_LEVEL_H )

	/* Enable action only for teammates */
#define ONLY_FOR_TEAMMATES
#define TOUCH_EXPLODE

const HEALTH_TO_HEAL	= 100;
const HEALTH_MAX		= 100;
const HEAL_RADIUS		= 300;

new const MODEL_V[]		= "models/v_he_mk_nade.mdl";
new const MODEL_P[]		= "models/p_he_mk_nade.mdl";
new const MODEL_W[]		= "models/w_he_mk_nade.mdl";

new const SPRITE_EXPLODE1[]	= "sprites/heal_explode.spr";
new const SPRITE_PROS[]		= "sprites/heal_shape.spr";

new const SOUND_HEAL[]		= "woomen_expr.wav";
/* End of settings */

enum {
	XO_WEAPON    = 4,
	XO_CGRENADE = 5,
	m_pPlayer    = 41,
	m_usEvent    = 114
}

new const EXCLASS[] = "grenade";

enum { STATUSICON_HIDE = 0, STATUSICON_FLASH = 2 };

const flagSmokeEvent    = (1 << 1);

#define IsSgGrenade(%1)            (get_pdata_int(%1, m_usEvent, XO_CGRENADE) & flagSmokeEvent)

#define _GetEntOwner(%1)        pev(%1, pev_owner)
#define _GetEntOrigin(%1,%2)    pev(%1, pev_origin, %2)

#define _SetViewModel(%1,%2)    set_pev(%1, pev_viewmodel2, %2)
#define _SetWorldModel(%1,%2)    set_pev(%1, pev_weaponmodel2, %2)

new g_MsgId_StatusIcon, g_MsgId_ScreenFade;

new g_pFirstExplosion,
	g_pPros,
	g_pCircle;

new const VERSION[] = "0.0.3";

public plugin_init() {
	register_plugin("Smoke: HealthNade", VERSION, "wopox1337");

	g_MsgId_StatusIcon = get_user_msgid("StatusIcon");
	g_MsgId_ScreenFade = get_user_msgid("ScreenFade");

	register_touch(EXCLASS, "*", "CGrenade_ExplodeTouch");

	register_event("CurWeapon", "Event_CurWeapon", "be", "1=1");
}

public plugin_precache() {
	precache_model(MODEL_V);
	precache_model(MODEL_P);
	precache_model(MODEL_W);

	g_pFirstExplosion = precache_model(SPRITE_EXPLODE1);
	g_pPros = precache_model(SPRITE_PROS);
	g_pCircle = precache_model("sprites/shockwave.spr");

	precache_sound(SOUND_HEAL);
}

public Event_CurWeapon(pPlayer)    { 
	enum { WeaponID = 2 };
	if(read_data(WeaponID) == CSW_SMOKEGRENADE)    {

#if defined ACCESS_FLAGS
		if(!IsUserHaveAccessToUse(pPlayer)) return;
#endif

		OnPlayer_SetViewModels(pPlayer);
		Send_StatusIcon__Cross(pPlayer);
	}
	else Send_StatusIcon__Cross(pPlayer, .status = STATUSICON_HIDE);
}

public grenade_throw(pPlayer, pEnt, w_id) {
	if(w_id != CSW_SMOKEGRENADE)
		return;

#if defined ACCESS_FLAGS
	if(!IsUserHaveAccessToUse(pPlayer)) return;
#endif

	OnGrenade_SetWorldModel(pEnt);
}

public CGrenade_ExplodeTouch(const pEnt, const pOther) {
	// Filter to another grenades type
	if(!IsSgGrenade(pEnt))
		return;

	static iOwner; iOwner = _GetEntOwner(pEnt);

#if defined ACCESS_FLAGS
	if(!IsUserHaveAccessToUse(iOwner)) return;
#endif

	static Float: fOrigin[3], iOrigin[3];
	_GetEntOrigin(pEnt, fOrigin);
	FVecIVec(fOrigin, iOrigin);

	// Show visuals
	Send_Explode(iOrigin);
	Send_Pros(iOrigin);
	Send_ShockWave(iOrigin);
	OnGrenade_PlaySound(pEnt);

	// Removed default smoke entity, and his detonate event accordingly
	OnGrenade_RemoveByTouch(pEnt);
  
	// Action on near players
	HealPlayersOnRadius(iOwner, fOrigin);
}

stock HealPlayersOnRadius(pInflictor, Float: fOrigin[3]) {
	for(new pPlayer = 1; pPlayer <= 32; pPlayer++) { 
		if(is_user_alive(pPlayer)) {

#if !defined ONLY_FOR_TEAMMATES
			if(get_user_team(pInflictor) != get_user_team(pPlayer))
				continue;
#endif
		#pragma unused pInflictor

			static Float: playerOrigin[3];
			_GetEntOrigin(pPlayer, playerOrigin);

			if(get_distance_f(fOrigin, playerOrigin) < HEAL_RADIUS)
				OnPlayer_HealEvent(pPlayer);
		}
	}
}

stock OnPlayer_HealEvent(const pPlayer) {
	set_user_health(pPlayer, min(get_user_health(pPlayer) + HEALTH_TO_HEAL, HEALTH_MAX));
	__UTIL_ScreenFade(pPlayer);
}

stock OnPlayer_SetViewModels(const pPlayer) {
	_SetViewModel(pPlayer, MODEL_V);
	_SetWorldModel(pPlayer, MODEL_P);
}

stock OnGrenade_SetWorldModel(const pEnt)
	engfunc(EngFunc_SetModel, pEnt, MODEL_W);

stock OnGrenade_RemoveByTouch(const pEnt)
	engfunc(EngFunc_RemoveEntity, pEnt);

stock Send_StatusIcon__Cross(const pPlayer, status = STATUSICON_FLASH) {
	message_begin(MSG_ONE_UNRELIABLE, g_MsgId_StatusIcon, .player = pPlayer);
	write_byte(status);
	write_string("cross");
	write_byte(0);
	write_byte(255);
	write_byte(0);
	message_end();
}

stock OnGrenade_PlaySound(const pEnt)
	engfunc(EngFunc_EmitSound, pEnt, CHAN_WEAPON, SOUND_HEAL, VOL_NORM, ATTN_NORM, 0, PITCH_NORM);


stock Send_Explode(iOrigin[3]) {
	emessage_begin(MSG_PVS, SVC_TEMPENTITY);
	ewrite_byte(TE_EXPLOSION);
	ewrite_coord(iOrigin[0]);
	ewrite_coord(iOrigin[1]);
	ewrite_coord(iOrigin[2] + 65);
	ewrite_short(g_pFirstExplosion);
	ewrite_byte(30);
	ewrite_byte(20);
	ewrite_byte(TE_EXPLFLAG_NOSOUND | TE_EXPLFLAG_NOPARTICLES);
	emessage_end();
}

stock Send_Pros(iOrigin[3]) {
	emessage_begin(MSG_PVS, SVC_TEMPENTITY);
	ewrite_byte(TE_SPRITETRAIL);
	ewrite_coord(iOrigin[0]);
	ewrite_coord(iOrigin[1]);
	ewrite_coord(iOrigin[2] + 20);
	ewrite_coord(iOrigin[0]);
	ewrite_coord(iOrigin[1]);
	ewrite_coord(iOrigin[2] + 80);
	ewrite_short(g_pPros);
	ewrite_byte(20);
	ewrite_byte(20);
	ewrite_byte(4);
	ewrite_byte(20);
	ewrite_byte(10);
	emessage_end();
}

stock Send_ShockWave(iOrigin[3]) {
	emessage_begin(MSG_PVS, SVC_TEMPENTITY);
	ewrite_byte(TE_BEAMCYLINDER);
	ewrite_coord(iOrigin[0]);
	ewrite_coord(iOrigin[1]);
	ewrite_coord(iOrigin[2]);
	ewrite_coord(iOrigin[0]);
	ewrite_coord(iOrigin[1]);
	ewrite_coord(iOrigin[2] + HEAL_RADIUS);
	ewrite_short(g_pCircle);
	ewrite_byte(0);
	ewrite_byte(1);
	ewrite_byte(5);
	ewrite_byte(30);
	ewrite_byte(1);
	ewrite_byte(10);
	ewrite_byte(255);
	ewrite_byte(40);
	ewrite_byte(255); 
	ewrite_byte(5);
	emessage_end();
}

stock __UTIL_ScreenFade(const pPlayer, iColor[3] = {170, 255, 0}, iAlpha = 80, Float: flFxTime = 1.0, Float: flHoldTime = 0.1) {
	const FFADE_IN = 0x0000;

	emessage_begin(MSG_ONE_UNRELIABLE, g_MsgId_ScreenFade, .player = pPlayer);
	ewrite_short(FixedUnsigned16(flFxTime));
	ewrite_short(FixedUnsigned16(flHoldTime));
	ewrite_short(FFADE_IN);
	ewrite_byte(iColor[0]);
	ewrite_byte(iColor[1]);
	ewrite_byte(iColor[2]);
	ewrite_byte(iAlpha);
	emessage_end();
}

stock FixedUnsigned16(Float:flValue, iScale = (1 << 12)) {
	return clamp(floatround(flValue * iScale), 0, 0xFFFF);
}

stock IsUserHaveAccessToUse(const pPlayer) {
	// Anytime we can add other checks, like cached bool
	return (get_user_flags(pPlayer) & ACCESS_FLAGS);
}

stock IsAllowedToUse() {
	return true;
}