/* AMX Mod X Plugin
* 
* (c) Copyright 2008, ConnorMcLeod 
* This file is provided as is (no warranties). 
* 
*/ 

#include <amxmodx>
#include <fakemeta>

#define PEV_PDATA_SAFE    2

#define MAX_PLAYERS    32
#define OFFSET_TEAM    114

#define W_FLASH_MODEL_STRLEN        22
#define FLASH_XPLODE_SOUND_STRLEN    23

new g_iMaxClients
new bool:g_bHasJustBeenFlashed[MAX_PLAYERS+1]
new g_msgidScreenFade

public plugin_init()
{
    register_plugin("No Team Flash", "1.0.0", "ConnorMcLeod")

    register_event("ScreenFade", "Event_ScreenFade", "be", "1>0", "2>0", "3=0","4=255", "5=255", "6=255", "7=200", "7=255")
    register_forward(FM_SetModel, "Forward_SetModel")
    register_forward(FM_EmitSound, "Forward_EmitSound")
}

public plugin_cfg()
{
    g_iMaxClients = global_get(glb_maxClients)
    g_msgidScreenFade = get_user_msgid("ScreenFade")
}
                            
public Forward_SetModel(iEntity, const szModel[])
{
    if(strlen(szModel) != W_FLASH_MODEL_STRLEN)
    {
        return FMRES_IGNORED
    }

    if(szModel[7] != 'w' || szModel[9] != 'f' || szModel[14] != 'b')
    {
        return FMRES_IGNORED
    }

    if(!pev_valid(iEntity))
    {
        return FMRES_IGNORED
    }

    static Float:fVelocity[3]
    pev(iEntity, pev_velocity, fVelocity)
    if(!fVelocity[0] && !fVelocity[1] && !fVelocity[2])
    {
        return FMRES_IGNORED
    }

    set_pev(iEntity, pev_iuser4, pev(iEntity, pev_owner) )
    return FMRES_HANDLED
}
                            
public Forward_EmitSound(iEntity, iChannel, const szSample[])
{
    if(szSample[0] != 'w' || szSample[8] != 'f' || szSample[9] != 'l')
    {
        return FMRES_IGNORED
    }

    if(!pev_valid(iEntity))
    {
        return FMRES_IGNORED
    }

    static iFlasher
    iFlasher = pev(iEntity, pev_iuser4)
    if( pev_valid(iFlasher) != PEV_PDATA_SAFE )
    {
        return FMRES_IGNORED
    }
    static id, iTeam
    iTeam = get_pdata_int(iFlasher, OFFSET_TEAM)

    for(id=1; id<=g_iMaxClients; id++)
    {
        if(!g_bHasJustBeenFlashed[id])
        {
            continue
        }

        g_bHasJustBeenFlashed[id] = false

        if( pev_valid(id) != PEV_PDATA_SAFE )
        {
            continue
        }

        if(id != iFlasher && get_pdata_int(id, OFFSET_TEAM) == iTeam)
        {
            reset_screen(id)
        }
    }

    return FMRES_HANDLED
}

public Event_ScreenFade(id)
{
    g_bHasJustBeenFlashed[id] = true
}

public client_putinserver(id)
{
    g_bHasJustBeenFlashed[id] = false
}

reset_screen(id)
{
    emessage_begin(MSG_ONE, g_msgidScreenFade, _, id)
    ewrite_short(4)
    ewrite_short(0)
    ewrite_short(0)
    ewrite_byte(0)
    ewrite_byte(0)
    ewrite_byte(0)
    ewrite_byte(0)
    emessage_end()
}  