#pragma semicolon 1

#include <amxmodx>
#include <reapi>

new const MOTD_MODEL[] = "models/legion.mdl";

enum MotdState
{
	MOTD_STATE_BEGIN,
	MOTD_STATE_INTRO,
	MOTD_STATE_END,

}; new MotdState:g_iMotdState[MAX_PLAYERS + 1];

public plugin_init()
{
	register_plugin("MOTD Model", "1.0.0", "fl0wer");

	RegisterHookChain(RG_ShowVGUIMenu, "@ShowVGUIMenu_Pre", false);
	RegisterHookChain(RG_HandleMenu_ChooseTeam, "@HandleMenu_ChooseTeam_Pre", false);
}

public plugin_precache()
{
	precache_model(MOTD_MODEL);
}

public client_putinserver(id)
{
	g_iMotdState[id] = MOTD_STATE_BEGIN;
}

@ShowVGUIMenu_Pre(id, VGUIMenu:menuType, bitsSlots, szOldMenu[])
{
	if (menuType == VGUI_Menu_Class_T || menuType == VGUI_Menu_Class_T)
	{
		set_member(id, m_bForceShowMenu, true);
		return;
	}

	if (menuType != VGUI_Menu_Team)
		return;

	set_member(id, m_bForceShowMenu, true);

	if (get_member(id, m_iJoiningState) == JOINED)
		return;

	switch (g_iMotdState[id])
	{
		case MOTD_STATE_BEGIN:
		{
			g_iMotdState[id] = MOTD_STATE_INTRO;

			set_entvar(id, var_viewmodel, MOTD_MODEL);
			set_task(3.7, "@Task_IntroEnd", id);
		}
		case MOTD_STATE_END: return;
	}

	SetHookChainArg(3, ATYPE_INTEGER, MENU_KEY_0);
	SetHookChainArg(4, ATYPE_STRING, "\n");
}

@HandleMenu_ChooseTeam_Pre(id, key)
{
	if (g_iMotdState[id] == MOTD_STATE_END)
		return HC_CONTINUE;

	SetHookChainReturn(ATYPE_INTEGER, false);
	return HC_SUPERCEDE;
}

@Task_IntroEnd(task)
{
	new id = task;

	if (!is_user_connected(id))
		return;

	g_iMotdState[id] = MOTD_STATE_END;

	set_entvar(id, var_viewmodel, "");
	engclient_cmd(id, "menuselect", "0");
}
