#include <amxmodx>
#include <fakemeta>
#include <reapi>

//#define MYSQL_SUPPORT   // Раскомментируйте данный define ,если хотите сохранять в БД MYSQL(по умолчанию, сохранение через nvault)
#define RANKS_SYSTEM        1
/* Тип интеграции со система ранга
1 - Army Ranks Ultimate
2 - Advanced Expirience System
3 - CMSStats Ranks*/

#if defined MYSQL_SUPPORT
#include <sqlx>
#else
#include <nvault>
#endif

#if defined RANKS_SYSTEM
    #if RANKS_SYSTEM == 1
        native ar_set_user_addxp(id, addxp);
        native ar_add_user_anew(admin, player, anew);
    #elseif RANKS_SYSTEM == 2
        #include <aes_v>
        ;
    #elseif RANKS_SYSTEM == 3
        native cmsranks_set_user_addxp(id, value);
        native cmsranks_add_user_anew(id, value);
    #endif
#endif
#pragma semicolon 1
enum _:eCvars
{
    Float: ENT_LIFETIME,
    GLOW,
    AES_DEAD,
    AES_ALL,
    AES_EXP,
    TIME_DELETE,
    AES_BONUS
}
new g_eCvar[eCvars];

new g_iMaxPlayers;
new g_iCoin[33];

new const ENT_CLASSNAME[] = "raise_the_coin";
new const ENT_MODEL[] = "models/exp.mdl";
new const SND_PICKUP[] = "exp.wav";


// НАСТРОЙКА ДАННЫХ  MYSQL (Вводить, если раскомментировон #define MYSQL_SUPPORT)
#if defined MYSQL_SUPPORT
new Host[]     = ""; // ip адрес хоста
new User[]    = ""; // Имя хоста
new Pass[]     = ""; // Пароль хоста
new Db[]     = "";  // Название бд
// КОНЕЦ НАСТРОЙКИ ДАННЫХ  MYSQL
new Handle:sql_typle;
new g_Error[512];
#else
new g_Vault;
#endif

public plugin_init( )
{
  register_plugin( "(AES)Raise_the_coin", "1.0.1", "Baton4ik48" );
  RegisterHookChain(RG_CBasePlayer_Killed, "CBasePlayer_Killed_Post", true);
  g_iMaxPlayers = get_maxplayers();
  set_task(2.0, "Task_HudMsg", .flags = "b");
}
// Настройка кваров
public plugin_cfg()
{
    bind_pcvar_float(create_cvar("raise_ent_life", "7.0", FCVAR_NONE), g_eCvar[ENT_LIFETIME]); // Время через которое исчезнет монета
    bind_pcvar_num(create_cvar("raise_ent_glow", "1", FCVAR_NONE), g_eCvar[GLOW]); // Свечение монеты
    bind_pcvar_num(create_cvar("raise_dead_exp", "1", FCVAR_NONE), g_eCvar[AES_DEAD]); // Кол-во опыта теряемое при смерти (ставить без минуса)
    bind_pcvar_num(create_cvar("raise_aes_all", "30", FCVAR_NONE), g_eCvar[AES_ALL]); // Необходимое кол-во монет до вознаграждения
    bind_pcvar_num(create_cvar("raise_aes_exp", "100", FCVAR_NONE), g_eCvar[AES_EXP]); // Кол-во опыта за вознаграждении
    bind_pcvar_num(create_cvar("raise_aes_bonus", "10", FCVAR_NONE), g_eCvar[AES_BONUS]); // Кол-во бонусов за вознаграждении
    bind_pcvar_num(create_cvar("raise_deletetime", "5", FCVAR_NONE), g_eCvar[TIME_DELETE]); // Записи игроков, не заходивших указанное кол-во дней, удаляются из бд. Меньше 1 - отключить (не рекомендуется).

// Конец настройки кваров

    #if defined MYSQL_SUPPORT
      set_task(1.0, "mysql_start");
      #else
      g_Vault = nvault_open("raise_the_coin");
      if(g_Vault == INVALID_HANDLE)
            {
                set_fail_state("Error nvault");
             }
    if (g_eCvar[TIME_DELETE] > 0)
        nvault_prune(g_Vault, 0, get_systime() - (86400 * g_eCvar[TIME_DELETE]));
      #endif
}


public plugin_precache()
{
    precache_model(ENT_MODEL);
    precache_sound(SND_PICKUP);
}


public CBasePlayer_Killed_Post(pVictim, pAttacker, pGib)
{
    new Float: vecOrigin[3];
    new Float: vecVelocity[3];

    get_entvar(pVictim, var_origin, vecOrigin);

    new iEntity = rg_create_entity("info_target", false);

    if(is_nullent(iEntity))
        return;

#if RANKS_SYSTEM == 1
    ar_set_user_addxp(pVictim,-g_eCvar[AES_DEAD]);
    #elseif RANKS_SYSTEM == 2
    aes_add_player_exp_f(pVictim,-g_eCvar[AES_DEAD]);
    #elseif RANKS_SYSTEM == 3
    cmsranks_set_user_addxp(pVictim,-g_eCvar[AES_DEAD]);
    #endif

    vecVelocity[0] = random_float(-200.0, 200.0);
    vecVelocity[1] = random_float(-200.0, 200.0);
    vecVelocity[2] = random_float(1.0, 200.0);

    engfunc(EngFunc_SetModel, iEntity, ENT_MODEL);
    engfunc(EngFunc_SetSize, iEntity, {-9.0, -7.0, -0.0}, {9.0, 7.0, 6.0});
    set_entvar(iEntity, var_framerate, 1.0);
    set_entvar(iEntity, var_sequence, 2);
    engfunc(EngFunc_AnimationAutomove, iEntity, 100.0);

    set_entvar(iEntity, var_origin, vecOrigin);
    set_entvar(iEntity, var_classname, ENT_CLASSNAME);
    set_entvar(iEntity, var_movetype, MOVETYPE_TOSS);
    set_entvar(iEntity, var_solid, SOLID_TRIGGER);
    set_entvar(iEntity, var_velocity, vecVelocity);
    set_entvar(iEntity, var_nextthink, get_gametime() + g_eCvar[ENT_LIFETIME]);

    if(g_eCvar[GLOW])
    {
        set_entvar(iEntity, var_rendermode, kRenderGlow);
        set_entvar(iEntity, var_renderamt, 1.0);
        set_entvar(iEntity, var_rendercolor, Float: { 0.0, 255.0, 0.0 });
        set_entvar(iEntity, var_renderfx, kRenderFxGlowShell);
    }

    SetThink(iEntity, "Cashbrick_Think");
    SetTouch(iEntity, "Cashbrick_Touch");
}

public Cashbrick_Think(pEntity)
{
    if(!is_entity(pEntity))
        return;

    if(get_entvar(pEntity, var_iuser2))
    {
        new Float: fRenderAmt;
        get_entvar(pEntity, var_renderamt, fRenderAmt);

        if(fRenderAmt > 20.0)
        {
            set_entvar(pEntity, var_renderamt, fRenderAmt - 20.0);
            set_entvar(pEntity, var_nextthink, get_gametime() + 0.1);
        }
        else
            set_entvar(pEntity, var_flags, FL_KILLME);
    }
    else
    {
        set_entvar(pEntity, var_iuser2, 1);
        set_entvar(pEntity, var_rendermode, kRenderTransTexture);
        set_entvar(pEntity, var_renderamt, 255.0);
        set_entvar(pEntity, var_nextthink, get_gametime() + 1.5);
    }
}

public Cashbrick_Touch(pEntity, pToucher)
{
    if(!is_entity(pEntity) || !is_user_connected(pToucher))
        return;

    g_iCoin[pToucher]++;
    set_hudmessage(0, 255, 0, -1.0, 0.26, 0, 0.1, 2.0, 0.1, 0.1, 3);
    show_hudmessage(pToucher, "+1 монета", g_iCoin);
    rh_emit_sound2(pToucher, 0, CHAN_ITEM, SND_PICKUP, VOL_NORM, ATTN_NORM);
    set_entvar(pEntity, var_flags, FL_KILLME);

    if(g_iCoin[pToucher] == g_eCvar[AES_ALL])
        {
            client_print_color(pToucher, print_team_default, "^1Вы получили ^4%i ^1опыта и ^4%i ^1бонус.", g_eCvar[AES_EXP] ,g_eCvar[AES_BONUS]);

#if RANKS_SYSTEM == 1
    ar_set_user_addxp(pToucher,g_eCvar[AES_EXP]);
    ar_add_user_anew(-1, pToucher,g_eCvar[AES_BONUS]);
    #elseif RANKS_SYSTEM == 2
    aes_add_player_exp_f(pToucher,g_eCvar[AES_EXP]);
    aes_add_player_bonus_f(pToucher,g_eCvar[AES_BONUS]);
    #elseif RANKS_SYSTEM == 3
    cmsranks_set_user_addxp(pToucher,g_eCvar[AES_EXP]);
    cmsranks_add_user_anew(pToucher,g_eCvar[AES_BONUS]);
    #endif

            g_iCoin[pToucher]  = 0;
        }
}

public Task_HudMsg()
{
    set_hudmessage(200, 200, 200, 0.01, 0.90, 0, 0.1, 1.0, 0.1, 0.1, 4);

    for(new id = 1; id < g_iMaxPlayers; id++)
    {
        if(!is_user_alive(id))
            continue;

        show_hudmessage(id, "Монет до вознаграждения: %i/%i", g_iCoin[id], g_eCvar[AES_ALL]);
    }
}

public client_connect(id)
{
    #if defined MYSQL_SUPPORT
    Load_MySql(id);
    #else
    load_coins(id);
    #endif
}

public client_disconnected(id)
{
    #if defined MYSQL_SUPPORT
        Save_MySql(id);
    #else
        save_coins(id);
    #endif
}

public plugin_end()
{
    #if defined MYSQL_SUPPORT
    if (sql_typle)
        SQL_FreeHandle(sql_typle);
    log_amx("sql_close");
    #else
    nvault_close(g_Vault);
    log_amx("nvault_close");
    #endif
}

#if defined MYSQL_SUPPORT
public mysql_start()
{
    sql_typle = SQL_MakeDbTuple(Host, User, Pass, Db);

    new ErrorCode,Handle:SqlConnection = SQL_Connect(sql_typle,ErrorCode,g_Error,charsmax(g_Error));
    if(SqlConnection == Empty_Handle)
        set_fail_state(g_Error);

    new Handle:Queries;
    Queries = SQL_PrepareQuery(SqlConnection,"CREATE TABLE IF NOT EXISTS Raise_the_coin (`steamid` varchar(32), `coin` INT(11), `time_join` timestamp)");

    if(!SQL_Execute(Queries))
    {
        SQL_QueryError(Queries,g_Error,charsmax(g_Error));
        set_fail_state(g_Error);
    }
    SQL_FreeHandle(Queries);
    SQL_FreeHandle(SqlConnection);
	
	if (g_eCvar[TIME_DELETE] > 0)
    {
    new szTemp[512];
    formatex(szTemp, charsmax(szTemp), "DELETE FROM `Raise_the_coin` WHERE `time_join` < FROM_UNIXTIME(%d - (86400 * %d))", get_systime(), g_eCvar[TIME_DELETE]);
    SQL_ThreadQuery(sql_typle, "ignore_handle",szTemp);
    }
}

public Load_MySql(id)
{
  new sAuthID[32];
  new szTemp[512];
  get_user_authid(id, sAuthID, charsmax(sAuthID));

  new Data[1];
  Data[0] = id;

  format(szTemp,charsmax(szTemp),"SELECT * FROM `Raise_the_coin` WHERE (`Raise_the_coin`.`steamid` = '%s')", sAuthID);

  SQL_ThreadQuery(sql_typle,"registration_client",szTemp,Data,1);
}

public registration_client(FailState,Handle:Query,Error[],Errcode,Data[],DataSize)
{
    if(FailState == TQUERY_CONNECT_FAILED)
    {
        log_amx("Load - Could not connect to SQL database.  [%d] %s", Errcode, Error);
    }
    else if(FailState == TQUERY_QUERY_FAILED)
    {
        log_amx("Load Query failed. [%d] %s", Errcode, Error);
    }

    new id;
    id = Data[0];

    if(SQL_NumResults(Query) < 1)
    {
  new sAuthID[32];
  new szTemp[512];

  get_user_authid(id, sAuthID, charsmax(sAuthID));

  format(szTemp,charsmax(szTemp), "INSERT INTO `Raise_the_coin` ( `steamid` , `coin`)VALUES ('%s','0')", sAuthID);
  SQL_ThreadQuery(sql_typle, "ignore_handle",szTemp);
    }
    else
    {
        g_iCoin[id] = SQL_ReadResult(Query, 1);
    }
    return PLUGIN_HANDLED;
}

public Save_MySql(id)
{
    new sAuthID[32];
    new szTemp[512];
    get_user_authid(id, sAuthID, charsmax(sAuthID));

    format(szTemp,charsmax(szTemp),"UPDATE `Raise_the_coin` SET `coin` = '%i' WHERE `Raise_the_coin`.`steamid` = '%s';", g_iCoin[id], sAuthID);

    SQL_ThreadQuery(sql_typle,"ignore_handle",szTemp);
}

public ignore_handle(FailState,Handle:Query,Error[],Errcode,Data[],DataSize)
{
    SQL_FreeHandle(Query);
    return PLUGIN_HANDLED;
}
#else
save_coins(id)
{
  new szKey[40];
  new szCoin[15];

  get_user_authid(id, szKey, charsmax(szKey));

  formatex(szCoin, charsmax(szCoin), "%i", g_iCoin[id]);
  nvault_set(g_Vault, szKey, szCoin);
}

load_coins(id)
{
  new szKey[40];
  new szCoin[15];

  get_user_authid(id, szKey, charsmax(szKey));

  nvault_get(g_Vault, szKey, szCoin, charsmax(szCoin));
  g_iCoin[id] = str_to_num(szCoin);
}
#endif